/**
 *  punchAction
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name: nekotan3rdDay $ $RCSfile: punchAction.js,v $ $Revision: 1.1 $ $Date: 2006/11/24 08:21:05 $
 * 
 *  @requires mController
 *  @member   mController
**/
{
 /**
  *  defaultView
  * 
  *  @private
 **/
 this._defaultView = 'executeViewIndex';

 /**
  *  image source url
  * 
  *  @private
 **/
 this._imgsrc = null;

 /**
  *  init
  * 
  *  @param   mModel  model  // target model object
  * 
  *  @return  void
 **/
 this.init = function(model)
 {
 };

 /**
  *  execute
  * 
  *  @param   mRequest  request  // request object
  * 
  *  @return  string
 **/
 this.execute = function(request)
 {
  // alias of mConfig object
  var cnf = mUtils.config;

  // diverges in present state
  switch(DomUtils.getObject('nekotan').src)
  {
   // to punch
   case cnf.getConfig('nekotanImgNormal'):
    // set punch image source address
    this._imgsrc = cnf.getConfig('nekotanImgPunch');
    // set timeout for return of normal state
    window.setTimeout(function(){mController.doAction('punch');},500);
    break;

   // to normal
   case cnf.getConfig('nekotanImgPunch'):
   default:
    // set normal image source address
    this._imgsrc = cnf.getConfig('nekotanImgNormal');
    break;
  }

  // return view name string
  return this._defaultView;
 };

 /**
  *  executeViewIndex
  * 
  *  @param   mRender  render  // render object
  * 
  *  @return  void
 **/
 this.executeViewIndex = function(render)
 {
  // update image source address
  DomUtils.getObject('nekotan').src = this._imgsrc;
 };
};
