/**
 *  mController
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: mController.js,v $ $Revision: 1.1 $ $Date: 2006/12/18 07:26:43 $
 * 
 *  @requires DomUtils
 *  @requires mUtils
**/
var mController =
{
 /**
  *  render object
  * 
  *  @see     mRender
  *  @private
 **/
 _render : {},

 /**
  *  request object
  * 
  *  @see     mRequest
  *  @private
 **/
 _request : {},

 /**
  *  model objects
  * 
  *  @see     mModel
  *  @private
 **/
 _models : {},

 /**
  *  action objects
  * 
  *  @see     mAction
  *  @private
 **/
 _actions : {},

 /**
  *  action chain
  * 
  *  @see     mController#doAction
  *  @private
 **/
 _actionChain : [],

 /**
  *  active action name
  * 
  *  @see     mController#doAction
  *  @private
 **/
 _actionName : null,

 /**
  *  active arguments
  * 
  *  @see     mController#doAction
  *  @private
 **/
 _actionArgs : null,

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 init : function()
 {
 },

 /**
  *  doAction
  * 
  *  @param   string  actionName  // target action name
  *  @param   object  args        // action arguments
  * 
  *  @return  void
 **/
 doAction : function(actionName,args)
 {
  mUtils.logger.resetLog();
  mController._actionName = actionName;
  mController._actionArgs = args;
  mController._loadConfig();
 },

 /**
  *  _loadConfig
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_loadLanguage
  *  @private
 **/
 _loadConfig : function()
 {
  mUtils.config.loadCustomConfig(this._actionName,this._loadLanguage,null);
 },

 /**
  *  _loadLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_loadFrame
  *  @private
 **/
 _loadLanguage : function()
 {
  mUtils.language.loadCustomLanguage(mController._actionName,mController._loadFrame,null);
 },

 /**
  *  _loadFrame
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_setupFrame
  *  @private
 **/
 _loadFrame : function()
 {
  var config  = mUtils.config;
  var render  = config.getConfig('renderPath') + config.getConfig('renderFile');
  var request = config.getConfig('requestPath') + config.getConfig('requestFile')
  mUtils.loadFile(render);
  mUtils.loadFile(request);
  mUtils.waitResponse(mController,
        {'_render'  : render,'_request' : request},
        mController._setupFrame,null);
 },

 /**
  *  _setupFrame
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_loadModel
  *  @private
 **/
 _setupFrame : function()
 {
  try
  {
   mController._request.init();
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','request initialize',
          mUtils.language.getLanguage('mControllerRequestCantSetup',
                {'request' : mUtils.config.getConfig('requestFile'),'message' : e}));
  }
  try
  {
   mController._render.init();
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','render initialize',
          mUtils.language.getLanguage('mControllerRequestCantSetup',
                {'render' : mUtils.config.getConfig('renderFile'),'message' : e}));
  }
  mController._loadModel();
 },

 /**
  *  _loadModel
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_setupModel
  *  @private
 **/
 _loadModel : function()
 {
  var file = mUtils.config.getConfig('modelPath') + this._actionName + 'Model.js';
  var obj  = {};
  obj[this._actionName] = file;
  mUtils.loadFile(file);
  mUtils.waitResponse(this._models,obj,this._loadAction,null);
 },

 /**
  *  _loadAction
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_setupAction
  *  @private
 **/
 _loadAction : function()
 {
  var file = mUtils.config.getConfig('actionPath') + mController._actionName + 'Action.js';
  var obj  = new Object();
  obj[mController._actionName] = file;
  mUtils.loadFile(file);
  mUtils.waitResponse(mController._actions,obj,mController._setupAction,null);
 },

 /**
  *  _setupAction
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_executeAction
  *  @private
 **/
 _setupAction : function()
 {
  var actionName = mController._actionName;
  var action = mController._actions[actionName];
  try
  {
   action.init(mController._models[actionName]);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action initialize',
          mUtils.language.getLanguage('mControllerActionCantInit',
                {'actionName' : actionName,'message' : e}));
  }
  mController._executeAction(action);
 },

 /**
  *  _executeAction
  * 
  *  @param   mAction  action  // current action
  * 
  *  @return  void
  * 
  *  @see     mController#_executeView
  *  @private
 **/
 _executeAction : function(action)
 {
  try
  {
   var viewName = action.execute(this._request,this._actionArgs);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action execute',
          mUtils.language.getLanguage('mControllerActionCantExecute',
                {'actionName' : this._actionName,'message' : e}));
  }
  this._executeView(action,viewName);
 },

 /**
  *  _executeView
  * 
  *  @param   mAction  action    // current action
  *  @param   enum     viewName  // target view name
  *                      executeViewIndex,executeViewInput,executeViewSuccess,
  *                      executeViewError,executeViewNone
  * 
  *  @return  void
  * 
  *  @private
 **/
 _executeView : function(action,viewName)
 {
  try
  {
   action[viewName](this._render);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action view',
          mUtils.language.getLanguage('mControllerActionCantView',
                {'actionName' : this._actionName,'viewName' : viewName,'message' : e}));
  }
  this._render.display();
  switch(true)
  {
   case this._actionChain.length != 0:
    this.doAction(this._actionChain.shift());
    break;
   case mUtils.config.getConfig('useDebug'):
    mUtils.renderLog('memo',true);
    break;
   default:
    break;
  }
 },


 /**
  *  appendActionChain
  * 
  *  @param   array  actionChain  // action chain array
  * 
  *  @return  void
  * 
  *  @see     mController::doAction
 **/
 appendActionChain : function(actionChain)
 {
  for(var i in actionChain)
   this._actionChain.push(actionChain[i]);
 }
};

DomUtils.appendEvent(window,'load',mController.init,'normal');
