/**
 *  @package  mValidate methods
 * 
 *  @author   $Author$
 *  @version  $Name$ $RCSfile$ $Revision$ $Date$
 * 
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  mRequireValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mRequireValidator = function(data,params)
 {
  if(data)
   return true;
  mUtils.logger.setMessage('validation','mValidator','require',
         mUtils.language.getLanguage('mValidatorRequire',{'keyName' : params.keyName}));
  return false;
 };

 /**
  *  mMinLengthValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMinLengthValidator = function(data,params)
 {
  if(data.length >= params.minLength)
   return true;
  mUtils.logger.setMessage('validation','mValidator','minLength',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName,'minLength' : params.minLength}));
  return false;
 };

 /**
  *  mMaxLengthValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMaxLengthValidator = function(data,params)
 {
  if(data.length <= params.maxLength)
   return true;
  mUtils.logger.setMessage('validation','mValidator','maxLength',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName,'maxLength' : params.maxLength}));
  return false;
 };

 /**
  *  mLengthValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mLengthRangeValidator = function(data,params)
 {
  if(data.length >= params.minLength && data.length <= params.maxLength)
   return true;
  mUtils.logger.setMessage('validation','mValidator','lengthRange',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName,'minLength' : params.minLength,'maxLength' : params.maxLength}));
  return false;
 };

 /**
  *  mMinValueValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMinValueValidator = function(data,params)
 {
  if(perseInt(data) <= perseInt(params.min))
   return true;
  mUtils.logger.setMessage('validation','mValidator','minValue',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName,'min' : params.min}));
  return false;
 };

 /**
  *  mMaxValueValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMaxValueValidator = function(data,params)
 {
  if(perseInt(data) >= perseInt(params.max))
   return true;
  mUtils.logger.setMessage('validation','mValidator','maxValue',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName,'max' : params.max}));
  return false;
 };

 /**
  *  mValueRangeValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mValueRangeValidator = function(data,params)
 {
  if(perseInt(data) <= perseInt(params.min) && perseInt(data) >= perseInt(params.max))
   return true;
  mUtils.logger.setMessage('validation','mValidator','valueRange',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName,'min' : params.min,'max' : params.max}));
  return false;
 };

 /**
  *  mAlphabetValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mAlphabetValidator = function(data,params)
 {
  if(data.match(/^[a-zA-Z]*$/))
   return true;
  mUtils.logger.setMessage('validation','mValidator','alphabet',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName}));
  return false;
 };

 /**
  *  mNumberValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mNumberValidator = function(data,params)
 {
  if(data.match(/^[0-9]*$/))
   return true;
  mUtils.logger.setMessage('validation','mValidator','number',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName}));
  return false;
 }

 /**
  *  mEnumValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mEnumValidator = function(data,params)
 {
  var flag = false;
  var earr = params.enumArray;
  for(var i in earr)
   if(data == earr[i])
    flag = true;
  return flag;
 }

 /**
  *  mMaskValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMaskValidator = function(data,params)
 {
  var reg = new RegExp(params.mask,params.maskflag);
  if(data.match(reg))
   return true;
  mUtils.logger.setMessage('validation','mValidator','mask',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName}));
  return false;
 };

 /**
  *  mFilterValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mFilterValidator = function(data,params)
 {
  var reg = new RegExp(params.filter,params.filterFlag);
  if(!data.match(reg))
   return true;
  mUtils.logger.setMessage('validation','mValidator','filter',
         mUtils.language.getLanguage('mValidator',{'keyName' : params.keyName}));
  return false;
 };
};
