/**
 *  onloadAction
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: onloadAction.js,v $ $Revision: 1.1 $ $Date: 2006/12/22 11:00:26 $
 * 
 *  @requires mController
 *  @member   mController
**/
{
 /**
  *  defaultView
  * 
  *  @private
 **/
 this._defaultView = 'executeViewIndex';

 /**
  *  init
  * 
  *  @param   mModel  model  // target model object
  * 
  *  @return  void
 **/
 this.init = function(model)
 {
 };

 /**
  *  execute
  * 
  *  @param   mRequst  request  // request object
  * 
  *  @return  string
 **/
 this.execute = function(request)
 {
  // preload action files
  mUtils.preloadActionFile(['view','change']);

  // append onchange event
  var fnc = new Function('mController.doAction("change");');
  DomUtils.appendEvent(DomUtils.getObject('activelang'),'change',fnc,'normal');

  // language name array
  var arr = ['en','jp'];
  // preload language file
  for(var i in arr)
   mUtils.loadFile(mUtils.config.getConfig('languagesPath') + arr[i] + '/lang.js');

  // preload template file
  mUtils.loadFile(mUtils.config.getConfig('templatePath') + 'season.html',true);

  // tab id array
  arr = ['Spring','Summer','Autumn','Winter'];
  for(i in arr)
  {
   // create function for doAction
   fnc = new Function('mController.doAction("view","' + arr[i] + '");');
   // append onclick event
   DomUtils.appendEvent(DomUtils.getObject(arr[i].toLowerCase()),'click',fnc,'normal');
  }

  // return view name string
  return this._defaultView;
 };

 /**
  *  executeViewIndex
  * 
  *  @param   mRender  render  // render object
  * 
  *  @return  void
 **/
 this.executeViewIndex = function(render)
 {
  // set render target object
  render.setRenderTarget(DomUtils.getObject('tabwindow'));
  // set render value
  render.setRenderValue({
        'Title' : mUtils.language.getLanguage('tabviewDefaultTitle'),
        'Body'  : mUtils.language.getLanguage('tabviewDefaultBody')});
 };
};
