/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit;

import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.MixedCalcLibraryInnerException;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.MixedCalcLibraryUtil;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ElementUtil;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.MixedCalcPreferenceManager;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ValueElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.AbstractUnit;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.IUnitManager;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.RatedUnit;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitCategory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitSet;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.xml.sax.SAXException;

public class UnitManager
extends AbstractUnit
implements IUnitManager {
    public static final String PROP_NAME_UNIT_SET = "unitSet";
    public static final String DEFAULT_UNIT_FILE_NAME = "unit.xml";
    private BeanReader reader;
    private static final int AS_MULTIPLY = 1;
    private static final int AS_DIVIDE = -1;
    private UnitSet unitSet;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private void initBeanReader() {
        this.reader = new BeanReader();
        this.reader.getXMLIntrospector().getConfiguration().setAttributesForPrimitives(false);
        this.reader.getBindingConfiguration().setMapIDs(false);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass(PROP_NAME_UNIT_SET, (Class)clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitCategory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("unitCategory", (Class)clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("unit", (Class)clazz3);
        }
        catch (IntrospectionException e) {
            String[] args = new String[]{DEFAULT_UNIT_FILE_NAME};
            String msg = MixedCalcLibraryUtil.getMessage("message.fatal.InvalidInternalFile", args);
            LoggerUtil.fatal(this.getClass(), (String)msg, (Throwable)e);
            throw new MixedCalcLibraryInnerException(msg, e);
        }
    }

    public UnitManager() {
        this.initBeanReader();
    }

    public UnitSet getUnitSet() {
        return this.unitSet;
    }

    public void setUnitSet(UnitSet unitSet) {
        UnitSet oldUnitSet = this.unitSet;
        this.unitSet = unitSet;
        super.firePropertyChange(PROP_NAME_UNIT_SET, oldUnitSet, unitSet);
    }

    private InputStream getInternalFileInputStream() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_UNIT_FILE_NAME);
        return is;
    }

    private InputStream getDefaultFileInputStream() {
        BufferedInputStream is;
        try {
            is = new BufferedInputStream(MixedCalcPreferenceManager.getFileInputStream(DEFAULT_UNIT_FILE_NAME));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String[] args = new String[]{DEFAULT_UNIT_FILE_NAME};
            String msg = MixedCalcLibraryUtil.getMessage("message.info.FileNotExist", args);
            LoggerUtil.info(this.getClass(), (String)msg);
            return null;
        }
        return is;
    }

    private UnitSet loadInputStream(InputStream is) throws IOException, SAXException {
        if (is == null) {
            return null;
        }
        UnitSet unitSet = (UnitSet)this.reader.parse(is);
        return unitSet;
    }

    public void load() {
        String msg;
        String[] args;
        String msg2;
        String[] args2;
        UnitSet unitSet = null;
        InputStream is = this.getDefaultFileInputStream();
        try {
            unitSet = this.loadInputStream(is);
        }
        catch (IOException e) {
            args2 = new String[]{DEFAULT_UNIT_FILE_NAME};
            msg2 = MixedCalcLibraryUtil.getMessage("message.error.InvalidPropertyFile", args2);
            LoggerUtil.error(this.getClass(), (String)msg2, (Throwable)e);
        }
        catch (SAXException e) {
            args2 = new String[]{DEFAULT_UNIT_FILE_NAME};
            msg2 = MixedCalcLibraryUtil.getMessage("message.error.InvalidPropertyFile", args2);
            LoggerUtil.error(this.getClass(), (String)msg2, (Throwable)e);
        }
        if (unitSet != null) {
            this.unitSet = unitSet;
            return;
        }
        is = this.getInternalFileInputStream();
        if (is == null) {
            args = new String[]{DEFAULT_UNIT_FILE_NAME};
            msg = MixedCalcLibraryUtil.getMessage("message.fatal.MissingInternalFile", args);
            LoggerUtil.fatal(this.getClass(), (String)msg);
            throw new MixedCalcLibraryInnerException(msg);
        }
        if (LoggerUtil.isDebugEnabled(this.getClass())) {
            args = new String[]{DEFAULT_UNIT_FILE_NAME};
            LoggerUtil.debug(this.getClass(), (String)MixedCalcLibraryUtil.getMessage("message.debug.ParsingInternalFile", args));
        }
        try {
            unitSet = this.loadInputStream(is);
        }
        catch (IOException e) {
            args2 = new String[]{DEFAULT_UNIT_FILE_NAME};
            msg2 = MixedCalcLibraryUtil.getMessage("message.fatal.InvalidInternalFile", args2);
            LoggerUtil.fatal(this.getClass(), (String)msg2, (Throwable)e);
            throw new MixedCalcLibraryInnerException(msg2, e);
        }
        catch (SAXException e) {
            args2 = new String[]{DEFAULT_UNIT_FILE_NAME};
            msg2 = MixedCalcLibraryUtil.getMessage("message.fatal.InvalidInternalFile", args2);
            LoggerUtil.fatal(this.getClass(), (String)msg2, (Throwable)e);
            throw new MixedCalcLibraryInnerException(msg2, e);
        }
        if (unitSet == null) {
            args = new String[]{DEFAULT_UNIT_FILE_NAME};
            msg = MixedCalcLibraryUtil.getMessage("message.fatal.InvalidInternalFile", args);
            LoggerUtil.fatal(this.getClass(), (String)msg);
            throw new MixedCalcLibraryInnerException(msg);
        }
        this.unitSet = unitSet;
    }

    private void initBeanWriter(BeanWriter writer) {
        writer.enablePrettyPrint();
        writer.getBindingConfiguration().setMapIDs(false);
    }

    private OutputStream getDefaultOutputStream() throws FileNotFoundException {
        BufferedOutputStream os = new BufferedOutputStream(MixedCalcPreferenceManager.getFileOutputStream(DEFAULT_UNIT_FILE_NAME));
        return os;
    }

    private void saveOutputStream(OutputStream os) throws IOException, SAXException, IntrospectionException {
        BeanWriter writer = new BeanWriter(os, "UTF-8");
        this.initBeanWriter(writer);
        writer.writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write((Object)this.unitSet);
    }

    public void save(OutputStream os) throws IOException, SAXException, IntrospectionException {
        this.saveOutputStream(os);
    }

    public void save() throws IOException, SAXException, IntrospectionException {
        OutputStream os = this.getDefaultOutputStream();
        this.saveOutputStream(os);
    }

    public void save(String path) throws IOException, SAXException, IntrospectionException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path));
        this.saveOutputStream(os);
    }

    private double getRateBetweenUnit(Unit unitFrom, Unit unitTo) {
        UnitCategory unitCategoryFrom = unitFrom.getUnitCategory();
        UnitCategory unitCategoryTo = unitTo.getUnitCategory();
        if (unitCategoryFrom == null || unitCategoryTo == null) {
            return 1.0;
        }
        if (unitCategoryFrom.getDimensionOfLength() != unitCategoryTo.getDimensionOfLength() || unitCategoryFrom.getDimensionOfMass() != unitCategoryTo.getDimensionOfMass() || unitCategoryFrom.getDimensionOfTime() != unitCategoryTo.getDimensionOfTime()) {
            return 1.0;
        }
        if (unitCategoryFrom.getDimensionOfLength() == 0 && unitCategoryFrom.getDimensionOfMass() == 0 && unitCategoryFrom.getDimensionOfTime() == 0 && !unitCategoryFrom.equals(unitCategoryTo)) {
            return 1.0;
        }
        return unitFrom.getRate() / unitTo.getRate();
    }

    public ValueElement convertUnit(ValueElement element, Unit unitTo) {
        Unit unitFrom = element.getUnit();
        double rate = unitFrom != null ? this.getRateBetweenUnit(unitFrom, unitTo) : 1.0;
        ValueElement result = ElementUtil.multiply(element, rate);
        result.setUnit(unitTo);
        return result;
    }

    private RatedUnit calculateUnits(Unit unit1, Unit unit2, int calculateAs) {
        double unit2Rate;
        int unit2DimOfTime;
        int unit2DimOfMass;
        int unit2DimOfLength;
        double unit1Rate;
        int unit1DimOfTime;
        int unit1DimOfMass;
        int unit1DimOfLength;
        if (unit1 != null) {
            unit1DimOfLength = unit1.getUnitCategory().getDimensionOfLength();
            unit1DimOfMass = unit1.getUnitCategory().getDimensionOfMass();
            unit1DimOfTime = unit1.getUnitCategory().getDimensionOfTime();
            unit1Rate = unit1.getRate();
        } else {
            unit1DimOfLength = 0;
            unit1DimOfMass = 0;
            unit1DimOfTime = 0;
            unit1Rate = 1.0;
        }
        if (unit2 != null) {
            unit2DimOfLength = unit2.getUnitCategory().getDimensionOfLength();
            unit2DimOfMass = unit2.getUnitCategory().getDimensionOfMass();
            unit2DimOfTime = unit2.getUnitCategory().getDimensionOfTime();
            unit2Rate = unit2.getRate();
        } else {
            unit2DimOfLength = 0;
            unit2DimOfMass = 0;
            unit2DimOfTime = 0;
            unit2Rate = 1.0;
        }
        if (unit1DimOfLength == 0 && unit2DimOfLength == 0 && unit1DimOfMass == 0 && unit2DimOfMass == 0 && unit1DimOfTime == 0 && unit2DimOfTime == 0) {
            RatedUnit ratedUnit = new RatedUnit();
            ratedUnit.unit = unit1 != null ? unit1 : unit2;
            ratedUnit.rate = 1.0;
            return ratedUnit;
        }
        int sign = calculateAs == 1 ? 1 : -1;
        int dimOfLength = unit1DimOfLength + sign * unit2DimOfLength;
        int dimOfMass = unit1DimOfMass + sign * unit2DimOfMass;
        int dimOfTime = unit1DimOfTime + sign * unit2DimOfTime;
        double rate = calculateAs == 1 ? unit1Rate * unit2Rate : unit1Rate / unit2Rate;
        if (dimOfLength == 0 && dimOfMass == 0 && dimOfTime == 0) {
            RatedUnit ratedUnit = new RatedUnit();
            ratedUnit.unit = null;
            ratedUnit.rate = rate;
            return ratedUnit;
        }
        Unit unit = this.searchUnit(dimOfLength, dimOfMass, dimOfTime, rate);
        if (unit == null) {
            RatedUnit ratedUnit = new RatedUnit();
            ratedUnit.unit = null;
            ratedUnit.rate = 1.0;
            return ratedUnit;
        }
        RatedUnit ratedUnit = new RatedUnit();
        ratedUnit.unit = unit;
        ratedUnit.rate = rate / unit.getRate();
        return ratedUnit;
    }

    public RatedUnit multiplyUnits(Unit unit1, Unit unit2) {
        return this.calculateUnits(unit1, unit2, 1);
    }

    public RatedUnit divideUnits(Unit unit1, Unit unit2) {
        return this.calculateUnits(unit1, unit2, -1);
    }

    public UnitCategory searchUnitCategory(int dimOfLength, int dimOfMass, int dimOfTime) {
        if (this.unitSet == null) {
            return null;
        }
        if (this.unitSet.getUnitCategoryList() == null) {
            return null;
        }
        Iterator it = this.unitSet.getUnitCategoryList().iterator();
        while (it.hasNext()) {
            UnitCategory unitCategory = (UnitCategory)it.next();
            if (unitCategory.getDimensionOfLength() != dimOfLength || unitCategory.getDimensionOfMass() != dimOfMass || unitCategory.getDimensionOfTime() != dimOfTime) continue;
            return unitCategory;
        }
        return null;
    }

    public Unit searchUnit(int dimOfLength, int dimOfMass, int dimOfTime, double rate) {
        UnitCategory unitCategory = this.searchUnitCategory(dimOfLength, dimOfMass, dimOfTime);
        if (unitCategory == null) {
            return null;
        }
        double logRateRequired = Math.log10(rate);
        Unit unitNearest = null;
        double logRateDiffNearest = Double.POSITIVE_INFINITY;
        Iterator it = unitCategory.getUnitList().iterator();
        while (it.hasNext()) {
            Unit unit = (Unit)it.next();
            double logRate = Math.log10(unit.getRate());
            double logRateDiff = Math.abs(logRate - logRateRequired);
            if (!(logRateDiff < logRateDiffNearest)) continue;
            unitNearest = unit;
            logRateDiffNearest = logRateDiff;
        }
        return unitNearest;
    }
}

