/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui.eclipse.actions;

import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitCategory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitSet;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcLoggerUtil;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcUIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class UnitCategoryCreateAction
extends Action {
    UnitSet unitSet = null;
    ISelectionProvider selectionProvider = null;

    public UnitCategoryCreateAction(UnitSet unitSet) {
        this.unitSet = unitSet;
    }

    public UnitCategoryCreateAction(UnitSet unitSet, ISelectionProvider selectionProvider) {
        this.unitSet = unitSet;
        this.selectionProvider = selectionProvider;
    }

    private void calculateEnabled(ISelection selection) {
        UnitCategory unitCategory = this.getUnitCategory(selection);
        if (this.getParentUnitSet(unitCategory) != null) {
            super.setEnabled(true);
        } else {
            super.setEnabled(false);
        }
    }

    private void calculateEnabled() {
        if (this.selectionProvider == null) {
            super.setEnabled(false);
        }
        this.calculateEnabled(this.selectionProvider.getSelection());
    }

    public boolean isEnabled() {
        this.calculateEnabled();
        return super.isEnabled();
    }

    private UnitCategory createNewUnitCategory() {
        UnitCategory unitCategory = new UnitCategory();
        unitCategory.setName(MixedCalcUIUtil.getMessage("label.newUnitCategory.name"));
        return unitCategory;
    }

    private UnitCategory getUnitCategory(ISelection selection) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (MixedCalcLoggerUtil.isTraceEnabled(((Object)((Object)this)).getClass())) {
            MixedCalcLoggerUtil.trace(((Object)((Object)this)).getClass(), firstElement.toString());
        }
        if (!(firstElement instanceof UnitCategory)) {
            return null;
        }
        return (UnitCategory)firstElement;
    }

    private UnitSet getParentUnitSet(UnitCategory unitCategory) {
        if (unitCategory == null) {
            return this.unitSet;
        }
        return unitCategory.getUnitSet();
    }

    public void run(ISelection selection) {
        UnitCategory unitCategory = this.getUnitCategory(selection);
        UnitSet unitSet = this.getParentUnitSet(unitCategory);
        if (unitSet == null) {
            return;
        }
        if (unitCategory != null) {
            int index = unitSet.indexOf(unitCategory);
            unitSet.addUnitCategory(++index, this.createNewUnitCategory());
        } else {
            unitSet.addUnitCategory(this.createNewUnitCategory());
        }
    }

    public void run() {
        if (this.selectionProvider == null) {
            return;
        }
        this.run(this.selectionProvider.getSelection());
    }
}

