/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui.eclipse.unit;

import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcUIUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class UnitPropertySourceAdapter
implements IPropertySource {
    private static final String ID_NAME = "name";
    private static final String ID_SIGN = "sign";
    private static final String ID_RATE = "rate";
    private Unit unit;

    public UnitPropertySourceAdapter(Unit unit) {
        this.unit = unit;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)ID_RATE, MixedCalcUIUtil.getMessage("label.unit.rate")), new TextPropertyDescriptor((Object)ID_SIGN, MixedCalcUIUtil.getMessage("label.unit.sign")), new TextPropertyDescriptor((Object)ID_NAME, MixedCalcUIUtil.getMessage("label.unit.name"))};
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (ID_NAME.equals(id)) {
            return this.unit.getName();
        }
        if (ID_SIGN.equals(id)) {
            return this.unit.getSign();
        }
        if (ID_RATE.equals(id)) {
            return Double.toString(this.unit.getRate());
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (ID_NAME.equals(id)) {
            this.unit.setName((String)value);
        } else if (ID_SIGN.equals(id)) {
            this.unit.setSign((String)value);
        } else if (ID_RATE.equals(id)) {
            double d;
            try {
                d = Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            this.unit.setRate(d);
        }
    }
}

