/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.ssuif.swt;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;
import jp.gr.java_conf.dev240k.util.ssuif.SsuifInnerException;
import jp.gr.java_conf.dev240k.util.ssuif.SsuifUtil;
import jp.gr.java_conf.dev240k.util.ssuif.swt.AbstractControlBuilder;
import jp.gr.java_conf.dev240k.util.ssuif.swt.IControlBuilder;
import jp.gr.java_conf.dev240k.util.ssuif.swt.IControlBuilderFactory;
import jp.gr.java_conf.dev240k.util.ssuif.swt.IControlFactory;
import jp.gr.java_conf.dev240k.util.ssuif.swt.PropertiesLoader;

public class ControlBuilderFactory
implements IControlBuilderFactory {
    private static final String STR_PROPERTIES_DEFAULT = "ssuif_default.properties";
    Map controlBuilderMap = new HashMap();
    Object controler;
    IControlFactory controlFactory;

    private void init() {
        try {
            if (LoggerUtil.isTraceEnabled(this.getClass())) {
                LoggerUtil.trace(this.getClass(), (String)SsuifUtil.getMessage((String)"message.trace.LoadDefaultSettings"));
            }
            this.include(STR_PROPERTIES_DEFAULT);
        }
        catch (ClassNotFoundException e) {
            String msg = SsuifUtil.getMessage((String)"message.fatal.CannotLoadDefaultSettings");
            LoggerUtil.fatal(this.getClass(), (String)msg, (Throwable)e);
            throw new SsuifInnerException(msg, (Throwable)e);
        }
        catch (InstantiationException e) {
            String msg = SsuifUtil.getMessage((String)"message.fatal.CannotLoadDefaultSettings");
            LoggerUtil.fatal(this.getClass(), (String)msg, (Throwable)e);
            throw new SsuifInnerException(msg, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = SsuifUtil.getMessage((String)"message.fatal.CannotLoadDefaultSettings");
            LoggerUtil.fatal(this.getClass(), (String)msg, (Throwable)e);
            throw new SsuifInnerException(msg, (Throwable)e);
        }
    }

    public ControlBuilderFactory() {
        this.init();
    }

    public ControlBuilderFactory(String fileName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.init();
        this.include(fileName);
    }

    public IControlBuilder getControlBuilder(Class modelClass) {
        IControlBuilder controlBuilder = (IControlBuilder)this.controlBuilderMap.get(modelClass);
        if (controlBuilder == null) {
            String[] args = new String[]{modelClass.getName()};
            LoggerUtil.warn(this.getClass(), (String)SsuifUtil.getMessage((String)"message.warn.CannotFindBuilder", (String[])args));
            return null;
        }
        if (!(controlBuilder instanceof AbstractControlBuilder)) {
            return controlBuilder;
        }
        AbstractControlBuilder abstractControlBuilder = (AbstractControlBuilder)controlBuilder;
        abstractControlBuilder.setControlBuilderFactory(this);
        return controlBuilder;
    }

    public void addControlBuilder(Class modelClass, IControlBuilder controlBuilder) {
        this.controlBuilderMap.put(modelClass, controlBuilder);
    }

    public void setControler(Object controler) {
        this.controler = controler;
    }

    public Object getControler() {
        return this.controler;
    }

    public IControlFactory getControlFactory() {
        return this.controlFactory;
    }

    public void setControlFactory(IControlFactory controlFactory) {
        this.controlFactory = controlFactory;
    }

    private void include(ResourceBundle rb, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (rb == null) {
            return;
        }
        PropertiesLoader loader = new PropertiesLoader();
        loader.load(rb, this, classLoader);
    }

    public void include(String fileName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.include(fileName, this.getClass().getClassLoader());
    }

    public void include(String fileName, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (LoggerUtil.isTraceEnabled(this.getClass())) {
            String[] args = new String[]{fileName};
            LoggerUtil.trace(this.getClass(), (String)SsuifUtil.getMessage((String)"message.trace.LoadSettings", (String[])args));
        }
        String baseName = fileName.replaceFirst("\\.properties$", "");
        ResourceBundle rb = ResourceBundle.getBundle(baseName, Locale.getDefault(), classLoader);
        this.include(rb, classLoader);
    }
}

