/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.dev240k.util.loader.ExtensionWrapper;
import jp.gr.java_conf.dev240k.util.loader.InvalidExtensionConfigurationException;
import jp.gr.java_conf.dev240k.util.loader.PluginManagerUtil;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class ExtensionPointWrapper {
    private IExtensionPoint extensionPoint = null;
    private List additionalExtensions = new ArrayList();

    public ExtensionPointWrapper() {
    }

    public ExtensionPointWrapper(IExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public void addExtensionWrapper(ExtensionWrapper extension) {
        this.additionalExtensions.add(extension);
    }

    public void setExtensionPoint(IExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public ExtensionWrapper getExtension(String extensionId) throws InvalidExtensionConfigurationException {
        if (this.extensionPoint != null) {
            try {
                IExtension extension = this.extensionPoint.getExtension(extensionId);
                if (extension != null) {
                    return new ExtensionWrapper(extension);
                }
            }
            catch (Exception e) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
            }
        }
        Iterator it = this.additionalExtensions.iterator();
        while (it.hasNext()) {
            ExtensionWrapper extension = (ExtensionWrapper)it.next();
            if (!extensionId.equals(extension.getUniqueIdentifier())) continue;
            return extension;
        }
        return null;
    }

    public ExtensionWrapper[] getExtensions() throws InvalidExtensionConfigurationException {
        int start;
        int i;
        ExtensionWrapper[] extensionWrappers;
        int length = this.additionalExtensions.size();
        if (this.extensionPoint != null) {
            try {
                IExtension[] extensions = this.extensionPoint.getExtensions();
                extensionWrappers = new ExtensionWrapper[length += extensions.length];
                i = 0;
                while (i < extensions.length) {
                    extensionWrappers[i] = new ExtensionWrapper(extensions[i]);
                    ++i;
                }
                start = i;
            }
            catch (Exception e) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
            }
        } else {
            extensionWrappers = new ExtensionWrapper[length];
            start = 0;
        }
        Iterator it = this.additionalExtensions.iterator();
        i = start;
        while (i < length) {
            extensionWrappers[i] = (ExtensionWrapper)it.next();
            ++i;
        }
        return extensionWrappers;
    }
}

