/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.loader;

import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.dev240k.util.dom.NodeWrapper;
import jp.gr.java_conf.dev240k.util.loader.ExtensionInstantiationException;
import jp.gr.java_conf.dev240k.util.loader.InvalidExtensionConfigurationException;
import jp.gr.java_conf.dev240k.util.loader.PluginManagerUtil;
import org.eclipse.core.runtime.IConfigurationElement;

public class ConfigurationElementWrapper {
    private IConfigurationElement configuration = null;
    private ClassLoader classLoader = null;
    private NodeWrapper node = null;

    public ConfigurationElementWrapper(IConfigurationElement configuration) {
        this.configuration = configuration;
    }

    public ConfigurationElementWrapper(ClassLoader classLoader, NodeWrapper node) {
        this.classLoader = classLoader;
        this.node = node;
    }

    public Object createExecutableExtension(String propertyName) throws ExtensionInstantiationException {
        if (this.configuration != null) {
            try {
                return this.configuration.createExecutableExtension(propertyName);
            }
            catch (Exception e) {
                throw new ExtensionInstantiationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
            }
        }
        String className = this.node.getAttribute(propertyName);
        if (className == null) {
            throw new ExtensionInstantiationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"));
        }
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ExtensionInstantiationException(PluginManagerUtil.getMessage("message.error.ClassNotFound"), e);
        }
        catch (InstantiationException e) {
            throw new ExtensionInstantiationException(PluginManagerUtil.getMessage("message.error.classInstantiationFailed"), e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionInstantiationException(PluginManagerUtil.getMessage("message.error.classInstantiationFailed"), e);
        }
    }

    public String getAttribute(String name) throws InvalidExtensionConfigurationException {
        if (this.configuration != null) {
            try {
                return this.configuration.getAttribute(name);
            }
            catch (Exception e) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
            }
        }
        return this.node.getAttribute(name);
    }

    public ConfigurationElementWrapper[] getChildren() throws InvalidExtensionConfigurationException {
        if (this.configuration != null) {
            try {
                IConfigurationElement[] children = this.configuration.getChildren();
                ConfigurationElementWrapper[] wrapperChildren = new ConfigurationElementWrapper[children.length];
                int i = 0;
                while (i < children.length) {
                    wrapperChildren[i] = new ConfigurationElementWrapper(children[i]);
                    ++i;
                }
                return wrapperChildren;
            }
            catch (Exception e) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
            }
        }
        List nodeList = this.node.getNodeList("*");
        if (nodeList == null) {
            return new ConfigurationElementWrapper[0];
        }
        ConfigurationElementWrapper[] wrapperChildren = new ConfigurationElementWrapper[nodeList.size()];
        Iterator it = nodeList.iterator();
        int i = 0;
        while (i < nodeList.size()) {
            wrapperChildren[i] = new ConfigurationElementWrapper(this.classLoader, (NodeWrapper)it.next());
            ++i;
        }
        return wrapperChildren;
    }

    public ConfigurationElementWrapper[] getChildren(String name) throws InvalidExtensionConfigurationException {
        if (this.configuration != null) {
            try {
                IConfigurationElement[] children = this.configuration.getChildren(name);
                ConfigurationElementWrapper[] wrapperChildren = new ConfigurationElementWrapper[children.length];
                int i = 0;
                while (i < children.length) {
                    wrapperChildren[i] = new ConfigurationElementWrapper(children[i]);
                    ++i;
                }
                return wrapperChildren;
            }
            catch (Exception exception) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"));
            }
        }
        List nodeList = this.node.getNodeList(name);
        if (nodeList == null) {
            return new ConfigurationElementWrapper[0];
        }
        ConfigurationElementWrapper[] wrapperChildren = new ConfigurationElementWrapper[nodeList.size()];
        Iterator it = nodeList.iterator();
        int i = 0;
        while (i < nodeList.size()) {
            wrapperChildren[i] = new ConfigurationElementWrapper(this.classLoader, (NodeWrapper)it.next());
            ++i;
        }
        return wrapperChildren;
    }

    public String getName() throws InvalidExtensionConfigurationException {
        if (this.configuration != null) {
            try {
                return this.configuration.getName();
            }
            catch (Exception exception) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"));
            }
        }
        return this.node.getNodeName();
    }

    public String getValue() throws InvalidExtensionConfigurationException {
        if (this.configuration != null) {
            try {
                return this.configuration.getValue();
            }
            catch (Exception exception) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"));
            }
        }
        String value = this.node.getNodeValue();
        if ("".equals(value.trim())) {
            return null;
        }
        return value;
    }
}

