<?
// ------------------------------------------------------------
// 
// IPアドレス通知用アダプター for MyDNS.JPとその他も!?
// 
// Ver.01.00	2013.10.01 T.Kabu
// ------------------------------------------------------------
?>
<?
// ----------------------------------------------------------------------
// Init Routine
// ----------------------------------------------------------------------
include("./mydns_init.php");

// ----------------------------------------------------------------------
// Message define Routine
// ----------------------------------------------------------------------
/////include("./mydns_msg.php");

// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
include("./mydns_sub.php");
?>
<?
// --------------------------------
// グローバル変数の設定
// --------------------------------
// アクセス日時の設定(グローバル変数)
$NOW_TIME = time();
$NOW_DAYTIME = date("Y/m/d H:i:s T", $NOW_TIME);

// リモートホストアドレス初期化
$REMOTE_ADDR = '';
// リモートホスト名初期化
$REMOTE_NAME = '';
// リモートホストIPアドレスがあるなら
if (isset($_SERVER["REMOTE_ADDR"]))
{
	// リモートホストIPアドレスを設定
	$REMOTE_ADDR = $_SERVER["REMOTE_ADDR"];
}
// リモートホスト名アドレスがあるなら
if (isset($_SERVER["REMOTE_NAME"]))
{
	// リモートホストIPアドレスを設定
	$REMOTE_NAME = $_SERVER["REMOTE_NAME"];
}

// ログイン状態を初期化(0=ログアウト)
$LOGIN_STATUS = 0;
// ログインIDを設定
unset($LOGIN_ID);

// メニュー番号初期化
$MENU = '000';
// ジョブ初期化
$JOB = '';

// エラーメッセージ初期化
$ERROR_MSG = '';

// デバッグメッセージ初期化
$DEBUG_MEMO = '';
?>
<?
// ----------------------------------------------------------------------
// URLの引数をグローバル変数に変換する必殺技
// ----------------------------------------------------------------------
foreach (array_keys($_REQUEST) as $PARAMNAME)
{
	global $$PARAMNAME;
	$$PARAMNAME = $_REQUEST[$PARAMNAME];
//	print "key:$PARAMNAME, param:$_REQUEST[$PARAMNAME]<BR>\n";
}
?>
<?
// ----------------------------------------------------------------------
// セッション管理
// ----------------------------------------------------------------------
// セッション設定($LOGIN_TIMEOUT分でタイムアウト、全ディレクトリに有効)
//session_set_cookie_params($LOGIN_TIMEOUT, '/');
session_cache_limiter('private');
session_cache_expire($LOGIN_TIMEOUT);
session_name($SESSIONID_NAME);
// セッションスタート
session_start();
$DEBUG_MEMO .= "セッション名:".$SESSIONID_NAME."\n";
?>
<?
// セッション情報があるなら
if (isset($_SESSION[$SESSIONID_NAME]))
{
	$DEBUG_MEMO .= "セッション情報ありました\n";
	// セッション情報からログイン情報を取得
	$LOGIN_INFO = $_SESSION[$SESSIONID_NAME];
}

// ログイン状態があって、ログイン状態(=1)なら
if (isset($LOGIN_INFO['login_status']) && $LOGIN_INFO['login_status'] == 1)
{
	$DEBUG_MEMO .= "ログインしてます\n";
	
	// ログイン情報を別変数にコピー
	$LOGIN_LANGUAGE = $LOGIN_INFO['login_language'];
	$LOGIN_STATUS = $LOGIN_INFO['login_status'];
	$LOGIN_TIME = $LOGIN_INFO['login_time'];
	$LOGIN_ID = $LOGIN_INFO['login_id'];

	$DEBUG_MEMO .= "ログイン状態での最終アクセスは".date("Y/m/d H:i:s", $LOGIN_TIME)."です\n";

}
else
{
	$DEBUG_MEMO .= "ログインしてません\n";
	
	// ログインしていない
	$LOGIN_LANGUAGE = 0; // 日本語 :-P
	$LOGIN_STATUS = 0;
	$LOGIN_TIME = 0;
	$LOGIN_ID = '';
}

// ログインしているなら
if ($LOGIN_STATUS == 1)
{
	// タイムアウトなら
	if (($LOGIN_TIME + ($LOGIN_TIMEOUT)) < $NOW_TIME)
	{
		// ログアウト処理
		$DEBUG_MEMO .= "タイムアウトしました\n";
		// 未指定
		$MENU = "090";
	}
	// そうではないなら
	else
	{
		// ログイン時間更新
		$LOGIN_TIME = $NOW_TIME;
	}
}

// タイムアウトを $LOGIN_TIMEOUT 分後とする
$IE_EXPIRE_DAYTIME = date("D, d M Y H:i:s JST", $NOW_TIME + ($LOGIN_TIMEOUT * 60));
// ヘッダー情報としてキャッシュタイム出力
Header("Pragma: no-cache");
Header("Cache-Control: no-cache");
Header("Expires: $IE_EXPIRE_DAYTIME");

// セッション情報に言語情報があって、言語モードがシステムで許される値なら 2012.03.26
if (
	$LOGIN_LANGUAGE == 0 || 
	$LOGIN_LANGUAGE == 1
	)
{
	// 問題なし
	$LANG_MODE = $LOGIN_LANGUAGE;
}
else
{
	//ブラウザの言語モードの先頭が日本語(=ja)なら
	if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) && preg_match('/^ja/i', $_SERVER['HTTP_ACCEPT_LANGUAGE']))
	{
		// 言語モードを日本語(=0)にする
		$LANG_MODE = 0;
	}
	// 検索エンジンのボットなら 2012.05.09 T.Kabu
	elseif (is_good_bot())
	{
		// 日本語モード(=0)
		$LANG_MODE = 0;
	}
	// そうではないなら
	else
	{
		// とりあえず英語モード(=1)
		$LANG_MODE = 1;
	}
}
?>
<?
// ----------------------------------------------------------------------
// Main Routine
// ----------------------------------------------------------------------
include("./mydns_main.php");
?>
<?
// ----------------------------------------------------------------------
// セッション情報格納
// ----------------------------------------------------------------------
// セッション情報に言語モードを設定
$LOGIN_INFO['login_language'] = $LANG_MODE;
// セッション情報に現在のログインステータスを設定
$LOGIN_INFO['login_status'] = $LOGIN_STATUS;
// ログイン状態(=1)なら
if ($LOGIN_STATUS == 1)
{
	// セッション情報にページにアクセスした最終日時を設定
	$LOGIN_INFO['login_time'] = $NOW_TIME;
	// セッション情報に現在のログインIDを設定
	$LOGIN_INFO['login_id'] = $LOGIN_ID;
}

// --------------------
// セッション情報格納
// --------------------
$_SESSION[$SESSIONID_NAME] = $LOGIN_INFO;
?>
<?
// --------------------
// DEBUG
// --------------------
$debug_flag = 0;

if ($debug_flag == 1)
{
	print "<PRE class=content12>\n";
	if (isset($DEBUG_MEMO)) print $DEBUG_MEMO."\n";
	if (isset($_REQUEST)) { print "↓クエリデータ----------\n"; var_dump($_REQUEST); }
	if (isset($_SERVER)) { print "↓サーバー情報----------\n"; var_dump($_SERVER); }
	if (isset($SESSION)) { print "↓セッション情報----------\n"; var_dump($SESSION); }
	if (isset($LOGIN_INFO)) { print "↓ログイン情報----------\n"; var_dump($LOGIN_INFO); }
	if (isset($ADAPTERINFO)) { print "↓アダプター情報----------\n"; var_dump($ADAPTERINFO); }
	if (isset($PASSWDINFO)) { print "↓パスワード情報----------\n"; var_dump($PASSWDINFO); }
	print "----------\n";
	print 'ログイン状態:'.$LOGIN_STATUS."\n";
	if ($LOGIN_STATUS == 1)
	{
		print 'ログインID:'.$LOGIN_ID."\n";
	}
	print 'アクセス日時:'.$NOW_DAYTIME."\n";
	print '言語モード:'.strval($LANG_MODE)."\n";
	print 'メニュー番号:'.$MENU."\n";
	print 'ジョブ:'.$JOB."\n";
	$JOB_TIME =  time() -$NOW_TIME;
	print '処理時間:'.$JOB_TIME."\n";
	print "</PRE>\n";
	
///	phpinfo();
}
?>
