<?
// ------------------------------------------------------------
// 
// MyDNS.JP    アダプターの各種設定(4xxはパスワード)
// 
// ------------------------------------------------------------
?>
<?
// --------------------------------
// メイン処理
// --------------------------------
// パスワード設定情報がないなら
if (!isset($PASSWDINFO))
{
	// エラーメッセージ設定
	$ERROR_MSG .= 'パスワード設定情報がありません!?';
	
	// 入力ページに戻る
	include("./mydns_body_menu300.php");
}
// 問題ないなら
else
{
	// --------------------------------
	// セッション情報処理
	// --------------------------------
	// 実変数をセッション情報に設定
	foreach (array_keys($PASSWDINFO) as $PARAMNAME)
	{
		// 実変数が配列だったら
		if (is_array($PASSWDINFO[$PARAMNAME]))
		{
			// 実変数をセッション情報に設定
			foreach(array_keys($PASSWDINFO[$PARAMNAME]) as $NUM)
			{
				// セッション情報に設定
				$SESSIONINFO['ADAPTERINFO['.$PARAMNAME.']['.strval($NUM).']'] = $PASSWDINFO[$PARAMNAME][$NUM];
			}
		}
		// 普通の変数だったら
		else
		{
			// セッション情報に設定
			$SESSIONINFO['ADAPTERINFO['.$PARAMNAME.']'] = $PASSWDINFO[$PARAMNAME];
		}
	}
	
	// --------------------------------
	// HTMLでやばい文字を変換…第二階層までしか対応していないョ!!
	// --------------------------------
	foreach (array_keys($PASSWDINFO) as $PARAMNAME)
	{
		// 変数が配列だったら
		if (is_array($PASSWDINFO[$PARAMNAME]))
		{
			// 配列をさらに展開
			foreach(array_keys($PASSWDINFO[$PARAMNAME]) as $NUM)
			{
				// 変数が文字列なら
				if (is_string($PASSWDINFO[$PARAMNAME]))
				{
					// 文字列を htmlspecialchars() にかけて、改行コードを追加する
					$PASSWDINFO[$PARAMNAME][$NUM] = nl2br(htmlspecialchars($PASSWDINFO[$PARAMNAME][$NUM], ENT_QUOTES));
				}
			}
		}
		// 変数が文字列なら
		elseif (is_string($PASSWDINFO[$PARAMNAME]))
		{
			// 文字列を htmlspecialchars() にかけて、改行コードを追加する
			$PASSWDINFO[$PARAMNAME] = nl2br(htmlspecialchars($PASSWDINFO[$PARAMNAME], ENT_QUOTES));
		}
	}
	
	// --------------------------------
	// パスワード情報確認
	// --------------------------------
	// パスワードが正しくないなら
	if (crypt($PASSWDINFO['target_old_passwd'], $PASSWDINFO['target_salt_passwd']) != $PASSWDINFO['target_salt_passwd'])
	{
		// エラーメッセージ設定
		$ERROR_MSG .= '現在のパスワードが正しくありません';
		
		// 入力ページに戻る
		include("./mydns_body_menu300.php");
	}
	// 新しいパスワードと確認用パスワードが合致しないなら
	else if ($PASSWDINFO['target_new_passwd'] !== $PASSWDINFO['target_tmp_passwd'])
	{
		// エラーメッセージ設定
		$ERROR_MSG .= '新しいパスワードと確認用パスワードが異なります';
		
		// 入力ページに戻る
		include("./mydns_body_menu300.php");
	}
	// 正常だったなら
	else
	{
		// 確認ページを表示
		include("./mydns_body_menu402.php");
	}
}
?>
