<?
// ------------------------------------------------------------
// 
// MyDNS.JP    サブルーチン
// 
// ------------------------------------------------------------
?>
<?
// --------------------
// Adapter Parameter Regist
// アダプターの設定値を保存
// --------------------
function adapter_parameter_write($MENU)
{
	// グローバル宣言
	global $CMD_SUDO;
	global $CMD_CP;
	global $CMD_RM;
	global $PARAMETER_TEMPNAME;
	global $PARAMETER_FILENAME;
	global $DEBUG_MEMO;
	
	// ------------------------------
	// IP通知設定情報をグローバル宣言
	// ------------------------------
	global $IPSENDINFO;
	// ------------------------------
	// アダプター設定情報をグローバル宣言
	// ------------------------------
	global $ADAPTERINFO;
	// ------------------------------
	// パスワード設定情報をグローバル宣言
	// ------------------------------
	global $PASSWDINFO;
	
	// メニュー番号による処理分岐
	switch ($MENU)
	{
		// IPアドレス通知設定
		case "100" :
		case "200" :
			// アダプター設定情報を読み込み
			adapter_parameter_read(300);
			// パスワード設定情報を読み込み
			adapter_parameter_read(400);
			// 抜ける
			break;
		case "300" :
			// IP通知設定情報を読み込み
			adapter_parameter_read(100);
			// パスワード設定情報を読み込み
			adapter_parameter_read(400);
			// 抜ける
			break;
		case "400" :
			// IP通知設定情報を読み込み
			adapter_parameter_read(100);
			// アダプター設定情報を読み込み
			adapter_parameter_read(300);
			// 抜ける
			break;
	}

	// DOMインスタンスの生成
	$XML_DOM = new DomDocument('1.0', 'UTF-8');
	// adapter ノードを追加
	$XML_ADAPTER = $XML_DOM->appendChild($XML_DOM->createElement('adapterinfo'));
	
	// ipsendinfo ノードを追加
	$XML_IPSENDIDINFO = $XML_ADAPTER->appendChild($XML_DOM->createElement('ipsendinfo'));
	
		// idpasswd ノードを追加
		$XML_URL = $XML_IPSENDIDINFO->appendChild($XML_DOM->createElement('url'));
			$XML_URL->appendChild($XML_DOM->createElement('ipv4', $IPSENDINFO['target_url_ipv4']));
			$XML_URL->appendChild($XML_DOM->createElement('ipv6', $IPSENDINFO['target_url_ipv6']));
	
	// target_id配列のサイズを調べて、既存設定＋4レコードを設定できるようにする
	$RECORD_MAX = count($IPSENDINFO['target_id']) + 4;
	
	// $RECORD_MAX分だけ入力項目を作る
	for ($RECORD_NUM = 0; $RECORD_NUM < $RECORD_MAX; $RECORD_NUM ++)
	{
		// マスターIDの指定がないなら
		if (!isset($IPSENDINFO['target_id'][$RECORD_NUM]) || !preg_match('/^mydns[0-9]{1,}/', $IPSENDINFO['target_id'][$RECORD_NUM]))
		{
			continue;
		}
		// idpasswd ノードを追加
		$XML_IDPASSWD = $XML_IPSENDIDINFO->appendChild($XML_DOM->createElement('idpasswd'));
			// 要素ノードを追加してテキストを入れる
			$XML_IDPASSWD->appendChild($XML_DOM->createElement('masterid', $IPSENDINFO['target_id'][$RECORD_NUM]));
			$XML_IDPASSWD->appendChild($XML_DOM->createElement('password', $IPSENDINFO['target_passwd'][$RECORD_NUM]));
			$XML_IDPASSWD->appendChild($XML_DOM->createElement('ipv4', $IPSENDINFO['target_ipv4'][$RECORD_NUM]));
			$XML_IDPASSWD->appendChild($XML_DOM->createElement('ipv6', $IPSENDINFO['target_ipv6'][$RECORD_NUM]));
			$XML_IDPASSWD->appendChild($XML_DOM->createElement('memo', $IPSENDINFO['target_memo'][$RECORD_NUM]));
	}
	
	// adapterinfo ノードを追加
	$XML_ADAPTERINFO = $XML_ADAPTER->appendChild($XML_DOM->createElement('adapterinfo'));
	
		// network ノードを追加
		$XML_NETWORK = $XML_ADAPTERINFO->appendChild($XML_DOM->createElement('network'));
			$XML_NETWORK->appendChild($XML_DOM->createElement('ipv4', $ADAPTERINFO['target_network_ipv4']));
			$XML_NETWORK->appendChild($XML_DOM->createElement('ipv6', $ADAPTERINFO['target_network_ipv6']));
		
		// ipv4address ノードを追加
		$XML_V4NETWORK = $XML_ADAPTERINFO->appendChild($XML_DOM->createElement('ipv4network'));
		if (isset($ADAPTERINFO['target_address_ipv4']) && is_array($ADAPTERINFO['target_address_ipv4']) && $ADAPTERINFO['target_network_ipv4'] === 'static')
		{
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('addr_0', $ADAPTERINFO['target_address_ipv4'][0]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('addr_1', $ADAPTERINFO['target_address_ipv4'][1]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('addr_2', $ADAPTERINFO['target_address_ipv4'][2]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('addr_3', $ADAPTERINFO['target_address_ipv4'][3]));
			
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('mask_0', $ADAPTERINFO['target_netmask_ipv4'][0]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('mask_1', $ADAPTERINFO['target_netmask_ipv4'][1]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('mask_2', $ADAPTERINFO['target_netmask_ipv4'][2]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('mask_3', $ADAPTERINFO['target_netmask_ipv4'][3]));
			
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('gate_0', $ADAPTERINFO['target_gateway_ipv4'][0]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('gate_1', $ADAPTERINFO['target_gateway_ipv4'][1]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('gate_2', $ADAPTERINFO['target_gateway_ipv4'][2]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('gate_3', $ADAPTERINFO['target_gateway_ipv4'][3]));
			
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('dns_0', $ADAPTERINFO['target_dns_ipv4'][0]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('dns_1', $ADAPTERINFO['target_dns_ipv4'][1]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('dns_2', $ADAPTERINFO['target_dns_ipv4'][2]));
			$XML_V4NETWORK->appendChild($XML_DOM->createElement('dns_3', $ADAPTERINFO['target_dns_ipv4'][3]));
		}
		// ipvaddress ノードを追加
		$XML_V6NETWORK = $XML_ADAPTERINFO->appendChild($XML_DOM->createElement('ipv6network'));
		if (isset($ADAPTERINFO['target_address_ipv6']) && is_array($ADAPTERINFO['target_address_ipv6']) && $ADAPTERINFO['target_network_ipv6'] === 'static')
		{
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_0', $ADAPTERINFO['target_address_ipv6'][0]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_1', $ADAPTERINFO['target_address_ipv6'][1]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_2', $ADAPTERINFO['target_address_ipv6'][2]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_3', $ADAPTERINFO['target_address_ipv6'][3]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_4', $ADAPTERINFO['target_address_ipv6'][4]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_5', $ADAPTERINFO['target_address_ipv6'][5]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_6', $ADAPTERINFO['target_address_ipv6'][6]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('addr_7', $ADAPTERINFO['target_address_ipv6'][7]));
			
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('mask', $ADAPTERINFO['target_netmask_ipv6']));
			
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_0', $ADAPTERINFO['target_gateway_ipv6'][0]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_1', $ADAPTERINFO['target_gateway_ipv6'][1]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_2', $ADAPTERINFO['target_gateway_ipv6'][2]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_3', $ADAPTERINFO['target_gateway_ipv6'][3]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_4', $ADAPTERINFO['target_gateway_ipv6'][4]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_5', $ADAPTERINFO['target_gateway_ipv6'][5]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_6', $ADAPTERINFO['target_gateway_ipv6'][6]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('gate_7', $ADAPTERINFO['target_gateway_ipv6'][7]));
			
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_0', $ADAPTERINFO['target_dns_ipv6'][0]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_1', $ADAPTERINFO['target_dns_ipv6'][1]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_2', $ADAPTERINFO['target_dns_ipv6'][2]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_3', $ADAPTERINFO['target_dns_ipv6'][3]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_4', $ADAPTERINFO['target_dns_ipv6'][4]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_5', $ADAPTERINFO['target_dns_ipv6'][5]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_6', $ADAPTERINFO['target_dns_ipv6'][6]));
			$XML_V6NETWORK->appendChild($XML_DOM->createElement('dns_7', $ADAPTERINFO['target_dns_ipv6'][7]));
		}
	
	// ipsendinfo ノードを追加
	$XML_PASSWDINFO = $XML_ADAPTER->appendChild($XML_DOM->createElement('passwdinfo'));
	
		// salt ノードを追加 (ここではパスワードはすでにcryptでsalt化されている)
		$XML_SALT = $XML_PASSWDINFO->appendChild($XML_DOM->createElement('salt'));
			$XML_SALT->appendChild($XML_DOM->createElement('passwd', $PASSWDINFO['target_salt_passwd']));
	
	// XML を整形（改行・字下げ）して出力
	$XML_DOM->formatOutput = true;
	// 保存（上書き）
	$RESULT = $XML_DOM->save($PARAMETER_TEMPNAME);
	if ($RESULT == FALSE) { $DEBUG_MEMO .= $PARAMETER_TEMPNAME."ファイルに書けません!?"."\n"; };
	// コピーして
	system($CMD_SUDO.' -u mydnsuser '.$CMD_CP.' '.$PARAMETER_TEMPNAME.' '.$PARAMETER_FILENAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $PARAMETER_FILENAME."にコピーできません!?"."\n"; };
	// 一時ファイルを削除
	system($CMD_RM.' -f '.$PARAMETER_TEMPNAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $PARAMETER_TEMPNAME."を削除できません!?"."\n"; };
}
?>
<?
// --------------------
// Adapter Parameter Read
// アダプターの設定値を保存
// --------------------
function adapter_parameter_read($MENU)
{
	// グローバル宣言
	global $PARAMETER_FILENAME;
	global $IPSENDURL_IPV4;
	global $IPSENDURL_IPV6;
	global $ADMIN_PWD;
	global $DEBUG_MEMO;
	
	// SimpleXMLで設定値保存ファイルを読み込む
	$XML = @simplexml_load_file($PARAMETER_FILENAME);

	// 正常に読み込めたなら
	if ($XML)
	{
		// メニュー番号による処理分岐
		switch ($MENU)
		{
			// IPアドレス通知設定
			case "100" :
			case "200" :
				// ------------------------------
				// IP通知設定情報をグローバル宣言
				// ------------------------------
				global $IPSENDINFO;
				
				$IPSENDINFO['target_url_ipv4'] = $XML->ipsendinfo->url->ipv4;
				$IPSENDINFO['target_url_ipv6'] = $XML->ipsendinfo->url->ipv6;
				
				foreach ($XML->ipsendinfo->idpasswd as $XML_VAL)
				{
					$IPSENDINFO['target_id'][] = $XML_VAL->masterid;
					$IPSENDINFO['target_passwd'][] = $XML_VAL->password;
					$IPSENDINFO['target_ipv4'][] = $XML_VAL->ipv4;
					$IPSENDINFO['target_ipv6'][] = $XML_VAL->ipv6;
					$IPSENDINFO['target_memo'][] = $XML_VAL->memo;
				}
				// 抜ける
				break;
			// アダプター各種設定
			case "300" :
				// ------------------------------
				// アダプター設定情報をグローバル宣言
				// ------------------------------
				global $ADAPTERINFO;
				
				// 型まで含めたチェック(=== か !===)をしているので文字列形に型キャストして設定
				$ADAPTERINFO['target_network_ipv4'] = (string)($XML->adapterinfo->network->ipv4);
				$ADAPTERINFO['target_network_ipv6'] = (string)($XML->adapterinfo->network->ipv6);
				
				$ADAPTERINFO['target_address_ipv4'][0] = $XML->adapterinfo->ipv4network->addr_0;
				$ADAPTERINFO['target_address_ipv4'][1] = $XML->adapterinfo->ipv4network->addr_1;
				$ADAPTERINFO['target_address_ipv4'][2] = $XML->adapterinfo->ipv4network->addr_2;
				$ADAPTERINFO['target_address_ipv4'][3] = $XML->adapterinfo->ipv4network->addr_3;
				
				$ADAPTERINFO['target_netmask_ipv4'][0] = $XML->adapterinfo->ipv4network->mask_0;
				$ADAPTERINFO['target_netmask_ipv4'][1] = $XML->adapterinfo->ipv4network->mask_1;
				$ADAPTERINFO['target_netmask_ipv4'][2] = $XML->adapterinfo->ipv4network->mask_2;
				$ADAPTERINFO['target_netmask_ipv4'][3] = $XML->adapterinfo->ipv4network->mask_3;
				
				$ADAPTERINFO['target_gateway_ipv4'][0] = $XML->adapterinfo->ipv4network->gate_0;
				$ADAPTERINFO['target_gateway_ipv4'][1] = $XML->adapterinfo->ipv4network->gate_1;
				$ADAPTERINFO['target_gateway_ipv4'][2] = $XML->adapterinfo->ipv4network->gate_2;
				$ADAPTERINFO['target_gateway_ipv4'][3] = $XML->adapterinfo->ipv4network->gate_3;
				
				$ADAPTERINFO['target_dns_ipv4'][0] = $XML->adapterinfo->ipv4network->dns_0;
				$ADAPTERINFO['target_dns_ipv4'][1] = $XML->adapterinfo->ipv4network->dns_1;
				$ADAPTERINFO['target_dns_ipv4'][2] = $XML->adapterinfo->ipv4network->dns_2;
				$ADAPTERINFO['target_dns_ipv4'][3] = $XML->adapterinfo->ipv4network->dns_3;
				
				$ADAPTERINFO['target_address_ipv6'][0] = $XML->adapterinfo->ipv6network->addr_0;
				$ADAPTERINFO['target_address_ipv6'][1] = $XML->adapterinfo->ipv6network->addr_1;
				$ADAPTERINFO['target_address_ipv6'][2] = $XML->adapterinfo->ipv6network->addr_2;
				$ADAPTERINFO['target_address_ipv6'][3] = $XML->adapterinfo->ipv6network->addr_3;
				$ADAPTERINFO['target_address_ipv6'][4] = $XML->adapterinfo->ipv6network->addr_4;
				$ADAPTERINFO['target_address_ipv6'][5] = $XML->adapterinfo->ipv6network->addr_5;
				$ADAPTERINFO['target_address_ipv6'][6] = $XML->adapterinfo->ipv6network->addr_6;
				$ADAPTERINFO['target_address_ipv6'][7] = $XML->adapterinfo->ipv6network->addr_7;
				
				$ADAPTERINFO['target_netmask_ipv6'] = $XML->adapterinfo->ipv6network->mask;
				
				$ADAPTERINFO['target_gateway_ipv6'][0] = $XML->adapterinfo->ipv6network->gate_0;
				$ADAPTERINFO['target_gateway_ipv6'][1] = $XML->adapterinfo->ipv6network->gate_1;
				$ADAPTERINFO['target_gateway_ipv6'][2] = $XML->adapterinfo->ipv6network->gate_2;
				$ADAPTERINFO['target_gateway_ipv6'][3] = $XML->adapterinfo->ipv6network->gate_3;
				$ADAPTERINFO['target_gateway_ipv6'][4] = $XML->adapterinfo->ipv6network->gate_4;
				$ADAPTERINFO['target_gateway_ipv6'][5] = $XML->adapterinfo->ipv6network->gate_5;
				$ADAPTERINFO['target_gateway_ipv6'][6] = $XML->adapterinfo->ipv6network->gate_6;
				$ADAPTERINFO['target_gateway_ipv6'][7] = $XML->adapterinfo->ipv6network->gate_7;
				
				$ADAPTERINFO['target_dns_ipv6'][0] = $XML->adapterinfo->ipv6network->dns_0;
				$ADAPTERINFO['target_dns_ipv6'][1] = $XML->adapterinfo->ipv6network->dns_1;
				$ADAPTERINFO['target_dns_ipv6'][2] = $XML->adapterinfo->ipv6network->dns_2;
				$ADAPTERINFO['target_dns_ipv6'][3] = $XML->adapterinfo->ipv6network->dns_3;
				$ADAPTERINFO['target_dns_ipv6'][4] = $XML->adapterinfo->ipv6network->dns_4;
				$ADAPTERINFO['target_dns_ipv6'][5] = $XML->adapterinfo->ipv6network->dns_5;
				$ADAPTERINFO['target_dns_ipv6'][6] = $XML->adapterinfo->ipv6network->dns_6;
				$ADAPTERINFO['target_dns_ipv6'][7] = $XML->adapterinfo->ipv6network->dns_7;
				// 抜ける
				break;
			// アダプターのパスワード設定
			case "0" :
			case "400" :
				// ------------------------------
				// パスワード設定情報をグローバル宣言
				// ------------------------------
				global $PASSWDINFO;
				
				// あとから設定したパスワードがあるなら
				if (isset($XML->passwdinfo->salt->passwd))
				{
					$PASSWDINFO['target_salt_passwd'] = (string)$XML->passwdinfo->salt->passwd;
				}
				// ないならデフォルトのを設定
				else
				{
					$PASSWDINFO['target_salt_passwd'] = $ADMIN_PWD;
				}
				// 抜ける
				break;
		}
	}
	else
	{
		// 読み込めなかった場合のエラー処理
		// エラーを出して初期化を促した方がよいかな？
		$DEBUG_MEMO .= $PARAMETER_FILENAME."が読めません!?"."\n";
		// メニュー番号による処理分岐
		switch ($MENU)
		{
			// IPアドレス通知設定
			case "100" :
			case "200" :
				// ------------------------------
				// IP通知設定情報をグローバル宣言
				// ------------------------------
				global $IPSENDINFO;
				
				$IPSENDINFO['target_url_ipv4'] = $IPSENDURL_IPV4;
				$IPSENDINFO['target_url_ipv6'] = $IPSENDURL_IPV6;
				
				// 抜ける
				break;
			// アダプター各種設定
			case "300" :
				// ------------------------------
				// アダプター設定情報をグローバル宣言
				// ------------------------------
				global $ADAPTERINFO;
				
				// 型まで含めたチェック(=== か !===)をしているので文字列形に型キャストして設定
				$ADAPTERINFO['target_network_ipv4'] = 'dhcp';
				$ADAPTERINFO['target_network_ipv6'] = 'auto';
				
				// 抜ける
				break;
			// アダプターのパスワード設定
			case "0" :
			case "400" :
				// ------------------------------
				// パスワード設定情報をグローバル宣言
				// ------------------------------
				global $PASSWDINFO;
				
				$PASSWDINFO['target_salt_passwd'] = $ADMIN_PWD;
				
				// 抜ける
				break;
		}
	}
	
	// ------------------------------
	// 
	// ------------------------------
	
	// ------------------------------
	// 
	// ------------------------------
	
}
?>
<?
// --------------------
// Adapter Parameter Init
// アダプターの設定値を保存
// --------------------
function adapter_parameter_init()
{
	// グローバル宣言
	global $CMD_SUDO;
	global $CMD_CP;
	global $CMD_RM;
	global $CMD_CRONTAB;
	global $PARAMETER_TEMPNAME;
	global $PARAMETER_FILENAME;
	global $DEBUG_MEMO;
	
	// 設定ファイルを削除前にコピー
	system($CMD_SUDO.' -u mydnsuser '.$CMD_CP.' '.$PARAMETER_FILENAME.' '.$PARAMETER_FILENAME.'.'.date("YmdHis"), $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $PARAMETER_FILENAME.'.'.date("YmdHis")."にコピーできません!?"."\n"; };
	// 設定ファイルを削除
	system($CMD_SUDO.' -u mydnsuser '.$CMD_RM.' -f '.$PARAMETER_FILENAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $PARAMETER_FILENAME."を削除できません!?"."\n"; };
	// crontabを削除する
	system($CMD_SUDO.' -u mydnsuser '.$CMD_CRONTAB.' -r ', $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= "crontabの設定を削除できません!?"."\n"; };
	// ログファイルは削除しません
	
	// ネットワークの初期化
	$ADAPTERINFO['target_network_ipv4'] = 'dhcp';
	$ADAPTERINFO['target_network_ipv6'] = 'auto';
	// --------------------------------
	// IPアドレス情報設定
	// --------------------------------
	$RESULT = setipinfo($ADAPTERINFO);
}
?>
<?
// --------------------
// IP send cron set
// IP通知cron設定
// --------------------
function ipsend_cron_set()
{
	// グローバル宣言
	global $IPSENDINFO;
	global $CMD_WGET;
	global $CMD_SUDO;
	global $CMD_CP;
	global $CMD_RM;
	global $CMD_CRONTAB;
	global $CRON_TEMPNAME;
	global $CRON_FILENAME;
	global $LOGS_DIRNAME;
	global $DEBUG_MEMO;
	
	// 生成結果を初期化
	$CRON_DATA = '';
	
	// target_id配列のサイズを調べて、既存設定＋4レコードを設定できるようにする
	$RECORD_MAX = count($IPSENDINFO['target_id']);
	
	// $RECORD_MAX分だけ入力項目を作る
	for ($RECORD_NUM = 0; $RECORD_NUM < $RECORD_MAX; $RECORD_NUM ++)
	{
		// マスターIDの指定がないなら
		if (!isset($IPSENDINFO['target_id'][$RECORD_NUM]) || !preg_match('/^mydns[0-9]{1,}/', $IPSENDINFO['target_id'][$RECORD_NUM]))
		{
			continue;
		}
		// 最初の情報部分を生成
		$CRON_COMMENT  = "###\n";
		$CRON_COMMENT .= "### ".$IPSENDINFO['target_id'][$RECORD_NUM].' : ';
		$CRON_STR_IPV4 = '';
		$CRON_STR_IPV6 = '';
		
		// IPv4の通知間隔の指定があるなら
///		if (isset($IPSENDINFO['target_ipv4'][$RECORD_NUM]) && is_int($IPSENDINFO['target_ipv4'][$RECORD_NUM]))
		if (isset($IPSENDINFO['target_ipv4'][$RECORD_NUM]))
		{
			// OFFなら
			if ($IPSENDINFO['target_ipv4'][$RECORD_NUM] == 0)
			{
				$CRON_COMMENT .= 'IPv4/OFF, ';
				$CRON_STR_IPV4 .= '#*/3'.$IPSENDINFO['target_ipv4'][$RECORD_NUM].' * * * * ';
			}
			// 24時間以上なら
			else if ($IPSENDINFO['target_ipv4'][$RECORD_NUM] == 1440)
			{
				$CRON_COMMENT .= 'IPv4/'.($IPSENDINFO['target_ipv4'][$RECORD_NUM] / 1440).'day, ';
				$CRON_STR_IPV4 .= rand(0,59).' '.rand(0,23).' * * * ';
			}
			// 60分以上なら
			else if ($IPSENDINFO['target_ipv4'][$RECORD_NUM] >= 60)
			{
				$CRON_COMMENT .= 'IPv4/'.($IPSENDINFO['target_ipv4'][$RECORD_NUM] / 60).'hour, ';
				$CRON_STR_IPV4 .= rand(0,59).' */'.($IPSENDINFO['target_ipv4'][$RECORD_NUM] / 60).' * * * ';
			}
			// 60分未満なら
			else
			{
				$CRON_COMMENT .= 'IPv4/'.$IPSENDINFO['target_ipv4'][$RECORD_NUM].'min, ';
				$CRON_STR_IPV4 .= '*/'.$IPSENDINFO['target_ipv4'][$RECORD_NUM].' * * * * ';
			}
		}
		// IPv6の通知間隔の指定があるなら
///		if (isset($IPSENDINFO['target_ipv6'][$RECORD_NUM]) && is_int($IPSENDINFO['target_ipv6'][$RECORD_NUM]))
		if (isset($IPSENDINFO['target_ipv6'][$RECORD_NUM]))
		{
			// OFFなら
			if ($IPSENDINFO['target_ipv6'][$RECORD_NUM] == 0)
			{
				$CRON_COMMENT .= 'IPv6/OFF, ';
				$CRON_STR_IPV6 .= '#*/3'.$IPSENDINFO['target_ipv6'][$RECORD_NUM].' * * * * ';
			}
			// 24時間以上なら
			else if ($IPSENDINFO['target_ipv6'][$RECORD_NUM] == 1440)
			{
				$CRON_COMMENT .= 'IPv6/'.($IPSENDINFO['target_ipv6'][$RECORD_NUM] / 1440).'day, ';
				$CRON_STR_IPV6 .= rand(0,59).' '.rand(0,23).' * * * ';
			}
			// 60分以上なら
			else if ($IPSENDINFO['target_ipv6'][$RECORD_NUM] >= 60)
			{
				$CRON_COMMENT .= 'IPv6/'.($IPSENDINFO['target_ipv6'][$RECORD_NUM] / 60).'hour, ';
				$CRON_STR_IPV6 .= rand(0,59).' */'.($IPSENDINFO['target_ipv6'][$RECORD_NUM] / 60).' * * * ';
			}
			// 60分未満なら
			else
			{
				$CRON_COMMENT .= 'IPv6/'.$IPSENDINFO['target_ipv6'][$RECORD_NUM].'min, ';
				$CRON_STR_IPV6 .= '*/'.$IPSENDINFO['target_ipv6'][$RECORD_NUM].' * * * * ';
			}
		}
		// memoがあるなら
		if (isset($IPSENDINFO['target_memo'][$RECORD_NUM]) && strlen($IPSENDINFO['target_memo'][$RECORD_NUM]))
		{
				$CRON_COMMENT .= $IPSENDINFO['target_memo'][$RECORD_NUM]."\n";
		}
		else
		{
				$CRON_COMMENT .= '(no memo)'."\n";
		}
		// IPv4のcron命令を設定
		$CRON_STR_IPV4 .= $CMD_WGET.' -O - --http-user='.$IPSENDINFO['target_id'][$RECORD_NUM].' --http-password='.$IPSENDINFO['target_passwd'][$RECORD_NUM].' '.$IPSENDINFO['target_url_ipv4'].' &> '.$LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result'."\n";
		$CRON_STR_IPV6 .= $CMD_WGET.' -O - --http-user='.$IPSENDINFO['target_id'][$RECORD_NUM].' --http-password='.$IPSENDINFO['target_passwd'][$RECORD_NUM].' '.$IPSENDINFO['target_url_ipv6'].' &> '.$LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result'."\n";
		
		$CRON_DATA .= $CRON_COMMENT.$CRON_STR_IPV4.$CRON_STR_IPV6."\n";
		
		// IP通知結果保存ディレクトリに既存のファイルがあるなら
		if (is_file($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result'))
		{
			// ファイルを削除
			system($CMD_SUDO.' -u mydnsuser '.$CMD_RM.' -f '.$LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result', $RESULT);
			if ($RESULT != 0) { $DEBUG_MEMO .= $LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result'."を削除できません!?"."\n"; };
		}
		// IP通知結果保存ディレクトリに既存のファイルがあるなら
		if (is_file($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result'))
		{
			// ファイルを削除
			system($CMD_SUDO.' -u mydnsuser '.$CMD_RM.' -f '.$LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result', $RESULT);
			if ($RESULT != 0) { $DEBUG_MEMO .= $LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result'."を削除できません!?"."\n"; };
		}
	}
	
	// 一時ファイルに出力
	$CRON_FILE = fopen($CRON_TEMPNAME, "w");
	if ($CRON_FILE == FALSE) { $DEBUG_MEMO .= $CRON_TEMPNAME."ファイルが開けません!?"."\n"; };
	$RESULT = fwrite($CRON_FILE, $CRON_DATA);
	if ($RESULT == FALSE) { $DEBUG_MEMO .= $CRON_TEMPNAME."ファイルに書けません!?"."\n"; };
	fclose($CRON_FILE);
	
	// コピーして
	system($CMD_SUDO.' -u mydnsuser '.$CMD_CP.' '.$CRON_TEMPNAME.' '.$CRON_FILENAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $CRON_FILENAME."にコピーできません!?"."\n"; };
	// 一時ファイルを削除
	system($CMD_RM.' -f '.$CRON_TEMPNAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $CRON_TEMPNAME."を削除できません!?"."\n"; };
	
	// crontabで読み込ませる
	system($CMD_SUDO.' -u mydnsuser '.$CMD_CRONTAB.' '.$CRON_FILENAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $CRON_FILENAME."をcrontabで読み込みできません!?"."\n"; };
	
	// 生成結果を返して終わり
	return $CRON_DATA;
}
?>
<?
// --------------------
// IP send result read
// IP通知結果を取得
// --------------------
function ipsend_result_read()
{
	// グローバル宣言
	global $IPSENDINFO;
	global $LOGS_DIRNAME;
	global $DEBUG_MEMO;
	
	// target_id配列のサイズを調べて、既存設定＋4レコードを設定できるようにする
	$RECORD_MAX = count($IPSENDINFO['target_id']);
	
	// $RECORD_MAX分だけ入力項目を作る
	for ($RECORD_NUM = 0; $RECORD_NUM < $RECORD_MAX; $RECORD_NUM ++)
	{
		// マスターIDの指定がないなら
		if (!isset($IPSENDINFO['target_id'][$RECORD_NUM]) || !preg_match('/^mydns[0-9]{1,}/', $IPSENDINFO['target_id'][$RECORD_NUM]))
		{
			continue;
		}
		
		
		// IPv4の通知間隔の指定があるなら
		if (isset($IPSENDINFO['target_ipv4'][$RECORD_NUM]))
		{
			// OFFなら
			if ($IPSENDINFO['target_ipv4'][$RECORD_NUM] == 0)
			{
				$IPSENDINFO['result_ipv4'][$RECORD_NUM] = '<B>OFF</B>';
			}
			// 通知間隔の設定があるなら
			else
			{
				// 結果ファイルがないなら
				if (!is_file($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result'))
				{
					// YETを設定
					$IPSENDINFO['result_ipv4'][$RECORD_NUM] = '<Font color="#8000C0"><B>YET</B></Font>';
				}
				// 結果ファイルがあるなら
				else
				{
					// デフォルトでNG!?を設定
					$IPSENDINFO['result_ipv4'][$RECORD_NUM] = '<a href="/showlog.php?MENU=200&JOB=SHOWLOG&TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv4&MODE=NG" title="'.date("Y/m/d H:i", filemtime($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result')).'" onClick="window.open(\'/showlog.php?TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv4&MODE=NG\',\''.$IPSENDINFO['target_id'][$RECORD_NUM].' IPv4 LOG\',\'width=800, height=480\') ; return false ;"><Font color="#000000" style="font-weight: bolder; color: #ffffff; background-color: #ff0000;">NG?!</Font></A>';
					
					// ファイルを開いて
					$RESULT_HANDLE = @fopen($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result', "r");
					if ($RESULT_HANDLE)
					{
						// 一行ずつ読み込み
						while (($RESULT_DATA = fgets($RESULT_HANDLE, 4096)) !== FALSE)
						{
							// 対象とする文字列があるなら
							if (preg_match('/login_status = 1./', $RESULT_DATA))
							{
								// OKを設定
								$IPSENDINFO['result_ipv4'][$RECORD_NUM] = '<a href="/showlog.php?MENU=200&JOB=SHOWLOG&TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv4&MODE=OK" title="'.date("Y/m/d H:i", filemtime($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result')).'" onClick="window.open(\'/showlog.php?TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv4&MODE=OK\',\''.$IPSENDINFO['target_id'][$RECORD_NUM].' IPv4 LOG\',\'width=800, height=480\') ; return false ;"><Font color="#00C000"><B>OK</B></Font></A>';
								// 読み込み終わり
								break;
							}
						}
						// ファイルを閉じる
						fclose($RESULT_HANDLE);
					}
					else
					{
						$DEBUG_MEMO .= $LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv4.result'.'が開けません!?'."\n";
					}
				}
			}
		}
		// IPv6の通知間隔の指定があるなら
		if (isset($IPSENDINFO['target_ipv6'][$RECORD_NUM]))
		{
			// OFFなら
			if ($IPSENDINFO['target_ipv6'][$RECORD_NUM] == 0)
			{
				$IPSENDINFO['result_ipv6'][$RECORD_NUM] = '<B>OFF</B>';
			}
			// 通知間隔の設定があるなら
			else
			{
				// 結果ファイルがないなら
				if (!is_file($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result'))
				{
					// YETを設定
					$IPSENDINFO['result_ipv6'][$RECORD_NUM] = '<Font color="#8000C0"><B>YET</B></Font>';
				}
				// 結果ファイルがあるなら
				else
				{
					// デフォルトでNG!?を設定
					$IPSENDINFO['result_ipv6'][$RECORD_NUM] = '<a href="/showlog.php?TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv6&MODE=NG" title="'.date("Y/m/d H:i", filemtime($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result')).'" onClick="window.open(\'/showlog.php?TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv6&MODE=NG\',\''.$IPSENDINFO['target_id'][$RECORD_NUM].' IPv6 LOG\',\'width=800,height=480\') ; return false ;"><Font color="#000000" style="font-weight: bolder; color: #ffffff; background-color: #ff0000;">NG?!</Font></A>';
					
					// ファイルを開いて
					$RESULT_HANDLE = @fopen($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result', "r");
					if ($RESULT_HANDLE)
					{
						// 一行ずつ読み込み
						while (($RESULT_DATA = fgets($RESULT_HANDLE, 4096)) !== FALSE)
						{
							// 対象とする文字列があるなら
							if (preg_match('/login_status = 1./', $RESULT_DATA))
							{
								// OKを設定
								$IPSENDINFO['result_ipv6'][$RECORD_NUM] = '<a href="/showlog.php?TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv6&MODE=OK" title="'.date("Y/m/d H:i", filemtime($LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result')).'" onClick="window.open(\'/showlog.php?TARGET_ID='.$IPSENDINFO['target_id'][$RECORD_NUM].'&PROTO=IPv6&MODE=OK\',\''.$IPSENDINFO['target_id'][$RECORD_NUM].' IPv6 LOG\',\'width=800,height=480\') ; return false ;"><Font color="#00C000"><B>OK</B></Font></A>';
								// 読み込み終わり
								break;
							}
						}
						// ファイルを閉じる
						fclose($RESULT_HANDLE);
					}
					else
					{
						$DEBUG_MEMO .= $LOGS_DIRNAME.'/'.$IPSENDINFO['target_id'][$RECORD_NUM].'_ipv6.result'.'が開けません!?'."\n";
					}
				}
			}
		}
	}
}
?>
<?
// --------------------------------
// Check IP info
// IPアドレス情報確認
// --------------------------------
function checkipinfo($ADAPTERINFO)
{
	// グローバル宣言
	global $ERROR_MSG; 
	global $DEBUG_MEMO; 
	
	// --------------------------------
	// IPv4ネットワーク情報のチェック
	// --------------------------------
	// IPv4ネットワークアドレスが固定(static)指定なら
	if (isset($ADAPTERINFO['target_network_ipv4']) && $ADAPTERINFO['target_network_ipv4'] === 'dhcp')
	{
		// OK
	}
	// IPv4ネットワークアドレスが固定(static)指定なら
	else if (isset($ADAPTERINFO['target_network_ipv4']) && $ADAPTERINFO['target_network_ipv4'] === 'static')
	{
		// IPv4ネットワークアドレスがないなら
		if (!isset($ADAPTERINFO['target_address_ipv4'][0]) ||
			!isset($ADAPTERINFO['target_address_ipv4'][1]) ||
			!isset($ADAPTERINFO['target_address_ipv4'][2]) ||
			!isset($ADAPTERINFO['target_address_ipv4'][3]) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4ネットワークアドレスが入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv4ネットワークアドレスが数字でないなら
		if (!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_address_ipv4'][0]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_address_ipv4'][1]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_address_ipv4'][2]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_address_ipv4'][3]) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4ネットワークアドレスが正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv4ネットワークアドレスの入力数値が異常なら
		if ($ADAPTERINFO['target_address_ipv4'][0] < 0 || $ADAPTERINFO['target_address_ipv4'][0] > 255 ||
			$ADAPTERINFO['target_address_ipv4'][1] < 0 || $ADAPTERINFO['target_address_ipv4'][1] > 255 ||
			$ADAPTERINFO['target_address_ipv4'][2] < 0 || $ADAPTERINFO['target_address_ipv4'][2] > 255 ||
			$ADAPTERINFO['target_address_ipv4'][3] < 0 || $ADAPTERINFO['target_address_ipv4'][3] > 255 ) 
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4ネットワークアドレスの値が正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		
		// IPv4ネットマスクがないなら
		if (!isset($ADAPTERINFO['target_netmask_ipv4'][0]) ||
			!isset($ADAPTERINFO['target_netmask_ipv4'][1]) ||
			!isset($ADAPTERINFO['target_netmask_ipv4'][2]) ||
			!isset($ADAPTERINFO['target_netmask_ipv4'][3]) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4のNETMASKが入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv4ネットマスクが数字でないなら
		if (!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_netmask_ipv4'][0]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_netmask_ipv4'][1]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_netmask_ipv4'][2]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_netmask_ipv4'][3]) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4のNETMASKが正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv4ネットマスクの入力数値が異常なら
		if ($ADAPTERINFO['target_netmask_ipv4'][0] < 0 || $ADAPTERINFO['target_netmask_ipv4'][0] > 255 ||
			$ADAPTERINFO['target_netmask_ipv4'][1] < 0 || $ADAPTERINFO['target_netmask_ipv4'][1] > 255 ||
			$ADAPTERINFO['target_netmask_ipv4'][2] < 0 || $ADAPTERINFO['target_netmask_ipv4'][2] > 255 ||
			$ADAPTERINFO['target_netmask_ipv4'][3] < 0 || $ADAPTERINFO['target_netmask_ipv4'][3] > 255 ) 
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4のNETMASKの値が正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		
		// IPv4ゲートウェイがないなら
		if (!isset($ADAPTERINFO['target_gateway_ipv4'][0]) ||
			!isset($ADAPTERINFO['target_gateway_ipv4'][1]) ||
			!isset($ADAPTERINFO['target_gateway_ipv4'][2]) ||
			!isset($ADAPTERINFO['target_gateway_ipv4'][3]) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4のGATEWAYが入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv4ゲートウェイが数字でないなら
		if (!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_gateway_ipv4'][0]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_gateway_ipv4'][1]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_gateway_ipv4'][2]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_gateway_ipv4'][3]) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4のGATEWAYが正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv4ゲートウェイの入力数値が異常なら
		if ($ADAPTERINFO['target_gateway_ipv4'][0] < 0 || $ADAPTERINFO['target_gateway_ipv4'][0] > 255 ||
			$ADAPTERINFO['target_gateway_ipv4'][1] < 0 || $ADAPTERINFO['target_gateway_ipv4'][1] > 255 ||
			$ADAPTERINFO['target_gateway_ipv4'][2] < 0 || $ADAPTERINFO['target_gateway_ipv4'][2] > 255 ||
			$ADAPTERINFO['target_gateway_ipv4'][3] < 0 || $ADAPTERINFO['target_gateway_ipv4'][3] > 255 ) 
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4のGATEWAYの値が正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv4ネットワークアドレスがリンクローカルアドレスなら
		if ($ADAPTERINFO['target_address_ipv4'][0] == 169 &&
			$ADAPTERINFO['target_address_ipv4'][1] == 254)
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4ネットワークアドレスがリンクローカルアドレスになっています';
			// FALSEを返して終わり
			return FALSE;
		}
		
		// IPv4ネットワークアドレスを16進表記にする
		$ipv4_address = sprintf("0x%02x%02x%02x%02x", $ADAPTERINFO['target_address_ipv4'][0], $ADAPTERINFO['target_address_ipv4'][1], $ADAPTERINFO['target_address_ipv4'][2], $ADAPTERINFO['target_address_ipv4'][3]);
		$ipv4_netmask = sprintf("0x%02x%02x%02x%02x", $ADAPTERINFO['target_netmask_ipv4'][0], $ADAPTERINFO['target_netmask_ipv4'][1], $ADAPTERINFO['target_netmask_ipv4'][2], $ADAPTERINFO['target_netmask_ipv4'][3]);
		$ipv4_gateway = sprintf("0x%02x%02x%02x%02x", $ADAPTERINFO['target_gateway_ipv4'][0], $ADAPTERINFO['target_gateway_ipv4'][1], $ADAPTERINFO['target_gateway_ipv4'][2], $ADAPTERINFO['target_gateway_ipv4'][3]);
			
		// ネットワーク範囲を計算する
		$ipv4_address_lower = gmp_and($ipv4_address, $ipv4_netmask);
		$ipv4_address_num = gmp_xor("0xffffffff", $ipv4_netmask);
		$ipv4_address_upper = gmp_add($ipv4_address_lower, $ipv4_address_num);
//		print long2ip(gmp_intval($ipv4_address_lower)).'～'.long2ip(gmp_intval($ipv4_address_upper)).'、'.gmp_intval($ipv4_address_num).'個'."\n";
		
		// ゲートウェイアドレスがネットワーク的に到達可能なら
		if (gmp_cmp($ipv4_gateway, $ipv4_address_lower) > 0 && gmp_cmp($ipv4_gateway, $ipv4_address_upper) < 0)
		{
//			print "ゲートウェイには到達可能\n";
		}
		else
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv4のGATEWAYに到達できません';
			// FALSEを返して終わり
			return FALSE;
		}
	}
	else
	{
		// エラーメッセージ設定
		$ERROR_MSG .= 'IPv4のネットワークの指定が異常です';
		// FALSEを返して終わり
		return FALSE;
	}
	
	// --------------------------------
	// IPv6ネットワーク情報のチェック
	// --------------------------------
	// IPv6ネットワークアドレスが固定(static)指定なら
	if (isset($ADAPTERINFO['target_network_ipv6']) && $ADAPTERINFO['target_network_ipv6'] === 'auto')
	{
		// OK
	}
	// IPv6ネットワークアドレスが固定(static)指定なら
	else if (isset($ADAPTERINFO['target_network_ipv6']) && $ADAPTERINFO['target_network_ipv6'] === 'static')
	{
		// IPv6ネットワークアドレスがないなら
		if (!isset($ADAPTERINFO['target_address_ipv6'][0]) ||
			!isset($ADAPTERINFO['target_address_ipv6'][1]) ||
			!isset($ADAPTERINFO['target_address_ipv6'][2]) ||
			!isset($ADAPTERINFO['target_address_ipv6'][3]) ||
			!isset($ADAPTERINFO['target_address_ipv6'][4]) ||
			!isset($ADAPTERINFO['target_address_ipv6'][5]) ||
			!isset($ADAPTERINFO['target_address_ipv6'][6]) ||
			!isset($ADAPTERINFO['target_address_ipv6'][7]) ||
			!isset($ADAPTERINFO['target_netmask_ipv6']) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv6ネットワークアドレスが入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		
		// IPv6ネットワークアドレスを小文字に変換
		for ($count = 0; $count < 8; $count ++)
		{
			$ADAPTERINFO['target_address_ipv6'][$count] = strtolower($ADAPTERINFO['target_address_ipv6'][$count]);
		}
		// IPv6ネットワークアドレスが正しくないなら
		if (!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][0]) ||
			!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][1]) ||
			!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][2]) ||
			!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][3]) ||
			!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][4]) ||
			!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][5]) ||
			!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][6]) ||
			!preg_match('/^[a-f0-9]{1,4}$/', $ADAPTERINFO['target_address_ipv6'][7]) ||
			!preg_match('/^[0-9]{1,3}$/', $ADAPTERINFO['target_netmask_ipv6']) )
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv6ネットワークアドレスが正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv6ネットワークアドレスの入力数値が異常なら
		if (intval('0x'.$ADAPTERINFO['target_address_ipv6'][0]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][0]) > 65535 ||
			intval('0x'.$ADAPTERINFO['target_address_ipv6'][1]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][1]) > 65535 ||
			intval('0x'.$ADAPTERINFO['target_address_ipv6'][2]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][2]) > 65535 ||
			intval('0x'.$ADAPTERINFO['target_address_ipv6'][3]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][3]) > 65535 ||
			intval('0x'.$ADAPTERINFO['target_address_ipv6'][4]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][4]) > 65535 ||
			intval('0x'.$ADAPTERINFO['target_address_ipv6'][5]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][5]) > 65535 ||
			intval('0x'.$ADAPTERINFO['target_address_ipv6'][6]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][6]) > 65535 ||
			intval('0x'.$ADAPTERINFO['target_address_ipv6'][7]) < 0 || intval('0x'.$ADAPTERINFO['target_address_ipv6'][7]) > 65535 ||
			$ADAPTERINFO['target_netmask_ipv6'] < 0 || $ADAPTERINFO['target_netmask_ipv6'] > 128)
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv6ネットワークアドレスの値が正しく入力されていません';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv6ネットワークアドレスがリンクローカルアドレスなら
		if ($ADAPTERINFO['target_address_ipv6'][0] === 'fe80')
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv6ネットワークアドレスがリンクローカルアドレスになっています';
			// FALSEを返して終わり
			return FALSE;
		}
		// IPv6ネットワークアドレスを16進表記にする
		$ipv6_address = sprintf("0x%04s%04s%04s%04s%04s%04s%04s%04s", 
								$ADAPTERINFO['target_address_ipv6'][0],
								$ADAPTERINFO['target_address_ipv6'][1],
								$ADAPTERINFO['target_address_ipv6'][2],
								$ADAPTERINFO['target_address_ipv6'][3],
								$ADAPTERINFO['target_address_ipv6'][4],
								$ADAPTERINFO['target_address_ipv6'][5],
								$ADAPTERINFO['target_address_ipv6'][6],
								$ADAPTERINFO['target_address_ipv6'][7]);
								
		$ipv6_netmask = gmp_init("0x00");
		$ipv6_bitmask = $ADAPTERINFO['target_netmask_ipv6'];
		for ($bit_num = 127; $bit_num >= 0; $bit_num-- )
		{
			gmp_setbit($ipv6_netmask, $bit_num, true);
			$ipv6_bitmask --;
			if ($ipv6_bitmask <= 0)
			{
				break;
			}
		}
//		print gmp_strval($ipv6_netmask, 16);
		
		$ipv6_gateway = sprintf("0x%04s%04s%04s%04s%04s%04s%04s%04s", 
								$ADAPTERINFO['target_gateway_ipv6'][0],
								$ADAPTERINFO['target_gateway_ipv6'][1],
								$ADAPTERINFO['target_gateway_ipv6'][2],
								$ADAPTERINFO['target_gateway_ipv6'][3],
								$ADAPTERINFO['target_gateway_ipv6'][4],
								$ADAPTERINFO['target_gateway_ipv6'][5],
								$ADAPTERINFO['target_gateway_ipv6'][6],
								$ADAPTERINFO['target_gateway_ipv6'][7]);
			
		// ネットワーク範囲を計算する
		$ipv6_address_lower = gmp_and($ipv6_address, $ipv6_netmask);
		$ipv6_address_num = gmp_xor("0xffffffffffffffffffffffffffffffff", $ipv6_netmask);
		$ipv6_address_upper = gmp_add($ipv6_address_lower, $ipv6_address_num);
//		print gmp_strval($ipv6_address_lower, 16).'～'.gmp_strval($ipv6_address_upper, 16).'、'.gmp_strval ($ipv6_address_num).'個'."\n";
		
		// ゲートウェイアドレスがネットワーク的に到達可能なら
		if (gmp_cmp($ipv6_gateway, $ipv6_address_lower) > 0 && gmp_cmp($ipv6_gateway, $ipv6_address_upper) < 0)
		{
//			print "ゲートウェイには到達可能\n";
		}
		else
		{
			// エラーメッセージ設定
			$ERROR_MSG .= 'IPv6のGATEWAYに到達できません';
			// FALSEを返して終わり
			return FALSE;
		}
	}
	else
	{
		// エラーメッセージ設定
		$ERROR_MSG .= 'IPv6のネットワークの指定が異常です';
		// FALSEを返して終わり
		return FALSE;
	}
		
	// OK
	return TRUE;
}
?>
<?
// --------------------
// Set IP info
// IPアドレス情報設定
// --------------------
function setipinfo($ADAPTERINFO)
{
	// グローバル宣言
	global $CMD_SUDO;
	global $CMD_CP;
	global $CMD_RM;
	global $CMD_NETWORK;
	global $IFCFG_DEVICE;
	global $IFCFG_TEMPNAME;
	global $IFCFG_FILENAME;
	global $ERROR_MSG; 
	global $DEBUG_MEMO;
	
	// ネットワーク設定情報を生成
	$IFCFG_DATA['00_device']					= 'DEVICE='.$IFCFG_DEVICE;
	$IFCFG_DATA['01_bootbroto']					= 'BOOTPROTO='.$ADAPTERINFO['target_network_ipv4'];
	$IFCFG_DATA['02_onboot']					= 'ONBOOT=yes';
	// もしtarget_network_ipv4がstaticなら
	if ($ADAPTERINFO['target_network_ipv4'] === 'static')
	{
		$IFCFG_DATA['03_ipaddr']				= 'IPADDR=';
		$IFCFG_DATA['03_ipaddr']				.= sprintf("%0d.%0d.%0d.%0d",
													$ADAPTERINFO['target_address_ipv4'][0],
													$ADAPTERINFO['target_address_ipv4'][1],
													$ADAPTERINFO['target_address_ipv4'][2],
													$ADAPTERINFO['target_address_ipv4'][3]);
		$IFCFG_DATA['04_netmask']				= 'NETMASK=';
		$IFCFG_DATA['04_netmask']				.= sprintf("%0d.%0d.%0d.%0d",
													$ADAPTERINFO['target_netmask_ipv4'][0],
													$ADAPTERINFO['target_netmask_ipv4'][1],
													$ADAPTERINFO['target_netmask_ipv4'][2],
													$ADAPTERINFO['target_netmask_ipv4'][3]);
		$IFCFG_DATA['04_gateway']				= 'GATEWAY=';
		$IFCFG_DATA['04_gateway']				.= sprintf("%0d.%0d.%0d.%0d",
													$ADAPTERINFO['target_gateway_ipv4'][0],
													$ADAPTERINFO['target_gateway_ipv4'][1],
													$ADAPTERINFO['target_gateway_ipv4'][2],
													$ADAPTERINFO['target_gateway_ipv4'][3]);
		// DNSの設定もきちんとしてあるなら
		if ((isset($ADAPTERINFO['target_dns_ipv4'][0]) && $ADAPTERINFO['target_address_ipv4'][0] !== '') &&
			(isset($ADAPTERINFO['target_dns_ipv4'][1]) && $ADAPTERINFO['target_address_ipv4'][1] !== '') &&
			(isset($ADAPTERINFO['target_dns_ipv4'][2]) && $ADAPTERINFO['target_address_ipv4'][2] !== '') &&
			(isset($ADAPTERINFO['target_dns_ipv4'][3]) && $ADAPTERINFO['target_address_ipv4'][3] !== '') ) 
		{
			$RESOLV_DATA						= 'nameserver ';
			$RESOLV_DATA						.= sprintf("%0d.%0d.%0d.%0d",
													$ADAPTERINFO['target_dns_ipv4'][0],
													$ADAPTERINFO['target_dns_ipv4'][1],
													$ADAPTERINFO['target_dns_ipv4'][2],
													$ADAPTERINFO['target_dns_ipv4'][3]);
		}
	}
	// そうではないなら
	{
		// DHCPなので何もしない
	}
	
	$IFCFG_DATA['10_nettworking_ipv6']			= 'IPV6INIT=yes';
	$IFCFG_DATA['11_nettworking_ipv6']			= 'NETWORKING_IPV6=yes';
	// もしtarget_network_ipv6がautoなら
	if ($ADAPTERINFO['target_network_ipv6'] === 'auto')
	{
		$IFCFG_DATA['12_ipv6_autoconf']			= 'IPV6_AUTOCONF=yes';
	}
	// そうではないなら
	else
	{
		$IFCFG_DATA['12_ipv6_autoconf']			= 'IPV6_AUTOCONF=no';
		$IFCFG_DATA['13_ipv6addr']				= 'IPV6ADDR=';
		$IFCFG_DATA['13_ipv6addr']				.= sprintf("%04s:%04s:%04s:%04s:%04s:%04s:%04s:%04s/%0s",
													$ADAPTERINFO['target_address_ipv6'][0],
													$ADAPTERINFO['target_address_ipv6'][1],
													$ADAPTERINFO['target_address_ipv6'][2],
													$ADAPTERINFO['target_address_ipv6'][3],
													$ADAPTERINFO['target_address_ipv6'][4],
													$ADAPTERINFO['target_address_ipv6'][5],
													$ADAPTERINFO['target_address_ipv6'][6],
													$ADAPTERINFO['target_address_ipv6'][7],
													$ADAPTERINFO['target_netmask_ipv6']);
		$IFCFG_DATA['13_ipv6_defaultgateway']	= 'IPV6_DEFAULTGW=';
		$IFCFG_DATA['13_ipv6_defaultgateway']	.= sprintf("%04s:%04s:%04s:%04s:%04s:%04s:%04s:%04s",
													$ADAPTERINFO['target_gateway_ipv6'][0],
													$ADAPTERINFO['target_gateway_ipv6'][1],
													$ADAPTERINFO['target_gateway_ipv6'][2],
													$ADAPTERINFO['target_gateway_ipv6'][3],
													$ADAPTERINFO['target_gateway_ipv6'][4],
													$ADAPTERINFO['target_gateway_ipv6'][5],
													$ADAPTERINFO['target_gateway_ipv6'][6],
													$ADAPTERINFO['target_gateway_ipv6'][7]);
		// DNSの設定もきちんとしてあるなら
		// …とおもったけど、IPv6のDNS設定はしないでおく…
	}
	$IFCFG_DATA['99_nm_controlledt']		= 'NM_CONTROLLED=no';
	
	// 出力データを生成
	$IFCFG_STR = '';
	ksort($IFCFG_DATA);
	foreach ($IFCFG_DATA as $IFCFG_NAME => $IFCFG_PARAM)
	{
		$IFCFG_STR .= $IFCFG_PARAM."\n";
	}
	
	// 一時ファイルに出力
	$IFCFG_FILE = fopen($IFCFG_TEMPNAME, "w");
	if ($IFCFG_FILE == FALSE) { $DEBUG_MEMO .= $IFCFG_TEMPNAME."ファイルが開けません!?"."\n"; };
	$RESULT = fwrite($IFCFG_FILE, $IFCFG_STR);
	if ($RESULT == FALSE) { $DEBUG_MEMO .= $IFCFG_TEMPNAME."ファイルに書けません!?"."\n"; }
	fclose($IFCFG_FILE);

	// コピーして
	system($CMD_SUDO.' -u root '.$CMD_CP.' '.$IFCFG_TEMPNAME.' '.$IFCFG_FILENAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $IFCFG_FILENAME."にコピーできません!?"."\n"; };
	// 一時ファイルを削除
	system($CMD_RM.' -f '.$IFCFG_TEMPNAME, $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $IFCFG_TEMPNAME."を削除できません!?"."\n"; };
	
	// ネットワークのrestartをする(標準出力に結果がでてしまうのでリダイレクトすること)
	system($CMD_SUDO.' -u root '.$CMD_NETWORK.' restart > /dev/null', $RESULT);
	if ($RESULT != 0) { $DEBUG_MEMO .= $IFCFG_FILENAME."で".$CMD_NETWORK.' restart'."ができません!?"."\n"; };

	// 生成結果を返して終わり
	return $IFCFG_STR;
}
?>
