<?php
	require("__include-common.php");
	require("../account/__logincheck.php");

	define('PRIVATE_DIR_1', str_replace('/', '', photo_RESIZE_DIR_SMALL));
	define('PRIVATE_DIR_2', str_replace('/', '', photo_RESIZE_DIR_THUMB));
	define('PRIVATE_DIR_3', str_replace('/', '', VIDEO_PREVIEW_CONVERT_FLV_DIR));

	_account_change($_GET['uid']);

	if (isset($_POST["path"]) && $_POST["path"] <> '') {
		$open_path = form_str_filepath($_POST["path"]);
	} elseif ($_GET['path'] <> '') {
		$open_path = my_GET('path');
	}
	$open_path = str_replace(DIRECTORY_SEPARATOR, '/', right_slash_strip($open_path));
	if ($open_path == '') {
		if ($_SESSION['photo_open_path'] <> '') {
			$open_path = $_SESSION['photo_open_path'];
		} else {
			$open_path = $_SESSION['login_friends_album_folder_'.$_SESSION['current_id']];
			if ($open_path == '') {
				$open_path = DEFAULT_IMAGES_FOLDER;
			}
		}
	}
	if (defined("photo_LIMITED_IMAGES_FOLDER") and photo_LIMITED_IMAGES_FOLDER <> '') {
		if ($_SESSION['システム管理者'] <> "YES" or photo_LIMITED_ADMIN_NOLIMIT <> 'YES') {
			$len = strlen(photo_LIMITED_IMAGES_FOLDER);
			if (substr($open_path, 0, $len) <> photo_LIMITED_IMAGES_FOLDER) {
				$open_path = photo_LIMITED_IMAGES_FOLDER;
			}
		}
	}
	$open_path = right_slash_strip($open_path);
	if ($_GET['imgmax'] <> '') {
		$_SESSION['photo_imgmax'] = $_GET['imgmax'];
	}
	if ($_GET['vss'] <> '') {
		$_SESSION['video_thumb_ss'] = $_GET['vss'];
	}
	if ($_SESSION['photo_imgmax'].'' == '') {
		$_SESSION['photo_imgmax'] = IMAGE_MAX_DEFAULT;
	}
	if ($_GET['mode'].'' <> '') {
		$_SESSION['photo_view_mode'] = $_GET['mode'];
		setcookie('photo_view_mode', $_SESSION['photo_view_mode'], time() + LOGIN_COOKIE_EXPIRE, '/');
	} else {
		if (isset($_COOKIE['photo_view_mode'])) {
			$_SESSION['photo_view_mode'] = $_COOKIE['photo_view_mode'];
		}
	}
	if ($_SESSION['photo_view_mode'] == '') {
		$_SESSION['photo_view_mode'] = 't';
	}
	if ($_GET['page'].'' <> '') {
		$page = intval($_GET['page']);
		if ($page < 1) {
			$page = 1;
		}
	} else {
		$page = 1;
	}
	if ($_GET['auto'].'' <> '') {
		$_SESSION['slide_view_auto'] = $_GET['auto'];
	}
	if ($_GET['rep'].'' <> '') {
		$_SESSION['slide_view_repeat'] = $_GET['rep'];
	}
	if ($_GET['flv'].'' <> '') {
		$_SESSION['slide_flv_preview'] = $_GET['flv'];
		setcookie('slide_flv_preview', $_SESSION['slide_flv_preview'], time() + LOGIN_COOKIE_EXPIRE, '/');
		$_SESSION['video_timeline_thumb'] = '';
	} else {
		if (isset($_COOKIE['slide_flv_preview'])) {
			$_SESSION['slide_flv_preview'] = $_COOKIE['slide_flv_preview'];
		}
	}
	if ($_COOKIE['slide_main_size'].'' <> '') {
		$_SESSION['slide_main_size'] = intval($_COOKIE['slide_main_size']);
	} elseif ($_SESSION['slide_main_size'].'' == '') {
		$_SESSION['slide_main_size'] = SLIDE_MAIN_SIZE;
	}
	if ($_COOKIE['photo_thumbs_size'].'' <> '') {
		$_SESSION['photo_thumbs_size'] = $_COOKIE['photo_thumbs_size'];
	} elseif ($_SESSION['photo_thumbs_size'].'' == '') {
		$_SESSION['photo_thumbs_size'] = SMALL_SIZE;
	}
	if ($_GET['it'].'' <> '') {
		$_SESSION['slide_interval_time'] = $_GET['it'];
	} elseif ($_SESSION['slide_interval_time'].'' == '') {
		if ($_COOKIE['slide_interval_time'].'' <> '') {
			$_SESSION['slide_interval_time'] = $_COOKIE['slide_interval_time'];
		} else {
			$_SESSION['slide_interval_time'] = SLIDE_INTERVAL_TIME;
		}
	}
	if ($_GET['vst'].'' <> '') {
		$_SESSION['video_timeline_thumb'] = $_GET['vst'];
		$_SESSION['slide_flv_preview'] = '';
		setcookie('slide_flv_preview', '', time() + LOGIN_COOKIE_EXPIRE, '/');
	}
	if ($_GET['vsn'].'' <> '') {
		$_SESSION['video_timeline_thumb_num'] = $_GET['vsn'];
	} elseif ($_SESSION['video_timeline_thumb_num'].'' == '') {
		if ($_COOKIE['video_timeline_thumb_num'].'' <> '') {
			$_SESSION['video_timeline_thumb_num'] = $_COOKIE['video_timeline_thumb_num'];
		} else {
			$_SESSION['video_timeline_thumb_num'] = VIDEO_TIMELINE_THUMB_NUM;
		}
	}
	if ($_COOKIE['video_timeline_thumb_size'].'' <> '') {
		$_SESSION['video_timeline_thumb_size'] = $_COOKIE['video_timeline_thumb_size'];
	} elseif ($_SESSION['video_timeline_thumb_size'].'' == '') {
		$_SESSION['video_timeline_thumb_size'] = VIDEO_TIMELINE_THUMB_SIZE;
	}
	if ($_SESSION['photo_open_path'] <> $open_path) {
		$_SESSION['photo_open_path'] = $open_path;
		$_SESSION['photo_subdir_count'] = 0;
		$_SESSION['photo_img_count'] = 0;
		unset($_SESSION['photo_subdir']);
		unset($_SESSION['photo_img']);
		unset($_SESSION['photo_img_type']);
		unset($_SESSION['up_folder_subdir']);
		get_target_path_info($open_path);
	}
	$add_meta = '';
	if ($_SESSION['photo_view_mode'] == 's' and $_SESSION['slide_view_auto'] == 'on') {
		if ($page < ceil($_SESSION['photo_img_count'])) {
			$add_meta = '<meta http-equiv="refresh" content="'.$_SESSION['slide_interval_time'].';';
			$add_meta .= 'url='.$_SERVER['SCRIPT_NAME'].'?page='.strval($page+1);
			$add_meta .= '&path='.urlencode($open_path);
			$add_meta .= '&mode=s">';
		} elseif ($_SESSION['slide_view_repeat'] == 'on') {
			$add_meta = '<meta http-equiv="refresh" content="'.$_SESSION['slide_interval_time'].';';
			$add_meta .= 'url='.$_SERVER['SCRIPT_NAME'].'?page=1';
			$add_meta .= '&path='.urlencode($open_path);
			$add_meta .= '&mode=s">';
		}
	}
	if ($_SESSION['photo_view_mode'] == 's' and $_SESSION['slide_flv_preview'] <> 'on' and $_SESSION['video_timeline_thumb'] <> 'on') {
		html_header(HTML_TITLE, '', '', ' onload="pixasticImageOnLoad()"', $add_meta);
	} else {
		html_header(HTML_TITLE, '', '', '', $add_meta);
	}
	page_header(False);		//ログイン表示なし
	contents_header();
	photo_body($open_path, $page);
	page_footer();
	html_footer();
	exit();
?>
<?php
function photo_body($open_path, $page) {
	view_photo_dir($open_path, $page);
	if ($_SESSION['photo_view_mode'] == 's') {
		view_photo_slide($open_path, $page, $_SESSION['slide_view_auto']);
	} elseif ($_SESSION['photo_view_mode'] == 'b') {
		view_photo_thumbnail_b($open_path, $page);
	} else {
		view_photo_thumbnail($open_path, $page);
	}
}
function get_target_path_info($open_path) {
	get_up_folder_subdir($open_path);
	$path_SJIS = myfile_ENCODE($open_path);
	if ($dir = opendir($path_SJIS)) {
		$subdir_count = 0;
		$img_count = 0;
		$files = scandir($path_SJIS);
		foreach ($files as $file) {
			if ($file != '.' && $file != '..' && $file != PRIVATE_DIR_1 && $file != PRIVATE_DIR_2 && $file != PRIVATE_DIR_3) {
				if (is_dir($path_SJIS.'/'.$file)) {
					$_SESSION['photo_subdir'][++$subdir_count] = myfile_DECODE($file);
				} elseif (is_img_filename($file)) {
					$_SESSION['photo_img'][++$img_count] = myfile_DECODE($file);
				} else {
					if (photo_VIDEO_FFMPEG == "YES") {
						if (is_video_filename($file)) {
							$_SESSION['photo_img'][++$img_count] = myfile_DECODE($file);
							$_SESSION['photo_img_type'][$img_count] = 'video';
						}
					}
				}
			}
		}
		closedir($dir);
	}
	$_SESSION['photo_subdir_count'] = $subdir_count;
	$_SESSION['photo_img_count'] = $img_count;
}
function get_up_folder_subdir($open_path) {
	if (!strstr($open_path,'/')) {
		return;
	}
	$up_path = up_folder_path($open_path);
	$path_SJIS = myfile_ENCODE($up_path);
	if ($dir = opendir($path_SJIS)) {
		$subdir_count = 0;
		$files = scandir($path_SJIS);
		foreach ($files as $file) {
			if ($file != '.' && $file != '..' && $file != PRIVATE_DIR_1 && $file != PRIVATE_DIR_2 && $file != PRIVATE_DIR_3) {
				if (is_dir($path_SJIS.'/'.$file)) {
					$_SESSION['up_folder_subdir'][++$subdir_count] = myfile_DECODE($file);
				}
			}
		}
		closedir($dir);
	}
}
function view_photo_dir($open_path, $page) {
	$up_path = up_folder_path($open_path);
?>
<div id="photo_body">
<div id="photo_header">
	<form name="frm0" action="<?= $_SERVER['SCRIPT_NAME'] ?>" method="post">
		<input type="button" value="↑" onClick="location.href='<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode(up_folder_path($open_path)) ?>'">
		<input class="text" type="text" name="path" value="<?= my_htmlspecialchars($open_path) ?>" size=50>
		<input type="submit" name="path_change" value="変更">
		<?php
			change_view_mode($_SESSION['photo_view_mode'], $open_path, $page);
			change_view_thumb_ss($page);
			if ($_SESSION['システム管理者'] == "YES") {
				if (photo_JPEG_RESIZE == 'YES') {
		?>
			<a href="img-resize.php?path=<?= urlencode($open_path) ?>" target="_blank" style="margin: 0 3px;">画像一括縮小</a>
		<?php
				}
				if (photo_VIDEO_FFMPEG == 'YES') {
		?>
			<a href="video-convert.php?path=<?= urlencode($open_path) ?>" target="_blank" style="margin: 0 3px;">動画一括変換</a>
		<?php
				}
			}
			if ($_SESSION['photo_view_mode'] == 's') {
				change_view_slide_option($page, $open_path);
			} else {
				select_page_images_max($_SESSION['photo_imgmax']);
			}
		?>
	</form>
</div>
<div id="dir_change_area">
<?php if (isset($_SESSION['up_folder_subdir'])) { ?>
<div id="up_folder_subdir" class="photo_dir_change">
<script type="text/javascript">
function upfolderOff(){
	$("#up_folder_subdir_area").css("display","none");
	$("#up_folder_subdir_on").css("display","");
	$.cookie("photo_up_folder_display","none",{ expires: 365 });
}
function upfolderOn(){
	$("#up_folder_subdir_area").css("display","");
	$("#up_folder_subdir_on").css("display","none");
	$.cookie("photo_up_folder_display","",{ expires: 365 });
}
</script>
	<span id="up_folder_subdir_area" style="display:<?= $_COOKIE['photo_up_folder_display'] == 'none' ? 'none' : '' ?>;">
<?php
	$current_folder = substr($open_path,strrpos($open_path,'/')+1);
	foreach ($_SESSION['up_folder_subdir'] as $subdir) {
		if ($subdir == $current_folder) {
			$class = ' id="current_folder"';
		} else {
			$class = '';
		}
?>
		<span class="photo_dir_change_a">
		<a href="<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode($up_path.'/'.$subdir) ?>"<?= $class ?>><?= $subdir ?></a>
		</span>
<?php
	}
?>
	<span id="up_folder_subdir_off"><a href="javascript:upfolderOff()">←▲非表示</a></span>
	</span>
	<span id="up_folder_subdir_on" style="display:<?= $_COOKIE['photo_up_folder_display'] == 'none' ? '' : 'none' ?>;"><a href="javascript:upfolderOn()">▼上位フォルダ表示</a></span>
</div>
<?php } ?>
<div id="current_folder_subdir" class="photo_dir_change">
<?php
	foreach ($_SESSION['photo_subdir'] as $subdir) {
?>
		<span class="photo_dir_change_a">
		<a href="<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode($open_path.'/'.$subdir) ?>"><?= $subdir ?></a>
		</span>
<?php
	}
?>
</div>
</div>
<?php
}
function view_photo_thumbnail($open_path, $page) {
	$img_count = $_SESSION['photo_img_count'];
	$start_count = ($page - 1) * $_SESSION['photo_imgmax'] + 1;		//開始番号を算出
	$end_count = $page * $_SESSION['photo_imgmax'];				//終了番号を算出
	$pagemax = ceil($img_count / $_SESSION['photo_imgmax']);		//取得したファイル数から最終頁を算出
	if ($end_count > $img_count) {
		$end_count = $img_count;
	}
?>
<div id="photo_image_size_change" style="padding:5;">
<input type="button" value="最小" onClick="setSizeImage(<?= SMALL_SIZE ?>)">
<input type="button" value="小さく" onClick="resizeImage(-<?= UPDOWN_SIZE ?>)">
<input type="button" value="大きく" onClick="resizeImage(<?= UPDOWN_SIZE ?>)">
<input type="button" value="中" onClick="setSizeImage(<?= MID_SIZE ?>)">
<input type="button" value="大" onClick="setSizeImage(<?= BIG_SIZE ?>)">
<input type="button" value="最大" onClick="setSizeImage(<?= MAX_SIZE ?>)">
</div>
<div id="photo_images_view_box">
<?php
	if ($start_count <= $end_count) {
		photo_page_control($img_count, $page, $pagemax, $open_path);
		for ($ix=$start_count; $ix<=$end_count; $ix++) {
			$filename = $_SESSION['photo_img'][$ix];
			$filepath = $open_path.'/'.$filename;
			if ($_SESSION['photo_img_type'][$ix] == 'video') {
				$getimg = "video-jpeg.php?file=".urlencode($filepath)."&ss=".$_SESSION['video_thumb_ss'];
				$click = "video-view.php?file=".urlencode($filepath);
				$height_size = $_SESSION['photo_thumbs_size'] - 2;
				$border_style = VIDEO_THUMBNAIL_BORDER;
			} else {
			//	$getimg = "../scripts/php/img-size-change.php?img=".urlencode($filepath)."&size=".MAX_SIZE;
				$getimg = "img-view.php?img=".urlencode($filepath);
				$click = $getimg;
				$height_size = $_SESSION['photo_thumbs_size'];
				$border_style = '';
			}
?>
			<span class="popup">
			<img class="thumbs" src="<?= $getimg ?>" height=<?= $height_size ?> style="<?= $border_style ?>" alt="<?= $filename ?>" title="<?= $filename ?>" align=top onDblClick="window.open('<?= $click ?>');return false;"/>
			</span>
<?php
		}
	}
?>
</div>
</div>
<script type="text/javascript" src="../scripts/jquery.js"></script>
<script type="text/javascript" src="../scripts/jquery.cookie.js"></script>
<script type="text/javascript">
<!--
var imgsize = <?= $_SESSION['photo_thumbs_size'] ?>;
var bigid = 0;
$(function(){
	// HTMLロード後に実行したい初期化コード
	$(".thumbs").click(function(){
		if ($(this).height() != imgsize) {
			$(this).height(imgsize);
		} else {
			//alert("bigidは「"+bigid+"」です");
			$("#"+bigid).height(imgsize);	//前に大きくしたアイコンを小さくする
			$(this).height(imgsize*2);
			bigid = $(this).attr("id");
		}
	});
});
function resizeImage(up_down) {
	setSizeImage(imgsize + up_down);
}
function setSizeImage(size) {
	imgsize = size;
	$.cookie('photo_thumbs_size',size,{ expires: 365 });
	$("img.thumbs").height(size);
}
-->
</script>
<?php
}
function view_photo_thumbnail_b($open_path, $page) {
	$img_count = $_SESSION['photo_img_count'];
	$start_count = ($page - 1) * $_SESSION['photo_imgmax'] + 1;		//開始番号を算出
	$end_count = $page * $_SESSION['photo_imgmax'];				//終了番号を算出
	$pagemax = ceil($img_count / $_SESSION['photo_imgmax']);		//取得したファイル数から最終頁を算出
	if ($end_count > $img_count) {
		$end_count = $img_count;
	}
?>
<div id="photo_image_size_change" style="padding:5;">
<input type="button" value="最小" onClick="setSizeImage(<?= SMALL_SIZE ?>)">
<input type="button" value="小さく" onClick="resizeImage(-<?= UPDOWN_SIZE ?>)">
<input type="button" value="大きく" onClick="resizeImage(<?= UPDOWN_SIZE ?>)">
<input type="button" value="中" onClick="setSizeImage(<?= MID_SIZE ?>)">
<input type="button" value="大" onClick="setSizeImage(<?= BIG_SIZE ?>)">
<input type="button" value="最大" onClick="setSizeImage(<?= MAX_SIZE ?>)">
</div>
<div class="vCenter">
	<ul>
<?php
	if ($start_count <= $end_count) {
		photo_page_control($img_count, $page, $pagemax, $open_path);
		for ($ix=$start_count; $ix<=$end_count; $ix++) {
			$filename = $_SESSION['photo_img'][$ix];
			$filepath = $open_path.'/'.$filename;
			if ($_SESSION['photo_img_type'][$ix] == 'video') {
				$width_height = "width";
				$getimg = "video-jpeg.php?file=".urlencode($filepath)."&ss=".$_SESSION['video_thumb_ss'];
				$click = "video-view.php?file=".urlencode($filepath);
				$height_size = $_SESSION['photo_thumbs_size'];
				$border_style = VIDEO_THUMBNAIL_BORDER;
			} else {
				get_width_height($filepath, &$width, &$height);
				if ($width > $height) {
					$width_height = "width";
				} else {
					$width_height = "height";
				}
				$getimg = "img-view.php?img=".urlencode($filepath);
				$click = $getimg;
				$height_size = $_SESSION['photo_thumbs_size'];
				$border_style = '';
			}
			$frame_size = $height_size + 6;
?>
			<li class="thumbs" style="width:<?= $frame_size ?>px; height:<?= $frame_size ?>px;">
			<!--[if gte IE 6]><span></span><![endif]-->
			<p class="thumbs" style="width:<?= $frame_size ?>px; height:<?= $frame_size ?>px;">
			<img class="thumbs_<?= $width_height ?>" src="<?= $getimg ?>" <?= $width_height ?>=<?= $height_size ?> style="line-height:<?= $_SESSION['photo_thumbs_size'] ?>px;<?= $border_style ?>" alt="<?= $filename ?>" title="<?= $filename ?>" onClick="window.open('<?= $click ?>');return false;"/>
			</p>
			</li>
<?php
		}
	}
?>
	</ul>
</div>
</div>
<script type="text/javascript" src="../scripts/jquery.js"></script>
<script type="text/javascript" src="../scripts/jquery.cookie.js"></script>
<script type="text/javascript">
<!--
var imgsize = <?= $_SESSION['photo_thumbs_size'] ?>;
function resizeImage(up_down) {
	setSizeImage(imgsize + up_down);
}
function setSizeImage(size) {
	$.cookie('photo_thumbs_size',size,{ expires: 365 });
	imgsize = size;
	$("img.thumbs_width").width(size);
	$("img.thumbs_height").height(size);
	frame_size = String(size+6)+"px";
	$("li.thumbs").css("width", frame_size)
		      .css("height", frame_size);
	$("p.thumbs").css("width", frame_size)
		     .css("height", frame_size);
}
-->
</script>
<?php
}
function view_photo_slide($open_path, $page, $auto_mode) {
	$img_count = $_SESSION['photo_img_count'];
?>
<script type="text/javascript" src="../scripts/jquery.js"></script>
<script type="text/javascript" src="../scripts/jquery.cookie.js"></script>
<script type="text/javascript" src="../scripts/cookie.js"></script>
<script type="text/javascript" src="../scripts/pixastic/pixastic.core.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/blur.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/brightness.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/coloradjust.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/desaturate.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/glow.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/hsl.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/lighten.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/posterize.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/sepia.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/sharpen.js"></script>
<script type="text/javascript" src="../scripts/pixastic/actions/solarize.js"></script>
<script type="text/javascript">
function pixasticImageOnLoad() {
	photo_pixastic = loadCookie("photo_pixastic_stack");
	pixasticLogView(photo_pixastic);
	if (photo_pixastic && photo_pixastic != "false") {
		pixastic = photo_pixastic.split(",");
		for(var ix in pixastic){
			pixasticAction(pixastic[ix]);
		}
	}
}
function pixasticImage(action) {
	if (action == "posterize") {
		posterize = loadCookie("photo_pixastic_posterize");
		if (posterize && posterize != "false" && posterize > 1) {
			posterize--;
		} else {
			posterize = 13;
		}
		saveCookie("photo_pixastic_posterize", posterize);
	}
	pixasticAction(action);
	photo_pixastic = loadCookie("photo_pixastic_stack");
	if (photo_pixastic && photo_pixastic != "false") {
		saveCookie("photo_pixastic_stack", photo_pixastic+","+action);
	} else {
		saveCookie("photo_pixastic_stack", action);
	}
	pixasticLogView(loadCookie("photo_pixastic_stack"));
}
function pixasticAction(action) {
	if (action == "contrast") {
		Pixastic.process(document.getElementById("img_slide_main"), "brightness", {brightness:0,contrast:0.3});
	} else if (action == "red") {
		Pixastic.process(document.getElementById("img_slide_main"), "coloradjust", {red:0.1,green:0,blue:0});
	} else if (action == "green") {
		Pixastic.process(document.getElementById("img_slide_main"), "coloradjust", {red:0,green:0.1,blue:0});
	} else if (action == "blue") {
		Pixastic.process(document.getElementById("img_slide_main"), "coloradjust", {red:0,green:0,blue:0.1});
	} else if (action == "glow") {
		Pixastic.process(document.getElementById("img_slide_main"), "glow", {amount:0.1,radius:1.0});
	} else if (action == "saturation") {
		Pixastic.process(document.getElementById("img_slide_main"), "hsl", {hue:0,saturation:20,lightness:0});
	} else if (action == "lighten") {
		Pixastic.process(document.getElementById("img_slide_main"), "lighten", {amount:0.1});
	} else if (action == "posterize") {
		posterize = loadCookie("photo_pixastic_posterize");
		Pixastic.process(document.getElementById("img_slide_main"), "posterize", {levels:posterize});
	} else if (action == "sharpen") {
		Pixastic.process(document.getElementById("img_slide_main"), "sharpen", {amount:0.2});
	} else {	// desaturate, sepia, solarize, blur
		Pixastic.process(document.getElementById("img_slide_main"), action);
	}
}
function pixasticImageReset() {
	saveCookie("photo_pixastic_stack", "false");
	saveCookie("photo_pixastic_posterize", "false");
	pixasticLogView("");
	Pixastic.revert(document.getElementById("img_slide_main"));
}
function pixasticLogView(current) {
	if (current+"" != "false") {
		document.getElementById('pixastic_log').innerHTML = current;
	}
}
</script>
<div id="photo_images_main_view">
<?php
	if ($page <= $img_count) {
		photo_page_control($img_count, $page, $img_count, $open_path, SLIDE_SMALL_NUM, '枚');
		$filename = $_SESSION['photo_img'][$page];
		if (VIDEO_PREVIEW == 'YES' && $_SESSION['slide_flv_preview'] == 'on' && is_preview_video_filename($filename) && is_ext_filename_str($filename, VIDEO_PREVIEW_CONVERT)) {
			$filepath = $open_path.'/'.$filename.'.flv';	// JWPlayerは拡張子が.flvでないと駄目なため
		} else {
			$filepath = $open_path.'/'.$filename;
		}
		$filepath_url = urlencode($filepath);
		if ($_SESSION['photo_img_type'][$page] == 'video') {
			$getimg = "video-jpeg.php?file=".$filepath_url."&ss=".$_SESSION['video_thumb_ss'];
			$click = "video-view.php?file=".$filepath_url;
			$height_size = $_SESSION['slide_main_size'] - 2;
			$border_style = VIDEO_THUMBNAIL_BORDER;
		} else {
			get_width_height($filepath, &$width, &$height);
			if (photo_JPEG_ROTATE == 'YES') {
/*
				if ($_GET['ro'] == 'r') {
					$getimg = "img-rotate.php?img=".$filepath_url."&ro=r";
				} elseif ($_GET['ro'] == 'l') {
					$getimg = "img-rotate.php?img=".$filepath_url."&ro=l";
				} else {
*/
					$getimg = "img-view.php?img=".$filepath_url;
/*
				}
*/
			} else {
				$getimg = "img-view.php?img=".$filepath_url;
			}
			$click = $getimg;
			$height_size = $_SESSION['slide_main_size'];
			$border_style = '';
		}
?>
	<script language="JavaScript">
	function movieSizeChange(sel, cookie_name) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				size = Number(sel.options[i].value);
			}
		}
		$.cookie(cookie_name,size,{ expires: 365 });
<?php 		if (is_ext_filename_str($click, VIDEO_PREVIEW_WMV)) { ?>
		wmv_preview("movie_preview", "<?= $click ?>", Math.floor(size*4/3), size);
<?php		} else { ?>
		//movie_preview_withimage("movie_preview", "<?= $click ?>", Math.floor(size*4/3), size, "<?= $getimg ?>");
		movie_preview("movie_preview", "<?= $click ?>", Math.floor(size*4/3), size);
<?php		} ?>
	}
	</script>
		<div id="slide_main_img" style="background-color: <?= SLIDE_MAIN_BG_COLOR ?>;">
<?php
		if ($_SESSION['photo_img_type'][$page] == 'video' and $_SESSION['video_timeline_thumb'] == 'on') {
			// 動画の再生時間を取得 (ffmpegのstderrを利用)
			$ret = shell_exec('ffmpeg -i "'.myfile_ENCODE($filepath).'" 2>&1');
			$time = trim(get_intag($ret, 'duration:', ',', $pos=0));
			$time_ar = explode(":", $time);
			$time_sec = (int)$time_ar[0]*3600+(int)$time_ar[1]*60+(int)$time_ar[2];
			$thumb_num = $_SESSION['video_timeline_thumb_num'];
?>
		<p id="file_info"><?= $filename ?> <span id="file_info_time"><?= $time ?></span></p>
		<img id="img_slide_main" height="0" style="display: none; " /><!-- ダミー -->
<?php
			for ($ix=0; $ix<$thumb_num; $ix++) {
				$sec = floor($time_sec / $thumb_num * $ix);
				$getimg = "video-jpeg.php?file=".$filepath_url."&ss=".$sec;
?>
			<a href="<?= $click ?>" target="_blank">
			<img class="img_timeline_thumb" class="bicubic" src="<?= $getimg ?>" height=<?= $_SESSION['video_timeline_thumb_size'] ?> style="<?= $border_style ?>" alt="<?= $filename ?>" title="<?= $filename ?>" align=top onDblClick="window.open('<?= $click ?>');return false;" />
			</a>
<?php
			}
		} elseif (VIDEO_PREVIEW == 'YES' && $_SESSION['slide_flv_preview'] == 'on' && is_preview_video_filename($filepath)) {
			if (is_ext_filename_str($click, VIDEO_PREVIEW_WMV)) {
?>
		<script type="text/javascript" src="../scripts/JWPlayer/silverlight.js"></script>
		<script type="text/javascript" src="../scripts/JWPlayer/wmvplayer.js"></script>
		<script type="text/javascript" src="../scripts/JWPlayer/movie_preview.js"></script>
		<div id="movie_preview">the player will be placed here</div>
		<script type="text/javascript">
			wmv_preview("movie_preview", "<?= $click ?>", "<?= floor($height_size*4/3) ?>", "<?= $height_size ?>");
		</script>
<?php
			} else {
?>
		<script type="text/javascript" src="../scripts/JWPlayer/swfobject.js"></script>
		<script type="text/javascript" src="../scripts/JWPlayer/movie_preview.js"></script>
		<div id="movie_preview">the player will be placed here</div>
		<script type="text/javascript">
			//movie_preview_withimage("movie_preview", "<?= $click ?>", "<?= floor($height_size*4/3) ?>", "<?= $height_size ?>", "<?= $getimg ?>");
			movie_preview("movie_preview", "<?= $click ?>", "<?= floor($height_size*4/3) ?>", "<?= $height_size ?>");
		</script>
<?php
			}
?>
		<div class="photo_file_name" style="text-align: center;"><?= $filename ?></div>
<?php
		} else {
?>
		<table style="margin-left: auto; margin-right: auto;"><tr><td>
		<a href="<?= $click ?>" target="_blank">
		<img class="img_timeline_thumb" height="0" style="display: none; " /><!-- ダミー -->
		<img id="img_slide_main" class="bicubic" src="<?= $getimg ?>" height="<?= $height_size ?>" style="<?= $border_style ?>" alt="<?= $filename ?>" title="<?= $filename ?>" align=top onDblClick="window.open('<?= $click ?>');return false;" />
		</a><p class="photo_file_name" style="text-align: center;"><?= $filename ?></p>
		</td>
		<?php if (JIGSAW_PUZZLE_CREATE == 'YES' or ($_SESSION['システム管理者'] == "YES" and is_ext_filename_str($filename,'jpg,jpeg'))) { ?>
		<td>
			<?php //	if (photo_JPEG_ROTATE == 'YES' and $_SESSION['システム管理者'] == "YES" and is_ext_filename_str($filename,'jpg,jpeg')) { ?>
<?php
		//	<a href="?page=<\= $page\>&ro=r" class="rotate">右回転</a><br><br>
		//	<a href="?page=<\= $page\>&ro=l" class="rotate">左回転</a><br><br>
?>
			<?php //	} ?>
			<?php if (JIGSAW_PUZZLE_CREATE == 'YES') { ?>
			<a href="jigsaw.php?img=<?= $filepath_url ?>" target="_blank" id="pop_jigsaw">ジグソー</a>
			<?php } ?>
		</td>
		<?php } ?>
		</tr></table>
<?php
		}
?>
		</div>
<?php
	} else {	// 画像がない場合のJavaScriptで画像サイズ変更用のダミー
?>
		<img id="img_slide_main" height="0" style="display: none; " />
		<img class="img_timeline_thumb" height="0" style="display: none; " />
<?php
	}
?>
</div>
<?php
	if ($auto_mode == 'on') return;
?>
<div id="photo_images_small_view" style="background-color: <?= SLIDE_SMALL_BG_COLOR ?>;">
<?php
	$current_page = $page;
	$end_count = $page + SLIDE_SMALL_NUM - 1;
	if ($end_count > $img_count) {
		$end_count = $img_count;
	}
	if ($end_count == $img_count) {		//残りが10枚以下の場合、すべて表示
		$page = $end_count - 9;
		if ($page < 1) {
			$page = 1;
		}
	}
	if ($page <= $img_count) {
		for ($ix=$page; $ix<=$end_count; $ix++) {
			$filename = $_SESSION['photo_img'][$ix];
			$filepath = $open_path.'/'.$filename;
			if ($_SESSION['photo_img_type'][$ix] == 'video') {
				$getimg = "video-jpeg.php?file=".urlencode($filepath)."&ss=".$_SESSION['video_thumb_ss'];
				$height_size = SLIDE_SMALL_SIZE - 2;
				$border_style = VIDEO_THUMBNAIL_BORDER;
			} else {
				$getimg = "img-view.php?img=".urlencode($filepath)."&type=thumb";
				$height_size = SLIDE_SMALL_SIZE;
				$border_style = '';
			}
			if ($ix == $current_page) {
				$height_size = SLIDE_SMALL_SIZE - 2;
				$border_style = CURRENT_THUMBNAIL_BORDER;
			}
?>
			<span class="small_img">
			<a href="<?= $_SERVER['SCRIPT_NAME'] ?>?page=<?= $ix ?>&path=<?= urlencode($open_path) ?>&mode=<?= $_SESSION['photo_view_mode'] ?>"><img class="bicubic" src="<?= $getimg ?>" height=<?= $height_size ?> style="<?= $border_style ?>" alt="<?= $filename ?>" title="<?= $filename ?>" align=top /></a>
			</span>
<?php
		}
	}
?>
</div>
<?php
}
function change_view_mode($view_mode, $open_path, $page) {
	if ($view_mode == 's') {
		$s_p = $page;
		$t_p = ($page - 1) / $_SESSION['photo_imgmax'] + 1;
		$end_count = $t_p + SLIDE_SMALL_NUM - 1;
		$img_count = $_SESSION['photo_img_count'];
		if ($end_count > $img_count) {
			$end_count = $img_count;
		}
		if ($end_count == $img_count) {		//残りが10枚以下の場合、すべて表示
			$t_p = $end_count - 9;
			if ($t_p < 1) {
				$t_p = 1;
			}
		}
	} else {
		$t_p = $page;
		$s_p = ($page - 1) * $_SESSION['photo_imgmax'] + 1;
	}
?>
	<script language="JavaScript">
	function RadioViewMode(sel, page) {
		window.location.href = '<?= $_SERVER['SCRIPT_NAME'] ?>?mode=' + sel + '&page=' + page + '&path=<?= urlencode($open_path) ?>';
	}
	</script>
	<input type="radio" onClick="RadioViewMode('t', '<?= $t_p ?>')"<?= $view_mode == 't' ? ' checked' : '' ?>>サムネイル
	<input type="radio" onClick="RadioViewMode('b', '<?= $t_p ?>')"<?= $view_mode == 'b' ? ' checked' : '' ?>>サムネイル(B)
	<input type="radio" onClick="RadioViewMode('s', '<?= $s_p ?>')"<?= $view_mode == 's' ? ' checked' : '' ?>>スライド
	<a href="slide.php?path=<?= urlencode($open_path) ?>&page=<?= $s_p ?>" style="margin: 0 3px;">全画面</a>
	<a href="slide.php?path=<?= urlencode($open_path) ?>&page=<?= $s_p ?>&slidemode=wallpaper" style="margin: 0 3px;">壁紙</a>
<?
}
function change_view_thumb_ss($page) {
?>
	<script language="JavaScript">
	function SelectionVideoSS(form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = '<?= $_SERVER['SCRIPT_NAME'] ?>?vss=' + escape(sel.options[i].value) + '&imgmax=<?= $_SESSION['photo_imgmax'] ?>' + '&mode=<?= $_SESSION['photo_view_mode'] ?>' + '&page=<?= $page ?>';
			}
		}
	}
	</script>
	動画開始秒：<select onchange="SelectionVideoSS(this.form, this)">
	<?php
		for ($video_ss=0; $video_ss <= 20; $video_ss+=2) {
	?>
		<option value="<?= $video_ss ?>"<?= $video_ss == $_SESSION['video_thumb_ss'] ? " selected" : "" ?>><?= $video_ss ?>秒
	<?php
		}
	?>
		</select>
<?
}
function change_view_slide_option($page, $open_path) {
	$filename = $_SESSION['photo_img'][$page];
?>
	<br>
	<script language="JavaScript">
	function CheckboxOnOff(pName, onOff) {
		if (onOff == 'on') {
			cbOnOff = pName + '=off';
		} else {
			cbOnOff = pName + '=on';
		}
		window.location.href = '<?= $_SERVER['SCRIPT_NAME'] ?>?' + cbOnOff + '&imgmax=<?= $_SESSION['photo_imgmax'] ?>' + '&mode=<?= $_SESSION['photo_view_mode'] ?>' + '&page=<?= $page ?>';
	}
	function SelectionNumber(op, form, sel, cookie_name) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				num = sel.options[i].value;
				$.cookie(cookie_name,num,{ expires: 365 });
				window.location.href = '<?= $_SERVER['SCRIPT_NAME'] ?>?' + op + '=' + num + '&imgmax=<?= $_SESSION['photo_imgmax'] ?>' + '&mode=<?= $_SESSION['photo_view_mode'] ?>' + '&page=<?= $page ?>';
			}
		}
	}
	function slideSizeChangeWithPixastic(objid, sel, cookie_name) {
<?php	if (!strstr($_SERVER['HTTP_USER_AGENT'], "MSIE") and $_SESSION['video_timeline_thumb'] <> 'on') { ?>
		// Pixastic.processを実行後、imgサイズ変更ができなくなるための回避策。一旦リセット。
		Pixastic.revert(document.getElementById("img_slide_main"));
		slideSizeChange(objid, sel, cookie_name);
		// Pixastic.processを実行後、imgサイズ変更ができなくなるための回避策。再設定。
		photo_pixastic = loadCookie("photo_pixastic_stack");
		if (photo_pixastic && photo_pixastic != "false") {
			pixastic = photo_pixastic.split(",");
			for(var ix in pixastic){
				pixasticAction(pixastic[ix]);
			}
		}
<?php	} else { ?>
		slideSizeChange(objid, sel, cookie_name);
<?php	} ?>
	}
	function slideSizeChange(objid, sel, cookie_name) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				size = Number(sel.options[i].value);
			}
		}
		$.cookie(cookie_name,size,{ expires: 365 });
		$("img"+objid).height(size);
	}
	</script>
<?php	if ($_SESSION['slide_flv_preview'] == 'on' && is_preview_video_filename($filename)) { ?>
	画像サイズ：<select onchange="movieSizeChange(this, 'slide_main_size')">
<?php	} else { ?>
	画像サイズ：<select onchange="slideSizeChangeWithPixastic('#img_slide_main', this, 'slide_main_size')">
<?php	} ?>
	<?php
		$keyary = explode(",", SLIDE_MAIN_SIZE_SELECT);
		foreach ($keyary as $size) {
	?>
		<option value="<?= $size ?>"<?= $size == $_SESSION['slide_main_size'] ? " selected" : "" ?>><?= $size ?> px
	<?php
		}
	?>
		</select>
	<input type="checkbox" value="on" onClick="CheckboxOnOff('auto','<?= $_SESSION['slide_view_auto'] ?>')"<?= $_SESSION['slide_view_auto'] == 'on' ? ' checked' : '' ?>>オートプレイ
	間隔：<select onchange="SelectionNumber('it', this.form, this, 'slide_interval_time')">
	<?php
		for ($ix=1; $ix<=10; $ix++) {
	?>
		<option value="<?= $ix ?>"<?= $ix == $_SESSION['slide_interval_time'] ? " selected" : "" ?>><?= $ix ?>秒
	<?php
		}
	?>
		</select>
	<input type="checkbox" value="on" onClick="CheckboxOnOff('rep','<?= $_SESSION['slide_view_repeat'] ?>')"<?= $_SESSION['slide_view_repeat'] == 'on' ? ' checked' : '' ?>>繰り返し
	<?php	if (photo_VIDEO_FFMPEG == 'YES' and photo_VIDEO_PREVIEW == 'YES') { ?>
	<input type="checkbox" value="on" onClick="CheckboxOnOff('flv','<?= $_SESSION['slide_flv_preview'] ?>')"<?= $_SESSION['slide_flv_preview'] == 'on' ? ' checked' : '' ?>>FLV/WMV動画再生
	<?php	} ?>
	<?php	if (photo_VIDEO_FFMPEG == 'YES') { ?>
	<input type="checkbox" value="on" onClick="CheckboxOnOff('vst','<?= $_SESSION['video_timeline_thumb'] ?>')"<?= $_SESSION['video_timeline_thumb'] == 'on' ? ' checked' : '' ?>>動画時間分割
	分割数：<select onchange="SelectionNumber('vsn', this.form, this, 'video_timeline_thumb_num')">
	<?php
		$keyary = explode(",", VIDEO_TIMELINE_THUMB_NUM_SELECT);
		foreach ($keyary as $num) {
	?>
		<option value="<?= $num ?>"<?= $num == $_SESSION['video_timeline_thumb_num'] ? " selected" : "" ?>><?= $num ?>
	<?php
		}
	?>
		</select>
	サイズ：<select onchange="slideSizeChange('.img_timeline_thumb', this, 'video_timeline_thumb_size')">
	<?php
		$keyary = explode(",", VIDEO_TIMELINE_THUMB_SIZE_SELECT);
		foreach ($keyary as $size) {
	?>
		<option value="<?= $size ?>"<?= $size == $_SESSION['video_timeline_thumb_size'] ? " selected" : "" ?>><?= $size ?> px
	<?php
		}
	?>
		</select>
	<?php	} ?>
<br>
<?php
	if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE") or $_SESSION['slide_flv_preview'] == 'on' or $_SESSION['video_timeline_thumb'] == 'on') {
		$disabled = ' disabled';
	}
?>
<button onclick="pixasticImage('sepia'); return false"<?= $disabled ?> style="background-color:#f8e0b0;">sepia</button>
<button onclick="pixasticImage('posterize'); return false"<?= $disabled ?> style="background-color:#f8e0f8;">posterize</button>
<button onclick="pixasticImage('saturation'); return false"<?= $disabled ?> style="background-color:#e0ffc0;">saturation</button>
<button onclick="pixasticImage('sharpen'); return false"<?= $disabled ?> style="background-color:#f5f5dc;">sharpen</button>
<button onclick="pixasticImage('blur'); return false"<?= $disabled ?> style="background-color:#f0e68c;">blur</button>
<button onclick="pixasticImage('contrast'); return false"<?= $disabled ?> style="background-color:#ffe0c0;">contrast</button>
<button onclick="pixasticImage('lighten'); return false"<?= $disabled ?> style="background-color:#f0f0f0;">lighten</button>
<button onclick="pixasticImage('glow'); return false"<?= $disabled ?> style="background-color:#ffffe0;">glow</button>
<button onclick="pixasticImage('red'); return false"<?= $disabled ?> style="background-color:#ffe0e0;">red</button>
<button onclick="pixasticImage('green'); return false"<?= $disabled ?> style="background-color:#e0ffe0;">green</button>
<button onclick="pixasticImage('blue'); return false"<?= $disabled ?> style="background-color:#e0ffff;">blue</button>
<button onclick="pixasticImage('desaturate'); return false"<?= $disabled ?> style="background-color:#808080;color:#ffffff;">desaturate</button>
<button onclick="pixasticImage('solarize'); return false"<?= $disabled ?> style="background-color:#808080;color:#ffff00;">solarize</button>
<button onclick="pixasticImageReset(); return false"<?= $disabled ?>>リセット</button>
<?php	if (!strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) { ?>
<p id="pixastic_log"></p>
<?php	} ?>
<?
}
function select_page_images_max($pageline) {
?>
	<br>
	<script language="JavaScript">
	function SelectionImageMax(form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = '<?= $_SERVER['SCRIPT_NAME'] ?>?imgmax=' + escape(sel.options[i].value) + '&mode=<?= $_SESSION['photo_view_mode'] ?>';
			}
		}
	}
	</script>
	頁枚数：<select onchange="SelectionImageMax(this.form, this)">
	<?php
		$keyary = explode(",", IMAGE_MAX_SELECT);
		foreach ($keyary as $keytmp) {
	?>
		<option value="<?= $keytmp ?>"<?= $pageline == $keytmp ? " selected" : "" ?>><?= $keytmp ?>
	<?php
		}
	?>
		</select>
<?
}
function photo_page_control($img_count, $page, $pagemax, $open_path, $skip_num=0, $page_suffix='頁') {
?>
<div class="photo_page_control">
<span class="photo_page_control_info">
	<span class="choice">枚数：<span class="photo_rowcnt"><?= $img_count ?></span>枚</span>&nbsp;
	<span class="choice"><span class="photo_page"><?= $page ?></span>/<span class="photo_pagemax"><?= $pagemax ?></span><?= $page_suffix ?></span>
<?php
	if ($page_suffix == '頁') { 
		$photo_fst = ($page - 1) * $_SESSION['photo_imgmax'] + 1;
		$photo_end = $photo_fst + $_SESSION['photo_imgmax'] - 1;
		if ($photo_end > $_SESSION['photo_img_count']) {
			$photo_end = $_SESSION['photo_img_count'];
		}
?>
	<span class="choice">(<span class="photo_fst_end"><?= $photo_fst ?></span>～<span class="photo_fst_end"><?= $photo_end ?></span>枚目)</span>
<?php
	}
?>
</span>
<span class="photo_page_control_move">
<?php
	$parm = '&path='.urlencode($open_path).'&mode='.$_SESSION['photo_view_mode'];
	$label = '[←先頭]';
		if ($page > 1) {
			page_move($label, 1, $parm);
		} else {
			page_no_move($label);
		}
		if ($skip_num <> 0) {
	$label = '[←スキップ ('.$skip_num.')]';
			if ($page-$skip_num > 0) {
				page_move($label, $page-$skip_num, $parm);
			} else {
				page_no_move($label);
			}
		}
	$label = '[←前]';
		if ($page > 1) {
			page_move($label, $page-1, $parm);
		} else {
			page_no_move($label);
		}
	$label = '[→次]';
		if ($page < $pagemax) {
			page_move($label, $page+1, $parm);
		} else {
			page_no_move($label);
		}
		if ($skip_num <> 0) {
	$label = '[→スキップ ('.$skip_num.')]';
			if ($page+$skip_num <= $pagemax) {
				page_move($label, $page+$skip_num, $parm);
			} else {
				page_no_move($label);
			}
		}
	$label = '[→最後]';
		if ($page < $pagemax) {
			page_move($label, $pagemax, $parm);
		} else {
			page_no_move($label);
		}
?>
</span>
</div>
<?php
}
function page_move($label, $move_page, $parm) {
?>
	<span><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?page=<?= $move_page ?><?= $parm ?>"><?= $label ?></a></span>
<?php
}
function page_no_move($label) {
?>
	<span class="link_off"><?= $label ?></span>
<?php
}
function get_width_height($img_file, &$width, &$height) {	// UTF-8
	$resize_SJIS = myfile_ENCODE(resize_filename($img_file, photo_RESIZE_DIR_SMALL));
	if (file_exists($resize_SJIS)) {
		list($width, $height) = getimagesize($resize_SJIS);
	} else {
		list($width, $height) = getimagesize(myfile_ENCODE($img_file));
	}
}
function resize_filename($img_file, $dir) {			// UTF-8
	$resize_dir = up_folder_path($img_file).$dir;
	return ($resize_dir.basename($img_file));
}
?>
