<?php
function img_view($img_file, $type, $overwrite='') {
	if ($img_file == '') {
		return;
	}
	$img_SJIS = myfile_ENCODE($img_file);
	if(!($attr = @getimagesize($img_SJIS))) {
		return;
	}
	$width = $attr[0];
	$height = $attr[1];
	if ($width > $height) {
		$checksize = $width;
	} else {
		$checksize = $height;
	}
	if (photo_JPEG_RESIZE == 'YES' and is_ext_filename_str($img_file, 'jpg,jpeg')) {
		if ($type == 'thumb') {
			$dir = photo_RESIZE_DIR_THUMB;
			$size = photo_RESIZE_SIZE_THUMB;
		} else {
			$dir = photo_RESIZE_DIR_SMALL;
			$size = photo_RESIZE_SIZE_SMALL;
		}
		$resize_file = resize_filename($img_file, $dir);
		$resize_SJIS = myfile_ENCODE(str_replace('/', DIRECTORY_SEPARATOR, $resize_file));
		if ($checksize > $size) {
			if ($overwrite == 'w' or !@file_exists($resize_SJIS)) {
				$img_SJIS = myfile_ENCODE(str_replace('/', DIRECTORY_SEPARATOR, $img_file));
				$ret = resize_jpeg($img_SJIS, $size, $resize_SJIS);
				if ($ret <> 0) {
					write_error_log(PHOTO_ERROR_LOG_FILE, 'exec(resize)', 'Err_file='.$img_file);
				}
			}
		}
		if (@file_exists($resize_SJIS)) {
			$img_SJIS = $resize_SJIS;
		}
	}
	$fp = @fopen($img_SJIS, "rb");
	if ($attr && $fp) {
		if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) {
			$img_file = myfile_ENCODE(substr($img_file,strrpos($img_file,'/')+1));
		} else {
			$img_file = urlencode(substr($img_file,strrpos($img_file,'/')+1));
		}
		header('Content-type: '.$attr['mime'].'; name='.$img_file);
		header('Content-Disposition: inline; filename='.$img_file);
		fpassthru($fp);
	}
}
function resize_filename($img_file, $dir) {		// UTF-8
	$resize_dir = up_folder_path($img_file).$dir;
	if (!@opendir(myfile_ENCODE($resize_dir))) {
		@mkdir(myfile_ENCODE($resize_dir));
	}
	return ($resize_dir.basename($img_file));
}
function resize_jpeg($src, $size, $tgt) {		// SJIS-win
	exec('i_view32 "'.$src.'" /resize=('.$size.','.$size.') /aspectratio /silent /convert="'.$tgt.'"', $o, $ret);
	return $ret;
}
?>
