<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	my_session_start();
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (FILE_MANAGER_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	if ($_GET['path'].'' == '') {
		exit;
	}
	$open_path = my_GET('path');
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<meta name="description" content="ファイルマネージャー,ファイルアップロード">
<script type="text/javascript" src="../scripts/jquery.js"></script>
<script type="text/javascript" src="../scripts/swfupload/swfupload.js"></script>
<script type="text/javascript" src="../scripts/jquery.swfupload.js"></script>
<script type="text/javascript">
$(function(){
	$('#swfupload-control').swfupload({
		upload_url: "file-upload-do.php?path=<?= urlencode($open_path) ?>",
		file_post_name: 'uploadfile',
	/*
		file_size_limit : "1024",
		file_types : "*.jpg;*.png;*.gif",
		file_types_description : "Image files",
		file_upload_limit : 5,
	*/
		flash_url : "../scripts/swfupload/swfupload.swf",
		button_image_url : '../scripts/swfupload/wdp_buttons_upload_114x29.png',
		button_width : 114,
		button_height : 29,
		button_placeholder : $('#button')[0],
		debug: false
	})
		.bind('fileQueued', function(event, file){
			var listitem='<li id="'+file.id+'" >'+
				'File: <em>'+file.name+'</em> ('+Math.round(file.size/1024)+' KB) <span class="progressvalue" ></span>'+
				'<div class="progressbar" ><div class="progress" ></div></div>'+
				'<p class="status" >Pending</p>'+
				'<span class="cancel" >&nbsp;</span>'+
				'</li>';
			$('#log').append(listitem);
			$('li#'+file.id+' .cancel').bind('click', function(){
				var swfu = $.swfupload.getInstance('#swfupload-control');
				swfu.cancelUpload(file.id);
				$('li#'+file.id).slideUp('fast');
			});
			// start the upload since it's queued
			$(this).swfupload('startUpload');
		})
		.bind('fileQueueError', function(event, file, errorCode, message){
			alert('Size of the file '+file.name+' is greater than limit');
		})
		.bind('fileDialogComplete', function(event, numFilesSelected, numFilesQueued){
			$('#queuestatus').text('Files Selected: '+numFilesSelected+' / Queued Files: '+numFilesQueued);
		})
		.bind('uploadStart', function(event, file){
			$('#log li#'+file.id).find('p.status').text('Uploading...');
			$('#log li#'+file.id).find('span.progressvalue').text('0%');
			$('#log li#'+file.id).find('span.cancel').hide();
		})
		.bind('uploadProgress', function(event, file, bytesLoaded){
			//Show Progress
			var percentage=Math.round((bytesLoaded/file.size)*100);
			$('#log li#'+file.id).find('div.progress').css('width', percentage+'%');
			$('#log li#'+file.id).find('span.progressvalue').text(percentage+'%');
		})
		.bind('uploadSuccess', function(event, file, serverData){
			var item=$('#log li#'+file.id);
			item.find('div.progress').css('width', '100%');
			item.find('span.progressvalue').text('100%');
		//	var pathtofile='<a href="uploads/'+file.name+'" target="_blank" >view &raquo;</a>';
		//	item.addClass('success').find('p.status').html('Done!!! | '+pathtofile);
			item.addClass('success').find('p.status').html('Done!!!');
		})
		.bind('uploadComplete', function(event, file){
			// upload has completed, try the next one in the queue
			$(this).swfupload('startUpload');
		})
});
</script>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110110" type="text/css">
<style type="text/css" >
#swfupload-control {
	margin-left: 10px;
}
#swfupload-control p{ margin:10px 5px; font-size:0.9em; }
#log{ margin:0; padding:0; width:500px;}
#log li{ list-style-position:inside; margin:2px; border:1px solid #ccc; padding:10px; font-size:12px;
	font-family:Arial, Helvetica, sans-serif; color:#333; background:#fff; position:relative;}
#log li .progressbar{ border:1px solid #333; height:5px; background:#fff; }
#log li .progress{ background:#999; width:0%; height:5px; }
#log li p{ margin:0; line-height:18px; }
#log li.success{ border:1px solid #339933; background:#ccf9b9; }
#log li span.cancel{ position:absolute; top:5px; right:5px; width:20px; height:20px; 
	background:url('../scripts/swfupload/cancel.png') no-repeat; cursor:pointer; }
#folder_path {
	background-color: #B0E0E6;
	padding: 3px;
}
</style>
<title>ファイルマネージャー（ファイル・アップロード）</title>
</head>
<body>
<a href="../tools/" class="return_index">■</a>
<span id="tool_title">ファイルマネージャー（ファイル・アップロード）</span>
<a href="file-manager.php?path=<?= urlencode($open_path) ?>" class="a_cancel_back">戻る</a>
<div id="swfupload-control">
	<p>アップロード先フォルダ：<span id="folder_path"><?= my_htmlspecialchars($open_path) ?></span></p>
	<p>複数ファイルを選択して一括アップロードが出来ます。</p>
	<p style="color:red;">※ 同一ファイル名がある場合、上書きします。</p>
	<p style="color:red;">※ Chromeでは、ファイル名やファイルパスに日本語が含まれているとエラーになります。</p>
	<p style="margin: 10px;"><input type="button" id="button" /></p>
	<p id="queuestatus" ></p>
	<ol id="log"></ol>
	<p style="margin:20px 0;"><a href="file-manager.php?path=<?= urlencode($open_path) ?>">ファイルマネージャに戻る</a></p>
</div>
</body>
</html>
