<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if (!defined("MAPS_FIX_HEIGHT")) {
		define("MAPS_FIX_HEIGHT", 35);
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<meta name="description" content="abook">
<meta name="keywords" content="住所録, マップ">
<title>MyHome 住所録 マップ</title>
<script language="javascript" src="../scripts/URLencode.js" type="text/javascript"></script>
<style type="text/css">
* { margin: 0px; padding: 0px; }
html {
	width: 100%;
	height: 100%;
	overflow: hidden;
}
form { margin: 0px; }
img { border: 0px; }
body {
	background-color: #ffffff;
	text-align: left;
	font-size: 84%;
	font-family: "ＭＳ Ｐゴシック",arial,helvetica,clean,sans-serif;
	margin: 0;
	width: 100%;
	height: 100%;
}
#page_body {
	width: 100%;
	height: 100%;
}
#page_contents {
	width: 100%;
	height: 100%;
}
#map_canvas {
	width: 100%;
	height: 100%;
}
#maps_filter {
	clear: both;
	margin: 0 0 0 10px;
	padding: 0;
}
.block {
	clear: both;
}
.block_left {
	float: left;
	text-align: left;
	padding: 0;
}
a:link { color: #2128e0; font-weight: normal; }
a:visited { color: #2128e0; font-weight: normal; }
a:hover { color: #f43316; font-weight: normal; background-color: #ffffc0; }
a:active { color: #f43316; font-weight: normal; background-color: #ffffc0; }
a.unesco_translate:link { color: #ff69b4; font-weight: normal; font-size: 72%; }
a.unesco_translate:visited { color: #ff69b4; font-weight: normal; font-size: 72%; }
a.unesco_translate:hover { color: #ff0000; font-weight: normal; font-size: 72%; }
a.unesco_translate:active { color: #ff0000; font-weight: normal; font-size: 72%; }
.error_msg { color: red; margin: 20px; padding: 0; }
.noramal_msg { color: #000000; margin: 20px; padding: 0; }
<?
	if ($_GET['opt'] == 'wh') {
		$side_bar_width = 160;
	} else {
		$side_bar_width = 90;
	}
?>
#side_bar {
	position: absolute; top: 50px; right: 6px; width: <?= $side_bar_width?>px; height: 70%;
	border: 1px solid #666; padding: 6px; line-height: 1.4; overflow:scroll;
	background: #ffffff; filter: alpha(opacity=75); -moz-opacity:0.75; opacity:0.75;
}
#side_bar li {
	white-space: nowrap;
}
</style>
</head>
<body onload="initialize()">
<?
	$con = my_mysql_connect(_DB_SCHEMA);
	$sql = "select * from v_abook where id_abook in (".$_GET['id'].')';
	if ($_GET['so'] <> '') {
		$sql .= ' order by '.my_GET('so');
	}
	$rs = my_mysql_query($sql);
	$row = mysql_num_rows($rs);
	if ($row <> 0) {
		google_maps($rs, $row);
	} else {
		echo "<script type='text/javascript'>function initialize(){}</script>\n";
		error_msg('該当するデータがありません。');
	}
	$con = mysql_close($con);
?>
</body>
</html>
<?php
	exit();
?>
<?php
function google_maps($rs, $row) {
	if (!defined("GETLATLNG_SLEEP_TIME")) {
		define("GETLATLNG_SLEEP_TIME", 200000);	// 0.2秒
	}
?>
<script type="text/javascript" src="../scripts/jquery.js"></script>
<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
<script language="javascript" src="../scripts/encodeURL.js" type="text/javascript"></script>
<script type="text/javascript">
var map;
var geocoder = null;
var maxLat=-999, minLat=999, maxLng=-999, minLng=999;
var notFound = '';
var current_infowin = null;
function setHeightPercent(elementID, fixHeight) {
	// マップの高さ設定
	if (document.all) {	// IE
		fixHeight += 40;
	}
	mapsWinHeight = 100 - Math.ceil( fixHeight * 100 / screen.availHeight );
	document.getElementById(elementID).style.height = mapsWinHeight + "%";
}
function initialize() {
	setHeightPercent('map_canvas', <?= MAPS_FIX_HEIGHT ?>);
	maxLat = -999;
	minLat = 999;
	maxLng = -999;
	minLng = 999;
	var vpoint = Array();
<?php
	$popstr = '';
	$address = '';
	$point_tbl = array();
	while ($rec=mysql_fetch_array($rs)) {
		if (($address <> '' and $address <> $rec['c_address1'])) {
			$point_tbl[] = array($address, $popstr, $name);
			$popstr = '';
		}
		if ($_GET['opt'] == 'wh') {
			$name = quote_chg($rec['c_name1']);
			$popstr .= '<font color=#000080>≪<b>'.$name.'</b>≫</font><br>';
			$popstr .= quote_chg($rec['c_name2']).'<br><br>';
			$popstr .= 'Ref.'.quote_chg($rec['c_phone1']).'&nbsp;&nbsp;';
			$popstr .= '<a href="http://maps.google.com/maps?q=' . urlencode($rec['c_address1']);
			$popstr .= '" target="_blank">' . quote_chg($rec['c_address1']) . '</a><br><br>';
			$popstr .= '<p><a href="http://whc.unesco.org/en/list/'. my_htmlspecialchars($rec['c_phone1']) . '" target="_blank">UNESCO</a>&nbsp;&nbsp;';
			$popstr .= '<a href="http://translate.google.com/translate?prev=hp&hl=ja&js=y&u=http://whc.unesco.org/en/list/' . my_htmlspecialchars($rec['c_phone1']) . '" class="unesco_translate" target="_blank">→日本語</a></p><br>';
			$popstr .= quote_chg($rec['c_memo']).'<br>';
			$popstr .= quote_chg($rec['c_address2']).'<br>';
		} else {
			$name = quote_chg($rec['c_name1']).' '.quote_chg($rec['c_name2']);
			$popstr .= '<font color=#000080>≪<b>'.$name.'</b>≫</font><br>';
			$popstr .= quote_chg($rec['c_kenmei']).'<br>';
			$popstr .= '<a href="http://maps.google.com/maps?q=' . urlencode($rec['c_address1']);
			$popstr .= '" target="_blank">' . quote_chg($rec['c_address1']) . '</a><br><br>';
			$popstr .= quote_chg($rec['c_memo']).'<br>';
			$popstr .= quote_chg($rec['c_address2']).'<br>';
		}
		$address = $rec['c_address1'];
	}
	$point_tbl[] = array($address, $popstr, $name);
	$adr_cnt = 0;
	foreach ($point_tbl as $point) {
		$p_ary = explode(',', $point[0]);
		if (count($p_ary) == 2 && is_numeric($p_ary[0]) && is_numeric($p_ary[1])) {
?>
	vpoint[<?= $adr_cnt ?>] = Array();
	vpoint[<?= $adr_cnt ?>]["address"] = '<?= $point[0] ?>';
	vpoint[<?= $adr_cnt ?>]["popstr"] = '<?= $point[1] ?>';
	vpoint[<?= $adr_cnt ?>]["name"] = '<?= $point[2] ?>';
	vpoint[<?= $adr_cnt ?>]["lat"] = <?= $p_ary[0] ?>;
	vpoint[<?= $adr_cnt ?>]["lng"] = <?= $p_ary[1] ?>;
	vpoint[<?= $adr_cnt ?>]["status"] = 'OK';
<?php
		} else {
			$status = getLatLng($point[0], $lat, $lng);
?>
	vpoint[<?= $adr_cnt ?>] = Array();
	vpoint[<?= $adr_cnt ?>]["address"] = '<?= $point[0] ?>';
	vpoint[<?= $adr_cnt ?>]["popstr"] = '<?= $point[1] ?>';
	vpoint[<?= $adr_cnt ?>]["name"] = '<?= $point[2] ?>';
	vpoint[<?= $adr_cnt ?>]["lat"] = <?= $lat ?>;
	vpoint[<?= $adr_cnt ?>]["lng"] = <?= $lng ?>;
	vpoint[<?= $adr_cnt ?>]["status"] = '<?= $status ?>';
<?php
		//	usleep(GETLATLNG_SLEEP_TIME);
		}
		++$adr_cnt;
	}
?>
	geocoder = new google.maps.Geocoder();
	for (var ix=0; ix<<?= $adr_cnt ?>; ix++) {
		if (vpoint[ix]["status"] == 'OK') {
			var lat = vpoint[ix]["lat"];
			var lng = vpoint[ix]["lng"];
			if (maxLat < lat) maxLat = lat;
			if (minLat > lat) minLat = lat;
			if (maxLng < lng) maxLng = lng;
			if (minLng > lng) minLng = lng;
		}
	}
	if (minLat == maxLat && minLng == maxLng) {
		minLat -= 0.002;		// 1地点の場合、拡大されすぎるのを抑止するため
		minLng -= 0.002;		// initialize()時点では
		maxLat += 0.002;		// map.fitBounds()後にsetZoom()が効かないため
		maxLng += 0.002;		// Lat, Lngを調整してからfitBounds()する
	}
	southWest = new google.maps.LatLng(minLat,minLng);
	northEast = new google.maps.LatLng(maxLat,maxLng);
	bounds = new google.maps.LatLngBounds(southWest,northEast);
	var myOptions = {
		zoom: 15,
		center: new google.maps.LatLng(minLat + maxLat / 2, minLng + maxLng / 2),
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		disableDoubleClickZoom: false,
		streetViewControl: true
	}
	map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
	map.fitBounds(bounds);
	showMarker(vpoint, <?= $adr_cnt ?>);
}
var side_bar_html = "";
var gmarkers = [];
var markerCnt = 0;
function showMarker(vpoint, cnt) {
	for (var ix=0; ix<cnt; ix++) {
		if (vpoint[ix]["status"] == 'OK') {
			var lat = vpoint[ix]["lat"];
			var lng = vpoint[ix]["lng"];
			createMarker(vpoint[ix]["address"], vpoint[ix]["popstr"], vpoint[ix]["name"], lat, lng);
		} else {
			notFound += vpoint[ix]["address"] + '&nbsp;';
		}
	}
	document.getElementById('side_bar').innerHTML = "<ul>"+side_bar_html+"</ul>";
	document.getElementById('not_found').innerHTML = notFound;
}
function createMarker(addr, html, name, lat, lng) {
	var infowindow = new google.maps.InfoWindow({
		content: html
	});
	var latlng = new google.maps.LatLng(lat, lng);
	var marker = new google.maps.Marker({
		position: latlng,
		map: map,
		title: name
	});
	google.maps.event.addListener(marker, 'click', function() {
		if (current_infowin) {
			current_infowin.close();
		}
		infowindow.open(map,marker);
		current_infowin = infowindow;
	});
	gmarkers[markerCnt] = marker;
	side_bar_html += '<li><a href="javascript:myClick(' + markerCnt + ')">' + name + '</a></li>';
	markerCnt++;
}
function myClick(markerCnt) {
	google.maps.event.trigger(gmarkers[markerCnt], 'click');
}
function markerClear() {
	map.clearOverlays();
}
function addressClear() {
	document.getElementById("address").value = '';
}
</script>
<div id="map_canvas"></div>
<div id="side_bar">Loading...</div>
<div>Not found: <span id="not_found" style="color: red;"></span></div>
<?php
}
function getLatLng($address, &$lat, &$lng) {		// Geocoding API V3
	$json = my_file_get_contents('http://maps.google.com/maps/api/geocode/json?address='.urlencode($address).'&sensor=false');
	$latLng = json_decode($json, true);
	if ($latLng['status'] <> 'OK') return 'NotFound';
	$lat = $latLng['results'][0]['geometry']['location']['lat'];
	$lng = $latLng['results'][0]['geometry']['location']['lng'];
	return 'OK';
}
?>
