<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if ($_POST['path'] <> '') {
		$path = form_str_filepath($_POST['path']);
	} elseif ($_GET['path'] <> '') {
		$path = my_GET('path');
	}
	set_time_limit(0);		//実行時間制御なし　max_execution_time
	ob_implicit_flush();		//自動フラッシュをオン(出力をバッファリングしない)
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta name="author" content="ok.2nd">
<title><?= VIDEO_PREVIEW_CONVERT ?> to FLV 一括変換</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110622" type="text/css">
</head>
<body>
<span id="tool_title"><font color="#b8860b"><?= VIDEO_PREVIEW_CONVERT ?> to FLV 一括変換</font></span>
<br><br>
<?php
	if ($path == '') {
		error_exit('ディレクトリ指定がありません。');
	}
	$path_SJIS = myfile_ENCODE($path);
	if (!($dir =@opendir($path_SJIS))) {
		error_exit('指定ディレクトリが開けません。');
	}
	closedir($dir);
?>
<form method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
<div style="margin: 10px; ">
<p style="margin: 5px 0 5px 0; ">
	ディレクトリ「<a href="../tools/file-manager.php?path=<?= urlencode($path) ?>" target="_blank" style="margin: 0 2px;"><?= $path ?></a>」の下の、<br>
	拡張子が「<font color="blue"><b><?= VIDEO_PREVIEW_CONVERT ?></b></font>」の動画ファイルを、<font color="red"><b>flv</b></font>にコンバートして、<br>
	ディレクトリ「<font color="blue"><?= $path.VIDEO_PREVIEW_CONVERT_FLV_DIR ?></font>」の下に登録します。
</p>
<p style="margin: 10px 0 5px 0; ">
<input type="submit" name="convert" value="一括変換実行">
<input type="hidden" name="path" value="<?= my_htmlspecialchars($path) ?>">
<input type="checkbox" name="overwrite" value="YES"<?= $_POST['overwrite']=='YES' ? ' checked' : '' ?>>既にflvがある場合、再変換してflvを上書きする。
</p>
</form>
<?php
	if (isset($_POST['convert'])) {
		$count = done_proc($path);
		echo '<br>変換件数： <b><font color=red>'.$count.'</font></b> 個';
	}
?>
</div>
</body>
</html>
<?php
function done_proc($path) {
	$path_SJIS = myfile_ENCODE($path);
	$flv_dir = $path_SJIS.VIDEO_PREVIEW_CONVERT_FLV_DIR;
	if (!@opendir($flv_dir)) {
		@mkdir($flv_dir);
	}
	$convert_count = 0;
	if ($dir=opendir($path_SJIS)) {
		$files_SJIS = scandir($path_SJIS);
		foreach ($files_SJIS as $file_SJIS) {
			$file = myfile_DECODE($file_SJIS);
			if (is_ext_filename_str($file, VIDEO_PREVIEW_CONVERT)) {
				$convert_count += video_convert($path.'/'.$file);
			}
		}
		closedir($dir);
	}
	return $convert_count;
}
function video_convert($srcfile) {		// UTF-8
	$flvfile = flv_file($srcfile);
	$src_SJIS = myfile_ENCODE($srcfile);
	$flv_SJIS = myfile_ENCODE($flvfile);
	if ($_POST['overwrite'] == 'YES' or !file_exists($flv_SJIS)) {
		if (is_preview_video_filename($srcfile) && is_ext_filename_str($srcfile, VIDEO_PREVIEW_CONVERT)) {
			echo $srcfile.'<br>';
			if (rightlower($srcfile,4) == '.mpg') {
				exec('ffmpeg -y -i "'.$src_SJIS.'" '.FFMPEG_CONVERT_OPTION_MPG.' "'.$flv_SJIS.'"');
			} elseif (rightlower($srcfile,4) == '.mov') {
				exec('ffmpeg -y -i "'.$src_SJIS.'" '.FFMPEG_CONVERT_OPTION_MOV.' "'.$flv_SJIS.'"');
			} elseif (rightlower($srcfile,5) == '.m2ts' or rightlower($srcfile,4) == '.mts') {
				exec('ffmpeg -y -i "'.$src_SJIS.'" '.FFMPEG_CONVERT_OPTION_M2TS.' "'.$flv_SJIS.'"');
			}
			return 1;
		}
	}
	return 0;
}
function flv_file($file_name) {			// UTF-8
	$flv_dir = up_folder_path($file_name).VIDEO_PREVIEW_CONVERT_FLV_DIR;
	return ($flv_dir.basename($file_name).'.flv');
}
?>
