<?php
	require("__common__/__define_common.php");
	require("__common__/include-common-all.php");
	session_start();
	mb_language("Japanese");
	mb_internal_encoding('UTF-8');
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta name="author" content="ok.2nd">
<meta name="description" content="MyHome Portal">
<link rel="stylesheet" href="style/original/tools_common.css?20110622" type="text/css">
<title>MyHome Portal サンプルDB自動セットアップ</title>
</head>
<body>
<?php
	if ($_POST) {
		$_SESSION['mysql_root_id'] = $_POST['mysql_root_id'];
		$_SESSION['mysql_root_password'] = $_POST['mysql_root_password'];
		$_SESSION['install_path_myhome'] = str_replace(DIRECTORY_SEPARATOR, "/", form_str_filepath($_POST['install_path_myhome']));
	} else {
		if ($_SESSION['install_path_myhome'] == '') {
			$_SESSION['install_path_myhome'] = $_SERVER['DOCUMENT_ROOT'].'/_myhome';
		}
	}
?>
<div class="input_form">
<h3><font color=blue>MyHome Portal サンプルDB自動セットアップ</font></h3><br>
<font color=red>MySQLのバージョンによって、エラーが発生する場合があります。<br>
その場合、z_db_backupフォルダ内の各ファイルの以下の形式の部分を修正することで、セットアップできる可能性もあります。<br>
&nbsp;&nbsp;&nbsp;&nbsp;PRIMARY KEY (`id_category`)  USING BTREE<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;↓↓↓<br>
&nbsp;&nbsp;&nbsp;&nbsp;PRIMARY KEY  USING BTREE (`id_category`)<br><br></font>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
<table>
<tr>
	<td>MySQL管理者 ユーザー名：</td>
	<td><input class="text" type="text" name="mysql_root_id" size=10 value="<?= $_SESSION['mysql_root_id'] ?>"></td>
</tr>
<tr>
	<td>MySQL管理者 パスワード：</td>
	<td><input class="password"  type="password" name="mysql_root_password" size=16 value="<?= $_SESSION['mysql_root_password'] ?>"></td>
</tr>
<tr>
	<td>_myhome ディレクトリ：</td>
	<td><input class="text"  type="text" name="install_path_myhome" size=40 value="<?= $_SESSION['install_path_myhome'] ?>"></td>
</tr>
</table>
	<input type="submit" name="開始" value="開始">
	<br><br>
<?php
	if (!$_POST) {
		exit;
	}
	if ($_SESSION['mysql_root_id'].'' == '') {
		echo '<br><br>MySQL管理者 ユーザー名を入れてください。<br>';
		exit;
	}
	error_reporting(0);	//エラーメッセージ抑制
	if (!opendir(myfile_ENCODE($_SESSION['install_path_myhome']))) {
		echo '<br><br>ディレクトリ「<font color=red><b>'.$_SESSION['install_path_myhome'].'</b></font>」が、ありません。<br>';
		exit;
	}
	if (!opendir(myfile_ENCODE($_SESSION['install_path_myhome'].'/z_db_backup'))) {
		echo '<br><br>ディレクトリ「<font color=red><b>'.$_SESSION['install_path_myhome'].'/z_db_backup'.'</b></font>」が、ありません。<br>';
		exit;
	}
	$con = mysql_connect('localhost', $_SESSION['mysql_root_id'], $_SESSION['mysql_root_password']);
	if ($con == False) {
		echo '<br><br>データベース接続エラー<br>';
		exit;
	}
	error_reporting(E_ALL);
	mysql_query('set names utf8');
	if (db_exist_check_all() > 0) {
		echo '<br>上記のデータベースが存在します。';
		if ($_POST['中止']) {
			echo '<br><br><br><font color=red>*****  セットアップを中止しました。 *****</font><br><br>';
			exit;
		}
		echo '<br>上記のデータベースを削除しても良ければ、次のボタンを押してください。<br><br>';
?>
	<input type="submit" name="削除" value="既存のデータベースを削除して、セットアップを継続">
	<input type="submit" name="中止" value="セットアップ中止">
	<br>
<?php
		if (!$_POST['削除']) {
			exit;
		}
	}
	ob_implicit_flush();	//自動フラッシュをオン(出力をバッファリングしない)
	echo '<br><b>処理開始</b><br>';
	$backup_file_path = $_SESSION['install_path_myhome'].'\z_db_backup';
	db_create_proc('_db_account', $backup_file_path);
	db_create_proc('_db_index', $backup_file_path);
	db_create_proc('_db_calendar', $backup_file_path);
	db_create_proc('_db_memo', $backup_file_path);
	db_create_proc('_db_bbs', $backup_file_path);
	db_create_proc('_db_rss', $backup_file_path);
	db_create_proc('_db_chat', $backup_file_path);
	db_create_proc('_db_kakeibo', $backup_file_path);
	db_create_proc('_db_study', $backup_file_path);
	db_create_proc('_db_abook', $backup_file_path);
	db_create_proc('_db_diary', $backup_file_path);
	db_create_proc('_db_sticky', $backup_file_path, False);
	db_create_proc('_db_photo', $backup_file_path, False);
	db_create_proc('_db_svg', $backup_file_path);
	db_create_proc('_db_draw', $backup_file_path);
	db_create_proc('_db_guide', $backup_file_path);
	db_create_proc('_db_zid_mgr_b', $backup_file_path, False);
	db_create_proc('_db_zid_mgr_a', $backup_file_path);

	$sql = "GRANT USAGE ON *.* TO myhome@localhost IDENTIFIED BY 'pass123';";
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_account.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_index.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_calendar.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_memo.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_bbs.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_rss.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_chat.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_kakeibo.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_study.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_abook.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_diary.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_sticky.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_photo.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_svg.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_draw.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_guide.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_zid_mgr_a.* TO myhome@localhost;';
	$sql .= 'GRANT SELECT,INSERT,UPDATE,DELETE ON _db_zid_mgr_b.* TO myhome@localhost;';
	$sql .= 'FLUSH PRIVILEGES;';
	mysqli_multi_query_by_text(NULL, $sql);
?>
</form>
<br><br>**********  サンプル・データベース　作成完了  **********<br><br>
<br><a href="http://localhost/_myhome/" target="_blank">http://localhost/_myhome/</a><br><br>
を開いて、アカウント名「<b>taro</b>」パスワード「<b>demo</b>」でログインしてください。<br><br>
MyHome Portalトップページが表示されればOKです。<br><br><br><br>
<?php
function db_create_proc($dbname, $backup_dir, $create_view = True) {
	echo '<br>------------------<br><font color=blue>【<b>'.$dbname.'</b>】</font><br>';
	// DB存在チェック
	error_reporting(0);	//エラーメッセージ抑制
	if (db_exist_check($dbname)) {
		mysql_query('drop  database '.$dbname);
	}
	error_reporting(E_ALL);
	// DB作成
	if (!mysql_query('create database '.$dbname)) {
		echo '<br>Create Database failed: ('.mysql_errno($con).') '.$mysql_error($con).'<br>';
		exit;
	}
	// バックアップファイル： ex. _db_memo.bk.txt
	mysql_exec_by_file($dbname, $backup_dir, $dbname.'.bk.txt');
	// ビュー定義ファイル： ex. _db_memo.bk.txt
	if ($create_view) {
		mysqli_multi_query_by_file($dbname, $backup_dir, 'create_view'.$dbname.'.txt');
	}
}
function db_exist_check_all() {
	$db_exist = 0;
	$db_exist .= db_exist_check('_db_account', True);
	$db_exist .= db_exist_check('_db_index', True);
	$db_exist .= db_exist_check('_db_calendar', True);
	$db_exist .= db_exist_check('_db_memo', True);
	$db_exist .= db_exist_check('_db_bbs', True);
	$db_exist .= db_exist_check('_db_rss', True);
	$db_exist .= db_exist_check('_db_chat', True);
	$db_exist .= db_exist_check('_db_kakeibo', True);
	$db_exist .= db_exist_check('_db_study', True);
	$db_exist .= db_exist_check('_db_abook', True);
	$db_exist .= db_exist_check('_db_diary', True);
	$db_exist .= db_exist_check('_db_sticky', True);
	$db_exist .= db_exist_check('_db_photo', True);
	$db_exist .= db_exist_check('_db_svg', True);
	$db_exist .= db_exist_check('_db_draw', True);
	$db_exist .= db_exist_check('_db_guide', True);
	$db_exist .= db_exist_check('_db_zid_mgr_b', True);
	$db_exist .= db_exist_check('_db_zid_mgr_a', True);
	return $db_exist;
}
function db_exist_check($dbname, $msg = False) {
	error_reporting(0);	//エラーメッセージ抑制
	if (mysqli_connect('localhost', $_SESSION['mysql_root_id'], $_SESSION['mysql_root_password'], $dbname)) {
		if ($msg) {
			echo 'データベース「<font color=red><b>'.$dbname.'</b></font>」が存在します。<br>';
		}
		return True;	//データベースが存在
	}
	return False;
}
function mysql_exec_by_file($dbname, $backup_dir, $sql_file) {
	$sql_path = myfile_ENCODE($backup_dir.chr(0x5c).$sql_file);
	echo '実行 → '.$sql_path.'<br>';
	$sql_path = str_replace('/', DIRECTORY_SEPARATOR, $sql_path);
	$command = 'mysql -u '.$_SESSION['mysql_root_id'].' -p'.$_SESSION['mysql_root_password'].' '.$dbname.' < '.$sql_path;
	exec($command, $arr, $res);
	if ($res !== 0) {
		echo '<span style="color:red;">&nbsp;&nbsp;===> <b>エラーが発生しました。</b>('.$res.')<br>';
		echo '&nbsp;&nbsp;実行コマンド：'.$command.'</span><br>';
		return;
	}
}
function mysqli_multi_query_by_file($dbname, $backup_dir, $sql_file) {
	$sql_path = myfile_ENCODE($backup_dir.chr(0x5c).$sql_file);
	echo '実行 → '.$sql_path.'<br>';
	$sql = file_get_contents($sql_path);
	$con = mysqli_connect('localhost', $_SESSION['mysql_root_id'], $_SESSION['mysql_root_password'], $dbname);
	if (mysqli_connect_errno()) {
		echo '<br>Connect failed: '.mysqli_connect_error().'<br>';
		exit;
	}
	if (!mysqli_multi_query($con, $sql)) {
		echo '<br>Create Table failed: ('.mysql_errno($con).') '.$mysql_error($con).'<br>';
		exit;
	}
	mysqli_close($con);
}
function mysqli_multi_query_by_text($dbname, $sql) {
	$con = mysqli_connect('localhost', $_SESSION['mysql_root_id'], $_SESSION['mysql_root_password']);
	if (mysqli_connect_errno()) {
		echo '<br>Connect failed: '.mysqli_connect_error().'<br>';
		exit;
	}
	if (!mysqli_multi_query($con, $sql)) {
		echo '<br>Create Table failed: ('.mysql_errno($con).') '.$mysql_error($con).'<br>';
		exit;
	}
	mysqli_close($con);
}
?>