<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("__define_code-file.php");
	require("__include-common-code-file.php");
	my_session_start();
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (FILE_MANAGER_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	if (!defined("FILE_MANAGER_DEFAULT_FOLDER")) {
		define("FILE_MANAGER_DEFAULT_FOLDER", $_SERVER['DOCUMENT_ROOT']);
	}
	if ($_POST['path'].'' <> '') {
		$open_path = form_str_filepath($_POST['path']);
	} elseif ($_GET['path'].'' <> '') {
		$open_path = my_GET('path');
	}
	$open_path = str_replace(DIRECTORY_SEPARATOR, "/", right_slash_strip($open_path));
	if ($open_path == "") {
		$open_path = FILE_MANAGER_DEFAULT_FOLDER;
	}
	if (isset($_POST['search_key']) && $_POST['search_key'].'' <> '') {
		$_SESSION['file_manager_search_key'] = $_POST['search_key'];
	} elseif ($_GET['key'].'' <> '') {
		$_SESSION['file_manager_search_key'] = $_GET['key'];
	}
	if (isset($_POST['search_reset'])) {
		$_SESSION['file_manager_search_key'] = '';
	}

	if ($_GET['sort'].'' <> '') {
		$_SESSION['file_manager_sort'] = $_GET['sort'];
	}
	if ($_GET['order'].'' <> '') {
		$_SESSION['file_manager_sort_order'] = $_GET['order'];
	}
	$file_mode = folder_check($open_path, $path_SJIS, $error_msg);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<meta name="description" content="ファイルマネージャー,ファイル暗号化">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110622" type="text/css">
<style type="text/css">
div#header {
	margin: 5px;
}
div#body {
	margin: 0px;
}
div#footer {
	margin: 5px;
}
div#print_dir {
	margin: 5px;
}
div#print_file {
	margin: 5px;
}
div#change_file_type {
	margin: 5px;
}
#selected_type {
	background-color: #ffc080;
}
.file_list {
	font-family: arial,sans-serif;
}
.file_list a:link { color: #101010; }
.file_list a:visited { color: #101010; }
.file_list a:hover { color: #ff0000; }
.file_list a:active { color: #ff0000; }
ul.file_list {
	margin: 10px 0 5px 10px;
}
td.file_list {
	padding-left: 10px;
}
td.file_size {
	padding: 1px 0 1px 10px;
	text-align: right;
}
td.file_time {
	padding: 1px 0 1px 10px;
}
td.file_type {
	padding: 1px 0 1px 0;
}
th.file_list {
	padding-left: 34px;
	background-color: #e0e0ff;
}
th.file_size {
	padding: 1px 0 1px 10px;
	text-align: right;
	color: #101010;
	background-color: #e0e0ff;
}
th.file_time {
	padding: 1px 0 1px 10px;
	background-color: #e0e0ff;
}
th.file_type {
	padding: 1px 0 1px 10px;
	background-color: #e0e0ff;
}
th a:link { color: #101010; font-weight: bold;}
th a:visited { color: #101010; font-weight: bold;}
th a:hover { color: #ff0000; font-weight: bold;}
th a:active { color: #ff0000; font-weight: bold;}
a.edit_btn {
	margin: 0 2px 0 2px;
}
a.edit_btn:link  { color: #ff8000; font-weight: normal;}
a.edit_btn:visited { color: #ff8000; font-weight: normal;}
a.edit_btn:hover { color: #ff0000; font-weight: normal; background-color: #f0f0f0}
a.edit_btn:active { color: #ff0000; font-weight: normal; background-color: #e0e0e0}
.order_mark {
	font-size: 80%;
	color: #808080;
	padding-left: 2px;
}
.file_folder {
	background-image: url(icon/folder.gif);
	background-repeat: no-repeat;
	background-position: top left;
	list-style: none;
	list-style-type: none;
	margin: 2px 0 2px 0;
	padding-left: 24px;
	font-size: 16px;
}
.file_php {
	background-image: url(icon/php.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_js {
	background-image: url(icon/js.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_html {
	background-image: url(icon/html.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
}
.file_css {
	background-image: url(icon/css.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_txt {
	background-image: url(icon/txt.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_xml{
	background-image: url(icon/txt.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_sql {
	background-image: url(icon/sql.gif);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
}
.file_zip {
	background-image: url(icon/zip.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_other {
	background-image: url(icon/other.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.file_encode {
	background-image: url(icon/encode.png);
	background-repeat: no-repeat;
	background-position: top left;
	padding-left: 24px;
	font-size: 16px;
}
.encode_file {
	color: red;
	font-weight: bold;
}
p#file_name_box {
	margin: 3px 0 0 0;
}
p#create_folder {
	margin: 3px 0 0 0;
}
span#file_name {
	text-decoration: underline;
	background-color: #e0f0ff;
	border: 0px;
	padding: 1px 4px 1px 4px;
}
span#file_encode {
	background-color: #fff0e0;
	border: 0px;
	padding: 1px 4px 1px 4px;
}
#filemanager_body input[type="button"], x:-moz-any-link {	/* Firefox */
	height: 1.4em;
}
html>/**/body #filemanager_body input[type="button"] {	/* IE以外 */
	padding: 0 2px;
	line-height: 1em;
}
*+html #filemanager_body input[type="button"] {	/* IE */
	height: 1.3em;
}
*html #filemanager_body input[type="button"]) {	/* IE6 */
	height: 1.3em;
}
</style>
<script language="javascript" src="../scripts/URLencode.js" type="text/javascript"></script>
<script language="JavaScript">
function rename_file(path, fname){
	fname = window.prompt("新しいファイル名を入れてください。", fname);
//	window.alert(fname);
	location.href='file-rename.php?path='+URLencode(path)+'&new='+URLencode(fname);
}
function delete_file(path){
	fname = path.substring(path.lastIndexOf('/')+1);
	if (window.confirm('ファイル「'+fname+'」を削除しますか？')) {
		location.href='file-delete.php?path='+URLencode(path);
	} else {
		//window.alert('キャンセルされました');
	}
}
function unzip_file(path, dest){
	dest = window.prompt("解凍先フォルダ名を入れてください。\nフォルダ名を省略するとカレントフォルダに(上書き)解凍します。", dest);
	location.href='file-unzip.php?path='+URLencode(path)+'&dest='+URLencode(dest);
}
function cipher_file(path){
	if (document.getElementById('encode_mode').checked) {
		mode = 2;
	} else {
		mode = 3;
	}
	location.href='file-cipher.php?path='+URLencode(path)+'&mode='+mode;
}
function create_folder(){
	location.href='folder-create.php?path=<?= urlencode($open_path) ?>&new='+URLencode(document.form0.create_folder_name.value);
}
function rename_folder(path, fname){
	fname = window.prompt("新しいフォルダ名を入れてください。", fname);
//	window.alert(fname);
	location.href='folder-rename.php?path='+URLencode(path)+'&new='+URLencode(fname);
}
function delete_folder(path){
	fname = path.substring(path.lastIndexOf('/')+1);
	if (window.confirm('フォルダ「'+fname+'」を削除しますか？')) {
		location.href='folder-delete.php?path='+URLencode(path);
	} else {
		//window.alert('キャンセルされました');
	}
}
</script>
<title>ファイルマネージャー（暗号化/復号化付き）</title>
</head>
<body>
<p id="tool_title_area">
<a href="../tools/" class="return_index">■</a>
<span id="tool_title">ファイルマネージャー（暗号化/復号化付き）</span>
</p>
<div id="header">
	<form name="form0" action="<?= $_SERVER['SCRIPT_NAME'] ?>" method="post">
		<input type="button" name="" value="↑" onClick="location.href='<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode(up_folder_path($open_path)) ?>'">
		<input class="text" type="text" id="path" name="path" value="<?= my_htmlspecialchars($open_path) ?>" size=60>
		<input type="submit" name="path_change" value="変更">
		ファイル/フォルダ名：<input class="text<?= $_SESSION['file_manager_search_key'] <> '' ? ' list_filter_true' : '' ?>" type="text" name="search_key" value="<?= my_htmlspecialchars($_SESSION['file_manager_search_key']) ?>" size=16>
		<input type="submit" name="search" value="検索">
		<input type="submit" name="search_reset" value="リセット">
		<br>
		<p id="file_name_box">カレント・フォルダ：<span><?= up_folder_direct('?path=', $open_path) ?></span></p>
		<p id="create_folder">作成フォルダ名：<input class="text" type="text" name="create_folder_name" value="" size=30>
		<input type="button" name="" value="フォルダ作成" onClick="create_folder()">
		</p>
	</form>
	<form action="file-upload-single.php?path=<?= urlencode($open_path) ?>" method="post" enctype="multipart/form-data">
		ファイル・アップロード：<input type="file" size=40 name="filename" style="button-font-size:small;">
		<input class="input_form_button" type="submit" name="登録" value="登録"></font>
		<a href="file-upload.php?path=<?= urlencode($open_path) ?>" style="margin-left:10px;">複数ファイル・一括アップロード</a>
	</form>
</div>
<div id="filemanager_body">
<?php
	if ($file_mode == 'Folder') {
		view_folder($open_path, $path_SJIS, $_SESSION['file_manager_search_key']);
	} else {
		echo '<p class="error_msg">'.$error_msg.'</p>';
	}
?>
</div>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function view_folder($open_path, $path_SJIS, $search_key) {
	$prt_dir = array();
	$prt_file = array();
	if ($dir = opendir($path_SJIS)) {
		$files = scandir($path_SJIS);
		natcasesort($files);
		$order = 0;
		error_reporting(0);	// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
		foreach ($files as $file) {
			if ($file != "." && $file != "..") {
				$filepath_SJIS = $path_SJIS.'/'.$file;
				if (is_dir($filepath_SJIS)) {
					$prt_dir[] = $file;
				} else {
					$type = chk_source_filename($file);
					$ext = strtolower(strrchr($file, '.'));
					if ($type == False) {
						if ($ext == '.encode3' or $ext == '.encode2' or $ext == '.encode') {
							$type = 'encode';
						} else if ($ext == '.zip') {
							$type = 'zip';
						} else {
							$type = 'other';
						}
					}
					if (($stat = stat($filepath_SJIS)) <> False) {
						$prt_file[] = array($file, $type, $stat['size'], $stat['mtime'], $ext);
						$prt_file_name[] = $file;
						$prt_file_time[] = $stat['mtime'];
						$prt_file_size[] = $stat['size'];
						$prt_file_type[] = $ext;
					} else {
						// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
						$prt_file[] = array($file, $type, 0, 0, '');
						$prt_file_name[] = $file;
						$prt_file_time[] = 0;
						$prt_file_size[] = 0;
						$prt_file_type[] = '';
					}
					// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
					$prt_order[] = ++$order;
				}
			}
		}
		error_reporting(E_ALL ^ E_NOTICE);
		closedir($dir);
	}
	print_dir($open_path, $prt_dir, $search_key);
	print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_time, $prt_file_size, $prt_file_type, $prt_order);
}
function print_dir($open_path, $prt_dir, $search_key) {
?>
	<div id="print_dir">
	<ul class="file_list">
<?php
	foreach ($prt_dir as $dir) {
		$file_UTF = myfile_DECODE($dir);
		$path_UTF = $open_path.'/'.myfile_DECODE($dir);
		if ($search_key == '' or ($search_key <> '' and stristr(basename($path_UTF), $search_key)) ) {
?>
		<li class="file_folder"><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode($path_UTF) ?>&key=<?= urlencode($search_key) ?>"><?= $file_UTF ?></a>
		<input type="button" class="copy_button" value="Ｃ" onClick="location.href='folder-copy.php?path=<?= urlencode($path_UTF) ?>'">
		<input type="button" class="copy_button" value="Ｒ" onClick="rename_folder('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｄ" onClick="delete_folder('<?= escape_squote($path_UTF) ?>')">
		</li>
<?php
		}
	}
?>
	</ul>
	</div>
<?php
}
function print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_time, $prt_file_size, $prt_file_type, $prt_order) {
	if (!$prt_file_name) return;
?>
	<div id="print_file">
	<?php if (defined("FILE_MANAGER_CIPHER_SEED") and FILE_MANAGER_CIPHER_SEED <> '') { ?>
		<p style="margin: 5px 0 0 20px; color:green">
		※ 暗号化は、すでに暗号化ファイルがあった場合、上書き処理します。<br>
		※ 復号化は、元ファイルがある場合、エラーとします。<br>
		※ unZipは、元のタイムスタンプは保存されません。<br>
		※ 暗号化/復号化/unZipは、ファイルサイズが大きいとかなり処理時間がかかります。
		</p>
		<p style="margin: 0 0 5px 20px;">
		<input type="button" class="copy_button" value="Ｃ">：コピー
		<input type="button" class="copy_button" value="Ｒ">：リネーム
		<input type="button" class="copy_button" value="Ｄ">：削除
		<input type="checkbox" id="encode_mode" value="2"<? if ($_SESSION['file_manager_encode_mode'] == '2') echo ' checked'; ?>>XORで暗号化(暗号化キーコードが推測されるリスクがあります)
		</p>
	<?php } else {?>
		<p style="margin: 10px 0 10px 20px; color:red">
		※ 実運用定義ファイルで、FILE_MANAGER_CIPHER_SEEDが定義されていないと暗号化/復号化はできません。<br>
		</p>
	<?php } ?>
	<table>
<?php
	$href = $_SERVER['SCRIPT_NAME'] . '?path=' .urlencode($open_path);
	if ($_SESSION['file_manager_sort'] == 'date') {
		if ($_SESSION['file_manager_sort_order'] == 'desc') {
			array_multisort($prt_file_time, SORT_DESC, $prt_file);
			$date_ch_order = '&order=asc';
			$date_om = '<span class="order_mark">▼</span>';
		} else {
			array_multisort($prt_file_time, SORT_ASC, $prt_file);
			$date_ch_order = '&order=desc';
			$date_om = '<span class="order_mark">▲</span>';
		}
	} else if ($_SESSION['file_manager_sort'] == 'type') {
		if ($_SESSION['file_manager_sort_order'] == 'desc') {
			array_multisort($prt_file_type, SORT_DESC, $prt_file);
			$type_ch_order = '&order=asc';
			$type_om = '<span class="order_mark">▼</span>';
		} else {
			array_multisort($prt_file_type, SORT_ASC, $prt_file);
			$type_ch_order = '&order=desc';
			$type_om = '<span class="order_mark">▲</span>';
		}
	} else if ($_SESSION['file_manager_sort'] == 'size') {
		if ($_SESSION['file_manager_sort_order'] == 'desc') {
			array_multisort($prt_file_size, SORT_DESC, $prt_file);
			$size_ch_order = '&order=asc';
			$size_om = '<span class="order_mark">▼</span>';
		} else {
			array_multisort($prt_file_size, SORT_ASC, $prt_file);
			$size_ch_order = '&order=desc';
			$size_om = '<span class="order_mark">▲</span>';
		}
	} else {
		if ($_SESSION['file_manager_sort_order'] == 'desc') {
			// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
			array_multisort($prt_order, SORT_DESC, $prt_file);
			$name_ch_order = '&order=asc';
			$name_om = '<span class="order_mark">▼</span>';
		} else {
			$name_ch_order = '&order=desc';
			$name_om = '<span class="order_mark">▲</span>';
		}
	}
?>
	<tr><a name="file" />
	<th class="file_list"><a href="<?= $href ?>&sort=name<?= $name_ch_order ?>#file">ファイル名</a><?= $name_om ?></th>
	<th class="file_size"><a href="<?= $href ?>&sort=size<?= $size_ch_order ?>#file">サイズ</a><?= $size_om ?></th>
	<th class="file_time"><a href="<?= $href ?>&sort=date<?= $date_ch_order ?>#file">更新日時</a><?= $date_om ?></th>
	<th class="file_type"><a href="<?= $href ?>&sort=type<?= $type_ch_order ?>#file">種類</a><?= $type_om ?></th>
	</tr>
<?php
	foreach ($prt_file as $file) {
		$file_UTF = myfile_DECODE($file[0]);
		$path_UTF = $open_path.'/'.myfile_DECODE($file[0]);
		$path_SJIS = myfile_ENCODE($path_UTF);
		if ($search_key == '' or ($search_key <> '' and stristr($file_UTF, $search_key)) ) {
?>
		<tr><td class="file_list" nowrap>
		<?php if ($file[1] == 'encode') { ?>
			<?php $cip_val = '←復号化' ?>
			<span class="file_<?= $file[1] ?>">
				<a href="file-download.php?path=<?= urlencode($path_UTF) ?>"><span class="encode_file"><?= $file_UTF ?></span></a>
			</span>
		<?php } else { ?>
			<?php $cip_val = '暗号化' ?>
			<span class="file_<?= $file[1] ?>">
				<a href="file-download.php?path=<?= urlencode($path_UTF) ?>"><?= $file_UTF ?></a>
			</span>
		<?php } ?>
		<?php if ($file[1] == 'zip') { ?>
			<input type="button" class="copy_button" value="unZip" onClick="unzip_file('<?= $path_UTF ?>', '<?= substr($file_UTF, 0, -4) ?>')">
		<?php } else if ($file[1] != 'other' && $file[1] != 'encode') { ?>
			<input type="button" class="copy_button" value="Ｓ" onClick="window.open().location.href='code-file-view.php?path=<?= urlencode($path_UTF) ?>'">
		<?php } ?>
		<?php if (defined("FILE_MANAGER_CIPHER_SEED") and FILE_MANAGER_CIPHER_SEED <> '') { ?>
	<input type="button" class="copy_button" value="<?= $cip_val ?>" onClick="cipher_file('<?= escape_squote($path_UTF) ?>')">
		<?php } ?>
	<input type="button" class="copy_button" value="Ｃ" onClick="location.href='file-copy.php?path=<?= urlencode($path_UTF) ?>'">
	<input type="button" class="copy_button" value="Ｒ" onClick="rename_file('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
	<input type="button" class="copy_button" value="Ｄ" onClick="delete_file('<?= escape_squote($path_UTF) ?>')">
	</td>
	<td class="file_size"><?= ceil($file[2]/1024) ?> KB</td>
	<td class="file_time"><?= date("Y/m/d H:i", $file[3]) ?></td>
	<td class="file_time"><?= $file[4] ?></td>
	</tr>
<?php
		}
	}
?>
	</table>
	</div>
<?php
}
function folder_check($open_path, &$path_SJIS, &$error_msg) {
	$path_SJIS = myfile_ENCODE($open_path);
	if (file_exists($path_SJIS)) {
		if (is_dir($path_SJIS)) {
			return 'Folder';
		} else {
			$error_msg =  'ファイル『 '.$open_path.' 』は表示できません。';
			return 'File';
		}
	} else {
		$error_msg =  'フォルダまたはファイル『 '.$open_path.' 』が、みつかりません。';
		return 'Error';
	}
}
?>
