<?php
	if (!defined("LIFEPLAN_YEAR_OPT_MAX")) {
		define("LIFEPLAN_YEAR_OPT_MAX", 10);
	}
	if (!defined("LIFEPLAN_INOUT_MAX")) {
		define("LIFEPLAN_INOUT_MAX", 8);
	}
	if (!defined("LIFEPLAN_SAVEDATA_MAX")) {
		define("LIFEPLAN_SAVEDATA_MAX", 9);
	}
	require("__include-common.php");
	require("../account/__logincheck.php");
	html_header('MyHome ライフプラン');
	if (kakeibo_PAGE_HEADER == 'YES') {
		page_header();
	} else {
		page_header_return_index();
	}
	contents_header();
	main_proc();
	page_footer();
	html_footer();
	exit();
function main_proc() {
?>
<style>
div#main_body {
	clear: both;
	margin: 5px 10px;
	padding: 0;
}
div#container {
	width: 800px;
	height: 400px;
	margin: 5px 10px;
}
#sim_table {
	border-collapse: collapse;
	border-style: solid;
	border-width: 1px;
	border-color: #A0A0A0;
	background-color: #A0A0A0;
}
#sim_table * {
	font-size: 12px;
}
#sim_table th {
	color: #FFFFFF;
	border: 1px solid #ccc;
	background-color: #00C0C0;
	padding: 2px;
	white-space: nowrap;
	vertical-align: middle;
}
#sim_table td {
	color: #000000;
	border: 1px solid #ccc;
	background-color: #E8F8FF;
	padding: 2px;
	text-align: right;
}
.set_data th,td {
	vertical-align: middle;
	white-space: nowrap;
}
#set_data_tbl input[type="text"] {
	width: 40px;
	ime-mode: disabled;
}
button {
	white-space: nowrap;
}
</style>
<div id="main_body">
<table class="set_data">
	<tr>
	<th>タイトル：</th><td><input id="subject" type="text" style="width: 100px;ime-mode: active;"></td>
	<td style="padding-left:10px;">
		<button onclick="dataSave();">Save</button>
		<select id="saveId">
		</select>
		<button onclick="dataLoad();">Load</button>
	</td>
	<td style="padding-left:10px;"><button onclick="dataClear();">クリア</button></td>
<!--	<td style="padding-left:10px;"><button onclick="dataAllClear();">Allクリア</button></td> -->
	<td style="padding-left:10px;"><button onclick="sampleSet();">サンプル</button></td>
	</tr>
</table>
<table class="set_data">
	<th>年(歳)：</th><td><input id="year1" type="text" style="width: 36px;ime-mode: disabled;"></td>
	<th>～</th><td><input id="year2" type="text" style="width: 36px;ime-mode: disabled;"></td>
	<th style="padding-left:10px;">項目名：</th><td><input id="itemname" type="text" style="width: 40px;ime-mode: active;"></td>
	<th>初期値：</th><td><input id="iteminit" type="text" style="width: 50px;ime-mode: disabled;"></td>
	<th>単位：</th><td><input id="itemunit" type="text" style="width: 30px;ime-mode: active;"></td>
	<th style="padding-left:10px;">金利：</th><td><input id="nenri" type="text" style="width: 30px;ime-mode: disabled;">％</td>
	<tr>
	</tr>
</table>
<h4>収入・支出</h4>
<table id="set_data_tbl">
	<tr>
		<th style="text-align:center;">費目＼年(歳)</th>
<?php	for ($ix=1; $ix<=LIFEPLAN_YEAR_OPT_MAX; $ix++) { ?>
		<td><input id="yc<?= $ix ?>" type="text"></td>
<?php	} ?>
	</tr>
<?php	for ($iy=0; $iy<LIFEPLAN_INOUT_MAX; $iy++) { ?>
		<tr>
			<th><input id="inoutname<?= $iy ?>" type="text" style="width:80px;ime-mode: active;"></th>
	<?php	for ($ix=1; $ix<=LIFEPLAN_YEAR_OPT_MAX; $ix++) { ?>
			<td><input id="inout<?= $iy ?><?= $ix ?>" type="text"></td>
	<?php	} ?>
		</tr>
<?php	} ?>
</table>
<table id="sim_table"></table>
</div>
<div id="container"></div>
<script src="../scripts/json2/json2.js"></script>
<script src="../scripts/jstorage.js"></script>
<script src="../scripts/Highcharts/js/highcharts.js"></script>
<script src="../scripts/Highcharts/js/modules/exporting.js"></script>
<script>
function dataAllClear() {
	if (window.confirm('Saveデータ含めて全てを削除しますか？')) {
		localStorage.clear();
	//	saveName_set();
	//	sim_table_set();
		window.location.reload();
	}
}
function dataClear() {
	dataClear_id('subject');
	dataClear_id('itemname');
	dataClear_id('itemunit','万円');
	dataClear_id('year1','');
	dataClear_id('year2','');
	dataClear_id('iteminit','0');
	dataClear_id('nenri','0');
	for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
		dataClear_id('yc'+ix);
	}
	for (iy=0; iy<<?= LIFEPLAN_INOUT_MAX ?>; iy++) {
		dataClear_id('inoutname'+iy);
		for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
			dataClear_id('inout'+iy+ix);
		}
	}
	sim_table_clear();
}
function sampleSet() {
	dataClear_id('subject','人生設計');
	dataClear_id('itemname','資産');
	dataClear_id('itemunit','万円');
	dataClear_id('year1','40');
	dataClear_id('year2','80');
	dataClear_id('iteminit','1000');
	dataClear_id('nenri','1');
	for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
		dataClear_id('yc'+ix);
	}
	for (iy=0; iy<<?= LIFEPLAN_INOUT_MAX ?>; iy++) {
		dataClear_id('inoutname'+iy);
		for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
			dataClear_id('inout'+iy+ix);
		}
	}
	dataClear_id('inoutname0','太郎収入');
	dataClear_id('inoutname1','花子収入');
	dataClear_id('inoutname2','太郎退職金');
	dataClear_id('inoutname3','太郎年金');
	dataClear_id('inoutname4','花子年金');
	dataClear_id('inoutname5','支出');
	dataClear_id('yc1','40');
	dataClear_id('yc2','50');
	dataClear_id('yc3','60');
	dataClear_id('yc4','61');
	dataClear_id('yc5','65');
	dataClear_id('yc6','70');
	dataClear_id('inout01','300');
	dataClear_id('inout02','400');
	dataClear_id('inout03','100');
	dataClear_id('inout04','100');
	dataClear_id('inout05','0');
	dataClear_id('inout06','0');
	dataClear_id('inout11','200');
	dataClear_id('inout12','200');
	dataClear_id('inout13','0');
	dataClear_id('inout14','0');
	dataClear_id('inout15','0');
	dataClear_id('inout16','0');
	dataClear_id('inout21','');
	dataClear_id('inout22','');
	dataClear_id('inout23','1000');
	dataClear_id('inout24','');
	dataClear_id('inout25','');
	dataClear_id('inout26','');
	dataClear_id('inout31','');
	dataClear_id('inout32','');
	dataClear_id('inout33','');
	dataClear_id('inout34','');
	dataClear_id('inout35','100');
	dataClear_id('inout36','100');
	dataClear_id('inout41','');
	dataClear_id('inout42','');
	dataClear_id('inout43','');
	dataClear_id('inout44','');
	dataClear_id('inout45','');
	dataClear_id('inout46','100');
	dataClear_id('inout51','-400');
	dataClear_id('inout52','-400');
	dataClear_id('inout53','-400');
	dataClear_id('inout54','-400');
	dataClear_id('inout55','-300');
	dataClear_id('inout56','-300');
	sim_table_set();
}
function todayYear() {
	today = new Date();
	return today.getFullYear();
}
function dataClear_id(name, inival) {
	if (inival) {
		$.jStorage.set(name, inival);
	} else {
		$.jStorage.set(name, '');
	}
	$('#'+name).val($.jStorage.get(name));
}
function dataSave() {
	saveId = 's' + $('#saveId').val();
	$.jStorage.set('currenId', $('#saveId').val());
	var subj = $.jStorage.get('subject').replace('"','”').replace("'",'’').replace(":",'：').replace(",",'：，');
	$.jStorage.set('subject', subj);
	json = '{"dummy": ""';
	json += dataSave_id('subject', saveId);
	json += dataSave_id('itemname', saveId);
	json += dataSave_id('itemunit', saveId);
	json += dataSave_id('year1', saveId);
	json += dataSave_id('year2', saveId);
	json += dataSave_id('iteminit', saveId);
	json += dataSave_id('nenri', saveId);
	for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
		json += dataSave_id('yc'+ix, saveId);
	}
	for (iy=0; iy<<?= LIFEPLAN_INOUT_MAX ?>; iy++) {
		json += dataSave_id('inoutname'+iy, saveId)
		for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
			json += dataSave_id('inout'+iy+ix, saveId);
		}
	}
	json += '}';
	var data = {ac:"<?=$_SESSION['current_id'] ?>", id:$('#saveId').val(), name:subj, json:json};
	$.ajax({
		type: "POST",
		url: "lifeplan-save.php",
		data: data,
		async: false,
		success: function(res){
			if (res != 'OK') {
				alert(res);
			} else {
				saveName_set();
			}
		}
	});
}
function dataSave_id(name, saveId) {
	$.jStorage.set(saveId+name, $.jStorage.get(name));
	return (',"' + name + '": "' + $.jStorage.get(name) + '"');
}
function dataLoad() {
	saveId = 's' + $('#saveId').val();
	$.ajax({
		type: "GET",
		url: "lifeplan-load.php?id="+$('#saveId').val(),
		async: false,
		success: function(json){
			if (json == "NoData") {
				dataClear();
			} else {
				var data = JSON.parse(json);
				dataLoad_id(data, "subject", saveId);
				dataLoad_id(data, "itemname", saveId);
				dataLoad_id(data, "itemunit", saveId);
				dataLoad_id(data, "year1", saveId);
				dataLoad_id(data, "year2", saveId);
				dataLoad_id(data, "iteminit", saveId);
				dataLoad_id(data, "nenri", saveId);
				for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
					dataLoad_id(data, "yc"+ix, saveId);
				}
				for (iy=0; iy<<?= LIFEPLAN_INOUT_MAX ?>; iy++) {
					dataLoad_id(data, "inoutname"+iy, saveId);
					for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
						dataLoad_id(data, "inout"+iy+ix, saveId);
					}
				}
				sim_table_set();
			}
		}
	});
}
function dataLoad_id(data, name, saveId) {
	$.jStorage.set(name, eval("data."+name));
	$('#'+name).val($.jStorage.get(name));
}
function saveName_set() {
	$.ajax({
		type: "GET",
		url: "lifeplan-load-name.php",
		async: false,
		success: function(res){
			var names = new Array()
			for (ix=1; ix<=<?= LIFEPLAN_SAVEDATA_MAX ?>; ix++) {
				names[ix] = '';
			}
			var res_split = res.split(",");
			for (ix=0; ix<res_split.length; ix++) {
				var nm = res_split[ix].split(":");
				names[Number(nm[0])] = nm[1];
			}
			var currenId = Number($.jStorage.get('currenId'));
			var saveOpt = '';
			for (ix=1; ix<=<?= LIFEPLAN_SAVEDATA_MAX ?>; ix++) {
				saveOpt += '<option value="' + ix + '"';
				if (ix == currenId) {
					saveOpt += ' selected'
				}
				saveOpt += '>' + ix + '：' + names[ix];
			}
			$('#saveId').html(saveOpt);
			$('#saveId').val(currenId);
		}
	});
}
$(function(){
	//	localStorage.clear();
	saveName_set();
	$('#saveId').val(1);
	dataLoad();
});
$('input').change(function(){
	var id = $(this).attr("id");
	inputval = zen2han($('#'+id).val());
	$('#'+id).val(inputval);
	$.jStorage.set(id, inputval);
	if ($('#year1').val() == '' || $('#year2').val() == '') {
		return;
	}
	year1 = Number($('#year1').val());
	year2 = Number($('#year2').val());
	if ((year2 - year1) < 2 || (year2 - year1) > 100) {
		if (id == 'year1' || id == 'year2') {
			alert('年(歳)の間隔は2以上100以下にしてください。');
		}
		return;
	}
	sim_table_set();
});
function sim_table_set() {
	var inout = new Array(<?= LIFEPLAN_INOUT_MAX ?>);
		for (var iy=0; iy<<?= LIFEPLAN_INOUT_MAX ?>; iy++) {
			inout[iy] = new Array();
		}
	var v_stock = new Array();
	var v_total = new Array();
	var v_inout = new Array(<?= LIFEPLAN_INOUT_MAX ?>);
		for (var iy=0; iy<<?= LIFEPLAN_INOUT_MAX ?>; iy++) {
			v_inout[iy] = new Array();
		}
	var rishi = new Array();
	var chart_val = new Array();
	var year1;
	var year2;
	var yc = new Array();
	var yc_cnt = 0;
	var inout_cnt = 0;
	year1 = storage_get_int('year1');
	year2 = storage_get_int('year2');
	itemname = $('#itemname').val();
	if (year1 >= year2) {
		sim_table_clear();
		return;
	}
	tbl_h = '<tr>';
		tbl_h += '<th></th>';
		for (yy=year1; yy<=year2; yy++) {
			tbl_h += '<th>'+yy+'</th>';
		}
	tbl_h += '</tr>';
	for (ix=1; ix<=<?= LIFEPLAN_YEAR_OPT_MAX ?>; ix++) {
		if (storage_get_int('yc'+ix, true) != null) {
			yc[ix] = storage_get_int('yc'+ix);
			for (iy=0; iy<<?= LIFEPLAN_INOUT_MAX ?>; iy++) {
				if ($.jStorage.get('inoutname'+iy,'') != '') {
					inoutID = 'inout'+iy+ix;
					inout[iy][ix] = storage_get_int(inoutID);
					inout_cnt = iy+1;
				}
			}
			yc_cnt = ix;
		} else {
			break;
		}
	}
	tbl_inout = '';
	for (iy=0; iy<inout_cnt; iy++) {
		tbl_inout += '<tr>';
			tbl_inout += '<th>'+$.jStorage.get('inoutname'+iy,'')+'</th>';
			for (yy=year1; yy<=year2; yy++) {
				v_inout[iy][yy] = get_inout(inout, yy, iy, yc, yc_cnt);
				tbl_inout += '<td>'+v_inout[iy][yy]+'</td>';
			}
		tbl_inout += '</tr>';
	}
	tbl_stock = '<tr>';
		v_stock[year1-1] = storage_get_int('iteminit');
		tbl_stock += '<th>'+itemname+'</th>';
		v_total[year1-1] = v_stock[year1-1];
	nenri = storage_get_int('nenri');
	tbl_rishi = '<tr>';
		tbl_rishi += '<th>利子</th>';
	tbl_total = '<tr>';
		tbl_total += '<th>合計</th>'
		ci = 0;
		for (yy=year1; yy<=year2; yy++) {
			inout_year = 0;
			for (iy=0; iy<inout_cnt; iy++) {
				inout_year += v_inout[iy][yy];
			}
			v_stock[yy] = v_total[yy-1];
			chart_val[ci++] = v_stock[yy];
			rishi[yy] = v_stock[yy] * nenri / 100;
			tbl_rishi += '<td>'+num_format(rishi[yy])+'</td>';
			tbl_stock += '<td>'+num_format(v_stock[yy], 0)+'</td>';
			v_total[yy] = v_stock[yy] + rishi[yy] + inout_year;
			tbl_total += '<td>'+num_format(v_total[yy], 0)+'</td>';
		}
	tbl_total += '</tr>';
	tbl_stock += '</tr>';
	tbl_rishi += '</tr>';
	$('#sim_table').html(tbl_h + tbl_stock + tbl_rishi + tbl_inout + tbl_total);
	chart_view(year1, chart_val);
}
function sim_table_clear() {
	$('#sim_table').html('');
	var chart_val = new Array();
	chart_view(0, chart_val);
}
function storage_get_int(name, chk) {
	if ($.jStorage.get(name) && !isNaN($.jStorage.get(name))) {
		return Number($.jStorage.get(name));
	} else {
		if (chk) {
			return null;
		} else {
			return 0;
		}
	}
}
function get_inout(inout, yy, iy, yc, yc_cnt) {
	var found_inout = 0;
	for (ix=1; ix<=yc_cnt; ix++) {
		if (yy < yc[ix]) return found_inout;
		if (inout[iy][ix]) {
			found_inout = inout[iy][ix];
		} else {
			found_inout = 0;
		}
		if (yy == yc[ix]) {
			return found_inout;;
		}
	}
	return found_inout;
}
</script>
<script>
var chart;
function chart_view(year1, chart_val) {
	title = $('#subject').val();
	itemname = $('#itemname').val();
	itemunit = $('#itemunit').val();
	chart = new Highcharts.Chart({
		chart: {
			renderTo: 'container',
			defaultSeriesType: 'area'
		},
		title: { text: title },
		subtitle: { text: '' },
		xAxis: {
			labels: {
				formatter: function() {
					return this.value; // clean, unformatted number for year
				}
			}
		},
		yAxis: {
			title: {
				text: itemunit
			},
			labels: {
				formatter: function() {
					return Highcharts.numberFormat(this.value, 0);
				}
			}
		},
		tooltip: {
			formatter: function() {
				return '<b>' + this.x + '</b>年(歳)：' + '<b>' + Highcharts.numberFormat(this.y, 0) + '</b>' + itemunit;
			}
		},
		plotOptions: {
			area: {
				pointStart: year1,
				marker: {
					enabled: false,
					symbol: 'circle',
					radius: 2,
					states: {
						hover: {
							enabled: true
						}
					}
				}
			}
		},
		series: [{
			name: itemname,
			data: chart_val
		}]
	});
}
</script>
<?php
}
?>
