<?php
//	■「__define_common_my.php」サンプル
// *************************************************************************************************************
//	__common__/__define_common.php 参照
//	このファイルを、インストールディレクトリ_myhomeの外に置きます。
//	フォルダ構成例：
//	D:\XAMPP\htdocs\_myhome_myset\__define_common_my.php		:実運用定義ファイル（このファイル）
//	D:\XAMPP\htdocs\_myhome_myset\__define_contents_my.php		:メインコンテンツ定義ファイル
//	D:\XAMPP\htdocs\_myhome_myset\__define_mysql_admin.php		:MySQL管理ツール：スキーマ表示権限ユーザー定義ファイル
//	D:\XAMPP\htdocs\_myhome_myset\_my_calendar_images		:カレンダー用アイコンフォルダ
//	D:\XAMPP\htdocs\_myhome_myset\__define_weather_city_my.php	:天気ガジェット都市プルダウン定義ファイル(使う場合のみ)
//	D:\XAMPP\htdocs\_attach\calendar				:カレンダー：添付ファイル格納場所
//	D:\XAMPP\htdocs\_attach\memo					:メモ：添付ファイル格納場所
//	D:\XAMPP\htdocs\_attach\bbs					:掲示板：添付ファイル格納場所
// *************************************************************************************************************

	define("_DB_SERVER", "localhost");
	define("_DB_USERNAME", "myhome");			// MySQL ユーザー名	★★★ 設定必須
	define("_DB_PASSWORD", "pass123");			// MySQL パスワード	★★★ 設定必須

// =============================================================================================================
	define("_DB_ANGOUKA_KEY", "YUihdYZYUihdmUwNZmsihshYZYUhdsihZYUiYUwNZsidsihYsiihYZYUihdYNZYUidsihYmw");	// ★★★
	// ↑ ID管理のID/パスワードの暗号化用文字列。
	// ↑ date関数のformatパラメータ文字列として使用可能な文字をランダムに指定。(文字の順番を変えるだけで十分。)
	// ↑ ★★★ 運用開始前に必ず修正すること。
	// ↑ ★★★ 運用開始後は絶対に修正してはいけません。修正するとID/パスワードが復元できなくなります。
	// ↑ ★★★ 修正後は、このファイルを必ずバックアップしてください。

	//define("_DB_ANGOUKA_KEY_EOR", "OpenSesame123");							// ★★★
	// ↑ ID管理の暗号化を2重に行う暗号化キーコードです。使う場合、コメントアウトを外してください。
	// ↑ 任意のランダムな英数字の文字列を指定。
	// ↑ ★★★ 運用開始前に必ず修正すること。
	// ↑ ★★★ 運用開始後は絶対に修正してはいけません。修正するとID/パスワードが復元できなくなります。
	// ↑ ★★★ 修正後は、このファイルを必ずバックアップしてください。

	//define("FILE_MANAGER_CIPHER_SEED", "HirakeGoma789");							// ★★★
	// ↑ ツール「ファイル暗号化」「実運用環境バックアップ」でファイル暗号化に使うキーコード。使う場合、コメントアウトを外してください。
	// ↑ XAMPPのバージョンによっては、Crypt_Blowfishがインストールされません。
	// ↑   /xampp/php/PEAR/Crypt/Blowfish.phpがインストールされている事を確認の上、設定してください。
	// ↑ 任意のランダムな英数字の文字列を指定。
	// ↑ ★★★ 運用開始前に必ず修正すること。
	// ↑ ★★★ 運用開始後は絶対に修正してはいけません。修正するとID/パスワードが復元できなくなります。
	// ↑ ★★★ 修正後は、このファイルを必ずバックアップしてください。

	// ↓実運用環境バックアップ：暗号化方式の選択
	// ↓XORで暗号化にすると、暗号化キーコードが、推測されるリスクがあります。
	define("BACKUP_MYDB_CIPHER_MODE", "3");		// 2:XORで暗号化 3:Crypt_Blowfishで暗号化
	// ↓Crypt_Blowfishによるファイル暗号化/復号化のサイズ制限
	// ↓制限を大きくしても、エラー(Out of memory)になるだけです。
	// ↓Crypt_Blowfishで暗号化するとファイルサイズが大きくなります。50MB以上にすると復号化できなくなる可能性もあります。
	define("CIPHER_FILE_MAX_SIZE", 50000000);	// 約50MB
// =============================================================================================================

//	define("PAGE_BODY_STYLE", "max-width: 980px;");		// ★ ページbodyのstyle(横幅)設定
	define("PAGE_BODY_STYLE", "max-width: 100%;");		// ★ ページbodyのstyle(横幅)設定

	define("LOGIN_COOKIE_EXPIRE", (3600 * 24 * 365));	// ログイン setcookie 保存時間
	define("IDMGR_COOKIE_EXPIRE", (3600 * 5));		// IDマネージャ setcookie 保存時間

	define("_STYLE_SHEET_FOLDER", "../style/original");		// CSSスタイルシート ディレクトリ
	define("_STYLE_SHEET_FOLDER_COMMON", "../style/original");	// CSSスタイルシート(common.css) ディレクトリ
	define("_STYLE_SHEET_BUTTON", "../style/button/standard.css?20120922");		// CSSボタン・スタイルシート
					// standard.css, radius.css, gradient.css, shadow.css, kube.css

	define("_CALENDAR_SELECT_FIRST_YEAR", 1980);		// カレンダー日付プルダウン表示開始年
	define("_DEBUG_ERROR_MSG", "NO");			// "YES":エラー詳細情報出力

	define("_ACCOUNT_CHANGE_USER_NUM", 5);			// カレントユーザ切り替えメニューをSELECTにするユーザ数

// *************************************************************************************************************
//	実運用のデータベース名をサンプルと変える場合は、ビュー作成時のデータベース名に注意してください。
//	以下のファイル内のデータベース名も全て変えてから、ビュー作成する必要があります。
//	z_db_backup\create_view_db_account.txt
//	.........
//	z_db_backup\create_view_db_zid_mgr_a.txt
// *************************************************************************************************************

	// データベース指定
	define("_DB_ACCOUNT_SCHEMA", "_mydb_account");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_account", "_mydb_account");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_calendar", "_mydb_calendar");		// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_index", "_mydb_index");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_memo", "_mydb_memo");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_zid_mgr_a", "_mydb_zid_mgr_a");		// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_zid_mgr_b", "_mydb_zid_mgr_b");		// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_bbs", "_mydb_bbs");				// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_rss", "_mydb_rss");				// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_chat", "_mydb_chat");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_kakeibo", "_mydb_kakeibo");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_study", "_mydb_study");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_abook", "_mydb_abook");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_diary", "_mydb_diary");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_sticky", "_mydb_sticky");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_photo", "_mydb_photo");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_svg", "_mydb_svg");				// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_draw", "_mydb_draw");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_psketch", "_mydb_psketch");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_email", "_mydb_email");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_gpslog", "_mydb_gpslog");			// ★ 実運用 (DB名変更)
	define("_DB_SCHEMA_guide", "_db_guide");			// サンプルと同じ

	// HTML タイトル
	define("HTML_TITLE_abook", "MyHome 住所録");
	define("HTML_TITLE_account", "MyHome 管理");
	define("HTML_TITLE_bbs", "MyHome 掲示板");
	define("HTML_TITLE_calendar", "MyHome カレンダー");
	define("HTML_TITLE_chat", "MyHome チャット");
	define("HTML_TITLE_diary", "MyHome 旅行記");
	define("HTML_TITLE_draw", "MyHome ペン画");
	define("HTML_TITLE_guide", "MyHome 利用ガイド");
	define("HTML_TITLE_idmanager", "MyHome ID管理");
	define("HTML_TITLE_index", "MyHome INDEX");
	define("HTML_TITLE_kakeibo", "MyHome 預貯金管理");
	define("HTML_TITLE_memo", "MyHome メモ");
	define("HTML_TITLE_photo", "MyHome アルバム");
	define("HTML_TITLE_rss", "MyHome RSS");
	define("HTML_TITLE_sticky", "MyHome 付箋");
	define("HTML_TITLE_study", "MyHome 学習");
	define("HTML_TITLE_svg", "MyHome お絵かき");
	define("HTML_TITLE_todo", "MyHome ToDo");
	define("HTML_TITLE_gpslog", "MyHome GPSログ");
	define("HTML_TITLE_tools", "MyHome ツール");
	define("HTML_TITLE_email", "MyHome EMail");

	// 電子メール
	define("_SENDMAIL_HOST", "localhost");			// smtp サーバ (php.ini)
	define("_SENDMAIL_PORT", 25);				// smtp ポート (25、587など)
	define("_SENDMAIL_EMAIL_NAME", "MyHome Portal");	// Emailに使う送信者名(日本語不可)
	define("_SENDMAIL_EMAIL_ADDR", "xxx@xxx.com");		// 送信者Emailアドレス
	define("_SENDMAIL_EMAIL_USER", "");			// 送信者Emailアカウント(smtp認証を使う場合)
	define("_SENDMAIL_EMAIL_PASS", "");			// 送信者Emailアカウントパスワード(smtp認証を使う場合)
	define("_SENDMAIL_AUTH_USE", False);			// smtp認証を使う場合: True
	define("_FORGOT_PASS_USE", False);			// パスワード忘れのメール送信機能を使う場合: True
	define("_SCHEDULE_SENDMAIL_USE", False);		// スケジュールメール送信機能を使う場合: True
	define("MAILTO_CONCATENATE_CHR", ",");			// mailto:で複数メールアドレスの結合文字
								// Thunderbird："," Outlook用：";"
	// 添付ファイルフォルダ
	define("ATTACH_FILE_FOLDER_account", "../../_attach/account/");			// ★ 実運用 (ファイル格納場所)
	define("ATTACH_FILE_FOLDER_memo", "../../_attach/memo/");			// ★ 実運用 (ファイル格納場所)
	define("ATTACH_FILE_FOLDER_calendar", "../../_attach/calendar/");		// ★ 実運用 (ファイル格納場所)
	define("ATTACH_FILE_FOLDER_bbs", "../../_attach/bbs/");				// ★ 実運用 (ファイル格納場所)
	define("ATTACH_FILE_FOLDER_diary", "../../_attach/diary/");			// ★ 実運用 (ファイル格納場所)
	define("ATTACH_FILE_FOLDER_diary_marker", "../../_attach/diary_marker/");	// ★ 実運用 (ファイル格納場所)
	define("ATTACH_FILE_FOLDER_gpslog", "../../_attach/gpslog/");			// ★ 実運用 (ファイル格納場所)
	define("ATTACH_FILE_FOLDER_abook", "../../_attach/abook/");			// ★ 実運用 (PDF作成場所)
	define("ATTACH_FILE_FOLDER_guide", "../_attach/guide/");			// サンプルと同じ

	// イメージファイルフォルダ
	define("IMAGES_FOLDER_calendar", "../../_myhome_myset/_my_calendar_images");	// ★ 実運用 カレンダーアイコン
	define("DIARY_MAPS_ICON_FOLDER", "../icon/maps/");				// Googleマップアイコン(旅行記、住所録で使用)
	//define("DIARY_MAPS_ICON_FOLDER", "../../_myhome_myset/_my_maps_icon/");	// Googleマップアイコンをカスタマイズする場合はこちらにしてください。(右端には必ず/を付けてください。)

	// カレンダースケジュール本文にhtmlタグを許可する場合"YES"
	//  ※注：<scriptだけは機能しないようにしていますが、それ以外は全て機能してしまいます。
	//	この機能はセキュリティ上、問題があります。
	//	家族など信頼できるユーザーだけで利用する以外は、
	//	define("TEXTAREA_HTML_USE", "NO")にして、このタグ機能を無効にすることをお勧めします。
	define("TEXTAREA_HTML_USE_calendar", "YES");

	// トップ・メニュー(コンテンツ・ナビ) デフォルト・カラー
	define("PAGE_NAVI_LINK_COLOR", "white");
	define("PAGE_NAVI_LINK_BG", "#404020");
	define("PAGE_NAVI_CURRENT_COLOR", "yellow");
	define("PAGE_NAVI_CURRENT_BG", "#9090ff");
	define("PAGE_NAVI_HOVER_COLOR", "white");
	define("PAGE_NAVI_HOVER_BG", "orange");
	define("PAGE_NAVI_ACTIVE_COLOR", "white");
	define("PAGE_NAVI_ACTIVE_BG", "gold");

	// ★ index トップページ 検索ボタン定義ファイル
	define("_DEFINE_INDEX_SEARCH_MY", "");
	//define("_DEFINE_INDEX_SEARCH_MY", "../../_myhome_myset/__define_index_search_my_google.php");
	//define("_DEFINE_INDEX_SEARCH_MY", "../../_myhome_myset/__define_index_search_my_yahoo.php");

	// ★ index トップページ
	define("index_BOX_BORDER_COLOR", '');	// ボックスのボーダー色：タイトルと同じ色にする場合
	//define("index_BOX_BORDER_COLOR", '#b0b0b0;');	// ボックスのボーダー色：全ボックスを同じ色にする場合
	define("index_BOX_BORDER_WIDTH", '1px');	// ボックスのボーダー幅

	define("index_CAPTURE_CREATE_SITE", 'http://capture.heartrails.com/130x130/cool?');	// キャプチャ画像作成サービス
	//define("index_CAPTURE_CREATE_SITE", 'http://img.simpleapi.net/small/');	// キャプチャ画像作成サービス

	// index livedoor天気ガジェット：表示有無
	define("GADGET_WEATHER_USE_index", "");			// 表示する場合: "YES"
	// index 天気ガジェット：都市プルダウン定義ファイル
	define("WEATHER_CITY_DEFINE_index", "../../_myhome_myset/__define_weather_city_my.php"); // ★ 実運用 (使う場合のみ)
	// index 天気ガジェット：リンク天気予報サイト
	define("LINK_WEATHER_SITE_index", "http://weathernews.jp/");

	// index チャット(Chat)表示
	define("CHAT_VIEW_FRAME_COLOR_index", "#87cefa");	// チャット(Chat)表示 枠カラー
	define("CHAT_READ_CHECK_INTERVAL_index", 2000);		// チャットAjax読取間隔 (ミリセカンド)
	define("CHAT_LOG_VIEW_CNT_MIN_index", 3);		// INDEXトップページ チャット表示 件数		(chat/read-min.php)
	define("CHAT_LOG_VIEW_INTERVAL_MIN_index", 30);		// INDEXトップページ チャット表示 経過時間 (分)	(chat/read-min.php)

	// index 掲示板スレッド表示
	define("BBS_VIEW_FRAME_COLOR_index", "#ff69b4");	// 掲示板スレッド表示 枠カラー
	define("BBS_VIEW_THREAD_index", 3);			// 掲示板スレッド表示 件数
	define("BBS_VIEW_INTERVAL_DAY_index", 7);		// 掲示板スレッド表示 表示日数 (n日以内の投稿があれば表示)

	// index ToDo
	define("TODO_VIEW_FRAME_COLOR_index", "#ff8c00");	// ToDo表示 枠カラー
	define("TODO_VIEW_CNT_MIN_index", 3);			// INDEXトップページ ToDo表示 件数	(todo/read-min.php)

	// calendar ToDo
	define("TODO_VIEW_FRAME_COLOR_calendar", "#ff8c00");	// カレンダーToDo表示 枠カラー
	define("TODO_VIEW_USE_calendar", "YES");		// カレンダーToDo表示 する場合:　"YES"

	// index スケジュール/カレンダー
	define("SCHEDULE_VIEW_FRAME_COLOR_index", "#228b22");	// スケジュール表示 枠カラー
	define("SCHEDULE_VIEW_DAY_index", 3);			// スケジュール表示 日数
	define("CALENDAR_VIEW_MONTH_index", 3);			// カレンダー表示 月数
	define("CALENDAR_VIEW_FIRST_index", -1);		// カレンダー表示 先頭月(-1:前月,0:今月)

	// index ブログパーツ：ディレクトリ
	define("BLOG_PARTS_FOLDER_index", "../../_blog-parts/");		// ★ 実運用 (ブログパーツファイル格納場所)
	// index ブログパーツ：HTMLファイル		// HTMLファイルはUTF-8でお願いします。

	define("BLOG_PARTS_SCRIPT_TOP1_index", "");				// 右カレンダーの上	// ★★★
	define("BLOG_PARTS_SCRIPT_TOP2_index", "");				// 右カレンダーの上	// ★★★
	//define("BLOG_PARTS_SCRIPT_BOTTOM1_index", "rss-google-news.inc");	// 右カレンダーの下	// ★★★
	//define("BLOG_PARTS_SCRIPT_BOTTOM2_index", "rss-ameba-news.inc");	// 右カレンダーの下	// ★★★
	define("BLOG_PARTS_SCRIPT_BOTTOM1_index", "");				// 右カレンダーの下	// ★★★
	define("BLOG_PARTS_SCRIPT_BOTTOM2_index", "");				// 右カレンダーの下	// ★★★

	//define("BLOG_PARTS_SCRIPT_RIGHT1_index", "clock-simple-blue.inc");	// 右カレンダーの右	// ★★★
	define("BLOG_PARTS_SCRIPT_RIGHT1_index", "myhome-clock.inc");		// 右カレンダーの右	// ★★★
	define("BLOG_PARTS_SCRIPT_RIGHT2_index", "weather-yahoo.inc");		// 右カレンダーの右	// ★★★
	define("BLOG_PARTS_SCRIPT_RIGHT3_index", "rss-tv.inc");			// 右カレンダーの右	// ★★★
	//define("BLOG_PARTS_SCRIPT_RIGHT4_index", "yahoo-ranking.inc");	// 右カレンダーの右	// ★★★

	//define("BLOG_PARTS_SCRIPT_RIGHT21_index", "");		// 右カレンダーの右2列目	// ★★★
	//define("BLOG_PARTS_SCRIPT_RIGHT22_index", "");		// 右カレンダーの右2列目	// ★★★
	//define("BLOG_PARTS_SCRIPT_RIGHT23_index", "");		// 右カレンダーの右2列目	// ★★★
	//define("BLOG_PARTS_SCRIPT_RIGHT24_index", "");		// 右カレンダーの右2列目	// ★★★

	define("OFTENUSE_URL_BGCOLOR_index","Mediumblue,Deepskyblue,Dodgerblue,Cornflowerblue,Royalblue,Mediumslateblue,Slateblue,Mediumpurple,Steelblue,Blueviolet,Darkviolet,Mediumorchid,Orchid,Crimson,Red,Orangered,Tomato,Coral,Lightsalmon,Darkorange,Orange,Gold,Chocolate,Peru,DarkGoldenrod,Goldenrod,Darkkhaki,Burlywood,Tan,Olive,Darkolivegreen,Olivedrab,Yellowgreen,Limegreen,Mediumseagreen,Forestgreen,Green,Darkgreen,Teal,Darkcyan,Cadetblue,Lightseagreen,Darkturquoise,Mediumturquoise,Turquoise,Magenta,Plum,Deeppink,Hotpink,Pink,Lightpink,LightCoral,Darkseagreen,Lightskyblue,Lightsteelblue,Skyblue,Darkslateblue,Navy,Silver,DarkSlategray,Slategray,Dimgray,Gray,Black");			// INDEX ピックアップ 背景色

	// index ブックマーク デフォルトディレクトリ
	define("LIST_URL_DEFAULT_FOLDER_index", "C:/Users/Public/Favorites");

	// proxy
	define("HTTP_PROXY_HOST", "");				// HTTP プロキシサーバ アドレス
	define("HTTP_PROXY_PORT", "");				// HTTP プロキシサーバ ポート

	// rss
	define("RSS_ARTICLE_VIEW_CNT_rss", 5);			// RSS 記事表示件数 (Ver.6.00からカテゴリ単位で設定のため無効)
	define("RSS_ARTICLE_TABLE_WIDTH_rss", 192);		// RSS 記事表示テーブル幅(px)
	define("RSS_ARTICLE_TABLE_WIDTH_POPUP_rss", 230);	// RSS ポップアップ記事表示テーブル幅(px)

	//define("RSS_SIMPLEXML_LOAD_USE", "YES");		// RSS simplexml_load_file()を使う場合: "YES"
	//define("SIMPLEXML_LOAD_CURL_USE", "YES");		// RSS simplexml_load_xxx()でcurlを使う場合: "YES"

	// MagpieRSS
	define("MAGPIE_OUTPUT_ENCODING", "UTF-8");
	define("MAGPIE_CACHE_DIR", "../../_rss_cache");		// MagpieRSS キャッシュ ディレクトリパス
								// /htdocs/_rss_cach
	define("MAGPIE_CACHE_AGE", 5*60);			// MagpieRSS キャッシュ 秒数
	define("MAGPIE_PROXY_HOST", HTTP_PROXY_HOST);		// MagpieRSS プロキシサーバ アドレス
	define("MAGPIE_PROXY_PORT", HTTP_PROXY_PORT);		// MagpieRSS プロキシサーバ ポート

	// メール(Email)
	define("EMAIL_LIST_VIEW_CNT_email", 10);		// Email index.php表示件数(最新より)
	define("EMAIL_LIST_READ_CNT_email", 50);		// Email リスト取得件数(最新より)
	define("EMAIL_LIST_TABLE_WIDTH_email", 288);		// Email index.php表示テーブル幅(px)
	define("EMAIL_MSG_WIDTH_email", 520);			// Email mail_msg.phpメール本文表示幅(px)

	// photo
	define("photo_DEFAULT_IMAGES_FOLDER", "D:/Temp");	// ★★★
	define("photo_SMALL_SIZE", 120);
	define("photo_MID_SIZE", 240);
	define("photo_BIG_SIZE", 360);
	define("photo_MAX_SIZE", 720);
	define("photo_UPDOWN_SIZE", 120);
	define("photo_LBOX_DIR_SIZE", 60);
	define("photo_LIST_DIR_SIZE", 60);
	define("photo_TILE_DIR_SIZE", 120);
	define("photo_DIR_POP_SIZE", 360);

	define("photo_CONVERT_SMALL_SIZE", 240);		// ImageMagickによる画像処理の画像サイズ(height)
	define("photo_CONVERT_MID_SIZE", 360);
	define("photo_CONVERT_BIG_SIZE", 480);
	define("photo_CONVERT_MAX_SIZE", 720);
	define("photo_CONVERT_UPDOWN_SIZE", 120);

	define("photo_LIMITED_IMAGES_FOLDER", "D:/デジカメ写真");	// アルバムの表示ディレクトリ制限	// ★★★
		// ↑これを指定すると、このディレクトリ以下以外には移動できない。
		// ↑パスのディレクトリ区切り文字は、\でなく必ず/を使ってください。
		// ↑これを指定するとカレンダー連携のアルバムフォルダは、このディレクトリからの相対アドレスとなります。
	define("photo_LIMITED_ADMIN_NOLIMIT", "YES");			// システム管理者のみ制限をはずす場合は、"YES"
		// ↑カレンダー連携のアルバムフォルダの相対アドレス化はそのまま。

	define("photo_IMAGE_MAX_SELECT", "5,10,20,50,100,200,1000");	// 頁内に表示する画像数
	define("photo_IMAGE_MAX_DEFAULT", "10");			// 頁内に表示する画像数（デフォルト）

	define("photo_SLIDE_MAIN_SIZE", 500);
	define("photo_SLIDE_SMALL_SIZE", 56);
	define("photo_SLIDE_SMALL_NUM", 10);
	define("photo_SLIDE_MAIN_BG_COLOR", "#202020");
	define("photo_SLIDE_SMALL_BG_COLOR", "#808080");

	define("photo_RESIZE_SIZE_SMALL", 1200);			// アルバム 縮小画像のサイズ ★
	define("photo_RESIZE_SIZE_THUMB", 160);				// アルバム スライド下のサムネイルサイズ ★
	define("photo_RESIZE_DIR_SMALL", "/___small___/");		// アルバム 縮小画像格納ディレクトリ
	define("photo_RESIZE_DIR_THUMB", "/___thumb___/");		// アルバム スライド下のサムネイル用格納ディレクトリ
	define("photo_DELETE_TRASH_DIR", "/___trash___/");		// アルバム 削除画像の格納ディレクトリ
	define("photo_IMG_CONVERT_DIR", "/___cnv___/");			// アルバム ImageMagickによる画像処理格納ディレクトリ

	define("photo_SLIDE_INTERVAL_TIME", 3);
	define("photo_SLIDE_MAIN_SIZE_SELECT", "100,200,300,400,500,600,800,1000,1200,1400,1600");

	define("photo_VIDEO_TIMELINE_THUMB_NUM", 5);		// 動画時間分割サムネイル表示個数
	define("photo_VIDEO_TIMELINE_THUMB_NUM_SELECT", "3,4,5,6,8,9,10,12,15,16,18,20,24,25,30,40,50,100");
	define("photo_VIDEO_TIMELINE_THUMB_SIZE", 160);		// 動画時間分割サムネイル表示サイズ
	define("photo_VIDEO_TIMELINE_THUMB_SIZE_SELECT", "80,120,160,200,240,320,400,480,640,800");

	define("photo_VIDEO_FFMPEG", "");	// 動画をサムネイル表示する場合:"YES"　★ffmpegがインストールされている事	// ★★★
	define("photo_JPEG_ROTATE", "");	// JPEG画像の回転機能を使う場合:"YES"　★★★ この機能は廃止しています。
	define("photo_JPEG_RESIZE", "");	// JPEG画像の縮小機能を使う場合:"YES"　★IrfanViewがインストールされている事	// ★★★
	define("photo_EXIF_AUTO_ROTATE", "");	// JPEG画像一括縮小の「EXIF縦位置元画像回転」機能を使う場合:"YES"	// ★★★
	define("photo_DELETE_FILE_USE", "");	// アルバムで、画像削除機能を使う場合:"YES"	// ★★★
	define("photo_IMAGEMAGIC", "");		// ImageMagickによる画像処理をする場合:"YES"　★ImageMagickがインストールされている事	// ★★★
	define("photo_IMAGEMAGIC_ALLUSER", "");	// ImageMagickによる画像処理をシステム管理者以外にも許可する場合:"YES"	// ★★★

	define("IS_VIDEO_EXT", "avi,flv,mpg,mov,swf,wmv,m2ts,mts,mp4");	// ↓同じ順序で対応するMIMEを定義
	define("IS_VIDEO_MIME","video/x-msvideo,video/x-flv,video/mpeg,video/quicktime,application/x-shockwave-flash,video/x-ms-wmv,video/avc,video/avc,video/mp4");
	define("IS_IMG_EXT", "jpeg,jpg,gif,png");

	define("photo_LOUPE_WIDTH", 600);		// スライドのルーペ(画像の部分拡大)サイズ
	define("photo_LOUPE_HEIGHT", 600);

	define("photo_SLIDE_FADEIN_USE", "YES");	// スライド全画面で画像のフェードインをする場合:"YES"
	define("photo_SLIDE_FADEIN_TIME", 800);		// スライド全画面フェードイン ミリ秒
	define("photo_SLIDE_AJAX_FADEOUT_TIME", 800);	// 全画面Ajax フェードアウト ミリ秒
	define("photo_SLIDE_AJAX_FADEIN_TIME", 800);	// 全画面Ajax フェードイン ミリ秒

	define("photo_JIGSAW_PUZZLE_CREATE", "YES");		//ジグソーパズル生成機能を使う場合: "YES"

	define("photo_VIDEO_PREVIEW", "YES");					//動画再生する場合: "YES"
	define("photo_VIDEO_PREVIEW_EXT", "flv,mp4,mp3,wmv,mpg,mov,m2ts,mts");	//動画再生対象
	//　★★★　mpg,mov,m2ts,mtsはffmpegでFLVに変換して再生します。この機能を使わない場合は、photo_VIDEO_PREVIEW_EXTから外してください。

	define("photo_SCREEN_AVAILHEIGHT_SETOFF", 200);	// サムネイル ポップアップ画像のサイズ screen.availHeightから減

	define("VIDEO_PREVIEW_WMV", "wmv");					//JW WMV Player使用
	define("VIDEO_PREVIEW_CONVERT", "mpg,mov,m2ts,mts");			//FLV変換して動画再生
	define("VIDEO_PREVIEW_CONVERT_FLV_DIR", "/___flv___/");			//FLV変換ファイル格納ディレクトリ
	define("FFMPEG_CONVERT_OPTION_MPG", "-vcodec flv");
	define("FFMPEG_CONVERT_OPTION_MOV", "-f flv -vcodec flv -r 25 -b 900 -s qvga -acodec libmp3lame -ar 44100 -ab 64k");
	//define("FFMPEG_CONVERT_OPTION_M2TS", "-ab 128 -r 29.97 -g 10 -ac 2 -ar 44100 -b 700k -s 720x480");
	define("FFMPEG_CONVERT_OPTION_M2TS", "-ar 44100 -b 700k -deinterlace");

	define("photo_FOLDER_IMAGE_VIEW", "");		// アルバムの「フォルダ画像表示」機能を使わない場合、"NO"

	define("photo_GALLERY_99_USE", "");		// ギャラリ99 Merging Image Boxes を使う場合 "YES"
	//define("photo_GALLERY_99_TEMP_DIR", "D:/xampp/htdocs/_myhome_myset/gallery5");
							// ギャラリ99 のテンポラリディレクトリ。\でなく必ず/を使ってください。
	define("MERGING_IMAGE_BOXES_SIZE_SELECT", "100,110,120,130,140,150,160,170,180,190,200,210,220,230,240,250");
							// ギャラリ99 Merging Image Boxes 画像1つのサイズ選択肢
	define("MERGING_IMAGE_BOXES_SIZE", 120);	// ギャラリ99 Merging Image Boxes 画像1つのサイズ初期値
	//define("MERGING_IMAGE_BOXES_BACKGROUND", "../../_myhome_myset/gallery5_background");
							// ギャラリ99 Merging Image Boxes 背景画像ディレクトリ
	// define("photo_FOLDER_MOVE_BY_KEYBOARD", "NO");	// アルバム標準画面でキーボード操作を使わない場合"NO"
	// define("photo_MODE_CHANGE_BY_KEYBOARD", "NO");	// アルバム標準画面でキーボード操作によるモード切替をしない場合"NO"

	// account
	define("LOGINLOG_MAXREC_account", 100);			// list-loginlog.phpレコード表示件数
	define("EDIT_PUBLIC_PAGE_account", "");			// 公開先メンバ修正ページ:""=全ユーザー一覧から選択式、"IDINP"=ID入力方式
	define("EDIT_FRIENDS_PAGE_account", "");		// My参照メンバ修正ページ:""=全ユーザー一覧から選択式、"IDINP"=ID入力方式
	define("NEWACCOUNT_CAPTCHASTR_USE_account", "YES");	// "YES":アカウント登録で、CAPTCHA(認証用絵文字コード)使用
	define("USER_SELF_NEW_ACCOUNT", "");			// ユーザー自身によるユーザー登録(newaccount.php)を使わない場合:"NO"
	// define("ACCOUNT_ID_NAME_MIN_LENGTH", 3);		// アカウント名の最小文字数
	// define("ACCOUNT_PASSWORD_MIN_LENGTH", 3);		// パスワードの最小文字数

	// Google Maps API バージョン　(カレンダー、旅行記のGoogle Mapsのバージョン)
	// V3指定の場合、Google Maps API キーが不要になり、localhost以外でのアクセスが利用可能になる。
	// V3指定の場合、Google Earth APIによる3D表示ができない。
	define("GOOGLE_MAPS_API_VERSION", "");			// "V3"

	// calendar スケジュール入力画面カラータグ挿入ボタン定義ファイル
	define("INPUT_COLOR_TAG_caledar", "__define_color_tag.php");

	// calendar スケジュール入力画面の日付入力補助ポップアップカレンダーの種類
	// デフォルトは、WEB上手(http://www.web-jozu.com/javascript/calen_input.html)の日付入力補助
	// ホームページの素(http://www.kanaya440.com/contents/js/calendar/)のものを使う場合: "kanaya"
	define("INPUT_POPUP_CALENDAR_calendar", "");		// Yahoo! UI Library: Calendar を使う場合: "YUI"

	// calendar
	define("NO_SUBJECT_INPUT_MARK_calendar", "☆");		// 件名がない場合のスケジュール修正画面リンクマーク
	define("CALENDAR_CATEGORYCOLOR_BACKGROUND", "");	// カテゴリ設定色をスケジュールの背景に使用しない場合:"NO"
	define("CALENDAR_SCHEDULE_PREFIX", "◆");		// 個々のスケジュールの頭に付ける文字。不要な場合:""
	define("CALENDAR_SCHEDULE_BORDER_STYLE", "border-top:1px dotted #b0b0b0;margin-top:-1px;");
								// 個々のスケジュールの枠のスタイル
	define("CALENDAR_SCHEDULE_TODAY_STYLE", "background-color:#d0fff0;border:#0080e0 2px solid;");
								// 月間カレンダーの今日の枠のスタイル
	define("CALENDAR_TODAY_SCROLL_ROW", 4);			// 月カレンダー:当日スクロールアップ行数指定(2以上指定可)

	define("CALENDAR_HANDLE_PRINT_BY", "");			// カレンダーで他人が書き込んだスケジュールに「by ハンドル名」表示しない場合："NO"
	define("CALENDAR_ALBUM_VIEW_FOLDER_NAME", "");		// カレンダーのアルバムモードでフォルダ名表示："YES"

	// calendar 天気出現率,気温
	define("DEFAULT_TODOFUKEN_ID", "08");			// 天気出現率のデフォルトの都道府県：東京都
	define("WEATHER_RATIO_LEVEL_1", 70);			// 天気出現率のマーク分岐点(%)
	define("WEATHER_RATIO_LEVEL_2", 55);			// 天気出現率のマーク分岐点(%)
	define("WEATHER_RATIO_LEVEL_3", 45);			// 天気出現率のマーク分岐点(%)
	define("WEATHER_TEMP_LEVEL_0", 30);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_1", 25);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_2", 20);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_3", 15);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_4", 10);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_5", 5);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_6", 0);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_7", -5);			// 気温分岐点
	define("WEATHER_TEMP_LEVEL_8", -10);			// 気温分岐点

	define("CALENDAR_TODAY_MINI_BACKGROUND_COLOR", "#00ced1");	// ミニカレンダー今日 背景色
	define("CALENDAR_TODAY_MINI_LINK_COLOR", "#ffffff");		// ミニカレンダー今日 文字色

	// define("FONT_ICON_STYLE_SHEET_FOLDER", '../style/font-awesome');		// Webアイコンフォント
	// define('FONT_ICON_CLASS_INCLUDE', '../__common__/__define_font-icon.php');	// Webアイコンフォント

	// 伝言
	define("_CALENDAR_SEND_MESSAGE_USE", "");		// 伝言機能を使わない場合: "NO"

	// bbs
	define("WYSIWYG_EDITOR_bbs", "openwysiwyg");
	//define("WYSIWYG_EDITOR_bbs", "YUI");

	define("VIEW_PHOTO_WIDTH_bbs", 400);
	define("VIDEO_PREVIEW_bbs", "YES");
	define("VIDEO_PREVIEW_EXT_bbs", "flv,mp4,mp3,wmv");
	define("VIDEO_PREVIEW_WIDTH_bbs", "400");
	define("VIDEO_PREVIEW_HEIGHT_bbs", "300");

	define("INPUT_DRAW_USE_bbs", "YES");			// 掲示板でお絵かきをする場合: "YES"
	define("INPUT_DRAW_WIDTH_bbs", "400");
	define("INPUT_DRAW_HEIGHT_bbs", "300");
	define("INPUT_DRAW_STROKE_STYLE_bbs", "3 1 rgb(32,32,32)");

	// memo (メモ)
	// define("MEMO_SUBJECT_USE", "NO");			// NO:メモの件名を使わない場合
	define("VIEW_PHOTO_WIDTH_memo", 200);
	define("VIDEO_PREVIEW_memo", "YES");
	define("VIDEO_PREVIEW_EXT_memo", "flv,mp4,mp3,wmv");
	define("VIDEO_PREVIEW_WIDTH_memo", "240");
	define("VIDEO_PREVIEW_HEIGHT_memo", "180");
	define("MEMO_LIST_SUBJECT_STYLE", "background-color:#d0d0ff;border-style:solid;border-color:#808080;border-width:1px 0 0 0;");	// 一覧リスト件名のスタイル

	// chat
	define("CHAT_READ_CHECK_INTERVAL_chat", 1000);			// チャットAjax読取間隔 (ミリセカンド)
	define("CHAT_LOG_VIEW_CNT_SELECT_chat", "5,10,20,50,100");	// チャット表示件数 選択肢
	define("CHAT_LOG_VIEW_CNT_SELECT_INIT_chat", "10");		// ↑ 初期値
	define("CHAT_LOG_VIEW_INTERVAL_SELECT_chat", "1:1時間,2:2時間,6:6時間,12:12時間,24:1日,168:1週間,720:30日,0:制限なし");
									// チャット表示経過時間 選択肢
	define("CHAT_LOG_VIEW_INTERVAL_SELECT_INIT_chat", "1");		// ↑ 初期値

	// study (学習)
	define("study_MASTER_EDIT_ADMIN_ONLY", "YES");			// 学習の問題集の編集をシステム管理者のみにする場合: "YES"
	define("study_INDEX_MENU_COLUMN_BREAK", 5);			// カテゴリの数がこれを超えたらindexページの表示を2列にする

	// abook (住所録)	★★★　百名山,世界遺産,.....それぞれデータを登録しない場合、-1を設定してください。
	define("HYAKUMEIZAN_CATEGORY_ID", 3);				//百名山のid_category(in m_category)
	define("SEKAI_ISAN_CATEGORY_ID", 4);				//世界遺産のid_category(in m_category)
	define("TETSUDO_EKI_CATEGORY_ID", 5);				//鉄道駅のid_category(in m_category)
	define("SAKURA_MEISHO_CATEGORY_ID", 6);				//桜名所のid_category(in m_category)
	define("HYAKUSEN_CATEGORY_ID", 7);				//日本百選のid_category(in m_category)

	define("CHECK_ITEM_NUMBER", 6);					//住所録チェック項目の数(事前にDBの列を追加する必要あり)

	// diary (旅行記)
	define("GOOGLE_MAPS_API_VERSION", "");				// "V3": Google Maps JavaScript API バージョン
	define("DIARY_MAPS_FRAME_WIDTH", "700px");
	define("DIARY_MAPS_FRAME_HEIGHT", "300px");
	define("DIARY_MAPS_FRAME_HEIGHT_SELECT", "300px,350px,400px,450px,500px,550px,600px,650px,700px,750px,800px");
	define("VIEW_PHOTO_WIDTH_diary", 200);
	define("VIDEO_PREVIEW_diary", "YES");
	define("VIDEO_PREVIEW_EXT_diary", "flv,mp4,mp3,wmv");
	define("VIDEO_PREVIEW_WIDTH_diary", "200");
	define("VIDEO_PREVIEW_HEIGHT_diary", "150");
	define("CALENDAR_FILTER_TITLE_diary", "旅行記");
	define("PRICE_UNIT_SELECT", "円,ドル,ユーロ");					// 通貨種類
	define("DIARY_RATING_CAPTION", "総合評価,コスト,施設,雰囲気,料理,風呂");	// 最大9個

	// sticky (付箋)
	define("sticky_BOARD_WIDTH", "980px");
	define("sticky_BOARD_HEIGHT", "500px");
	define("sticky_IE6_IFRAME_HEIGHT", "560px");

	// id-manager
	define("ID_MANAGER_ITEM_NUMBER", 6);		// ID管理の項目最大数。増やす場合は、Ver.4.21の修正履歴を参照してください。
	define("POP_WIN1_LEFT_id_manager", 10);
	define("POP_WIN1_TOP_id_manager", 10);
	define("POP_WIN1_WIDTH_id_manager", 500);
	define("POP_WIN1_HEIGHT_id_manager", 130);
	define("POP_WIN2_LEFT_id_manager", 100);
	define("POP_WIN2_TOP_id_manager", 160);
	define("POP_WIN2_WIDTH_id_manager", 900);
	define("POP_WIN2_HEIGHT_id_manager", 560);

	// tools
//	define("CODE_FILE_VIEW_EDIT_DEFAULT_FOLDER_tools", "D:/xampp/htdocs");	// デフォルトは$_SERVER['DOCUMENT_ROOT']を使用
	define("CODE_FILE_VIEW_EDIT_TEXTAREA_HEIGHT_tools", "520px");
	define("ATTACH_FILE_FOLDER_excel_graph", "../../_attach/excel-graph/");	// 日本語名は不可	// ★★★
	define("GRAPH_WIDTH_excel_graph", 350);

	// tools: HTML URL抽出&ファイルダウンロード対象ファイル
	define("GET_URL_FILE_TYPE_SELECTS_tools", "jpeg,jpg,gif,png,wmv,flv,avi,mpg,mp4,mov,m2ts,mts,swf,zip,lzh");

	// tools: Google Maps & Earth
	define("GOOGLE_API_KEY", "ABQIAAAA1XbMiDxx_BTCY2_FkPh06RRaGTYH6UMl8mADNa0YKuWNNa8VNxQEerTAUcfkyrr6OwBovxn7TDAH5Q");
	define("GOOGLE_MAPS_EARTH_ADDRESS", "新宿");
	define("GOOGLE_MAPS_EARTH_ZOOM", 15);

	// tools: Google Maps & Earth & カレンダーマップ 緯度経度取得の1地点あたりの遅延時間
	define("GETLATLNG_SLEEP_TIME", 200000);	// 0.2秒

	// tools: MeCab：漢字読み変換を使う場合、MeCabのインストールパスを設定してください。
	// 例：define("MECAB_EXE_PATH", "C:\Program Files\MeCab\bin\mecab.exe");

	// db_tool
	define("_DEFINE_mysql_ADMIN", "../../_myhome_myset/__define_mysql_admin.php");
	define("EXCEL_IMPORT_FOLDER_db_tool", "../../_attach/excel-import/");	// 日本語名は不可	// ★★★
	define("CSV_IMPORT_FOLDER_db_tool", "../../_attach/csv-import/");	// 日本語名は不可	// ★★★

	define("FILE_UPLOAD_MEMORY_LIMIT", "32M");		// ファイルアップロード メモリサイズ
	define("FILE_UPLOAD_MAX_EXECUTION_TIME", "60");		// ファイルアップロード 最大実行時間

	define("MEMORY_LIMIT_INI_SET", "128M");			// Excel/CSV インポート メモリサイズ
	define("MAX_EXECUTION_TIME_INI_SET", "240");		// Excel/CSV インポート 最大実行時間

	// 実運用環境バックアップ
	// バックアップ先ディレクトリ BACKUP_MYDB_DIR_REALのコメントアウトを外して、利用願います。	// ★★★
	//define("BACKUP_MYDB_DIR_REAL", "D:/_myhome_backup");	// ←優先 (物理パス) /xampp/htdocsの下以外を指定してください
	define("BACKUP_MYDB_DIR", "/_myhome_backup");		// ←セキュリティ上、問題あり (/xampp/htdocsの下)

	define("BACKUP_TEMP_DIR", "temp");
	define("BACKUP_ZIP_FOLDER_NAME", "_myhome_backup");
	define("BACKUP_ZIP_COMMON_MY", "__define_common_my.zip");
	define("BACKUP_ZIP_MYDB_A", "_mydb_backup_a.zip");
	define("BACKUP_ZIP_MYDB_B", "_mydb_backup_b.zip");

	define("_NEWACOUNT_KIYAKU_account", "ハンドル名とコメントは公開されます。
本システム利用による何らかの不利益に一切の責任を負いません。");

	// メインコンテンツ定義ファイル
	define("_MY_DEFINE_CONTENTS_FILE", "../../_myhome_myset/__define_contents_my.php");

	// OSのファイルシステムの文字エンコーディング：Windows="SJIS-win"
	define("_SYSTEM_FILE_ENCODING", "SJIS-win");

	// エラーログ出力先。(IrfanViewエラー)	// 環境に合わせてパスを修正して、コメントアウトを外してください。★★★
	// パスのディレクトリ区切り文字は、\でなく必ず/を使ってください。
	//define("ERROR_LOG_DIR", "D:/xampp/htdocs/_myhome_myset/log");
	define("PHOTO_ERROR_LOG_FILE", "photo.log");

	// favicon アイコンファイル
	define("FAVICON_ICON", "../images/favicon/house_red.ico");

	define("kakeibo_PAGE_HEADER", "");		// "YES"：(ツール)預貯金管理を、メインコンテンツにする場合。
							// __define_contents_my.phpに次の行の追加も必要。
							//	$navi_item[] = array("href"=>"kakeibo/", "query"=>"", "name"=>"預貯金");
	define("gpslog_PAGE_HEADER", "");		// "YES"：(ツール)GPSログを、メインコンテンツにする場合。
							// __define_contents_my.phpに次の行の追加も必要。
							//	$navi_item[] = array("href"=>"gpslog/", "query"=>"", "name"=>"GPSログ");
	define("psketch_PAGE_HEADER", "");		// "YES"：(ツール)physicSketchを、メインコンテンツにする場合。
							// __define_contents_my.phpに次の行の追加も必要。
							//	$navi_item[] = array("href"=>"psketch/", "query"=>"", "name"=>"pSketch");

	define("DB_TOOL_ID_PASSWORD_USE", "");		// "YES"：(ツール)MySQL管理ツール利用に、ID管理ログイン認証を要求。
							// 「ユーザー一覧」の「一括修正/追加/削除」「一括追加」も同様。
							// 「PHPサーバー変数($_SERVER)一覧」も同様。

	define("FILE_MANAGER_ID_PASSWORD_USE", "");	// "YES"：(ツール)ファイルマネージャ利用に、ID管理ログイン認証を要求。
							// 「PHP/JavaScript ソースコード表示&編集＋ファイルマネージャー」も同様。

	define("EDIT_MYPROFILE_LOGIN_PASS_EXPIRE", (60 * 3));	// アカウント情報修正 パスワード保存時間 (3分)

	// 一覧検索で、全角/半角、カタカナ/ひらがなを同一視しない場合。MP_LIST_SELECT_COLLATEを、""にしてください。
	// define("MP_LIST_SELECT_COLLATE", "");

	define("MB_CONVERT_ENCODING_AUTO", "ASCII,JIS,UTF-8,EUC-JP,SJIS-win,SJIS");	// mb_convert_encoding()

	// ツール「はてなキーワード自動リンク & Yahoo!キーフレーズ → Weblio」で、Yahoo!キーフレーズを使う場合、
	// Yahoo! JAPANで、アプリケーションIDを取得し、以下に入れてください。
	// http://e.developer.yahoo.co.jp/webservices/register_application
	define("YAHOO_JAPAN_APPLICATION_ID_KEYPHRASE", "");
?>
