<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	require("../__common__/include-common-mp-list.php");
	require("../calendar/_my_calendar.php");

	$table_name_view = "v_schedule";
	$table_name = "m_schedule";
	$id_item = "id_schedule";
	$must_item = "c_subject";
	$arg_pool_prefix = "calendar_schedule";

	$mp_list_arg = array();
	$mp_list_arg['account_id']	= $_SESSION['current_id'];
	$mp_list_arg['table_name_view']		= "v_schedule";
	$mp_list_arg['table_name_edit']		= "v_schedule";
	$mp_list_arg['table_name_update']	= "m_schedule";
	$mp_list_arg['id_item']		= "id_schedule";
	$mp_list_arg['must_item']	= "c_subject";
	$mp_list_arg['add_filter']	= "../calendar/list-my-add-filter.php";
	$mp_list_arg['template_view']	= "list-my-template.php";
	$mp_list_arg['input_new']	= "yes";
	$mp_list_arg['use_privacy']	= "no";
	$mp_list_arg['add_list']	= "yes";

	$mp_list_arg['sql_for_view'] = "SELECT v_schedule.*, T1.c_place, T1.c_markertype";
	$mp_list_arg['sql_for_view'] .= " FROM v_schedule";
	$mp_list_arg['sql_for_view'] .= " LEFT OUTER JOIN ( select id_schedule, c_place, c_markertype from v_marker WHERE v_marker.id_markertype = 60 ) as T1";
	$mp_list_arg['sql_for_view'] .= " ON v_schedule.id_schedule = T1.id_schedule";
	$mp_list_arg['sql_for_view'] .= " where v_schedule.id_account = '".$_SESSION['current_id']."'";

	$mp_list_arg['sql_for_edit'] = $mp_list_arg['sql_for_view'];

	$item_tbl = array();
	$item_tbl[] = array(	"表示名"=>"カテゴリ",	"列名"=>"id_category", "http_arg_GET名"=>"cat",
				"type"=>"select", "参照テーブル"=>"m_category", "参照テーブル表示列"=>"c_categoryName",
				"参照テーブル表示順"=>"c_categoryDisplayOrder", "参照テーブル表示色"=>"c_categoryDisplayColor");
	$item_tbl[] = array(	"表示名"=>"日付",	"列名"=>"c_date",
				"type"=>"date", "firstYear"=>_CALENDAR_SELECT_FIRST_YEAR, "toYear"=>10, "ime-mode"=>"disabled",
				"date_http_arg_y"=>"selY", "date_http_arg_m"=>"selM", "date_http_arg_d"=>"selD");
	$item_tbl[] = array(	"表示名"=>"タイトル<br>国",	"列名"=>"c_subject",
				"type"=>"text", "size"=>60, "ime-mode"=>"active", "文字検索"=>"Y", "break"=>"後");
	$item_tbl[] = array(	"表示名"=>"国",	"列名"=>"c_country",
				"type"=>"text", "size"=>20, "ime-mode"=>"active", "文字検索"=>"Y", "break"=>"前");
	$item_tbl[] = array(	"表示名"=>"通貨<br>為替レート", "列名"=>"c_currencyUnit",
				"type"=>"select", "filter_type"=>"no", "select_options"=>PRICE_UNIT_SELECT, "break"=>"後");
	$item_tbl[] = array(	"表示名"=>"為替レート",	"列名"=>"c_exchangeRate", "zero"=>"space",
				"type"=>"text", "size"=>11, "ime-mode"=>"disabled", "break"=>"前");
	$item_tbl[] = array(	"表示名"=>"場所",	"列名"=>"T1.c_place", "type"=>"no_edit_no_col", "文字検索"=>"Y");
	$item_tbl[] = array(	"表示名"=>"概要",	"列名"=>"c_memo",
				"type"=>"textarea", "cols"=>60, "rows"=>3, "文字検索"=>"Y");
	$order_tbl = array();
	$order_tbl[] = array(   "表示名"=>"登録最新順", "get_order_name"=>"new",
				"order_by"=>"id_schedule desc");		/* default */
	$order_tbl[] = array(   "表示名"=>"日付順(昇順)", "get_order_name"=>"date_a",
				"order_by"=>"c_date");
	$order_tbl[] = array(   "表示名"=>"日付順(降順)", "get_order_name"=>"date_d",
				"order_by"=>"c_date desc");
	$http_arg = array();
	$http_arg['pl'] = PAGE_LINE_DEFAULT;		// mp_list 必須
	$http_arg['sort'] = '';				// mp_list 必須
	$http_arg['cat'] = '';				// mp_list 必須
	$http_arg['key'] = '';				// mp_list 必須
	$http_arg['type'] = '';
	$http_arg['selY'] = '';
	$http_arg['selM'] = '';
	$http_arg['selD'] = '';
	$http_arg['toY'] = '';
	$http_arg['toM'] = '';
	$http_arg['toD'] = '';
	$http_arg['y'] = '';
	$http_arg['m'] = '';

	if (isset($_POST['登録'])) {
		check_post_account($_POST['login_id'], $_POST['current_id']);
		mp_list_update($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
	} else {
		_GET_to_http_arg_pool($http_arg, $arg_pool_prefix, 'selY,selM,selD,toY,toM,toD,sort,key,pl,y,m');
		html_header(HTML_TITLE);
		page_header();
		contents_header();
		if ($_GET['edit'] == "a") {
			$mp_list_arg['sql_for_edit'] = "select * from v_schedule where id_schedule = 0";
			mp_list_edit($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
		} elseif ($_GET['edit'] == "y") {
			mp_list_edit($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
		} else {
?>
			<table><tr><td>
<?php
			$_SESSION['diary_back_view'] = $_SERVER['SCRIPT_NAME'].'?'.$_SERVER['QUERY_STRING'];
			$_SESSION['diary_back_view_name'] = '一覧に戻る';
			$_SESSION['diary_list_sql'] = mp_list_view($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
?>
			</td><td>
<?php
			side_calendar($http_arg);
?>
			</td></tr></table>
<?php
		}
		page_footer();
		html_footer();
	}
	exit();
?>
<?php
function side_calendar($http_arg) {
	if ($http_arg['selM'] <> '') {
		if ($http_arg['selY'] <> '') {
			$year = $http_arg['selY'];
		} else {
			$year = date("Y");
		}
		$month = $http_arg['selM'];
	} elseif ($http_arg['selY'] <> '') {
		$year = $http_arg['selY'];
		$month = 2;
	} else {
		$year = date("Y");
		$month = date("n");
	}
	$con = my_mysqli_connect(_DB_SCHEMA);
	define("CALENDAR_DIARY_MODE", "diary");
	if ($http_arg['selY'] <> '' and $http_arg['selM'] == '') {
		side_calendar_year($http_arg, $year);
	} else {
		side_calendar_3month($http_arg, $year, $month);
	}
	mysqli_close($con);
}
function side_calendar_year($http_arg, $year) {
?>
	<table id="side_calendar">
	<?php
		$m_ary = array(1,5,9,2,6,10,3,7,11,4,8,12);
		foreach ($m_ary as $month) {
			if ($month >= 9) {
				$style = 'padding: 5px 6px 5px 4px;';
			} else {
				$style = 'padding: 5px 6px 5px 4px; border-right: 2px solid #e0e0e0;';
			}
			if ($month==2 || $month==3 || $month==4) {
	?>
		</tr>
		<tr>
	<?php
			}
	?>
			<td class="year_calendar_frame_month" style="<?= $style ?>">
	<?php
			calendar_month($year, $month, $_SESSION['current_id'], $http_arg['cat'], $http_arg['key'], "calendar_tbl_mini");
	?>
			</td>
	<?php
		}
	?>
	</table>
<?php
}
function side_calendar_3month($http_arg, $year, $month) {
?>
<style>
.calendar_tbl_mini {
	width: 150px;
}
</style>
	<table id="side_calendar">
	<?php
		if ($month == 1) {
			$year = $year - 1;
			$month = 12;
		} else {
			$month = $month - 1;
		}
		for ($ix=1; $ix<=3; $ix++) {
	?>
			<tr><td class="year_calendar_frame_month">
	<?php
			define("CALENDAR_DIARY_MODE", "diary");
			calendar_month($year, $month, $_SESSION['current_id'], $http_arg['cat'], $http_arg['key'], "calendar_tbl_mini");
			if ($month == 12) {
				$year++;
				$month = 1;
			} else {
				$month++;
			}
	?>
			</td></tr>
	<?php
		}
	?>
	</table>
<?php
}
?>
