<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if (!defined('TIMER_ALARM_MAXNUM')) {
		define('TIMER_ALARM_MAXNUM', 10);
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<meta name="description" content="Alarm">
<meta name="keywords" content="alarm,timer">
<style>
body {
	font-family: "MS PGothic",Osaka,Arial,sans-serif;
	font-size: 12px;
	background: #f0f0f0;
}
table#list {
	 margin-left: 10px;
}
input[type="number"] {
	padding-right: 3px;
	text-align: right;
	width: 35px;
}
#icon {
	border: 0;
	height: 14px;
	margin: 0 5px;
	vertical-align: middle;
}
a.return_index { font-size: 12px; text-decoration: none; font-weight: normal; }
a.return_index:link { color: #808080; }
a.return_index:visited { color: #808080; }
a.return_index:hover { color: #ffc080; }
a.return_index:active { color: #ffc080; }
</style>
<script src="../scripts/jquery.js"></script>
<title>タイマーアラート設定</title>
</head>
<body>
<div><div>
<form id="alarm_form" method="POST" action="alarm-update.php">
<p><a href="javascript:window.close()"><img id="icon" src="../icon/alarm-clock.png"></a>タイマーアラート設定</p>
<p style="margin-left:10px;color:#666;">日や曜日を設定すると、毎月または毎週、その時間になるとアラートが表示されます。<br>日や曜日を設定しない場合、毎日その時間になるとアラートが表示されます。</p>
<table id="list">
<?php
	$con = my_mysqli_connect(_DB_SCHEMA);
	for ($ix=1; $ix<=TIMER_ALARM_MAXNUM; $ix++) {
		$sql = "select * from m_alarm where id_account = ".$_SESSION['login_id']." and id_num = ".$ix;
		$rs = my_mysqli_query($sql);
		if (mysqli_num_rows($rs) > 0) {
			$rec = mysqli_fetch_array($rs);
			$hour = $rec['c_hour'];
			$min = $rec['c_min'];
			$day = $rec['c_day'];
			$week = $rec['c_week'];
			$message = my_htmlspecialchars($rec['c_message']);
			$valid = $rec['c_valid'];
		} else {
			$hour = 0;
			$min = 0;
			$day = 0;
			$week = -1;
			$message = '';
			$valid = '';
		}
		input_form($ix, $hour, $min, $day, $week, $message, $valid);
	}
?>
</table>
<input type="submit" value="セット">
</form>
<br><br>
<?php
	page_footer();
	html_footer();
?>
<?php
function input_form($num, $hour, $min, $day, $week, $message, $valid) {
	if ($valid == 'on') {
		$color = '#FFEB96';
	} else {
		$color = '#fff';
	}
?>
<tr><td style="background:<?= $color ?>">
<label><input type="checkbox" id="valid<?= $num ?>" name="valid<?= $num ?>" value="on"<? if ($valid == 'on') echo ' checked'; ?>>ＯＮ</label>
<span style="margin-left:5px;">日：</span><?php
	select_opt('day'.$num, $day, 1, 31, '0');
?>
<span style="margin-left:5px;">曜日：</span><?php
	select_week('week'.$num, $week);
?>
<span style="margin-left:5px;">時間：</span><?php
	select_opt('hour'.$num, $hour, 0, 23, -99);
	echo '：';
	select_opt('min'.$num, $min, 0, 59, -99);
?>
<span style="margin-left:5px;">メッセージ：<input type="text" id="message<?= $num ?>" name="message<?= $num ?>" value="<?= $message ?>" style="width:300px;"></span>&nbsp;
</td></tr>
<?php
}
function select_opt($name, $now, $first, $end, $def) {
	if (strstr($_SERVER['HTTP_USER_AGENT'], "Chrome")) {
		if ($def <> -99 and $now == 0) {
			$now = '';
		}
?><input type="number" id="<?= $name ?>" name="<?= $name ?>" value="<?= $now ?>" min="<?= $first ?>" max="<?= $end ?>"><?php	} else {
		echo "<select id='".$name."' name='".$name."'>";
		if ($def <> -99) {
			echo "<option value='".$def."'>";
		}
		for ($sel=$first; $sel<=$end; $sel++) {
			echo "<option value='".$sel."'";
			if ($sel == $now) {
				echo " selected";
			}
			echo ">".right('0'.$sel,2)."</option>";
		}
		echo "</select>";
	}
}
function select_week($name, $now) {
	$week = array('日', '月', '火', '水', '木', '金', '土');
	echo "<select id='".$name."' name='".$name."'>";
	echo "<option value='-1'>";
	for ($sel=0; $sel<=6; $sel++) {
		echo "<option value='".$sel."'";
		if ($sel == $now) {
			echo " selected";
		}
		echo ">".$week[$sel]."</option>";
	}
	echo "</select>";
}
?>
