<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>花火</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="author" content="Scott Schiller" />
<meta name="language" content="en-us" />
<meta name="keywords" content="Fireworks.js DHTML animated fireworks effect free animation script" />
<meta name="description" content="Project page for Fireworks, a fun and downloadable javascript-driven animated fireworks experiment." />
<link rel="stylesheet" href="style/fireworks.css" media="screen" />
<link rel="stylesheet" href="demo-only/demo.css" media="screen" />
<script src="demo-only/demo.js"></script>
<!--script src="script/debug.js"></script-->
<script src="script/soundmanager.js"></script>
<script src="script/fireworks.js"></script>
</head>
<body>
<!-- 

 Fireworks elements (cloned and animated via script):
 
 #sound
 #fireworks-template
 #fireContainer

 #sound is optional and can be omitted (as can the related .js.)

-->
<div id="sound">
</div>

<div id="fireworks-template">
 <div id="fw" class="firework"></div>
 <div id="fp" class="fireworkParticle"><img src="image/particles.gif" alt="" /></div>
</div>

<div id="fireContainer"></div>

<!-- demo page stuff -->

<div id="site">

 <div id="content">

 <h2>花火 by Fireworks.js</h2>
<!--
 <h4>Fireworks Parameters</h4>
-->
 <div id="controls">

  <div class="checkbox">
   <div>
    <input id="disabled-0" type="checkbox" checked="checked" title="When not applied, random values will be chosen." value="Apply" /> Apply
   </div>
  </div>

  <div class="checkbox">
   <div>
    <input id="disabled-1" type="checkbox" title="When not applied, random values will be chosen." value="Apply" /> Apply
   </div>
  </div>

  <div class="clear"></div>

  <dl class="col">

   <dt>Blast Radius</dt>
   <dd class="title">% of window size</dd>
   <dd>1-100</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Size of the explosion"></div>
   </dd>

   <dt>Particles</dt>
   <dd class="title">Explosion elements</dd>
   <dd>1-200</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Number of elements - more means slower"></div>
   </dd>

   <dt>Circles</dt>
   <dd class="title">..per explosion</dd>
   <dd>1-8</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Number of concentric circles"></div>
   </dd>

   <dt>Burst Type</dt>
   <dd class="title">(Base colour)</dd>
   <dd>1-7</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Primary (inner circle) colour"></div>
   </dd>

  </dl>

  <dl class="col disabled">

   <dt>Start X</dt>
   <dd class="title">% of window</dd>
   <dd>1-100</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Originating X axis"></div>
   </dd>

   <dt>Start Y</dt>
   <dd class="title">% of window</dd>
   <dd>1-100</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Originating Y axis"></div>
   </dd>

   <dt>Explode X</dt>
   <dd class="title">% of window</dd>
   <dd>1-100</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Detonation X axis"></div>
   </dd>

   <dt>Explode Y</dt>
   <dd class="title">% of window</dd>
   <dd>1-100</dd>
   <dd class="control">
    <div class="bar" title="Click to move here"></div>
    <div class="slider" title="Detonation Y axis"></div>
   </dd>

  </dl>

  <div id="options">

   <h4>Additional Options</h4>

   <p class="compact">
    <input type="button" onclick="fc.controller.randomize()" value="Randomize controls" title="Assign random control values" />
   </p>

   <dl>

    <dt><input id="opt-random0" type="checkbox" title="Allow fireworks to have non-linear explosions" value="Randomize explosion pattern" onclick="fc.controller.updateExample()" /></dt>
    <dd>Randomize explosion pattern</dd>

    <dt><input id="opt-random1" type="checkbox" title="Control whether fireworks bounce off browser window" value="Obey window boundaries" onclick="fc.controller.updateExample()" /></dt>
    <dd>Obey window boundaries</dd>

   </dl>

  </div>

 </div>

 <div class="clear"></div>

 <div id="fireButton">
  <div id="fireIE"></div>
  <a href="#" onclick="fc.controller.createCustomFirework();this.blur();return false" class="content">Fire!</a>
 </div>

 <p class="compact showAlways">
  <input id="hideStuff" type="checkbox" title="Hiding elements can improve the animation framerate under browsers such as Opera" onclick="document.getElementById('site').className=(this.checked?'hideStuff':'')" value="hide stuff" /> Hide content (may increase performance)
 </p>


 <code style="display:none;">
  createFirework(<span id="function-example">nRadius,nParticles,nCircles,burstType,startX,startY,burstX,burstY)</span>);
 </code>


 <h3>Demo Presets</h3>

 <ul>

  <li><a href="#" onclick="createFirework(100,100,1,null,50,100,50,50,false,true);return false" title="I swear it looks like the Apple key, really!">Apple Key-esque</a></li>
  <li><a href="#" onclick="createFirework(11,30,3,4,null,null,null,null,false,true);return false" title="Standard-issue.">Standard Circle</a></li>
  <li><a href="#" onclick="createFirework(25,187,5,1,null,null,null,null,false,true);return false" title="The usual, a bit more filled-out.">Concentric Circles</a></li>
  <li><a href="#" onclick="createFirework(66,139,4,5,1,1,97,96,true,true);return false" title="Nowhere else to go but up and out.">Cornered</a></li>
  <li><a href="#" onclick="createFirework(38,128,2,null,49,2,50,100,false,true);return false" title="Particles bounce from the bottom.">Semicircle</a></li>
  <li><a href="#" onclick="createFirework(100,800,8,5,1,100,50,50,false,false);return false" title="Give this one time to start..">CPU-heavy</a></li>
  <li><a href="#" onclick="var r=4+parseInt(Math.random()*16);for(var i=r; i--;){setTimeout('createFirework(8,14,2,null,null,null,null,null,Math.random()>0.5,true)',(i+1)*(1+parseInt(Math.random()*1000)));}return false" title="A number of randomly-timed explosions.">Sequence: Explosions</a></li>

 </ul>
 
 </div>

<div id="footer"></div>

</div>

<script>
if (typeof(soundManagerInit)!='undefined') soundManagerInit();
</script>

</body>
</html>