<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	if (isset($_POST['reset'])) {
		$global_url = '';		// $global_url: global for html_src_2_http(), html_href_2_http()
	} elseif ($_POST['url'].'' <> '') {
		$global_url = $_POST['url'];
	} else {
		$global_url = $_GET['url'];
	}
	if (isset($_GET['reset'])) {
		$global_url = '';
	}
	if (!defined('HTML_MY_CSS_STYLE_SHEET')) {
		define('HTML_MY_CSS_STYLE_SHEET', '../style/tools/html-my-css.css');
	}
	if ($global_url <> '') {
		if (left($global_url,7) <> 'http://') {
			$err = 'http://以外は取得できません。';
		}
		if ($html = my_file_get_contents($global_url)) {
			$html = mb_convert_encoding($html, 'UTF-8', MB_CONVERT_ENCODING_AUTO);
			$html = strip_span_str($html, '<!--', '-->');
			$title = trim(get_intag($html, '<title>', '</title>', $pos=0));
		} else {
			$err = '取得できませんでした。';
		}
	}
	if ($title.'' <> '') {
		$html_title = $title;
	} else {
		$html_title = 'MyCSS';
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<link rel="shortcut icon" href="../images/favicon/house_red.ico" type="image/ico">
<link rel="stylesheet" href="<?= HTML_MY_CSS_STYLE_SHEET ?>">
<title><?= $html_title ?></title>
<style>
body {
	background: #f8f8f8;
	margin: 10px;
	padding: 0px;
}
div#my_css_head * {
	font-family: "MS PGothic","Osaka",Arial,sans-serif;
	font-size: 12px;
}
form, p {
	margin:0;padding:0;
}
input.text {
	padding: 2px 1px 3px 1px\9;	/* IE */
}
div#my_css_view {
	margin: 5px;
	padding 10px;
}
</style>
<style>
<?php if ($_COOKIE['html_my_css_img'].'' <> 'on') { ?>
img { display: none; }
<?php } ?>
<?php if ($_COOKIE['html_my_css_video'].'' <> 'on') { ?>
video { display: none; }
<?php } ?>
<?php if ($_COOKIE['html_my_css_object'].'' <> 'on') { ?>
object { display: none; }
<?php } ?>
<?php if ($_COOKIE['html_my_css_embed'].'' <> 'on') { ?>
embed { display: none; }
<?php } ?>
<?php if ($_COOKIE['html_my_css_iframe'].'' <> 'on') { ?>
iframe { display: none; }
<?php } ?>
</style>
<script src="../scripts/jquery.js"></script>
<script src="../scripts/jquery.cookie.js"></script>
<script src="../scripts/ok2nd.js"></script>
<script>
function display_onOff(me, tag) {
	chgCookieCheckOnOff(me, 'html_my_css_' + tag);
	if (me.checked) {
		$(tag).show();
	} else {
		$(tag).hide();
	}
}
</script>
</head>
<body>
<div id="my_css_head">
<p><a href="../tools/" style="color:#e0e0e0;text-decoration:none;">■</a>
<span style="font-size:14px;font-weight:bold;">HTML テキストを自分のCSSで読む</span></p>
<form method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>" style="margin-left:5px;">
URL：<input class="text" type="text" name="url" value="<?= $global_url ?>" size=80>
<input type="submit" name="gethtml" value="読み込み">
<input type="submit" name="reset" value="リセット"><br>
<label><input type="checkbox" value="on" onClick="display_onOff(this, 'img')"<?= $_COOKIE['html_my_css_img'] == 'on' ? ' checked' : '' ?>>&lt;img&gt;有</label>
<label><input type="checkbox" value="on" onClick="display_onOff(this, 'video')"<?= $_COOKIE['html_my_css_video'] == 'on' ? ' checked' : '' ?>>&lt;video&gt;有</label>
<label><input type="checkbox" value="on" onClick="display_onOff(this, 'object')"<?= $_COOKIE['html_my_css_object'] == 'on' ? ' checked' : '' ?>>&lt;object&gt;有</label>
<label><input type="checkbox" value="on" onClick="display_onOff(this, 'embed')"<?= $_COOKIE['html_my_css_embed'] == 'on' ? ' checked' : '' ?>>&lt;embed&gt;有</label>
<label><input type="checkbox" value="on" onClick="display_onOff(this, 'iframe')"<?= $_COOKIE['html_my_css_iframe'] == 'on' ? ' checked' : '' ?>>&lt;iframe&gt;有</label>
</form>
</div>
<?php
	if ($err.'' <> '') {
		echo '<p style="margin:20px;color:red;font-size:12px;">'.$err.'</p>';
	} else {
		view_html($global_url, $html, $title);
	}
?>
<div style="font-size: 12px;">
<p style="margin-top:10px; width:550px; text-indent: -1.3em; margin-left: 1.4em;">
※ 以下のようなブックマークレットをブラウザに登録しておくことで、表示しているホームページをこのページで表示できます。
</p>
<div style="border:solid 1px #808080; width:500px; margin-left: 1.4em;">
javascript:(function(){window.open('http://<?= $_SERVER['HTTP_HOST'] ?>/<?= MY_SESSION_NAME ?>/tools/html-my-css.php?url='+encodeURIComponent(document.URL))})();
</div>
<p style="margin-top:10px;">
<a href="javascript:(function(){window.open('http://<?= $_SERVER['HTTP_HOST'] ?>/<?= MY_SESSION_NAME ?>/tools/html-my-css.php?url='+encodeURIComponent(document.URL))})();">▲MyCSS</a> ←このリンクをブックマークバーにドラッグすると登録できます。
</p>
<p style="margin-top:10px;">
現在のスタイルシート(CSS)：
<div style="border:solid 1px #808080; width:500px; margin-left: 1.4em;">
<a href="<?= HTML_MY_CSS_STYLE_SHEET ?>" target="_blank"><?= HTML_MY_CSS_STYLE_SHEET ?></a>
</div>
</p>
<p style="margin-top:10px;">
実運用定義ファイルで、以下の様に定義することで任意のスタイルシート(CSS)を指定できます。
<div style="border:solid 1px #808080; width:500px; margin-left: 1.4em;">
define('HTML_MY_CSS_STYLE_SHEET', '../../_myhome_myset/css/?????.css');
</div>
</p>
</div>
</body>
</html>
<?php
function view_html($url, $contents, $title) {
	if ($title <> '') {
?>
	<a href="<?= $url ?>" id="my_css_url" target="_blank"><?= $title ?></a>
<?php
	}
	if (($body = get_intag($contents, '<body', '</body>', $pos=0)) <> '') {
		$pos = mb_strpos($body, '>');
		$contents = substr($body, $pos+1);
	} else {
		$contents = str_ireplace('<html', '<xxx', $contents);
		$contents = str_ireplace('</html>', '', $contents);
		$contents = strip_span_str($contents, '<head', '</head>');
	}
	$contents = strip_span_str($contents, '<script', '</script>');
	$contents = strip_span_str($contents, '<style', '</style>');
	$contents = strip_span_str($contents, '<select', '</select>');
	$contents = strip_span_str($contents, '<input', '>');
	$contents = strip_span_str($contents, '<button', '</button>');
	$contents = str_ireplace('<font', '<xxx', $contents);
	$contents = str_ireplace('<form', '<xxx', $contents);
	$contents = str_ireplace('<center', '<xxx', $contents);
	$contents = str_ireplace(' align="center"', ' align="left"', $contents);
	$contents = str_ireplace(" align='center'", " align='left'", $contents);
	$contents = str_ireplace(' style=', ' xx=', $contents);
	$contents = html_src_2_http($contents);		// use $global_url
	$contents = html_href_2_http($contents);	// use $global_url
?>
<div id="my_css_view"><!-- ########### -->
<?= $contents ?>
</div><!-- ########### -->
<?php
}
?>
