#include <jni.h>

#include "gnu_javax_comm_wce_WCECommDriver.h"

#define CommPortIdentifier_PORT_SERIAL		1
#define CommPortIdentifier_PORT_PARALLEL	2

/**
 * VA|[g
 */
static void initializePort(HANDLE hPort);


/**
 * VA|[g
 */
static void initializePort(HANDLE hPort) {
	COMMTIMEOUTS timeouts = {0};
	COMSTAT comstat = {0};
	DCB dcb = {0};
	DWORD dwErrors = 0;

	// G[NAĂisvHj
	ClearCommError(hPort, &dwErrors, &comstat);

	// ݂̏Ԃ擾
	dcb.DCBlength = sizeof(DCB);
	GetCommState(hPort, &dcb);
	
	
	// l͈ȉ̒ʂ
	// E{[[g:    9600
	// Ef[^rbg:  8
	// EXgbvrbg:1
	// EpeB:      Ȃ
	dcb.BaudRate	= 9600;
	dcb.ByteSize	= 8;
	dcb.StopBits	= ONESTOPBIT;
	dcb.Parity		= NOPARITY;
	dcb.fParity		= FALSE;

	// t[
	// ĺuv
	dcb.fDtrControl		= DTR_CONTROL_ENABLE;	// DTR͏ɃIiɎM\j
	dcb.fOutxDsrFlow	= FALSE;				// DSR͖iɑMj
	dcb.fDsrSensitivity = FALSE;				// DSȐԂɂ炸ɎM
	dcb.fRtsControl		= RTS_CONTROL_ENABLE;	// RTS͏ɃIiɎM\j
	dcb.fOutxCtsFlow	= FALSE;				// CTS͖iɑMj					
	dcb.fInX			= FALSE;				// XON/XOFFíj
	dcb.fOutX			= FALSE;				// XON/XOFFiój

	// G[ł͏IȂiCxgnhClearCommError()j
	dcb.fAbortOnError = FALSE;
	
	// ݒ
	SetCommState(hPort, &dcb);

	// Cxgҋ@tOݒ肷
	// EV_ERR͏ɑҋ@\ƂĂA
	// Xiւ̒ʒmJavaNXŐ䂷
	SetCommMask(hPort, EV_ERR);

	// ^CAEg𖳌ɂ
	// itimeouts͂Oŏς݁j
	SetCommTimeouts(hPort, &timeouts);
}

/*
 * Class:     gnu_javax_comm_wce_WCECommDriver
 * Method:    getNativeHandle
 * Signature: (Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCECommDriver_getNativeHandle(JNIEnv *env, jobject obj, jstring name, jint type) {
	jint handle = 0;

	switch (type) {
	case CommPortIdentifier_PORT_SERIAL:
		// VA|[g
		{
			_TCHAR fileName[MAX_PATH + 1];
			const jint length = (*env)->GetStringLength(env, name);
			const jchar* tmp = (*env)->GetStringChars(env, name, NULL);
			if (tmp) {
				HANDLE hPort;
				_tcsncpy(fileName, tmp, length);
				fileName[length] = _T('\0');
				(*env)->ReleaseStringChars(env, name, tmp);

				// VA|[gI[v
				hPort = CreateFile(fileName,
								  GENERIC_READ | GENERIC_WRITE,	// ǂݏ\
								  0,							// LȂ
								  NULL,
								  OPEN_EXISTING,				// ݂Ȃ΃G[
								  FILE_ATTRIBUTE_NORMAL,
								  NULL);

				if (hPort == INVALID_HANDLE_VALUE) {
					// I[vs
					DWORD error = GetLastError();
					handle = 0;
				} else {
					// VA|[g
					initializePort(hPort);
					handle = (jint) hPort;
				}
			} else {
				handle = 0;
			}
		}
		break;
	
	case CommPortIdentifier_PORT_PARALLEL:
		// p|[g̓T|[gĂȂ
		handle = 0;
		break;

	default:
		handle = 0;
		break;
	}
	return handle;
}