/* gnu_java_awt_peer_wce_WCEImageProducer.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEImageProducer.h>

#define ImageConsumer_COMPLETESCANLINES 4 
#define ImageConsumer_IMAGEABORTED 4 
#define ImageConsumer_IMAGEERROR 1 
#define ImageConsumer_RANDOMPIXELORDER 1 
#define ImageConsumer_SINGLEFRAME 16 
#define ImageConsumer_SINGLEFRAMEDONE 2 
#define ImageConsumer_SINGLEPASS 8 
#define ImageConsumer_STATICIMAGEDONE 3 
#define ImageConsumer_TOPDOWNLEFTRIGHT 2 

static jmethodID g_setDimensions_id, g_setPixels_id, g_imageComplete_id;

/*
 * Class:     gnu_java_awt_peer_wce_WCEImageProducer
 * Method:    initIDs
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEImageProducer_initIDs(JNIEnv *env, jclass clazz) {
	// C^tF[XImageConsumer̃\bhID擾Ă
	jclass consumer_class = (*env)->FindClass(env, "java/awt/image/ImageConsumer");
	if (! consumer_class) {
		// G[^[
		jclass clazz = (*env)->FindClass(env, "java/awt/AWTError");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, "Failed to find ImageConsumer");
		}
		return;
	}

	g_setDimensions_id = (*env)->GetMethodID(env, consumer_class, "setDimensions", "(II)V");
	g_setPixels_id = (*env)->GetMethodID(env, consumer_class, "setPixels", "(IIIILjava/awt/image/ColorModel;[III)V");
	g_imageComplete_id = (*env)->GetMethodID(env, consumer_class, "imageComplete", "(I)V");
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEImageProducer
 * Method:    startNativeProduction
 * Signature: (I[Ljava/awt/image/ImageConsumer;)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEImageProducer_startNativeProduction(JNIEnv *env, jobject peer_obj, jint windowHandle, jint bitmapHandle, jobjectArray c) {
	// ȉ̏ԂImageConsumerɃC[Wf[^]
	// 1. DIB쐬
	// 2. DIBɃC[W`悷
	// 3. ImageConsumer.setDimensions()ĂяoB
	// 4. DIB̓eint[] zɃRs[AImageConsumer.setPixels()Ăяo
	// 5. ImageConsumer.imageComplete() Ăяo
	
	HBITMAP hBitmap = (HBITMAP) bitmapHandle;
	HBITMAP hDIB;
	BITMAP bitmap;
	int* bits;	// C[Wf[^
	jintArray intArray;
	jclass colorModel_class;
	jobject consumer, colorModel;

	// BITMAP\̂擾
	GetObject(hBitmap, sizeof(BITMAP), &bitmap);
	
	// ColorModel.getRGBdefault()ĂяoAftHgRGBJ[f𓾂
	colorModel_class = (*env)->FindClass(env, "java/awt/image/ColorModel");
	if (colorModel_class) {
		// ftHgRGBJ[f擾
		jmethodID mid = (*env)->GetStaticMethodID(env, colorModel_class, "getRGBdefault", "()Ljava/awt/image/ColorModel;");
		if (! mid) {
			return;
		}
		colorModel = (*env)->CallStaticObjectMethod(env, colorModel_class, mid);
		if (! colorModel) {
			return;
		}
	} else {
		// G[^[
		return;
	}

	// ImageConsumerւ̒ʒmpint[]쐬
	intArray = (*env)->NewIntArray(env, bitmap.bmWidth * bitmap.bmHeight);	
	if (! intArray) {
		// G[^[
		throw_AWTError(env, "Failed to allocate a data buffer.");
		return;
	}
	
	{
		HDC hdc, hdcSrc, hdcDest;
		HBITMAP hOldDestBitmap, hOldSrcBitmap;
		BITMAPINFO bitmapinfo = {0};

		// BITMAPINFO\̂
		bitmapinfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bitmapinfo.bmiHeader.biWidth = bitmap.bmWidth;
		bitmapinfo.bmiHeader.biHeight = -bitmap.bmHeight;	// gbv_EDIBɂ
		bitmapinfo.bmiHeader.biPlanes = 1;
		bitmapinfo.bmiHeader.biBitCount = 32;
		bitmapinfo.bmiHeader.biCompression = BI_RGB;


		// DIB쐬AnꂽC[W̓e`悷
		hDIB = CreateDIBSection(NULL,
								&bitmapinfo,
								DIB_RGB_COLORS,
								&bits,
								NULL,
								0);
		if (hDIB == NULL) {
			// throw new AWTException();
			return;
		}

		// ]pDC쐬
		hdc = GetDC((HWND) windowHandle);
		hdcSrc = CreateCompatibleDC(hdc);
		hdcDest = CreateCompatibleDC(hdc);
		ReleaseDC((HWND) windowHandle, hdc);

		hOldSrcBitmap = (HBITMAP) SelectObject(hdcSrc, hBitmap);
		hOldDestBitmap = (HBITMAP) SelectObject(hdcDest, hDIB);

		// ]
		BitBlt(hdcDest,
			   0,
			   0,
			   bitmap.bmWidth,
			   bitmap.bmHeight,
			   hdcSrc,
			   0,
			   0,
			   SRCCOPY);

		// n
		SelectObject(hdcSrc, hOldSrcBitmap);
		SelectObject(hdcDest, hOldDestBitmap);
		DeleteDC(hdcSrc);
		DeleteDC(hdcDest);
	}

	// DIB  intArray ɃRs[
	(*env)->SetIntArrayRegion(env, intArray, 0, bitmap.bmWidth * bitmap.bmHeight, bits);

	// DIB폜
	DeleteObject(hDIB);

	// ImageConsumerɒʒm
	{
		int i;
		int num_consumers = (*env)->GetArrayLength(env, c);
		for (i = 0; i < num_consumers; ++i) {
			consumer = (*env)->GetObjectArrayElement(env, c, i);
			if (consumer) {		
				// setDimensions()Ăяo
				(*env)->CallVoidMethod(env, consumer, g_setDimensions_id, bitmap.bmWidth, bitmap.bmHeight);

				if ((*env)->ExceptionCheck(env)) {
					break;
				}
			
				// setPixels()Ăяo
				(*env)->CallVoidMethod(env,
									   consumer,
									   g_setPixels_id,
									   0,				// x
									   0,				// y
									   bitmap.bmWidth,	// width
									   bitmap.bmHeight,	// height
									   colorModel,		// ColorModel
									   intArray,		// pixels
									   0,				// offset
									   bitmap.bmWidth	// scanSice
									   );

				if ((*env)->ExceptionCheck(env)) {
					break;
				}
										
				// imageComlete()Ăяo
				(*env)->CallVoidMethod(env, consumer, g_imageComplete_id, ImageConsumer_STATICIMAGEDONE);

				if ((*env)->ExceptionCheck(env)) {
					break;
				}
			}
		}
	}
}
