/* WCEDIBSectionBuffer.java -- 
   Copyright (C) 2006 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

/**
 * Windows CEDIBSectionf[^obt@
 */
public class WCEDIBSectionBuffer extends WCEBitmapBuffer {
	/**
	 * DIB̃obt@쐬
	 *
	 * @param	dataType	f[^^CvBDataBufferŒ`ꂽlw肷B
	 *						̃NXł́ATYPE_INT܂TYPE_USHORT̂ꂩLȒlƂȂB
	 *                      TYPE_USHORTw肳ꂽꍇARGB565̃J[tH[}bgDIB쐬
	 * @param	width		C[W̕
	 * @param	height		C[W̍
	 */
	protected WCEDIBSectionBuffer(int dataType,
								  int width,
								  int height) {
		super(dataType, width, height);
	}
	
	/**
	 * lCeBurbg}bv쐬ÃnhԂB
	 */
	protected int createBitmapHandle() {
		return createNativeBitmapHandle(getDataType(),
								 getWidth(),
								 getHeight());
	}
	
	/**
	 * lCeBurbg}bv쐬B
	 *
	 * @param	dataType
	 * @param	width
	 * @param	height
	 */
	private native int createNativeBitmapHandle(int dataType, int width, int height);

	public int getElem(int bank, int i) {
		return getNativePixel(getBitmapHandle(), i);
	}
	
	private native int getNativePixel(int bitmapHandle, int i);
	
	/**
	 * w肳ꂽlݒ肷B
	 *
	 * @param	bank	B
	 * @param	i		CfbNX
	 * @param	val		ݒlB
	 */
	public void setElem(int bank, int i, int val) {
		setNativePixel(getBitmapHandle(), i, val);
	}
	
	private native void setNativePixel(int bitmapHandle, int i, int val);

	/**
	 * ̃C[W̃f[^𒊏o邽߂SampleModel쐬B
	 */
	public SampleModel createCompatibleSampleModel() {
		throw new UnsupportedOperationException("Not implemented");
	}
	
	/**
	 * ̃C[W̃f[^̐FColorModel쐬B
	 */
	public ColorModel createCompatibleColorModel() {
		throw new UnsupportedOperationException("Not implemented");
	}
	
	/**
	 * ̃C[ŴׂẴsNZf[^int[]ƂĕԂB
	 * f[^^CvTYPE_INTȊȌꍇAUnsupportedOperationExceptionthrowB
	 */
	public int[] getAllPixels(int[] pixels) {
		if (getDataType() != DataBuffer.TYPE_INT) {
			throw new UnsupportedOperationException("getDataType()!=DataBuffer.TYPE_INT");
		}
		return getNativeAllPixelsInt(getBitmapHandle(), pixels);
	}
	
	/**
	 * ̃C[W̑Sf[^Aw肳ꂽsNZŒuB
	 * f[^^CvTYPE_INTȊȌꍇAUnsupportedOperationExceptionthrowB
	 */
	public void setAllPixels(int[] pixels) {
		if (getDataType() != DataBuffer.TYPE_INT) {
			throw new UnsupportedOperationException("getDataType()!=DataBuffer.TYPE_INT");
		}
		setNativeAllPixelsInt(getBitmapHandle(), pixels);
	}

	/**
	 * ̃C[ŴׂẴsNZf[^short[]ƂĕԂB
	 * f[^^CvTYPE_USHORTȊȌꍇAUnsupportedOperationExceptionthrowB
	 */
	public short[] getAllPixels(short[] pixels) {
		if (getDataType() != DataBuffer.TYPE_USHORT) {
			throw new UnsupportedOperationException("getDataType()!=DataBuffer.TYPE_USHORT");
		}
		return getNativeAllPixelsUShort(getBitmapHandle(), pixels);
	}
	
	/**
	 * ̃C[W̑Sf[^Aw肳ꂽsNZŒuB
	 * f[^^CvTYPE_USHORTȊȌꍇAUnsupportedOperationExceptionthrowB
	 */
	public void setAllPixels(short[] pixels) {
		if (getDataType() != DataBuffer.TYPE_USHORT) {
			throw new UnsupportedOperationException("getDataType()!=DataBuffer.TYPE_USHORT");
		}
		setNativeAllPixelsUShort(getBitmapHandle(), pixels);
	}
	
	private native int[] getNativeAllPixelsInt(int bitmapHandle, int[] pixels);
	private native void setNativeAllPixelsInt(int bitmapHandle, int[] pixels);

	private native short[] getNativeAllPixelsUShort(int bitmapHandle, short[] pixels);
	private native void setNativeAllPixelsUShort(int bitmapHandle, short[] pixels);


}
