package gnu.javax.sound.sampled.wce;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioPermission;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

/**
 * o̓CB
 */
public class WCESourceDataLine extends WCEDataLine
										implements SourceDataLine {
	/**
	 * lCeBuf[^
	 */
	private int nativeData;
	
	/**
	 * o̓C̃CX^X쐬B
	 *
	 * @param	info	Linȅ
	 */
	public WCESourceDataLine(DataLine.Info info) {
		super(info);
	}
	
	/**
	 * ̃CftHgݒŃI[v
	 *
	 */
	public void open()
			throws LineUnavailableException,
				   IllegalArgumentException,
				   SecurityException {
		open(getFormat());
	}
	
	/**
	 * ̃CI[v
	 *
	 * @param	format	tH[}bg
	 * @param	bufferSize	obt@TCY
	 */
	public synchronized void open(AudioFormat format, int bufferSize)
								throws LineUnavailableException,
									   IllegalArgumentException,
									   IllegalStateException,
									   SecurityException {
		if (isOpen()) {
			throw new IllegalStateException("Already open");
		}
		
		// ZLeB`FbN
		SecurityManager sm = System.getSecurityManager();
		if (sm != null) {
			// "play" `FbN
			sm.checkPermission(new AudioPermission("play"));
		}
		
		// tH[}bg`FbN
		checkFormat(format);
		
		// I[v
		super.open();
		this.nativeData
			=  openNative(bufferSize,
						  format.getSampleRate(),
						  format.getSampleSizeInBits(),
						  format.getChannels(),
						  format.getFrameSize(),
						  format.getFrameRate(),
						  format.isBigEndian());
		setFormat(format);
	}
	
	/**
	 * ̃CI[v
	 *
	 * @param	format	tH[}bg
	 */
	public void open(AudioFormat format)
								throws LineUnavailableException,
									   IllegalArgumentException,
									   IllegalStateException,
									   SecurityException {
		open(format, 0);
	}
	
	/**
	 * Windows CẺo̓foCXI[vB
	 *
	 * @param	bufferSize	obt@TCY
	 * @param	sampleRate	Tv[g
	 * @param	sampleSizeInBits	rbgPʂŕ\Tvf[^TCYB
	 * @param	channels	`lB
	 * @param	frameSize	1t[̃f[^oCg
	 * @param	frameRate	1b̍Đt[
	 * @param	bigEndian	f[^rbOGfBȀꍇtrueB
	 *
	 * @return	lCeBuf[^Bi\̂̃|C^j
	 *
	 * @throws LineUnavailableException
	 *						o̓foCXI[vłȂꍇB
	 */
	private native int openNative(int bufferSize,
								  float sampleRate,
								  int sampleSizeInBits,
								  int channels,
								  int frameSize,
								  float frameRate,
								  boolean bigEndian)
								throws LineUnavailableException,
									   IllegalArgumentException,
									   IllegalStateException,
									   SecurityException;
	
	/**
	 * I[fBf[^Cɏ
	 */
	public int write(byte[] b, int off, int len)
							throws IllegalArgumentException,
								   ArrayIndexOutOfBoundsException {
		if (! isOpen()) {
			return 0;
		}
		return writeNative(this.nativeData,
						   b,
						   off,
						   len);
	}
	
	/**
	 * I[fBIo̓foCXɁAg`f[^
	 *
	 * @param	nativeData	lCeBuf[^
	 * @param	b			obt@
	 * @param	off
	 * @param	len
	 */
	private native int writeNative(int nativeData,
								   byte[] b,
								   int off,
								   int len)
							throws IllegalArgumentException,
								   ArrayIndexOutOfBoundsException;

	/**
	 * CN[Y
	 */
	public void close() {
		if (isOpen()) {
			stop();
			flush();
			nativeClose(this.nativeData);
			super.close();
		}
	}
	
	/**
	 * Windows CẺo̓foCXN[Y
	 */
	private native void nativeClose(int nativeData);
	
	public void drain() {
		if (! isOpen()) {
			return;
		}
		drainNative(this.nativeData);
	}
	
	/**
	 * obt@̃f[^ɂȂ܂ŃubN
	 */
	private native void drainNative(int nativeData);
	
	public void flush() {
		if (! isOpen()) {
			return;
		}
		flushNative(this.nativeData);
	}
	
	/**
	 * o̓obt@̃f[^j
	 */
	private native void flushNative(int nativeData);

	public boolean isActive() {
		return isNativeActive(this.nativeData);
	}
	
	/**
	 * Windows CEfoCXŉo͒ԂB
	 */
	private native boolean isNativeActive(int nativeData);

	public int getBufferSize() {
		if (! isOpen()) {
			return 0;
		}
		return getNativeBufferSize(this.nativeData);
	}
	
	/**
	 * lCeBuobt@TCYԂ
	 */
	private native int getNativeBufferSize(int nativeData);
	
	public int available() {
		if (! isOpen()) {
			return 0;
		}
		return availableNative(this.nativeData);
	}
	
	/**
	 * lCeBuCuŃubNɏ߂oCg
	 * ԂB
	 */
	private native int availableNative(int nativeData);
	
	public int getFramePosition() {
		return (int) getLongFramePosition();
	}
	
	public long getLongFramePosition() {
		if (! isOpen()) {
			return 0L;
		}
		// ToDo: 
		return AudioSystem.NOT_SPECIFIED;
	}
	
	public long getMicrosecondPosition() {
		if (! isOpen()) {
			return 0L;
		}
		// ToDo: 
		return AudioSystem.NOT_SPECIFIED;
	}
	
	public float getLevel() {
		// ToDo: 
		return AudioSystem.NOT_SPECIFIED;
	}
	

	public Control[] getControls() {
		// ToDo: 
		return new Control[0];
	}

	public boolean isControlSupported(Control.Type control) {
		// ToDo: 
		return false;
	}
	
	public Control getControl(Control.Type control) {
		// ToDo: 
		throw new IllegalArgumentException("Not supported:" + control);
	}

	public void start() {
		if (! isOpen()) {
			return;
		}
		
		super.start();
		startNative(this.nativeData);
	}
	
	private native void startNative(int nativeData);
	
	public void stop() {
		if (! isOpen()) {
			return;
		}
		stopNative(this.nativeData);
		super.stop();
	}

	private native void stopNative(int nativeData);

	
	/**
	 * tH[}bg`FbN
	 */
	protected static void checkFormat(AudioFormat format) throws LineUnavailableException {
		// tH[}bg`FbN
		// T|[gĂ͈̂ȉ̂Q
		// o  8rbgȂPCM
		// o 16rbgtPCM
		boolean validFormat = false;
		int sampleSizeInBits = format.getSampleSizeInBits();
		AudioFormat.Encoding encoding = format.getEncoding();
		switch (sampleSizeInBits) {
		case 8:
			// Wrbg̏ꍇ͕Ȃ
			if (AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
				validFormat = true;
			}
			break;
			
		case 16:
			// 16rbg̏ꍇ͕t
			if (AudioFormat.Encoding.PCM_SIGNED.equals(encoding)) {
				validFormat = true;
			}
			break;
		}
		if (format.getChannels() > 0) {
			// `l`FbN
			validFormat = true;
		}
		
		if (! validFormat) {
			throw new LineUnavailableException("Unsupported format:" + format);
		}
	}
}
