/* java.lang.VMProcess -- VM implementation of java.lang.Process
   Copyright (C) 2004, 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Windows CẼvZXǗLinuxƈقȂ邽߁AGNU Classpath̃t@X
 * ̂܂ܓKpłȂB
 * 啝ɕύXĂB
 *
 * @see Process
 * @see Runtime#exec
 */
final class VMProcess extends Process {

	/**
	 * vZXID
	 */
	private int processID;
	
	/**
	 * RXgN^
	 */
	public VMProcess(String[] cmd, String[] env, File dir, boolean redirect) throws IOException {
		// vZX쐬AvZXIDێĂ
		this.processID = createNativeProcess(cmd);
	}
	
	/**
	 * lCeBuvZX쐬ÃvZXIDԂB
	 */
	private native int createNativeProcess(String[] cmd) throws IOException;
	
	/**
	 * vZXւ̏o̓Xg[𓾂
	 */
	public OutputStream getOutputStream() {
		// 
		return null;
	}

	/**
	 * vZX̓̓Xg[𓾂
	 */
	public InputStream getInputStream() {
		// 
		return null;
	}
	
	/**
	 * vZX̃G[Xg[𓾂
	 */
	public InputStream getErrorStream() {
		// 
		return null;
	}
	
	public int waitFor() throws InterruptedException {
		return waitForNative(this.processID);
	}
	
	/**
	 * lCeBuvZX̏Iҋ@
	 */
	private native int waitForNative(int pid) throws InterruptedException;
	
	public int exitValue() {
		return getNativeExitCode(this.processID);
	}
	
	/**
	 * lCeBuvZX̏IR[hԂ
	 */
	private native int getNativeExitCode(int pid);
	
	public void destroy() {
		destroyNative(this.processID);
	}
	
	/**
	 * lCeBuvZXI
	 */
	private native void destroyNative(int pid);
	
	/**
	 * Entry point from Runtime.exec().
	 */
	static Process exec(String[] cmd, String[] env, File dir) throws IOException {
	    return new VMProcess(cmd, env, dir, false);
	}
	
  static Process exec(List cmd, Map env,
		      File dir, boolean redirect) throws IOException
  {
    String[] acmd = (String[]) cmd.toArray(new String[cmd.size()]);
    String[] aenv = new String[env.size()];

    int i = 0;
    Iterator iter = env.entrySet().iterator();
    while (iter.hasNext())
      {
	Map.Entry entry = (Map.Entry) iter.next();
	aenv[i++] = entry.getKey() + "=" + entry.getValue();
      }

    return new VMProcess(acmd, aenv, dir, redirect);
  }
	
}
