// unzip.cpp : Defines the entry point for the application.
//

#include <windows.h>
#include "unzip.h"
#include "zconf.h"
#include "zlib.h"

/**
 * ZIPt@CGg
 */
struct zip_entry {
	WORD  compression_method;				// k@iO͔񈳏kj
	DWORD compressed_size;					// kTCY
	DWORD uncompressed_size;				// 񈳏kTCY
	DWORD relative_offset_of_local_header;	// [Jwb_JnAhX̃ItZbg
};

/**
 * ZIPt@Cnh
 */
struct ZIPFILE {
	HANDLE hFile;							// t@Cnh
	HANDLE hMapping;						// }bsOnh
	LPVOID data;							// }bvꂽAhX	

	DWORD file_size;						// ZIPt@CTCY 

	DWORD central_directory_size;			// central directorỹTCY
	DWORD central_directory_offset;			// central directorẙJnItZbg

	zip_entry current_entry;				// JgGg
};

/**
 * 32rbglǂݍ
 */
#define READ_INT32(p) \
	(((__int32) (p)[0] & 0x000000ff) \
			| ((__int32) (p)[1] << 8 & 0x0000ff00) \
			| ((__int32) (p)[2] << 16 & 0x00ff0000) \
			| ((__int32) (p)[3] << 24 & 0xff000000))

/**
 * 16rbglǂݍ
 */
#define READ_INT16(p) \
	((__int16) (p)[0] & 0x00ff) \
			| ((__int16) (p)[1] << 8 & 0xff00)

/**
 * w肳ꂽZIPt@CI[v
 */
ZIPFILE* unzip_open(LPTSTR filename) {
	ZIPFILE* zfile = NULL;

	// }bsOpɃt@CI[v
	HANDLE hFile = CreateFileForMapping(filename,
		                                GENERIC_READ,
										FILE_SHARE_READ,
										NULL,
										OPEN_EXISTING,
										FILE_FLAG_RANDOM_ACCESS,
										NULL);
	if (hFile != NULL) {
		// t@CTCY擾
		DWORD size = GetFileSize(hFile, NULL);
		// t@C}bsOnh쐬
		HANDLE hMapping = CreateFileMapping(hFile,
											NULL,
											PAGE_READONLY,
											0,				// őTCYȂ
											0,				// it@CŚj
											NULL);			// OȂ
		if (hMapping != NULL) {
			// t@CɃ}bv
			LPVOID buff = MapViewOfFile(hMapping,
										FILE_MAP_READ,
										0,					// t@C̐擪}bsO
										0,					// 
										0);					// t@CŜ}bsO
			if (buff != NULL) {
				// t@C̍Ō - 20oCgڂɈړA"End of central directory record"
				// ̓eǂݍ
				for (char* p = (char*) buff + (size - 1 - 20); p > buff; --p) {
					// ŌVOj`Ɉv鐔lT
					if (p[0] == 0x50 && p[1] == 0x4b && p[2] == 0x05 && p[3] == 0x06) {
						// ZIPFILE\̂̓e
						zfile = (ZIPFILE*) malloc(sizeof(ZIPFILE));
						zfile->hFile = hFile;
						zfile->hMapping = hMapping;
						zfile->data = buff;
						zfile->file_size = size;
						zfile->central_directory_size	= READ_INT32(p+12);
						zfile->central_directory_offset = READ_INT32(p+16);

						zfile->current_entry.relative_offset_of_local_header = (DWORD) -1;

						break;
					}
				}
				if (zfile == NULL) {
					// ZIPt@Cł͂Ȃ߁AA}bv
					UnmapViewOfFile(buff);
				}
			}
			if (zfile == NULL) {
				// ZIPt@Cł͂Ȃ߁A}bsOnhN[Y
				CloseHandle(hMapping);
			}
		}
		
		if (zfile == NULL) {
			// ZIPt@Cł͂Ȃ߁At@CnhN[Y
			CloseHandle(hFile);
		}
	}

	return zfile;
}

/**
 * w肳ꂽZIPt@CN[Y
 */
BOOL unzip_close(ZIPFILE* zfile) {
	if (zfile == NULL) {
		return FALSE;
	}
	
	// }bvAnhN[Y
	BOOL result1 = UnmapViewOfFile(zfile->data);
	BOOL result2 = CloseHandle(zfile->hMapping);
	BOOL result3 = CloseHandle(zfile->hFile);
	
	// 
	free(zfile);

	return result1 && result2 && result3;
}

/**
 * w肳ꂽt@C̈ʒu܂ňړ
 */
BOOL unzip_seek(ZIPFILE* zfile, const char* filename) {
	BOOL result = FALSE;
	int len = strlen(filename);

	// central directorỹAhXvZ
	const char* p = (const char*) ((char*) zfile->data + zfile->central_directory_offset);

	// IAhXvZ
	const char* end = p + zfile->central_directory_size;

	while (p < end) {
		if (! (p[0] == 0x50 && p[1] == 0x4b && p[2] == 0x01 && p[3] == 0x02)) {
			// VOj`central directorŷ̂ł͂ȂꍇA𒆎~
			break;
		}
		
		// t@CAGNXgtB[hAt@CRg̒𓾂
		WORD filename_length		= READ_INT16(p + 28);
		WORD extra_field_length		= READ_INT16(p + 30);
		WORD file_comment_length	= READ_INT16(p + 32);

		if (filename_length == len) {
			// t@C̔rs
			const char* name = (const char*) (p + 46);
			if (memcmp(name, filename, len) == 0) {
				// t@CvꍇAGgǂݍ
				zip_entry* entry = &zfile->current_entry;
				entry->compression_method			   = READ_INT16(p + 10);
				entry->compressed_size				   = READ_INT32(p + 20);
				entry->uncompressed_size			   = READ_INT32(p + 24);
				entry->relative_offset_of_local_header = READ_INT32(p + 42);
				result = TRUE;
				break;
			}
		}
		
		// ̈ʒuɈړ
		p += 46							// central directory̌Œ蕔TCY
			 + filename_length
			 + extra_field_length
			 + file_comment_length;
	}
	if (! result) {
		// t@CȂ
		zfile->current_entry.relative_offset_of_local_header = (DWORD) -1;
	}

	return result;
}

/**
 * ݂̃GgɑΉt@C̓WJ̃TCYԂB
 */
DWORD unzip_get_uncompressed_size(ZIPFILE* zfile) {
	DWORD size = (DWORD) -1;
	if (zfile->current_entry.relative_offset_of_local_header != (DWORD) -1) {
		size = zfile->current_entry.uncompressed_size;
	}
	return size;
}

/**
 * Gg𓀂Aw肳ꂽobt@ɓ
 * i݂̎ł́Aobt@TCY == WJ̃TCYɂȂĂȂ΂ȂȂj
 */
BOOL unzip_read(ZIPFILE* zfile, char* buff, DWORD bufflen) {
	zip_entry* entry = &zfile->current_entry;
	if (entry->relative_offset_of_local_header == (DWORD) -1) {
		return FALSE;
	}
	
	// local headerJnAhX𓾂
	const char* header = (const char*) zfile->data
										+ entry->relative_offset_of_local_header;
	if (! (header[0] == 0x50 && header[1] == 0x4b && header[2] == 0x03 && header[3] == 0x04)) {
		// VOj`local header̂̂ƈvȂꍇ
		return FALSE;
	}
	
	// f[^ǂݍ
	BOOL result = FALSE;

	// local header̃TCYvZ邽߂
	// t@CƃGNXgtB[h̒擾
	WORD filename_length    = READ_INT16(header + 26);
	WORD extra_field_length = READ_INT16(header + 28);
	unsigned char* body = (unsigned char*) header
			                              + 30					// local headeřŒ蕔TCY
										  + filename_length
										  + extra_field_length; 
	if (entry->compression_method == 0) {
		// 񈳏k̏ꍇARs[
		memcpy(buff, body, bufflen);
		result = TRUE;
	} else {
		// k
		z_stream stream;
		stream.zalloc = Z_NULL;
		stream.zfree  = Z_NULL;
		stream.opaque = Z_NULL;
		if (inflateInit2(&stream, -MAX_WBITS) == Z_OK) {
			// local headerɈkf[^
			stream.next_in = body;
			stream.avail_in = zfile->file_size - entry->relative_offset_of_local_header;
			stream.next_out = (unsigned char*) buff;
			stream.avail_out = bufflen;

			int err = inflate(&stream, Z_FINISH);
			if (err == Z_STREAM_END) {
				result = TRUE;
			}
			inflateEnd(&stream);
		}
	}
	
	return result;
}
