/* WCEDesktopPeer.java
   Copyright (C) 2005, 2006, 2007, 2008 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.awt.peer.wce;

import java.awt.AWTPermission;
import java.awt.Desktop;
import java.awt.Desktop.Action;
import static java.awt.Desktop.Action.*;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class WCEDesktopPeer implements DesktopPeer {
	
	private static final DesktopPeer INSTANCE = new WCEDesktopPeer();
	
	public boolean isSupported(Action action) {
		switch (action) {
			case OPEN:
			case EDIT:
			case BROWSE:
			case MAIL:
			case PRINT:
				return true;
			
			default:
				throw new UnsupportedOperationException();
		}
	}

	public void browse(URI url) throws IOException {
		if (url == null) {
			throw new NullPointerException("url");
		}
		SecurityManager sm = System.getSecurityManager ();
		if (sm != null) {
			sm.checkPermission (new AWTPermission ("showWindowWithoutWarningBanner"));
		}
		nativeShellExecuteEx("open", null, url.toString());
	}

	public void edit(File file) throws IOException {
		if (file == null) {
			throw new NullPointerException("file");
		}
		String abspath = file.getAbsolutePath();
		SecurityManager sm = System.getSecurityManager ();
		if (sm != null) {
			sm.checkRead(abspath);
			sm.checkWrite(abspath);
			sm.checkPermission (new AWTPermission ("showWindowWithoutWarningBanner"));
		}
		File absFile = new File(abspath);
		nativeShellExecuteEx("edit", absFile.getParent(), absFile.getName());
	}
	
	public void mail(URI mailtoURL) throws IOException {
		if (mailtoURL == null) {
			throw new NullPointerException("mailtoURL");
		}
		SecurityManager sm = System.getSecurityManager ();
		if (sm != null) {
			sm.checkPermission (new AWTPermission ("showWindowWithoutWarningBanner"));
		}
		nativeShellExecuteEx("open", null, mailtoURL.toString());
	}

	public void mail() throws IOException {
		SecurityManager sm = System.getSecurityManager ();
		if (sm != null) {
			sm.checkPermission (new AWTPermission ("showWindowWithoutWarningBanner"));
		}
		nativeShellExecuteEx("open", null, "mailto:");
	}

	public void open(File file) throws IOException {
		if (file == null) {
			throw new NullPointerException("file");
		}
		String abspath = file.getAbsolutePath();
		SecurityManager sm = System.getSecurityManager ();
		if (sm != null) {
			sm.checkRead(abspath);
		}
		File absFile = new File(abspath);
		nativeShellExecuteEx("open", absFile.getParent(), absFile.getName());
	}
	
	public void print(File file) throws IOException {
		if (file == null) {
			throw new NullPointerException("file");
		}
		String abspath = file.getAbsolutePath();
		SecurityManager sm = System.getSecurityManager ();
		if (sm != null) {
			sm.checkRead(abspath);
		}
		File absFile = new File(abspath);
		nativeShellExecuteEx("print", absFile.getParent(), absFile.getName());
	}
	
	public static DesktopPeer getDesktopPeer() {
		return INSTANCE;
	}
	
	/**
	 * ShellExecuteEx()s
	 *
	 * @param	verb	SHELLEXECUTEINFO.lpVerb ɓnl
	 * @param	dir		SHELLEXECUTEINFO.lpDirectory  ɓnl
	 * @param	file  	SHELLEXECUTEINFO.lpFile  ɓnl
	 */
	private static native void nativeShellExecuteEx(String verb, String dir, String file) throws IOException;
	
}
