/* WCEScrollPanePeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.AWTEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.PaintEvent;
import java.awt.peer.ScrollPanePeer;
import java.lang.reflect.Field;

public class WCEScrollPanePeer extends WCEContainerPeer implements ScrollPanePeer {
	/**
	 * ScrollPaneAdjustble.maximum
	 */
	private static Field maximumField;
	
	/**
	 * ScrollPaneAdjustable.visibleAmount
	 */
	private static Field visibleAmountField;
	
	static {
		try {
			// ScrollPaneAdjustable.maximum tB[h̓pbP[WvCx[gȂ̂
			// ANZXł悤ɂ
			Class clazz = ScrollPaneAdjustable.class;
			maximumField = clazz.getDeclaredField("maximum");
			maximumField.setAccessible(true);
			
			// "visibleAmount"tB[hɂĂ
			visibleAmountField = clazz.getDeclaredField("visibleAmount");
			visibleAmountField.setAccessible(true);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public WCEScrollPanePeer(ScrollPane scrollPane) {
		super(scrollPane);
	}
	
	protected int createNative(int hParentWnd, int x, int y, int width, int height) {
		ScrollPane scrollPane = (ScrollPane) getComponent();
		return createNativeScrollPane(hParentWnd,
									  x,
									  y,
									  width,
									  height,
									  scrollPane.getScrollbarDisplayPolicy());
	}
		
	private native int createNativeScrollPane(int hParentWnd, int x, int y, int width, int height, int policy);
	
	public int getHScrollbarHeight() {
		return getNativeHScrollbarHeight(getWindowHandle());
	}
	
	/**
	 * lCeBuXN[o[̍Ԃ
	 */
	private native int getNativeHScrollbarHeight(int windowHandle);
	
	public int getVScrollbarWidth() {
		return getNativeVScrollbarWidth(getWindowHandle());
	}
	
	/**
	 * lCeBuXN[o[̕Ԃ
	 */
	private native int getNativeVScrollbarWidth(int windowHandle);
	
	/**
	 * lCeBuXN[o[ŔXN[CxgɁAVʒuvZA
	 * JavãR|[lgɔfB
	 * ̃\bh́AOS WM_VSCROLL/WM_HSCROLL bZ[WMۂɌĂяo
	 *
	 * @param	scrollbarType	XN[ʁBScrollbar.HORIZONTAL, Scrollbar.VERTICAL̂ꂩB
	 * @param	eventType		Cxg^CvBAdjustmentEvent ̒萔lw肷B
	 * @param	value			lCeBuXN[o[̌ݒl
	 * @param	isAdjusting		l𒲐iXN[o[hbOj̏ꍇtrue
	 * @return					JavaR|[lgɔflB
	 */
	int updatePosition(int scrollbarType,
					   int eventType,
					   int value,
					   boolean isAdjusting) {
		ScrollPane scrollPane = (ScrollPane) getComponent();
		Adjustable adjustable;
		int maximum;
		switch (scrollbarType) {
			case Scrollbar.HORIZONTAL:
				adjustable = scrollPane.getHAdjustable();
				break;
			case Scrollbar.VERTICAL:
				adjustable = scrollPane.getVAdjustable();
				break;
			default:
				throw new IllegalArgumentException("scrollbarType");
		}
		
		// VlvZ
		int newvalue = value;
		switch (eventType) {
			case AdjustmentEvent.UNIT_INCREMENT:
				newvalue += adjustable.getUnitIncrement();
				break;
				
			case AdjustmentEvent.UNIT_DECREMENT:
				newvalue -= adjustable.getUnitIncrement();
				break;
				
			case AdjustmentEvent.BLOCK_INCREMENT:
				newvalue += adjustable.getBlockIncrement();
				break;
				
			case AdjustmentEvent.BLOCK_DECREMENT:
				newvalue -= adjustable.getBlockIncrement();
				break;
			
			case AdjustmentEvent.TRACK:
				// lCeBu̒l̂܂܎gp
				break;
				
			default:
				throw new IllegalArgumentException("eventType");
		}
		
		// [ŏl - ől]͈͓̔Ɏ܂悤ɒ
		int max = adjustable.getMaximum() - adjustable.getVisibleAmount();
		newvalue = (newvalue > max) ? max : newvalue;
		newvalue = (newvalue < 0) ? 0 : newvalue;
		
		// AdjustableɐVlݒ肷
		ScrollPaneAdjustable spa = (ScrollPaneAdjustable) adjustable;
		if (spa.getValueIsAdjusting() != isAdjusting
				|| spa.getValue() != newvalue) {
			spa.setValue(newvalue);
			spa.setValueIsAdjusting(isAdjusting);
			// Cxgʒm
			notifyAdjustmentEvent((ScrollPaneAdjustable) adjustable,
								  eventType,
								  newvalue,
								  isAdjusting);
		}
		
		// ݒ肵VlԂ
		return newvalue;
	}
	
	
	public void setScrollPosition(int x, int y) {
		ScrollPane sp = (ScrollPane) getComponent();
		Dimension vs = sp.getViewportSize();
		Component child = sp.getComponent(0);

		ScrollPane scrollPane = (ScrollPane) getComponent();

		Adjustable adjustable = scrollPane.getHAdjustable();
		// Cxgʒm
		if (x != adjustable.getValue()) {
			notifyAdjustmentEvent((ScrollPaneAdjustable) adjustable,
								  AdjustmentEvent.TRACK,
								  x,
								  false);
		}
		
		adjustable = scrollPane.getVAdjustable();
		// Cxgʒm
		if (y != adjustable.getValue()) {
			notifyAdjustmentEvent((ScrollPaneAdjustable) adjustable,
								  AdjustmentEvent.TRACK,
								  y,
								  false);
		}
		if (x != adjustable.getValue() || y != adjustable.getValue()) {
			// ݈ʒu擾
			int oldX = -child.getX();
			int oldY = -child.getY();
			
			// lCeBuR|[lgɃXN[w
			setNativeScrollPosition(getWindowHandle(), oldX, oldY, x, y);
		}
	}
	
	/**
	 * lCeBuR|[lgXN[
	 */
	private native void setNativeScrollPosition(int windowHandle, int oldX, int oldY,
																  int newX, int newY);
	
	/**
	 * w肳ꂽAdjustableAw肳ꂽlŏ
	 *
	 * @param	adjustable	ݒΏۂƂȂAdjustable
	 * @param	visibleAmount	\͈
	 */
	private void setupAdjustable(Adjustable adjustable,
								 int visibleAmount) {
		// \̈ BlockIncrement ̒l͓
		adjustable.setBlockIncrement((visibleAmount > 1) ? visibleAmount : 1);
		try {
			visibleAmountField.setInt(adjustable, (visibleAmount > 0) ? visibleAmount : 0);
		} catch (IllegalAccessException iae) {
			iae.printStackTrace();
		}
		
		// UnitIncrement̒l𒲐
		if (adjustable.getUnitIncrement() > visibleAmount) {
			adjustable.setUnitIncrement((visibleAmount) > 0 ? visibleAmount : 1);
		}
	}
	
	/**
	 * doLayout()sɁAScrollPaneĂяo
	 */
	public void childResized(int width, int height) {
		ScrollPane scrollPane = (ScrollPane) getComponent();
		
		// Adjustableɒlݒ肷
		Adjustable h = scrollPane.getHAdjustable();
		Adjustable v = scrollPane.getVAdjustable();
		Dimension viewportSize = scrollPane.getViewportSize();
		
		// Adjustablẽp[^Đݒ肷
		setupAdjustable(v, (int) viewportSize.getHeight());
		setupAdjustable(h, (int) viewportSize.getWidth());
		
		int vmaximum = height - v.getVisibleAmount();
		int hmaximum = width - h.getVisibleAmount();
		setMaximum(v, vmaximum);
		setMaximum(h, hmaximum);

		// lCeBuXN[o[̃p[^ݒ肷
		if (scrollPane.getScrollbarDisplayPolicy()
						!= ScrollPane.SCROLLBARS_NEVER) {

			int windowHandle = getWindowHandle();
			// XN[o[
			setNativeScrollbarParameters(windowHandle,
										 Scrollbar.HORIZONTAL,
										 hmaximum,
										 h.getVisibleAmount());
			// XN[o[
			setNativeScrollbarParameters(windowHandle,
										 Scrollbar.VERTICAL,
										 vmaximum,
										 v.getVisibleAmount());
		}
	}
	
	public void setUnitIncrement(Adjustable item, int inc) {
		// 
	}
	
	public void setValue(Adjustable item, int value) {
		// 
	}
	
	/**
	 * lCeBuXN[o[̍ől^\͈͂ݒ肷
	 * ̃\bhĂяoʁAXN[o[̕\ԋy
	 * L^Ԃω\B
	 * getInsets()̌Ăяoʂ̃\bhĂяȏO
	 * ω\B
	 *
	 * @param	windowHandle	lCeBuScrollPanẽEChEnh
	 * @param	scrollbarType	XN[o[̃^CvBScollbar.VERTICAL, Scrollbar.HORIZONTAL̂ꂩB
	 * @param	maximum			XN[o[̍őlBiŏl͂OŒj
	 * @param	visibleAmount	\\̈
	 */
	private native void setNativeScrollbarParameters(int windowHandle,
													 int scrollbarType,
													 int maximum,
													 int visibleAmount);

	/**
	 * TCYԂB
	 */
	public Dimension getPreferredSize() {
		// ScrollPaneR|[lg̃TCY𗘗p
		return getComponent().getSize();
	}
	

	/**
	 * Adjustableɓo^ꂽAdjustmentListener
	 * Cxgʒm
	 */
	protected void notifyAdjustmentEvent(ScrollPaneAdjustable adjustable,
										 int type,
										 int value,
										 boolean adjusting) {
		AdjustmentListener[] listeners
			= adjustable.getAdjustmentListeners();
		AdjustmentEvent e = null;
		for (int i = 0; i < listeners.length; ++i) {
			if (e == null) {
				// Cxg𐶐
				e = new AdjustmentEvent(adjustable,
										AdjustmentEvent.ADJUSTMENT_VALUE_CHANGED,
										type,
										value,
										adjusting);
			}
			listeners[i].adjustmentValueChanged(e);
		}
	}
	
	/**
	 * ScrollPaneAdjustable.maximum tB[hݒ肷
	 */
	private void setMaximum(Adjustable adj, int maximum) {
		try {
			if (maximumField != null) {
				maximumField.setInt(adj, maximum);
			}
		} catch (IllegalAccessException iae) {
			iae.printStackTrace();
		}
	}
}
