/* WaveFileConstants.java
   Copyright (C) 2006 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; the version 2.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.javax.sound.sampled.wce;

public interface WaveFileConstants {
	public static byte[] RIFF_TAG
		= new byte[] {  0x52, // 'R'
						0x49, // 'I'
						0x46, // 'F'
						0x46  // 'F'
					};
				
	public static byte[] WAVE_TAG
		= new byte[] {  0x57, // 'W'
						0x41, // 'A'
						0x56, // 'V'
						0x45  // 'E'
					};

	public static byte[] FMT_TAG
		= new byte[] {  0x66, // 'f'
						0x6d, // 'm'
						0x74, // 't'
						0x20  // ' '
					};

	public static byte[] FACT_TAG
		= new byte[] {  0x66, // 'f'
						0x61, // 'a'
						0x63, // 'c'
						0x61  // 't'
					};

	public static byte[] DATA_TAG
		= new byte[] {  0x64, // 'd'
						0x61, // 'a'
						0x74, // 't'
						0x61  // 'a'
					};

	public static int FMT_LENGTH = 16;
	
	public static int OUTPUT_HEADER_LENGTH = 44;
}
