#ifndef TIME_H_INCLUDED
#define TIME_H_INCLUDED

#include <time.h>
#include <winsock.h>


/* Windows CE does not have "getenv()" */
#define getenv(s)	NULL

struct timezone {
     int tz_minuteswest; /* minutes W of Greenwich */
     int tz_dsttime;     /* type of dst correction */
};

#ifdef __cplusplus
extern "C" {
#endif

_inline int gettimeofday(struct timeval *tv, struct timezone *tz)
{
	FILETIME        ft;
	SYSTEMTIME      st;
	LARGE_INTEGER   li;
	__int64         t;
	DWORD dwTick;

	GetSystemTime(&st);
	dwTick = GetTickCount();			// ToDo: Lu[V

	SystemTimeToFileTime(&st,&ft);
	li.LowPart  = ft.dwLowDateTime;
	li.HighPart = ft.dwHighDateTime;
	t  = li.QuadPart;					// 100imbP
	t -= 116444736000000000i64;			// 1601/1/1  1970/1/1 ܂ł̌oߎ
										//   = 370 (years)
										//     * 365.25 (days/year)
										//     * 24 (hr/day)
										//     * 60 (min/hr)
										//     * 60 (sec/min)
										//     * 10,000,000 (100imbPʁj

	t /= 10;							// 100imb1}CNbPʂɕϊ

	tv->tv_sec  = (long) (t / 1000000);								// b
	tv->tv_usec = (long) (t % 1000000) + (dwTick % 1000) * 1000;	// }CNb;
	return 0;
}

#ifdef __cplusplus
}
#endif

#endif
