/* gnu_java_awt_peer_wce_WCECheckboxPeer.c
   Copyright (C) 2005, 2006 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCECheckboxPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCECheckboxPeer
 * Method:    createNativeCheckbox
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCECheckboxPeer_createNativeCheckbox(JNIEnv *env, jobject peer_obj, jint hwndParent, int x, int y, int width, int height, jobject checkBoxGroup) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	if (! peer_obj) {
		throw_AWTError(env, "NewGlobalRef() failed.");
		return 0;
	}
	return (jint) create_native_checkbox(peer_obj, (HWND) hwndParent, x, y, width, height, checkBoxGroup);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCECheckboxPeer
 * Method:    setNativeCheckboxGroup
 * Signature: (ILjava/awt/CheckboxGroup;)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCECheckboxPeer_setCheckboxGroup(JNIEnv *env, jobject peer_obj, jint windowHandle, jobject checkboxGroup) {
	set_checkbox_group((HWND) windowHandle, checkboxGroup);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCECheckboxPeer
 * Method:    getNativeState
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_java_awt_peer_wce_WCECheckboxPeer_getNativeState(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	BOOL checked = (BOOL) SendMessage((HWND) windowHandle, BM_GETCHECK, 0, 0);
	return checked ? JNI_TRUE : JNI_FALSE;
}

/*
 * Class:     gnu_java_awt_peer_wce_WCECheckboxPeer
 * Method:    setNativeState
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCECheckboxPeer_setNativeState(JNIEnv *env, jobject peer_obj, jint windowHandle, jboolean state) {
	SendMessage((HWND) windowHandle, BM_SETCHECK, (WPARAM) (state ? BST_CHECKED : BST_UNCHECKED), 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCECheckboxPeer
 * Method:    getNativePreferredSize
 * Signature: (I)Ljava/lang/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCECheckboxPeer_getNativePreferredSize(JNIEnv *env, jobject peer_obj, int windowHandle) {
	jclass clazz;
	jmethodID constructor_id;
	jobject dim;
	SIZE size;
	HWND hwnd = (HWND) windowHandle;
	int length, cx, cy, width, height;
	_TCHAR* buff;

	// ̃TCY擾
	// x擾
	length = (int) SendMessage(hwnd, WM_GETTEXTLENGTH, 0, 0);
	buff = (_TCHAR*) malloc(sizeof(_TCHAR) * (length + 1));
	if (! buff) {
		throw_AWTError(env, "Failed to allocate a buffer.");
		return NULL;
	}
	SendMessage(hwnd, WM_GETTEXT, (WPARAM) length + 1, (LPARAM) buff);
	get_text_extent_point(hwnd, buff, &size);
	free(buff);
	
	// VXe擾
	cx = GetSystemMetrics(SM_CXSMICON);
	cy = GetSystemMetrics(SM_CYSMICON);
	
	width = size.cx + cx;
	height = cy > size.cy ? cy : size.cy;

	clazz = (*env)->FindClass(env, "java/awt/Dimension");
	if (! clazz) {
		throw_AWTError(env, "Failed to load java.awt.Dimension");
		return NULL;
	}
	constructor_id = (*env)->GetMethodID(env, clazz, "<init>", "(II)V");
	if (! constructor_id) {
		throw_AWTError(env, "GetMethodID failed.");
		return NULL;
	}
	dim = (*env)->NewObject(env,
							clazz,
							constructor_id,
							width,
							height);
	return dim;
}
