/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.comm.wce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class WCESerialPort
extends SerialPort {
    private final int handle;
    private volatile boolean closed;
    private SerialPortEventListener listener;
    private BitSet eventMask = new BitSet();
    private Thread notifyThread;

    public WCESerialPort(String string, int n) {
        this.name = string;
        this.handle = n;
        this.notifyThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!WCESerialPort.this.closed) {
                    WCESerialPort.this.waitAndNotifyNativeEvents(WCESerialPort.this.handle);
                }
            }
        });
        this.notifyThread.setDaemon(true);
        this.notifyThread.start();
    }

    private void checkOpen() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Port closed");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkOpen();
        return new WCESerialPortInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.checkOpen();
        return new WCESerialPortOutputStream();
    }

    @Override
    public void close() {
        this.nativeClose(this.handle);
        this.closed = true;
        super.close();
    }

    private native void nativeClose(int var1);

    @Override
    public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        this.checkOpen();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public void disableReceiveThreshold() {
        this.checkOpen();
    }

    @Override
    public boolean isReceiveThresholdEnabled() {
        this.checkOpen();
        return false;
    }

    @Override
    public int getReceiveThreshold() {
        this.checkOpen();
        return 0;
    }

    @Override
    public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        this.checkOpen();
        this.enableNativeReceiveTimeout(this.handle, n);
    }

    native void enableNativeReceiveTimeout(int var1, int var2) throws UnsupportedCommOperationException;

    @Override
    public void disableReceiveTimeout() {
        this.checkOpen();
        this.disableNativeReceiveTimeout(this.handle);
    }

    native void disableNativeReceiveTimeout(int var1);

    @Override
    public boolean isReceiveTimeoutEnabled() {
        this.checkOpen();
        return this.isNativeReceiveTimeoutEnabled(this.handle);
    }

    native boolean isNativeReceiveTimeoutEnabled(int var1);

    @Override
    public int getReceiveTimeout() {
        this.checkOpen();
        return this.getNativeReceiveTimeout(this.handle);
    }

    native int getNativeReceiveTimeout(int var1);

    @Override
    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        this.checkOpen();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public void disableReceiveFraming() {
        this.checkOpen();
    }

    @Override
    public boolean isReceiveFramingEnabled() {
        this.checkOpen();
        return false;
    }

    @Override
    public int getReceiveFramingByte() {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setInputBufferSize(int n) {
        this.checkOpen();
        this.setNativeInputBufferSize(this.handle, n);
    }

    native void setNativeInputBufferSize(int var1, int var2);

    @Override
    public int getInputBufferSize() {
        this.checkOpen();
        return this.getNativeInputBufferSize(this.handle);
    }

    native int getNativeInputBufferSize(int var1);

    @Override
    public void setOutputBufferSize(int n) {
        this.checkOpen();
        this.setNativeOutputBufferSize(this.handle, n);
    }

    native void setNativeOutputBufferSize(int var1, int var2);

    @Override
    public int getOutputBufferSize() {
        this.checkOpen();
        return this.getNativeOutputBufferSize(this.handle);
    }

    native int getNativeOutputBufferSize(int var1);

    @Override
    public int getBaudRate() {
        this.checkOpen();
        return this.getNativeBaudRate(this.handle);
    }

    native int getNativeBaudRate(int var1);

    @Override
    public int getDataBits() {
        this.checkOpen();
        return this.getNativeDataBits(this.handle);
    }

    native int getNativeDataBits(int var1);

    @Override
    public int getStopBits() {
        this.checkOpen();
        return this.getNativeStopBits(this.handle);
    }

    native int getNativeStopBits(int var1);

    @Override
    public int getParity() {
        this.checkOpen();
        return this.getNativeParity(this.handle);
    }

    native int getNativeParity(int var1);

    @Override
    public void sendBreak(int n) {
        this.checkOpen();
        this.sendNativeBreak(this.handle, n);
    }

    native void sendNativeBreak(int var1, int var2);

    @Override
    public void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        this.checkOpen();
        this.setNativeFlowControlMode(this.handle, n);
    }

    native void setNativeFlowControlMode(int var1, int var2) throws UnsupportedCommOperationException;

    @Override
    public int getFlowControlMode() {
        this.checkOpen();
        return this.getNativeFlowControlMode(this.handle);
    }

    native int getNativeFlowControlMode(int var1);

    @Override
    public void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        this.checkOpen();
        this.setNativeSerialPortParams(this.handle, n, n2, n3, n4);
    }

    native void setNativeSerialPortParams(int var1, int var2, int var3, int var4, int var5) throws UnsupportedCommOperationException;

    @Override
    public void setDTR(boolean bl) {
        this.checkOpen();
        this.setNativeDTR(this.handle, bl);
    }

    native void setNativeDTR(int var1, boolean var2);

    @Override
    public boolean isDTR() {
        this.checkOpen();
        return false;
    }

    @Override
    public void setRTS(boolean bl) {
        this.checkOpen();
        this.setNativeRTS(this.handle, bl);
    }

    native void setNativeRTS(int var1, boolean var2);

    @Override
    public boolean isRTS() {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean isCTS() {
        this.checkOpen();
        return this.isNativeCTS(this.handle);
    }

    native boolean isNativeCTS(int var1);

    @Override
    public boolean isDSR() {
        this.checkOpen();
        return this.isNativeDSR(this.handle);
    }

    native boolean isNativeDSR(int var1);

    @Override
    public boolean isRI() {
        this.checkOpen();
        return this.isNativeRI(this.handle);
    }

    native boolean isNativeRI(int var1);

    @Override
    public boolean isCD() {
        this.checkOpen();
        return this.isNativeCD(this.handle);
    }

    native boolean isNativeCD(int var1);

    @Override
    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        this.checkOpen();
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = serialPortEventListener;
    }

    @Override
    public void removeEventListener() {
        this.listener = null;
    }

    private void setEventMask(int n, boolean bl) {
        this.checkOpen();
        this.eventMask.set(n, bl);
        this.setNativeEventMask(this.handle, n, bl);
    }

    native void setNativeEventMask(int var1, int var2, boolean var3);

    @Override
    public void notifyOnDataAvailable(boolean bl) {
        this.setEventMask(1, bl);
    }

    @Override
    public void notifyOnOutputEmpty(boolean bl) {
        this.setEventMask(2, bl);
    }

    @Override
    public void notifyOnCTS(boolean bl) {
        this.setEventMask(3, bl);
    }

    @Override
    public void notifyOnDSR(boolean bl) {
        this.setEventMask(4, bl);
    }

    @Override
    public void notifyOnRingIndicator(boolean bl) {
        this.setEventMask(5, bl);
    }

    @Override
    public void notifyOnCarrierDetect(boolean bl) {
        this.setEventMask(6, bl);
    }

    @Override
    public void notifyOnOverrunError(boolean bl) {
        this.setEventMask(7, bl);
    }

    @Override
    public void notifyOnParityError(boolean bl) {
        this.setEventMask(8, bl);
    }

    @Override
    public void notifyOnFramingError(boolean bl) {
        this.setEventMask(9, bl);
    }

    @Override
    public void notifyOnBreakInterrupt(boolean bl) {
        this.setEventMask(10, bl);
    }

    native int nativeRead(int var1) throws IOException;

    native int nativeRead(int var1, byte[] var2, int var3, int var4) throws IOException;

    native int availableBytes(int var1) throws IOException;

    native void nativeWrite(int var1, int var2) throws IOException;

    native void nativeWrite(int var1, byte[] var2, int var3, int var4) throws IOException;

    void notifyEvent(int n, boolean bl, boolean bl2) {
        if (this.listener != null && this.eventMask.get(n)) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, n, bl, bl2);
            this.listener.serialEvent(serialPortEvent);
        }
    }

    native void waitAndNotifyNativeEvents(int var1);

    class WCESerialPortOutputStream
    extends OutputStream {
        WCESerialPortOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            WCESerialPort.this.nativeWrite(WCESerialPort.this.handle, n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            WCESerialPort.this.nativeWrite(WCESerialPort.this.handle, byArray, n, n2);
        }
    }

    class WCESerialPortInputStream
    extends InputStream {
        WCESerialPortInputStream() {
        }

        @Override
        public int read() throws IOException {
            return WCESerialPort.this.nativeRead(WCESerialPort.this.handle);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return WCESerialPort.this.nativeRead(WCESerialPort.this.handle, byArray, n, n2);
        }

        @Override
        public int available() throws IOException {
            return WCESerialPort.this.availableBytes(WCESerialPort.this.handle);
        }
    }
}

