<?php
// vim: foldmethod=marker
/**
 *  Ethna_Renderer.php
 *
 *  @author     Kazuhiro Hosoi <hosoi@gree.co.jp>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Renderer.php,v 1.6 2006/11/28 04:52:54 ichii386 Exp $
 */

// {{{ Ethna_Renderer
/**
 *  饯饹MojaviΤޤ͡
 *
 *  @author     Kazuhiro Hosoi <hosoi@gree.co.jp>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Renderer
{
    /**#@+
     *  @access private
     */

    /** @var    object  Ethna_Controller    controller֥ */
    var $controller;

    /** @var    object  Ethna_Controller    controller֥($controllerξά) */
    var $ctl;

    /** @var    string  template directory  */
    var $template_dir;

    /** @var    string  template engine */
    var $engine;

    /** @var    string  template file */
    var $template;

    /** @var    string  ƥץ졼ѿ */
    var $prop;
    
    /** @var    string  ץ饰(Ethna_PluginȤϴطʤ) */
    var $plugin_registry;
    
    /**
     *  Ethna_Renderer饹Υ󥹥ȥ饯
     *
     *  @access public
     */
    function Ethna_Renderer(&$controller)
    {
        $this->controller =& $controller;
        $this->ctl =& $this->controller;
        $this->template_dir = null;
        $this->engine = null;
        $this->template = null;
        $this->prop = array();
        $this->plugin_registry = array();
    }

    /**
     *  ӥ塼Ϥ
     *
     *  @param string   $template   ƥץ졼
     *
     *  @access public
     */
    function perform($template = null)
    {
        if ($template == null && $this->template == null) {
            return Ethna::raiseWarning('template is not defined');
        }

        if ($template != null) {
            $this->template = $template;
        }

        // ƥץ졼Ȥ̵ͭΥå
        if (is_readable($this->template_dir . $this->template)) {
            include_once $this->template_dir . $this->template;
        } else {
            return Ethna::raiseWarning("template is not found: " . $this->template);
        }
    }

    /**
     *  ƥץ졼ȥ󥸥
     * 
     *  @return object   Template Engine.
     * 
     *  @access public
     */
    function &getEngine()
    {
        return $this->engine;
    }

    /**
     *  ƥץ졼ȥǥ쥯ȥ
     * 
     *  @return string   Template Directory
     * 
     *  @access public
     */
    function getTemplateDir()
    {
        return $this->template_dir;
    }

    /**
     *  ƥץ졼ѿ
     * 
     *  @param string $name  ѿ̾
     * 
     *  @return mixed    ѿ
     * 
     *  @access public
     */
    function &getProp($name)
    {
        if (isset($this->prop[$name])) {
            return $this->prop[$name];
        }

        return null;
    }

    /**
     *  ƥץ졼ѿ
     * 
     *  @param name    ѿ̾
     * 
     *  @access public
     */
    function &removeProp($name)
    {
        if (isset($this->prop[$name])) {
            unset($this->prop[$name]);
        }
    }

    /**
     *  ƥץ졼ѿƤ
     * 
     *  @param array $array
     * 
     *  @access public
     */
    function setPropArray($array)
    {
        $this->prop = array_merge($this->prop, $array);
    }

    /**
     *  ƥץ졼ѿ򻲾ȤȤƳƤ
     * 
     *  @param array $array
     * 
     *  @access public
     */
    function setPropArrayByRef(&$array)
    {
        $keys  = array_keys($array);
        $count = sizeof($keys);

        for ($i = 0; $i < $count; $i++) {
            $this->prop[$keys[$i]] =& $array[$keys[$i]];
        }
    }

    /**
     * ƥץ졼ѿƤ
     * 
     * @param string $name ѿ̾
     * @param mixed $value 
     * 
     * @access public
     */
    function setProp($name, $value)
    {
        $this->prop[$name] = $value;
    }

    /**
     *  ƥץ졼ѿ˻ȤƤ
     * 
     *  @param string $name ѿ̾
     *  @param mixed $value 
     * 
     *  @access public
     */
    function setPropByRef($name, &$value)
    {
        $this->prop[$name] =& $value;
    }

    /**
     *  ƥץ졼ȤƤ
     * 
     *  @param string $template ƥץ졼̾
     * 
     *  @access public
     */
    function setTemplate($template)
    {
        $this->template = $template;
    }

    /**
     *  ƥץ졼ȥǥ쥯ȥƤ
     * 
     *  @param string $dir ǥ쥯ȥ̾
     * 
     *  @access public
     */
    function setTemplateDir($dir)
    {
        $this->template_dir = $dir;

        if (substr($this->template_dir, -1) != '/') {
            $this->template_dir .= '/';
        }
    }
    
    /**
     *  ƥץ졼Ȥ̵ͭå
     * 
     *  @param string $template ƥץ졼̾
     * 
     *  @access public
     */
    function templateExists($template)
    {
        if (substr($this->template_dir, -1) != '/') {
            $this->template_dir .= '/';
        }

        return (is_readable($this->template_dir . $template));
    }

    /**
     *  ץ饰򥻥åȤ
     * 
     *  @param string $nameץ饰̾
     *  @param string $type ץ饰󥿥
     *  @param string $plugin ץ饰
     * 
     *  @access public
     */
    function setPlugin($name, $type, $plugin)
    {
        $this->plugin_registry[$type][$name] = $plugin;
    }

    // {{{ proxy methods (for B.C.)
    /**
     *  ƥץ졼ѿƤ(ߴ)
     *
     *  @access public
     */
    function assign($name, $value)
    {
        $this->setProp($name, $value);
    }

    /**
     *  ƥץ졼ѿ˻ȤƤ(ߴ)
     *
     *  @access public
     */
    function assign_by_ref($name, &$value)
    {
        $this->setPropByRef($name, $value);
    }

    /**
     *  ӥ塼Ϥ
     *
     *  @access public
     */
    function display($template = null)
    {
        return $this->perform($template);
    }
    // }}}
}
// }}}
?>
