/***************************************************************************
 *   Copyright (C) 2009 by Husky                                           *
 * 　husky@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation; either version 3 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <my_global.h>
#include <m_string.h>
#include <mysql.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int hiragana_convert(char word);

/**
 * Initialization
 */
my_bool alpha_to_hiragana_init(UDF_INIT *initid, UDF_ARGS *args, char *message) {
    
    if (args->arg_count != 1) {
        strmov(message, "This function takes 1 argument");
        return 1;
    }

    if (args->arg_type[0] != STRING_RESULT) {
        args->arg_type[0] = STRING_RESULT;
    }

    initid->maybe_null = 1; 
    return 0;
}

/**
 * Main method
 */
char *alpha_to_hiragana(UDF_INIT *initid, UDF_ARGS *args, char *result, unsigned long *length, char *is_null, char *error) {

    if (args->args[0] != NULL) {
    int i, x;

        args->args[0][args->lengths[0]] = '\0';
        x = strlen(args->args[0]);

        for (i = 0; i < x; i++) {
            if (isalpha(args->args[0][i])) {
                result[i] = hiragana_convert(args->args[0][i]);
            } else {
                result[i] = args->args[0][i];
            }
        }

        result[i] = '\0';
        *length = x;
    } else {
        *length = 0;
        result = NULL;
    }
    return result;
}

/**
 * Deinitialization
 */
void alpha_to_hiragana_deinit(UDF_INIT *initid) {
}

/**
 * From Alphabet to Japanese word 'hiragana' 
 */
int hiragana_convert(char word){
    char data;

    switch (tolower(word)) {
    case 'a':
        data = 'a';
        break;
    case 'i':
        data = 'b';
        break;
    case 'u':
        data = 'c';
        break;
    case 'e':
        data = 'd';
        break;
    case 'o':
        data = 'e';
        break;
    case 'k':
    case 'g':
    case 'q':
        data = 'f';
        break;
    case 's':
    case 'z':
    case 'j':
    case 'x':
        data = 'g';
        break;
    case 't':
    case 'd':
    case 'c':
        data = 'h';
        break;
    case 'n':
        data = 'i';
        break;
    case 'h':
    case 'f':
    case 'b':
    case 'p':
    case 'v':
        data = 'j';
        break;
    case 'm':
        data = 'k';
        break;
    case 'y':
        data = 'l';
        break;
    case 'r':
    case 'l':
        data = 'm';
        break;
    case 'w':
        data = 'n';
        break;
    default:
        data = 'o';
    }
    return data;
}
