/***************************************************************************
 *   Copyright (C) 2010 by fukaoi                                          *
 * 　husky@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation; either version 3 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <my_global.h>
#include <m_string.h>
#include <mysql.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int hiragana_convert(char word);
char *hiragana_header(char word);
char *groups;

/**
 * Initialization
 */
my_bool alpha_to_hiragana_init(UDF_INIT *initid, UDF_ARGS *args, char *message) {
    
    if (args->arg_count != 1) {
        strmov(message, "This function takes 1 argument");
        return 1;
    }

    if (args->arg_type[0] != STRING_RESULT) {
        args->arg_type[0] = STRING_RESULT;
    }

    initid->maybe_null = 1; 
    return 0;
}

/**
 * Main method
 */
char *alpha_to_hiragana(
		                UDF_INIT *initid __attribute__((unused)),
                        UDF_ARGS *args, 
                        char *result, 
                        unsigned long *length, 
                        char *is_null __attribute__((unused)),
                        char *error __attribute__((unused))
                        ) {

    if (args->args[0] == NULL) {
		*length = 0;
		return NULL;
	}
	int i, x;

	args->args[0][args->lengths[0]] = '\0';
	x = strlen(args->args[0]);

	for (i = 0; i < x; i++) {
		if (i == 0) {
			groups = hiragana_header(args->args[0][0]);
		}
		if (isalpha(args->args[0][i])) {
			result[i] = hiragana_convert(args->args[0][i]);
		} else {
			result[i] = args->args[0][i];
		}
	}
	result[i] = '\0';
	*length = x;
	return result;
}

/**
 * Deinitialization
 */
void alpha_to_hiragana_deinit(UDF_INIT *initid __attribute__((unused))) {
}

//------------------------------------------------------------------------------//

/**
 * Initialization
 */
my_bool hiragana_group_init(UDF_INIT *initid, UDF_ARGS *args, char *message) {
    if (args->arg_count != 1) {
        strmov(message, "This function takes 1 argument");
        return 1;
    }
    if (args->arg_type[0] != STRING_RESULT) {
        args->arg_type[0] = STRING_RESULT;
    }
    initid->maybe_null = 1;
    return 0;
}

/**
 * Get hiragana line name
 */
char *hiragana_group(UDF_INIT *initid __attribute__((unused)),
                     UDF_ARGS *args __attribute__((unused)),
                     char *result __attribute__((unused)),
                     unsigned long *length_h,
                     char *is_null __attribute__((unused)),
                     char *error __attribute__((unused))) {
  *length_h = 2;
  return groups;
}

/**
 * Deinitialization
 */
void hiragana_group_deinit(UDF_INIT *initid __attribute__((unused)) ) {
}

//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//

/**
 * From Alphabet to Japanese word 'hiragana' 
 */
int hiragana_convert(char word){

	int conv_word;

	switch (tolower(word)) {
	case 0x61: // a
		conv_word = 0x61; // a
		break;
	case 0x69: // i
		conv_word = 0x62; // b
		break;
	case 0x75: // u
		conv_word = 0x63; // c
		break;
	case 0x65: // e
		conv_word = 0x64; // d
		break;
	case 0x6f: // o
		conv_word = 0x65; // e
		break;
	case 0x6b: // k
	case 0x67: // g
	case 0x71: // q
		conv_word = 0x66; // f
		break;
	case 0x73: // s
	case 0x7a: // z
	case 0x6a: // j
	case 0x78: // x
		conv_word = 0x67; // g
		break;
	case 0x74: // t
	case 0x64: // d
	case 0x63: // c
		conv_word = 0x68; // h
		break;
	case 0x6e: // n
		conv_word = 0x69; // i
		break;
	case 0x68: // h
	case 0x66: // f
	case 0x62: // b
	case 0x70: // p
	case 0x76: // v
		conv_word = 0x6a; // j
		break;
	case 0x6d: // m
		conv_word = 0x6b; // k
		break;
	case 0x79: // y
		conv_word = 0x6c; // l
		break;
	case 0x72: // r
	case 0x6c: // l
		conv_word = 0x6d; // m
		break;
	case 0x77: // w
		conv_word = 0x6e; // n
		break;
	default:
		conv_word = 0x6f; // o
	}
	return conv_word;
}

/**
 * Return 'hiragana' group name
 */
char *hiragana_header(char word){
	char *conv_word;

	switch (tolower(word)) {
	case 0x61: // a
	case 0x69: // i
	case 0x75: // u
	case 0x65: // e
	case 0x6f: // o
		conv_word = "a"; // a
		break;
	case 0x6b: // k
	case 0x67: // g
	case 0x71: // q
		conv_word = "ka"; // ka
		break;
	case 0x73: // s
	case 0x7a: // z
	case 0x6a: // j
	case 0x78: // x
		conv_word = "sa"; // sa
		break;
	case 0x74: // t
	case 0x64: // d
	case 0x63: // c
		conv_word = "ta"; // ta
		break;
	case 0x6e: // n
		conv_word = "na"; // na
		break;
	case 0x68: // h
	case 0x66: // f
	case 0x62: // b
	case 0x70: // p
	case 0x76: // v
		conv_word = "ha"; // ha
		break;
	case 0x6d: // m
		conv_word = "ma"; // ma
		break;
	case 0x79: // y
		conv_word = "ya"; // ya
		break;
	case 0x72: // r
	case 0x6c: // l
		conv_word = "ra"; // ra
		break;
	case 0x77: // w
		conv_word = "wa"; // wa
		break;
	default:
		conv_word = NULL; // no match
	}
	return conv_word;
}
