/*
    TCFbECsvOutputFormatter.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbECsvOutputFormatter.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall TCFbECsvOutputFormatter::TCFbECsvOutputFormatter(TCFbECommandLineParser* Parser, TCFbEOutputCash* OutputCash, bool IsVerbose)
    : TCFbEOutputFormatter(Parser, OutputCash, IsVerbose)
{
}

//---------------------------------------------------------------------------
__fastcall TCFbECsvOutputFormatter::~TCFbECsvOutputFormatter()
{
}

//---------------------------------------------------------------------------
// wb_ this->FOutputStringList ɒǉDwb_KvłȂꍇ͂ return D
void __fastcall TCFbECsvOutputFormatter::OutputHeader(void)
{
    // xo
    AnsiString ALine = "Label";
    for (int j = 0; j < this->OutputCash->GetNumberOfColumns(); j++) {
        if (this->OutputCash->IsResultedColumn(j)) {
            ALine += "," + this->OutputCash->GetResultColumnLabel(j);
        }
    }

    // "l̕z" x̏o
    if (this->Parser->DisplayDistribution) {
        ALine += ",Distributions of Similarities";
        for (int k = 1; k < 20; k++) {
            ALine += ",";
        }
    }

    // "Neighbor̃x" x̏o
    if (this->Parser->DisplayNeighbors) {
        ALine += ",Neighbors' Labels";
        for (int k = 1; k < this->Parser->NeighborsSize; k++) {
            ALine += ",";
        }
    }

    // "Neighbor̗ގx" x̏o
    if (this->Parser->DisplaySimilarities) {
        ALine += ",Neighbors' Similarities";
        for (int k = 1; k < this->Parser->NeighborsSize; k++) {
            ALine += ",";
        }
    }

    // "Neighbor̒l" x̏o
    if (this->Parser->DisplayValues) {
        ALine += ",Neighbors' Values";
        for (int k = 1; k < this->Parser->NeighborsSize; k++) {
            ALine += ",";
        }
    }

    this->FOutputStringList->Add(ALine);
}

//---------------------------------------------------------------------------
// {fB this->FOutputStringList ɒǉD
void __fastcall TCFbECsvOutputFormatter::OutputBody(int TargetRowIndex)
{
    // sx̏o
    AnsiString    ALine = this->OutputCash->GetResultRowLabel(TargetRowIndex);

    // \ʂ̒l̏o
    for (int j = 0; j < this->OutputCash->GetNumberOfColumns(); j++) {
        if (this->OutputCash->IsResultedColumn(j)) {
            ALine += ",";
        }
        if (this->OutputCash->GetResultEnabled(TargetRowIndex, j)) {
            ALine += FloatToStr(this->OutputCash->GetResultValue(TargetRowIndex, j));
        } else if (this->OutputCash->GetResultFailed(TargetRowIndex, j)) {
            ALine += "FAILED!";
        }
    }

    // ގx̕z̏o
    if (this->Parser->DisplayDistribution) {
        for (int k = 19; k >= 0; k--) {
            ALine += "," + IntToStr(this->OutputCash->GetDistribution(TargetRowIndex, k));
        }
    }

    // Neighbor ̃x̏o
    if (this->Parser->DisplayNeighbors) {
        for (int k = 0; k < this->OutputCash->GetNumberOfNeighbors(TargetRowIndex); k++) {
            ALine += "," + this->OutputCash->GetNeighbor(TargetRowIndex, k)->Label;
        }
    }

    // Neighbor̗ގx ̏o
    if (this->Parser->DisplaySimilarities) {
        for (int k = 0; k < this->OutputCash->GetNumberOfNeighbors(TargetRowIndex); k++) {
            ALine += "," + FloatToStr(this->OutputCash->GetNeighbor(TargetRowIndex, k)->Similarity);
        }
    }

    // Neighbor̒l̏o
    if (this->Parser->DisplayValues) {
        for (int k = 0; k < this->OutputCash->GetNumberOfNeighbors(TargetRowIndex); k++) {
            ALine += "," + FloatToStr(this->OutputCash->GetNeighbor(TargetRowIndex, k)->SourceValue);
        }
    }

    this->FOutputStringList->Add(ALine);
}

//---------------------------------------------------------------------------

