/*
    docfbe_test.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.
                                  
    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop
#pragma argsused       
//---------------------------------------------------------------------------
// for Leak Check
#include <cppunit/cudebug.h>

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT           
//---------------------------------------------------------------------------
#include "TCFbETestCase0.cpp"
#include "TCFbETestCase2.cpp"
#include "TCFbETestCase4.cpp"

#include "TCFbEToolkit.h"
//---------------------------------------------------------------------------
// #define ENABLE_LEAK_CHECKER
#if defined(ENABLE_LEAK_CHECKER) && defined(_MSC_VER)
#  pragma warning(disable:4073)
#  pragma init_seg(lib)
LeakChecker g_leakChecker;
#endif

class TCFbETestSuite : public TestSuite
{
public:
    Test* GetTestCase0() {
        TestSuite* TestCase0 = new TestSuite("TCFbETestCase0");
//        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_DB));
      
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_AdoptData_tmbLearningData));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_AdoptData_tmbEstimatingData));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_AdoptData_tmbBoth));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_Merge));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbECsvOutputFormatter_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbERecommendationOutputFormatter_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_module1_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEOutputCash_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEOutputCash_TCFbETCFbEDistanceSimilarityWithMedian_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbStandardizedValue_abColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEOutputCash_Jacknifing1));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEOutputCash_Jacknifing2));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEOutputCash_Reuse));
                    
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataSet));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbECommandLineParser));

        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_Assign));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_AssignWithTurn));

        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMaxOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMinOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetAverageOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMedianOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetStdevOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetInversedDistanceOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetAveragedMultiplierOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMedianOfMultiplierOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetWeightedMultiplierOfRow));

        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMaxOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMinOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetAverageOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMedianOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetStdevOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetInversedDistanceOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetInversedDistanceOfColumn2));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetInversedDistanceOfColumn3));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetInversedDistanceOfColumn4));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetAveragedMultiplierOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetMedianOfMultiplierOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETable_GetWeightedMultiplierOfColumn));
        return TestCase0;
    }

    Test* GetTestCase2() {
        TestSuite* TestCase2 = new TestSuite("TCFbETestCase2");
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetRowLabelList));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetColumnLabelList));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetValues));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbStandardizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbStandardizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbNormalizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbNormalizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbOrder_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbOrder_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbStandardizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbStandardizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbNormalizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbNormalizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbOrder_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbOrder_abColumn));

        /////////
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleStandardizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleStandardizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleNormalizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleNormalizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleOrder_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbDoubleOrder_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleStandardizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleStandardizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleOrder_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbDoubleOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleOrder_abColumn));


        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow_DefaultValue));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedValues_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAverageOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetAppliedWeightedMultiplierOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow_CaseAmplification));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetICFCoefficient_vbValue_abRow_InverseCaseFrequency));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableValues_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableAverageOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableAverageOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableAveragedMultiplierOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfMultiplierOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableWeightedMultiplierOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abRow_InverseCaseFrequency));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableValues_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableAverageOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableAverageOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableAveragedMultiplierOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableMedianOfMultiplierOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSet_GetSimilarityComputationTableWeightedMultiplierOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbValue_abColumn_InverseCaseFrequency));

        return TestCase2;
    }

    Test* GetTestCase4() {
        TestSuite* TestCase4 = new TestSuite("TCFbETestCase4");

        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEDataSet_TemporaryUnable_vbNormalizedValue));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEDataSet_TemporaryUnable_vbDoubleStandardizedValue));

        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_CopyRowFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_CopyRowAsColumnFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_CopyColumnFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_CopyColumnAsRowFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialNormalize));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialStandardize));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialOrdering));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialRowNormalize));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialRowNormalizeOnColumn));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialRowStandardize));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialRowStandardizeOnColumn));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETable_PartialDoubleNormalize));

        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbECosineSimilarity_vbValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbNormalizedValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEWeightedSum_vbNormalizedValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEOutputCash_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow));
        return TestCase4;
    }
};

//---------------------------------------------------------------------------
int main(int argc, char* argv[])
{
#if defined(ENABLE_LEAK_CHECKER) && !defined(_MSC_VER)
    LeakChecker checker;
#endif

    TestRunner    testRunner;
    TCFbETestSuite    testSuite;
    testRunner.addTest("TCFbETestCase0", testSuite.GetTestCase0());
    testRunner.addTest("TCFbETestCase2", testSuite.GetTestCase2());
    testRunner.addTest("TCFbETestCase4", testSuite.GetTestCase4());
    int ReturnValue = testRunner.run(argc, argv);
    TCFbEToolkit::DeleteToolkit();
    return ReturnValue;
}

// ȉ̋Lq̓fobOpȂ̂ŖĂB
#ifdef USE_DEBUGTOOLS
#  include <debug/debugtools.cpp>
#endif

#if defined(ENABLE_LEAK_CHECKER) && defined(_MSC_VER)
#  pragma warning(disable:4073)
#  pragma init_seg(lib)
LeakChecker g_leakChecker;
#endif

//---------------------------------------------------------------------------
