/*
    TCFbEDataSet.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEDataSetH
#define TCFbEDataSetH
//---------------------------------------------------------------------------
// #include "Maprof.h"

#include "math.h"
#include "TCFbEToolkit.h"
#include "TCFbETable.h"
#include "TCFbECell.h"
#include "TCFbENeighbor.h"

class TCFbESimilarityComputationAlgorithm;
#include "TCFbESimilarityComputationAlgorithm.h"

class TCFbEPredictionAlgorithm;
#include "TCFbEPredictionAlgorithm.h"
//---------------------------------------------------------------------------
// Ăl
enum TCFbEValueBase { vbUnknown, vbValue, vbStandardizedValue, vbNormalizedValue, vbOrder, vbDoubleStandardizedValue, vbDoubleNormalizedValue, vbDoubleOrder };

// x[X̃ASYiabUnknown Ȃ abRow ƓlƂ݂Ȃ
enum TCFbEAlgorithmBase { abUnknown, abRow, abColumn };
//---------------------------------------------------------------------------
// Facade IȃNX
class TCFbEDataSet : public TObject
{
public:
    // ANZT
    virtual double __fastcall GetSourceValue(AnsiString RowLabel, AnsiString ColumnLabel) {
        return this->FSourceTable->GetCell(RowLabel, ColumnLabel)->GetValue();
    }

    virtual void __fastcall SetSourceValue(AnsiString RowLabel, AnsiString ColumnLabel, double Value) {
        this->IsUpdated();
        this->FSourceTable->GetCellByIndex(this->FSourceTable->RowIsUpdated(RowLabel), this->FSourceTable->ColumnIsUpdated(ColumnLabel))->SetValue(Value);
    }

    virtual double __fastcall GetValueByIndex(int RowIndex, int ColumnIndex) {
        return this->FSourceTable->GetCellByIndex(RowIndex, ColumnIndex)->GetValue();
    }

    virtual void __fastcall SetValuesByIndex(int RowIndex, int ColumnIndex, double Value) {
        this->IsUpdated();
        this->FSourceTable->RowIsUpdated(RowIndex);
        this->FSourceTable->ColumnIsUpdated(ColumnIndex);
        this->FSourceTable->GetCellByIndex(RowIndex, ColumnIndex)->SetValue(Value);
    }

    virtual bool __fastcall GetEnabled(AnsiString RowLabel, AnsiString ColumnLabel) {
        return this->FSourceTable->GetCell(RowLabel, ColumnLabel)->GetEnabled();
    }

    virtual void __fastcall SetEnabled(AnsiString RowLabel, AnsiString ColumnLabel, bool Value) {
        this->IsUpdated();
        this->FSourceTable->GetCellByIndex(this->FSourceTable->RowIsUpdated(RowLabel), this->FSourceTable->ColumnIsUpdated(ColumnLabel))->SetEnabled(Value);
    }

    virtual bool __fastcall GetEnabledByIndex(int RowIndex, int ColumnIndex) {
        return this->FSourceTable->GetCellByIndex(RowIndex, ColumnIndex)->GetEnabled();
    }

    virtual void __fastcall SetEnabledByIndex(int RowIndex, int ColumnIndex, bool Value) {
        this->IsUpdated();
        this->FSourceTable->RowIsUpdated(RowIndex);
        this->FSourceTable->ColumnIsUpdated(ColumnIndex);
        this->FSourceTable->GetCellByIndex(RowIndex, ColumnIndex)->SetEnabled(Value);
    }

    virtual int __fastcall GetNumberOfRows(void) {
        return this->FSourceTable->GetNumberOfRows();
    }

    virtual int __fastcall GetNumberOfColumns(void) {
        return this->FSourceTable->GetNumberOfColumns();
    }

    virtual TStringList* __fastcall GetRowLabelList(void) {
        return this->FSourceTable->GetRowLabelList();
    }

    virtual TStringList* __fastcall GetColumnLabelList(void) {
        return this->FSourceTable->GetColumnLabelList();
    }

    virtual TCFbETable* __fastcall GetSimilarityComputationTable(void) {
        if (!this->FAppliedTableArePrepared) {
            Exception("AppliedValues are not prepared.");
        }
        return this->FSimilarityComputationTable;
    }

    virtual TCFbETable* __fastcall GetPredictionTable(void) {
        if (!this->FAppliedTableArePrepared) {
            Exception("AppliedValues are not prepared.");
        }
        return this->FPredictionTable;
    }

    virtual double __fastcall GetSimilarity(AnsiString TargetRowLabel, AnsiString ComparedRowLabel) {
        return this->GetSimilarityByIndex(this->GetRowLabelList()->IndexOf(TargetRowLabel), this->GetRowLabelList()->IndexOf(ComparedRowLabel));
    }

    virtual double __fastcall GetPredictedValue(AnsiString TargetRowLabel, AnsiString TargetColumnLabel) {
        return this->GetPredictedValueByIndex(this->GetRowLabelList()->IndexOf(TargetRowLabel), this->GetColumnLabelList()->IndexOf(TargetColumnLabel));
    }

    virtual double __fastcall GetSimilarityByIndex(int TargetRowIndex, int ComparedRowIndex);
    virtual double __fastcall GetPredictedValueByIndex(int TargetRowIndex, int TargetColumnIndex);

    virtual TCFbESimilarityComputationAlgorithm*    GetSimilarityComputationAlgorithm(void) { return this->FSimilarityComputationAlgorithm; }
    virtual TCFbEPredictionAlgorithm*               GetPredictionAlgorithm(void) { return this->FPredictionAlgorithm; }

    
    virtual __fastcall TCFbEDataSet(void);    // RXgN^
    virtual __fastcall TCFbEDataSet(TStringList* SourceCsvStringList);    // RXgN^
    __fastcall ~TCFbEDataSet();    // fXgN^

    virtual void    __fastcall PrepareCF(TCFbEValueBase ValueBase, TCFbEAlgorithmBase AlgorithmBase, TCFbESimilarityComputationAlgorithm* SimilarityComputationAlgorithm, TCFbEPredictionAlgorithm* PredictionAlgorithm, int NeighborhoodSize, bool DefaultValueEnabled, double DefaultValue, bool InverseCaseFrequencyEnabled, double CaseAmplifier);    // CF ̏siPredictionTable 
    virtual bool    __fastcall TemporaryChangeEnabled(int TargetRowIndex, int TargetColumnIndex, bool Value);   // TargetRowIndex sځCTargetColumnIndex ڂ̃Z Enabled ꎞI Value ɂ
    virtual void    __fastcall TemporaryUnable(int TargetRowIndex, int TargetColumnIndex);    // TargetRowIndex, TargetColumnIndex ̃ZꎞI Enabled = false ɂ
    virtual void    __fastcall RecoverEnabled(void);    // ꎞI Enabled = false ɂĂZɂǂ

    virtual void    __fastcall DeleteValue(AnsiString RowLabel, AnsiString ColumnLabel);    // RowLabel, ColumnLabel ̃Z폜iEnabled = false ɂ

    virtual int     __fastcall CopyRowFrom(TCFbEDataSet* SourceDataSet, int SourceRowIndex, bool AddColumn=true);    // DataSet  RowIndex sڂXV
    virtual int     __fastcall AddRow(AnsiString RowLabel);    // sǉD
    virtual void    __fastcall DeleteRow(AnsiString RowLabel);    // s폜D
    virtual int     __fastcall AddColumn(AnsiString ColumnLabel);    // ǉD
    virtual void    __fastcall DeleteColumn(AnsiString ColumnLabel);    // 폜D

    virtual double  __fastcall GetICFCoefficient(int j);    // j ڂ Inverse Case Frequency Coefficient 𓾂
    virtual void __fastcall GetNearestNeighbors(int TargetRowIndex, int TargetColumnIndex, int NeighborhoodSize, TObjectList* NeighborList);    // TargetRowIndex ɑ΂ NearestNeigobors 𒲂ׂ

    virtual void    __fastcall FillColumns(TCFbEDataSet* BaseDataSet);    // BaseDataSet ɂāCthis ɂȂVȗƂĒǉ
    virtual bool    __fastcall IsConsistentWith(TCFbEDataSet* TargetDataSet);    // TargetDataSet Ǝѐ邩ǂ𒲂ׂ

    virtual double  __fastcall DisNormalize(int ColumnIndex, double NormalizedValue);    // ColumnIndex ڂ Normalize ꂽl NormalizedValue  DisNormalize ĕԂ
    virtual double  __fastcall DisStandardize(int ColumnIndex, double StandardizedValue);    // ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisStandardize ĕԂ
    virtual double  __fastcall DisOrdering(int ColumnIndex, double Order);    // ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ
    virtual double  __fastcall DisDoubleNormalize(int RowIndex, int ColumnIndex, double DoubleNormalizedValue);    // RowIndex sځCColumnIndex ڂ DoubleNormalize ꂽl DoubleNormalizedValue  DisDoubleNormalize ĕԂ
    virtual double  __fastcall DisDoubleStandardize(int RowIndex, int ColumnIndex, double DoubleStandardizedValue);    // RowIndex sځCColumnIndex ڂ DoubleStandardize ꂽl DoubleStandardizedValue  DisDoubleStandardize ĕԂ
    virtual double  __fastcall DisDoubleOrdering(int RowIndex, int ColumnIndex, double DoubleOrder);    // RowIndex sځCColumnIndex ڂ DoubleOrdering ꂽl DoubleOrder  DisDoubleOrdering ĕԂ

protected:
    TCFbEValueBase      FValueBase;
    TCFbEAlgorithmBase  FAlgorithmBase;
    TCFbETable*         FSourceTable;
    TCFbETable*         FSimilarityComputationTable;
    TCFbETable*         FPredictionMediateTable;
    TCFbETable*         FPredictionTable;
    bool                FAppliedTableArePrepared;
    TCFbESimilarityComputationAlgorithm*    FSimilarityComputationAlgorithm;
    TCFbEPredictionAlgorithm*               FPredictionAlgorithm;
    int                 FNeighborhoodSize;
    bool                FDefaultValueEnabled;
    double              FDefaultValue;
    bool                FInverseCaseFrequencyEnabled;
    double              FCaseAmplifier;
    TObjectList*        FSimilarityList;
    int                 TargetRowIndexOfSimilarity;
    TObjectList*        FPredictedValueList;
    int                 TargetRowIndexOfPrediction;
    int                 TemporaryUnableRowIndex;
    int                 TemporaryUnableColumnIndex;

    // Abvf[gꂽƂ}[NCLbVNA
    virtual void __fastcall IsUpdated(void) {
        this->FAppliedTableArePrepared = false;
        this->TargetRowIndexOfSimilarity = -1;
        this->TargetRowIndexOfPrediction = -1;
    }

    virtual void __fastcall CsvToStrings2(char* str, TStrings *List);    // CSV`̕TStringsɕ

private:

};
//---------------------------------------------------------------------------
#endif
