/*
    TCFbEOutputCash.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEOutputCashH
#define TCFbEOutputCashH
//---------------------------------------------------------------------------
#include <system.hpp>
#include <Classes.hpp>
#include <stdio.h>
#include <Math.hpp>

#include "EDocfbeError.h"

#include "TCFbEDataSet.h"
#include "TCFbECommandLineParser.h"
#include "TCFbEDataLoader.h"

#include "TCFbETable.h"
//---------------------------------------------------------------------------
class TCFbEOutputCash : public TObject
{
public:
    virtual __fastcall TCFbEOutputCash(TCFbECommandLineParser* Parser, TCFbEDataLoader* DataLoader, bool IsVerbose=false);    // RXgN^
    __fastcall ~TCFbEOutputCash();    // fXgN^

    virtual int __fastcall GetNumberOfRows(void) { return this->FResultTable->GetNumberOfRows(); }
    virtual int __fastcall GetNumberOfColumns(void) { return this->FResultTable->GetNumberOfColumns(); }

    virtual AnsiString __fastcall GetResultRowLabel(int RowIndex);
    virtual AnsiString __fastcall GetResultColumnLabel(int ColumnIndex);

    virtual bool __fastcall IsResultedColumn(int ColumnIndex) { return this->FIsResultedColumn[ColumnIndex]; }    // ColumnIndex ڂɌʂo͂Ă邩ǂ𒲂ׂ
    virtual bool __fastcall GetResultEnabled(int RowIndex, int ColumnIndex) { return this->FResultTable->GetCellByIndex(RowIndex, ColumnIndex)->GetEnabled(); }
    virtual double __fastcall GetResultValue(int RowIndex, int ColumnIndex) { return this->FResultTable->GetCellByIndex(RowIndex, ColumnIndex)->GetValue(); }
    virtual bool __fastcall GetResultFailed(int RowIndex, int ColumnIndex) { return this->FResultTable->GetCellByIndex(RowIndex, ColumnIndex)->GetRank() == 0.0; }

    virtual int __fastcall GetNumberOfNeighbors(int TargetIndex) { return ((TObjectList*)this->FNeighborsList->Items[TargetIndex])->Count; }
    virtual TCFbENeighbor* __fastcall GetNeighbor(int TargetIndex, int NeighborsIndex) { return (TCFbENeighbor*)((TObjectList*)this->FNeighborsList->Items[TargetIndex])->Items[NeighborsIndex]; }
    virtual int __fastcall GetDistribution(int TargetIndex, int RangeIndex) { return (int)((TList*)this->FDistributionList->Items[TargetIndex])->Items[RangeIndex]; }

    int    ErrorCode;    // G[R[hiG[Ȃꍇ 0
    AnsiString    ErrorParameter;    // G[p[^

protected:
    virtual void __fastcall CountDistribution(TCFbEDataSet* DataSet, int TargetRowIndex, TList* StoredList);    // DataSet ɂ TargetRowIndex sڂ̍sɑ΂ގx̕z StoredList Ɋi[ĕԂ

    TCFbECommandLineParser*    Parser;
    TCFbEDataLoader*    DataLoader;
    TCFbETable*    FResultTable;    // vZʂi[e[u
    TObjectList*    FNeighborsList;    // NearestNeighbors i[ TObjectList i[邽߂ TObjectList
    TObjectList*    FDistributionList;    // ގx̕zi[ TList i[邽߂ TObjectList
    TBooleanDynArray    FIsResultedColumn;    // eɏo͂ꂽl邩

private:

};
//---------------------------------------------------------------------------
#endif
