/*
    TCFbETable.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETableH
#define TCFbETableH
//---------------------------------------------------------------------------
#include <System.hpp>
#include <Classes.hpp>
#include <Contnrs.hpp>

// #include "Maprof.h"

#include "TCFbECell.h"
#include "TCFbEToolkit.h"
#include "TCFbEPrimitiveTable.h"
//---------------------------------------------------------------------------
class TCFbETable : public TCFbEPrimitiveTable
{
public:
    // ANZT\bh
    virtual void __fastcall SetValueByIndex(int TargetRowIndex, int TargetColumnIndex, double Value) {
        TCFbECell* Cell = this->GetCellByIndex(TargetRowIndex, TargetColumnIndex);
        if (!Cell->GetEnabled() || Cell->GetValue() != Value) {
            Cell->SetValue(Value);
            this->RowIsUpdated(TargetRowIndex);
            this->ColumnIsUpdated(TargetColumnIndex);
        }
    }

    virtual void __fastcall SetEnabledByIndex(int TargetRowIndex, int TargetColumnIndex, bool Value) {
        TCFbECell* Cell = this->GetCellByIndex(TargetRowIndex, TargetColumnIndex);
        if (Cell->GetEnabled() != Value) {
            Cell->SetEnabled(Value);
            this->RowIsUpdated(TargetRowIndex);
            this->ColumnIsUpdated(TargetColumnIndex);
        }
    }


    virtual void __fastcall SetCell(AnsiString RowLabel, AnsiString ColumnLabel, TCFbECell* Cell) {
        this->SetCellByIndex(this->RowIsUpdated(RowLabel), this->ColumnIsUpdated(ColumnLabel), Cell);
    }

    virtual void __fastcall SetCellByIndex(int RowIndex, int ColumnIndex, TCFbECell* Cell) {
        this->RowIsUpdated(RowIndex);
        this->ColumnIsUpdated(ColumnIndex);
        TCFbEPrimitiveTable::SetCellByIndex(RowIndex, ColumnIndex, Cell);
    }

    virtual __fastcall      TCFbETable(void);       // RXgN^ĩe[u쐬
    virtual __fastcall      TCFbETable(TStringList* RowLabelList, TStringList* ColumnLabelList);    // w肳ꂽse[u쐬
    __fastcall              ~TCFbETable();          // fXgN^

    virtual void __fastcall RowIsUpdated(int RowIndex);
    virtual int __fastcall  RowIsUpdated(AnsiString RowLabel);
    virtual void __fastcall ColumnIsUpdated(int  ColumnIndex);
    virtual int __fastcall  ColumnIsUpdated(AnsiString ColumnLabel);

    // s폜D
    virtual void __fastcall DeleteRowByIndex(int TargetRowIndex) {
        TCFbEPrimitiveTable::DeleteRowByIndex(TargetRowIndex);
        this->DeleteRowCache(TargetRowIndex);
    }

    // 폜D
    virtual void __fastcall DeleteColumnByIndex(int TargetColumnIndex) {
        TCFbEPrimitiveTable::DeleteColumnByIndex(TargetColumnIndex);
        this->DeleteColumnCache(TargetColumnIndex);
    }

    // sǉD
    virtual int __fastcall AddRow(AnsiString RowLabel) {
        this->AddRowCache();
        return TCFbEPrimitiveTable::AddRow(RowLabel);
    }

    // ǉD
    virtual int __fastcall AddColumn(AnsiString ColumnLabel) {
        this->AddColumnCache();
        return TCFbEPrimitiveTable::AddColumn(ColumnLabel);
    }

    virtual void __fastcall Assign(TCFbETable* SourceTable);            // SourceTable ̊evfRs[
    virtual void __fastcall AssignWithTurn(TCFbETable* SourceTable);    // SourceTable ̊evf̍sƗւăRs[

    virtual bool __fastcall Normalize(TCFbECell* Cell, double MaxValue, double MinValue);    // Normalize 
    virtual void __fastcall PartialNormalize(int ColumnIndex, bool RowUpdate=true); // Table ̗vf𕔕I Normalize 
    virtual void __fastcall Normalize(void);        // Table ̗vf Normalize 

    virtual bool __fastcall Standardize(TCFbECell* Cell, double AverageValue, double StdevValue);   // Standardize 
    virtual void __fastcall PartialStandardize(int ColumnIndex, bool RowUpdate=true); // Table ̗vf𕔕I Standardize 
    virtual void __fastcall Standardize(void);    // Table ̗vf Standardize 

    virtual void __fastcall Ordering(TList* SortedCellList);    // Ordering 
    virtual void __fastcall PartialOrdering(int ColumnIndex, bool RowUpdate=true); // Table ̗vf𕔕I Ordering 
    virtual void __fastcall Ordering(void);    // Table ̗vf Ordering 

    virtual void __fastcall PartialRowNormalize(int RowIndex, bool ColumnUpdate=true); // Table ̗vfɕI Normalize 
    virtual void __fastcall PartialRowNormalizeOnColumn(int ColumnIndex, bool RowUpdate=true);  // ColumnIndex Ԗڂ̗ Table ̗vfɕI Normalize 
    virtual void __fastcall RowNormalize(void);    // Table ̗vf Normalize 
    virtual void __fastcall PartialRowStandardize(int RowIndex, bool ColumnUpdate=true); // Table ̗vfɕI Standardize 
    virtual void __fastcall PartialRowStandardizeOnColumn(int ColumnIndex, bool RowUpdate=true); // ColumnIndex Ԗڂ̗ Table ̗vfɕI Standardize 
    virtual void __fastcall RowStandardize(void);    // Table ̗vf Standardize 
    // Ordering ͕IɂĂǂȂ
    virtual void __fastcall PartialRowOrdering(int RowIndex, bool ColumnUpdate=true); // Table ̗vfɕI Ordering 
    virtual void __fastcall RowOrdering(void);    // Table ̗vf Ordering 

    virtual double __fastcall   DisNormalize(int ColumnIndex, double NormalizedValue);    // ColumnIndex ڂ Normalize ꂽl NormalizedValue  DisNormalize ĕԂ
    virtual double __fastcall   DisStandardize(int ColumnIndex, double StandardizedValue);    // ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisStandardize ĕԂ
    virtual double __fastcall   DisOrdering(int ColumnIndex, double Order, TDoubleDynArray& SortedOrders);    // ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ

    virtual double __fastcall   DisRowNormalize(int RowIndex, double RowNormalizedValue);    // RowIndex ڂ̉ Normalize ꂽl RowNormalizedValue  DisRowNormalize ĕԂ
    virtual double __fastcall   DisRowStandardize(int RowIndex, double RowStandardizedValue);    // RowIndex ڂ̉ Standardize ꂽl RowStandardizedValue  DisRowStandardize ĕԂ
    virtual double __fastcall   DisRowOrdering(int RowIndex, double RowOrder, TDoubleDynArray& SortedOrders);    // RowIndex ڂ̉ Ordering ꂽl RowOrder  DisRowOrdering ĕԂ

    virtual double __fastcall   DisOrderingCommon(int Index, double Order, TDoubleDynArray& SortedOrders, TDoubleDynArray& SortedValues);    // DisOrdering  DisRowOrdering Ŏgʂ̏

    virtual double __fastcall   GetMaxOfRow(int i);    // s̍őlԂD
    virtual double __fastcall   GetMinOfRow(int i);    // s̍ŏlԂD
    virtual double __fastcall   GetAverageOfRow(int i);    // s̕ϒlԂD
    virtual double __fastcall   GetMedianOfRow(int i);    // s̒ԒlԂD
    virtual double __fastcall   GetStdevOfRow(int i);    // s̕W΍ԂD
    virtual double __fastcall   GetInversedDistanceOfRow(int BaseRowIndex, int ComparedRowIndex);    // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Inversed Distance ԂD
    virtual double __fastcall   GetAveragedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);    // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall   GetMedianOfMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);    // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Median of Multiplier ԂD
    virtual double __fastcall   GetWeightedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex, int BaseColumnIndex);    // BaseColumnIndex Ԗڂ̗Ɋւ ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Weighted Multiplier ԂD

    virtual double __fastcall   GetMaxOfColumn(int j);    // ̍őlԂD
    virtual double __fastcall   GetMinOfColumn(int j);    // ̍ŏlԂD
    virtual double __fastcall   GetAverageOfColumn(int j);    // ̕ϒlԂD
    virtual double __fastcall   GetMedianOfColumn(int j);    // ̒ԒlԂD
    virtual double __fastcall   GetStdevOfColumn(int j);    // ̕W΍ԂD
    virtual double __fastcall   GetInversedDistanceOfColumn(int BaseColumnIndex, int ComparedColumnIndex);    // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Inversed Distance ԂD
    virtual double __fastcall   GetAveragedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);    // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall   GetMedianOfMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);    // BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Median of Multiplier ԂD
    virtual double __fastcall   GetWeightedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex, int BaseRowIndex);    // BaseRowIndex Ԗڂ̍sɊւ BaseColumnIndex Ԗڂ̗ ComparedColumnIndex Ԗڂ̗ɑ΂ Weighted Multiplier ԂD

protected:
    virtual void __fastcall AddRowCache(void);       // s̃LbVǉ
    virtual void __fastcall AddColumnCache(void);    // ̃LbVǉ
    virtual void __fastcall DeleteRowCache(int TargetRowIndex);         // s̃LbV폜
    virtual void __fastcall DeleteColumnCache(int TargetColumnIndex);   // ̃LbV폜
    virtual void __fastcall CopyRowCache(TCFbETable* SourceTable, int TargetRowIndex);          // s̃LbVRs[
    virtual void __fastcall CopyColumnCache(TCFbETable* SourceTable, int TargetColumnIndex);    // ̃LbVRs[
    virtual void __fastcall CopyRowCacheFromColumn(TCFbETable* SourceTable, int TargetRowIndex);    // s̃LbṼLbVRs[
    virtual void __fastcall CopyColumnCacheFromRow(TCFbETable* SourceTable, int TargetColumnIndex); // ̃LbVs̃LbVRs[

    TObjectList*    MaxOfRowList;
    TObjectList*    MinOfRowList;
    TObjectList*    AverageOfRowList;
    TObjectList*    MedianOfRowList;
    TObjectList*    StdevOfRowList;
    TObjectList*    InversedDistanceOfRowList;
    TList*          CachedBaseRowListForID;

    TObjectList*    MaxOfColumnList;
    TObjectList*    MinOfColumnList;
    TObjectList*    AverageOfColumnList;
    TObjectList*    MedianOfColumnList;
    TObjectList*    StdevOfColumnList;
    TObjectList*    InversedDistanceOfColumnList;
    TList*          CachedBaseColumnListForID;

private:

};
//---------------------------------------------------------------------------
#endif
