/*
    TCFbEWeightedSum.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEWeightedSum.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEWeightedSum::TCFbEWeightedSum(void)
    : TCFbEPredictionAlgorithm()
{
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEWeightedSum::~TCFbEWeightedSum()
{
}

//---------------------------------------------------------------------------
// TargetRowIndex sڂ TargetColumnIndex ̒l\
double __fastcall TCFbEWeightedSum::Predict(TCFbETable* PredictionTable, int TargetRowIndex, int TargetColumnIndex, TObjectList* NeighborList)
{
    this->PredictionTable = PredictionTable;
    this->TargetRowIndex = TargetRowIndex;
    this->TargetColumnIndex = TargetColumnIndex;
    this->NeighborList = NeighborList;

    double    Numerator = 0.0;        // q
    double    Denominator = 0.0;    // 

    for (int i = 0; i < this->NeighborList->Count; i++) {
        Numerator += this->GetNumerator(i);
        Denominator += this->GetDenominator(i);
    }
                               
    if (TCFbEToolkit::GetToolkit()->Equals(Denominator, 0.0)) {
//    if (Denominator == 0.0) {
        return 0.0;
    } else {
        return this->GetPredictedValue(Numerator, Denominator);
    }
}

//---------------------------------------------------------------------------
// ȍ~Cprotected \bh
//---------------------------------------------------------------------------
// LbVNA
void __fastcall TCFbEWeightedSum::ClearCash(void)
{
    this->NeighborList->Clear();
}

//---------------------------------------------------------------------------
// q̒l𓾂
double __fastcall TCFbEWeightedSum::GetNumerator(int NeighborIndex)
{
    TCFbENeighbor*    Neighbor = (TCFbENeighbor*)this->NeighborList->Items[NeighborIndex];
    return    Neighbor->GetValue() * Neighbor->GetSimilarity();
}

//---------------------------------------------------------------------------
// ̒l𓾂
double __fastcall TCFbEWeightedSum::GetDenominator(int NeighborIndex)
{
    return fabs(((TCFbENeighbor*)this->NeighborList->Items[NeighborIndex])->GetSimilarity());
}

//---------------------------------------------------------------------------
// \l𓾂
double __fastcall TCFbEWeightedSum::GetPredictedValue(double Numerator, double Denominator)
{
    return Numerator / Denominator;
}

//---------------------------------------------------------------------------

