/*
 * TestListener.h
 */

#ifndef cppunit_TestListener_h
#define cppunit_TestListener_h

#include "cuconfig.h"

cu_NAMESPACE_BEGIN(cppunit)

class Test;
class TestFailure;

/**
 * eXg̃XiB<br>
 * A Listener for test progress.
 *
 * @see TestResult
 */
class TestListener
{
  public:
	/** fXgN^B */
	virtual ~TestListener() {}

	/**
	 * eXgJnB
	 * @param test eXgB
	 */
	virtual void startTest(Test* test) = 0;

	/**
	 * eXgIB
	 * @param test eXgB
	 */
	virtual void endTest(Test* test) = 0;

	/**
	 * eXg̎sǉꂽB
	 * @param failure seXg̏B
	 */
	virtual void addFailure(const TestFailure* failure) = 0;

	/**
	 * G[ǉꂽB
	 * @param error G[B
	 */
	virtual void addError(const TestFailure* error) = 0;
};

cu_NAMESPACE_END

#endif /* !cppunit_TestListener_h */
