/*
    TCFbEAdjustedWeightedSumWithMedianOfColumn.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEAdjustedWeightedSumWithMedianOfColumn.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEAdjustedWeightedSumWithMedianOfColumn::TCFbEAdjustedWeightedSumWithMedianOfColumn(void)
    : TCFbEWeightedSum()
{
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEAdjustedWeightedSumWithMedianOfColumn::~TCFbEAdjustedWeightedSumWithMedianOfColumn()
{
}

//---------------------------------------------------------------------------
// ȍ~Cprotected \bh
//---------------------------------------------------------------------------
// LbVNA
void __fastcall TCFbEAdjustedWeightedSumWithMedianOfColumn::ClearCash(void)
{
    TCFbEWeightedSum::ClearCash();
    this->CashEnabled = false;
}

//---------------------------------------------------------------------------
// q̒l𓾂
double __fastcall TCFbEAdjustedWeightedSumWithMedianOfColumn::GetNumerator(int NeighborIndex)
{
    if (!this->CashEnabled) {
        this->MedianOfColumn = this->PredictionTable->GetMedianOfColumn(this->TargetColumnIndex);
    }

    TCFbENeighbor*    Neighbor = (TCFbENeighbor*)this->NeighborList->Items[NeighborIndex];
    return (Neighbor->GetValue() - this->MedianOfColumn) *  Neighbor->GetSimilarity();
}

//---------------------------------------------------------------------------
// \l𓾂
double __fastcall TCFbEAdjustedWeightedSumWithMedianOfColumn::GetPredictedValue(double Numerator, double Denominator)
{
    if (!this->CashEnabled) {
        this->MedianOfColumn = this->PredictionTable->GetMedianOfColumn(this->TargetColumnIndex);
    }

    return this->MedianOfColumn + Numerator / Denominator;
}

//---------------------------------------------------------------------------

