/*
    TCFbETestCase4.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase4H
#define TCFbETestCase4H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include <System.hpp>

//#include "TCFbEDataAccessor.h"
#include "TCFbETableEx.h"
#include "TCFbEDataSetEx.h"
#include "TCFbECommandLineParser.h"
#include "TCFbEOutputCash.h"
#include "TCFbEOutputFormatter.h"
#include "TCFbEDataLoader.h"
//---------------------------------------------------------------------------
// eXgP[X4
class TCFbETestCase4 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase4)

public:
    // eXg
    //    FILENAME  BUG LOC N_COMM  HALVOL  SCPMN   N_VEXUSE
    //    module_1  1   800 0.3     3600    4       0.6
    //    module_2  0   250 0.2     3200    3.5     0.4
    //    module_3  0   500 0       3200    3       0.3
    //    module_4  1   700 0.25    3500    4       0.8
    //    module_5  0   600 0.2     3200    2.5     0.1
    //    module_6  1   900 0.35    3800    4.1     0.75
    virtual void setUp() {
        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,    BUG,    LOC,    N_COMM,    HALVOL,    SCPMN,    N_VEXUSE");
        TestStringList->Add("module_1,    1,        800,    0.3,    3600,    4,        0.6");
        TestStringList->Add("module_2,    0,        250,    0.2,    3200,    3.5,    0.4");
        TestStringList->Add("module_3,    0,        500,    0,        3200,    3,        0.3");
        TestStringList->Add("module_4,    1,        700,    0.25,    3500,    4,        0.8");
        TestStringList->Add("module_5,    0,        600,    0.2,    3200,    2.5,    0.1");
        TestStringList->Add("module_6,    1,        900,    0.35,    3800,    4.1,    0.75");

        this->DataSet = new TCFbEDataSetEx(TestStringList);
        delete TestStringList;

        this->DataSet->TemporallyUnable(0, 0);
    }

    // eXǧЕt
    virtual void tearDown() {
        this->DataSet->RecoverEnabled();
        delete this->DataSet;
    }

    //---------------------------------------------------------------------------
    // ȉCDataSet ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbEDataSetEx_TemporallyUnable_vbNormalizedValue() {
        this->DataSet->RecoverEnabled();
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        //  Normalize	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
        //  module_1	1.0	0.846153846	0.857142857	0.666666667	0.9375	0.714285714
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.846153846, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 5), 1E-6);

        //  module_2	0.0	0.0	0.571428571	0.0	0.625	0.428571429
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.428571429, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 5), 1E-6);

        //  module_3	0.0	0.384615385	0.0	0.0	0.3125	0.285714286
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.384615385, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.285714286, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 5), 1E-6);

        //  module_4	1.0	0.692307692	0.714285714	0.5	0.9375	1.0
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.692307692, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 5), 1E-6);

        //  module_5	0.0	0.538461538	0.571428571	0.0	0.0	0.0
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.538461538, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 5), 1E-6);

        //  module_6	1.0	1.0	1.0	1.0	1.0	0.928571429
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.928571429, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 5), 1E-6);

        this->DataSet->TemporallyUnable(5, 3);

        //  Unabled Normalize	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
        //  module_1	1.0	0.846153846	0.857142857	1.0	0.9375	0.714285714
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.846153846, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 5), 1E-6);

        //  module_2	0.0	0.0	0.571428571	0.0	0.625	0.428571429
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.428571429, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 5), 1E-6);

        //  module_3	0.0	0.384615385	0.0	0.0	0.3125	0.285714286
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.384615385, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.285714286, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 5), 1E-6);

        //  module_4	1.0	0.692307692	0.714285714	0.75	0.9375	1.0
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.692307692, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.75, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 5), 1E-6);

        //  module_5	0.0	0.538461538	0.571428571	0.0	0.0	0.0
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.538461538, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 5), 1E-6);

        //  module_6	1.0	1.0	1.0		1.0	0.928571429
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS((int)false, this->DataSet->GetSimilarityComputationTable()->GetEnabledByIndex(5, 3));
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.928571429, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 5), 1E-6);

        //  Max of Column	1.0	1.0	1.0	1.0	1.0	1.0
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0.0	0.0	0.0	0.0	0.0	0.0
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(5), 1E-6);

        //  Average of Column	0.5	0.576923077	0.619047619	0.35	0.635416667	0.55952381
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.576923077, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.619047619, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.635416667, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.55952381, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0.5	0.615384615	0.642857143	0.0	0.78125	0.571428571
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.615384615, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.642857143, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.78125, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	0.5	0.325600644	0.315869028	0.435889894	0.370487901	0.355751257
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.325600644, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.315869028, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.435889894, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.370487901, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.355751257, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(5), 1E-6);

        //  Inversed Distance		3.099710983	2.758318739	13.71428571	4.693611473	3.897772701
        TEST_ASSERT_EQUALS_DOUBLE(3.099710983, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.758318739, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(13.71428571, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.693611473, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.897772701, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 5), 1E-6);

        //  Max of Row	1.0	0.625	0.384615385	1.0	0.571428571	1.0
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.384615385, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(5), 1E-6);

        //  Min of Row	0.714285714	0.0	0.0	0.692307692	0.0	0.928571429
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.692307692, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.928571429, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(5), 1E-6);

        //  Average of Row	0.892513736	0.270833333	0.163804945	0.849015568	0.184981685	0.985714286
        TEST_ASSERT_EQUALS_DOUBLE(0.892513736, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.270833333, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.163804945, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.849015568, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.184981685, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.985714286, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(5), 1E-6);

        //  Median of Row	0.897321429	0.214285714	0.142857143	0.84375	0.0	1.0
        TEST_ASSERT_EQUALS_DOUBLE(0.897321429, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.214285714, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.142857143, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.84375, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	0.1002463	0.27710555	0.166445956	0.132875673	0.261776654	0.028571429
        TEST_ASSERT_EQUALS_DOUBLE(0.1002463, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.27710555, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.166445956, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.132875673, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.261776654, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.028571429, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(5), 1E-6);

        //  Averaged Multiplier		1.555555556	2.566666667	1.078306878	1.535714286	0.882005495
        TEST_ASSERT_EQUALS_DOUBLE(1.555555556, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.566666667, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.078306878, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.535714286, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.882005495, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);

        //  Median of Multiplier		1.5	2.5	1.1	1.535714286	0.857142857
        TEST_ASSERT_EQUALS_DOUBLE(1.5, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.535714286, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);

        //  Weighted Multiplier		1.557237514	2.621194159	1.166819974	1.537795631	0.857173385
        TEST_ASSERT_EQUALS_DOUBLE(1.557237514, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.621194159, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.166819974, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.537795631, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857173385, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);

        this->DataSet->RecoverEnabled();
        
        //  Normalize	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
        //  module_1	1.0	0.846153846	0.857142857	0.666666667	0.9375	0.714285714
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.846153846, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 5), 1E-6);

        //  module_2	0.0	0.0	0.571428571	0.0	0.625	0.428571429
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.428571429, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 5), 1E-6);

        //  module_3	0.0	0.384615385	0.0	0.0	0.3125	0.285714286
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.384615385, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.285714286, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 5), 1E-6);

        //  module_4	1.0	0.692307692	0.714285714	0.5	0.9375	1.0
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.692307692, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 5), 1E-6);

        //  module_5	0.0	0.538461538	0.571428571	0.0	0.0	0.0
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.538461538, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 5), 1E-6);

        //  module_6	1.0	1.0	1.0	1.0	1.0	0.928571429
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.928571429, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 5), 1E-6);
    }

    virtual void Test_TCFbEDataSetEx_TemporallyUnable_vbDoubleStandardizedValue() {
        this->DataSet->RecoverEnabled();
        this->DataSet->PrepareCF(vbDoubleStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        //  DoubleStandardized	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
        //  module_1	1.36818919	0.34221676	-0.090961334	0.086463293	0.274018819	-1.979926728
        TEST_ASSERT_EQUALS_DOUBLE(1.36818919, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.34221676, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.090961334, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.086463293, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.274018819, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.979926728, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 5), 1E-6);

        //  module_2	-0.488275825	-1.776820902	0.929430475	-0.36509548	1.134161811	0.566599921
        TEST_ASSERT_EQUALS_DOUBLE(-0.488275825, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.776820902, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.929430475, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.36509548, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.134161811, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.566599921, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 5), 1E-6);

        //  module_3	0.044669715	0.975101634	-2.136824969	0.212376438	0.336501816	0.568175366
        TEST_ASSERT_EQUALS_DOUBLE(0.044669715, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.975101634, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-2.136824969, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.212376438, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.336501816, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.568175366, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 5), 1E-6);

        //  module_4	0.89054444	-0.892866001	-1.038890283	-0.887726478	0.380530784	1.548407539
        TEST_ASSERT_EQUALS_DOUBLE(0.89054444, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.892866001, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.038890283, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.887726478, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.380530784, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.548407539, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 5), 1E-6);
                                                                                                 
        //  module_5	-0.139203179	1.285387369	1.232675243	-0.020004685	-1.294352314	-1.064502434
        TEST_ASSERT_EQUALS_DOUBLE(-0.139203179, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.285387369, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.232675243, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.020004685, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.294352314, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.064502434, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 5), 1E-6);

        //  module_6	-0.847493897	0.458600449	0.051431679	1.938920067	-0.917024329	-0.684433969
        TEST_ASSERT_EQUALS_DOUBLE(-0.847493897, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.458600449, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.051431679, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.938920067, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.917024329, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.684433969, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 5), 1E-6);

        this->DataSet->TemporallyUnable(5, 3);

        //  Unabled DoubleStandardized	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
        //  module_1	0.354672459	-0.188916564	-0.418426491	1.896973785	-0.22504975	-1.419253438
        TEST_ASSERT_EQUALS_DOUBLE(0.354672459, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.188916564, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.418426491, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.896973785, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.22504975, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.419253438, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 5), 1E-6);

        //  module_2	-0.527648862	-1.828718869	0.903837842	-0.195509818	1.11055921	0.537480498
        TEST_ASSERT_EQUALS_DOUBLE(-0.527648862, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.828718869, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.903837842, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.195509818, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.11055921, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.537480498, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 5), 1E-6);

        //  module_3	-0.001989692	0.914466849	-2.150717645	0.439128749	0.285458999	0.513652741
        TEST_ASSERT_EQUALS_DOUBLE(-0.001989692, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.914466849, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-2.150717645, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.439128749, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.285458999, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.513652741, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 5), 1E-6);

        //  module_4	0.675662289	-1.230737804	-1.386832385	0.432537714	0.130476469	1.378893717
        TEST_ASSERT_EQUALS_DOUBLE(0.675662289, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.230737804, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.386832385, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.432537714, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.130476469, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.378893717, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 5), 1E-6);

        //  module_5	-0.172029142	1.249594367	1.196992027	0.145616409	-1.324772412	-1.095401249
        TEST_ASSERT_EQUALS_DOUBLE(-0.172029142, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.249594367, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.196992027, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.145616409, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.324772412, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.095401249, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 5), 1E-6);

        //  module_6	-0.842489044	1.551129663	0.804930288		-0.969914251	-0.543656655
        TEST_ASSERT_EQUALS_DOUBLE(-0.842489044, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.551129663, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.804930288, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS((int)false, this->DataSet->GetSimilarityComputationTable()->GetEnabledByIndex(5, 3));
        TEST_ASSERT_EQUALS_DOUBLE(-0.969914251, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.543656655, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 5), 1E-6);

        //  Max of Column	0.675662289	1.551129663	1.196992027	1.896973785	1.11055921	1.378893717
        TEST_ASSERT_EQUALS_DOUBLE(0.675662289, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.551129663, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.196992027, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.896973785, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.11055921, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.378893717, this->DataSet->GetSimilarityComputationTable()->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	-0.842489044	-1.828718869	-2.150717645	-0.195509818	-1.324772412	-1.419253438
        TEST_ASSERT_EQUALS_DOUBLE(-0.842489044, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.828718869, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-2.150717645, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.195509818, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.324772412, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.419253438, this->DataSet->GetSimilarityComputationTable()->GetMinOfColumn(5), 1E-6);

        //  Average of Column	-0.085636999	0.07780294	-0.175036061	0.543749368	-0.165540289	-0.104714064
        TEST_ASSERT_EQUALS_DOUBLE(-0.085636999, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.07780294, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.175036061, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.543749368, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.165540289, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.104714064, this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	-0.087009417	0.362775142	0.193251898	0.432537714	-0.04728664	-0.015001957
        TEST_ASSERT_EQUALS_DOUBLE(-0.087009417, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.362775142, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.193251898, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.432537714, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.04728664, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.015001957, this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	0.509265648	1.268991519	1.25417775	0.715477998	0.807654441	0.991465991
        TEST_ASSERT_EQUALS_DOUBLE(0.509265648, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.268991519, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.25417775, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.715477998, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.807654441, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.991465991, this->DataSet->GetSimilarityComputationTable()->GetStdevOfColumn(5), 1E-6);

        //  Inversed Distance		0.022209434	0.022536202	0.021569167	0.021868768	0.02233517
        TEST_ASSERT_EQUALS_DOUBLE(0.022209434, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.022536202, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.021569167, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.021868768, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.02233517, this->DataSet->GetSimilarityComputationTable()->GetInversedDistanceOfColumn(0, 5), 1E-6);

        //  Max of Row	1.896973785	1.11055921	0.914466849	1.378893717	1.249594367	1.551129663
        TEST_ASSERT_EQUALS_DOUBLE(1.896973785, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.11055921, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.914466849, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.378893717, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.249594367, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.551129663, this->DataSet->GetSimilarityComputationTable()->GetMaxOfRow(5), 1E-6);

        //  Min of Row	-1.419253438	-1.828718869	-2.150717645	-1.386832385	-1.324772412	-0.969914251
        TEST_ASSERT_EQUALS_DOUBLE(-1.419253438, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.828718869, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-2.150717645, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.386832385, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.324772412, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.969914251, this->DataSet->GetSimilarityComputationTable()->GetMinOfRow(5), 1E-6);

        //  Average of Row	2.96059E-16	1.29526E-16	-1.85037E-17	7.40149E-17	-1.11022E-16	1.39888E-15
        TEST_ASSERT_EQUALS_DOUBLE(2.96059E-16, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.29526E-16, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.85037E-17, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.40149E-17, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.11022E-16, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.39888E-15, this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(5), 1E-6);

        //  Median of Row	-0.206983157	0.17098534	0.362293874	0.281507092	-0.013206367	-0.543656655
        TEST_ASSERT_EQUALS_DOUBLE(-0.206983157, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.17098534, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.362293874, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.281507092, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.013206367, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.543656655, this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1	1	1	1	1	1
        TEST_ASSERT_EQUALS_DOUBLE(1, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->DataSet->GetSimilarityComputationTable()->GetStdevOfRow(5), 1E-6);

        //  Averaged Multiplier		2.297390164	31.08789145	1.353320334	2.842528376	0.781040807
        TEST_ASSERT_EQUALS_DOUBLE(2.297390164, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(31.08789145, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.353320334, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.842528376, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.781040807, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);

        //  Median of Multiplier		0.567559683	1.775719366	0.777097639	0.822606033	0.420981687
        TEST_ASSERT_EQUALS_DOUBLE(0.567559683, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.775719366, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.777097639, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.822606033, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.420981687, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);

        //  Weighted Multiplier		2.582509649	1.638660156	1.497600999	2.939545507	0.874671624
        TEST_ASSERT_EQUALS_DOUBLE(2.582509649, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.638660156, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.497600999, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.939545507, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.874671624, this->DataSet->GetSimilarityComputationTable()->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);

        this->DataSet->RecoverEnabled();

        //  DoubleStandardized	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
        //  module_1	1.36818919	0.34221676	-0.090961334	0.086463293	0.274018819	-1.979926728
        TEST_ASSERT_EQUALS_DOUBLE(1.36818919, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.34221676, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.090961334, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.086463293, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.274018819, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.979926728, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(0, 5), 1E-6);

        //  module_2	-0.488275825	-1.776820902	0.929430475	-0.36509548	1.134161811	0.566599921
        TEST_ASSERT_EQUALS_DOUBLE(-0.488275825, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.776820902, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.929430475, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.36509548, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.134161811, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.566599921, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(1, 5), 1E-6);

        //  module_3	0.044669715	0.975101634	-2.136824969	0.212376438	0.336501816	0.568175366
        TEST_ASSERT_EQUALS_DOUBLE(0.044669715, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.975101634, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-2.136824969, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.212376438, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.336501816, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.568175366, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(2, 5), 1E-6);

        //  module_4	0.89054444	-0.892866001	-1.038890283	-0.887726478	0.380530784	1.548407539
        TEST_ASSERT_EQUALS_DOUBLE(0.89054444, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.892866001, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.038890283, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.887726478, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.380530784, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.548407539, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(3, 5), 1E-6);
                                                                                                 
        //  module_5	-0.139203179	1.285387369	1.232675243	-0.020004685	-1.294352314	-1.064502434
        TEST_ASSERT_EQUALS_DOUBLE(-0.139203179, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.285387369, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.232675243, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.020004685, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.294352314, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.064502434, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(4, 5), 1E-6);

        //  module_6	-0.847493897	0.458600449	0.051431679	1.938920067	-0.917024329	-0.684433969
        TEST_ASSERT_EQUALS_DOUBLE(-0.847493897, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.458600449, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.051431679, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.938920067, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.917024329, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.684433969, this->DataSet->GetSimilarityComputationTable()->GetValueByIndex(5, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // ȉCTable ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbETableEx_CopyRowFrom() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TCFbETableEx* DestTable = new TCFbETableEx();
        DestTable->CopyRowFrom(this->DataSet->GetPredictionTable(), 0, false);
        TEST_ASSERT_EQUALS(1, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(0, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_1", DestTable->GetRowLabelList()->Strings[0].c_str());

        DestTable->CopyRowFrom(this->DataSet->GetPredictionTable(), 1, true);
        TEST_ASSERT_EQUALS(2, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_2",  DestTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("BUG",       DestTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",       DestTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    DestTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    DestTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",     DestTable->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",  DestTable->GetColumnLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  DestTable->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  DestTable->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, DestTable->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,  DestTable->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4,  DestTable->GetValueByIndex(1, 5), 1E-6);

        DestTable->CopyRowFrom(this->DataSet->GetPredictionTable(), 2, false);
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_3",  DestTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  DestTable->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, DestTable->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,    DestTable->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  DestTable->GetValueByIndex(2, 5), 1E-6);

        DestTable->CopyRowFrom(this->DataSet->GetPredictionTable(), 0, true);
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_1",  DestTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS((int)false,  (int)DestTable->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(800,  DestTable->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  DestTable->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600, DestTable->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    DestTable->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,  DestTable->GetValueByIndex(0, 5), 1E-6);

        delete DestTable;
    }

    virtual void Test_TCFbETableEx_CopyRowAsColumnFrom() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TCFbETableEx* DestTable = new TCFbETableEx();
        DestTable->CopyRowAsColumnFrom(this->DataSet->GetPredictionTable(), 0, false);
        TEST_ASSERT_EQUALS(0, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(1, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_1", DestTable->GetColumnLabelList()->Strings[0].c_str());

        DestTable->CopyRowAsColumnFrom(this->DataSet->GetPredictionTable(), 1, true);
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(2, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_2",  DestTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("BUG",       DestTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",       DestTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    DestTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    DestTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",     DestTable->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",  DestTable->GetRowLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  DestTable->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  DestTable->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, DestTable->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,  DestTable->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4,  DestTable->GetValueByIndex(5, 1), 1E-6);

        DestTable->CopyRowAsColumnFrom(this->DataSet->GetPredictionTable(), 2, false);
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_3",  DestTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  DestTable->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, DestTable->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,    DestTable->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  DestTable->GetValueByIndex(5, 2), 1E-6);

        DestTable->CopyRowAsColumnFrom(this->DataSet->GetPredictionTable(), 0, true);
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_1",  DestTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS((int)false,  (int)DestTable->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(800,  DestTable->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  DestTable->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600, DestTable->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    DestTable->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,  DestTable->GetValueByIndex(5, 0), 1E-6);

        delete DestTable;
    }

    virtual void Test_TCFbETableEx_CopyColumnFrom() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TCFbETableEx* DestTable = new TCFbETableEx();
        DestTable->CopyColumnFrom(this->DataSet->GetPredictionTable(), 0, false);
        TEST_ASSERT_EQUALS(0, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(1, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("BUG", DestTable->GetColumnLabelList()->Strings[0].c_str());

        DestTable->CopyColumnFrom(this->DataSet->GetPredictionTable(), 1, true);
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(2, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_1",  DestTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2",  DestTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3",  DestTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4",  DestTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5",  DestTable->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6",  DestTable->GetRowLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS("BUG",       DestTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",       DestTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(800,  DestTable->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  DestTable->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  DestTable->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700,  DestTable->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  DestTable->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900,  DestTable->GetValueByIndex(5, 1), 1E-6);

        DestTable->CopyColumnFrom(this->DataSet->GetPredictionTable(), 2, false);
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("N_COMM",    DestTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  DestTable->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  DestTable->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, DestTable->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  DestTable->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, DestTable->GetValueByIndex(5, 2), 1E-6);

        DestTable->CopyColumnFrom(this->DataSet->GetPredictionTable(), 0, true);
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("BUG",   DestTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS((int)false,  (int)DestTable->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(0,  DestTable->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,  DestTable->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, DestTable->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,  DestTable->GetValueByIndex(5, 0), 1E-6);

        delete DestTable;
    }

    virtual void Test_TCFbETableEx_CopyColumnAsRowFrom() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);

        TCFbETableEx* DestTable = new TCFbETableEx();
        DestTable->CopyColumnAsRowFrom(this->DataSet->GetPredictionTable(), 0, false);
        TEST_ASSERT_EQUALS(1, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(0, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("BUG", DestTable->GetRowLabelList()->Strings[0].c_str());

        DestTable->CopyColumnAsRowFrom(this->DataSet->GetPredictionTable(), 1, true);
        TEST_ASSERT_EQUALS(2, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("module_1",  DestTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2",  DestTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3",  DestTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4",  DestTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5",  DestTable->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6",  DestTable->GetColumnLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS("BUG",       DestTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",       DestTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(800,  DestTable->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  DestTable->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  DestTable->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700,  DestTable->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  DestTable->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900,  DestTable->GetValueByIndex(1, 5), 1E-6);

        DestTable->CopyColumnAsRowFrom(this->DataSet->GetPredictionTable(), 2, false);
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("N_COMM",    DestTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  DestTable->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  DestTable->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, DestTable->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  DestTable->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, DestTable->GetValueByIndex(2, 5), 1E-6);

        DestTable->CopyColumnAsRowFrom(this->DataSet->GetPredictionTable(), 0, true);
        TEST_ASSERT_EQUALS(3, DestTable->GetNumberOfRows());
        TEST_ASSERT_EQUALS(6, DestTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS("BUG",   DestTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS((int)false,  (int)DestTable->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    DestTable->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    DestTable->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    DestTable->GetValueByIndex(0, 5), 1E-6);

        delete DestTable;
    }

    //              BUG	LOC	        N_COMM	HALVOL	    SCPMN	N_VEXUSE
    //  module_1	 	0.846153846	0.3	    0.666666667	4	    0.714285714
    //  module_2	0	0	        0.2	    0	        3.5	    0.428571429
    //  module_3	0	0.384615385	0	    0	        3	    0.285714286
    //  module_4	1	0.692307692	0.25	0.5	        4	    1
    //  module_5	0	0.538461538	0.2	    0	        2.5	    0
    //  module_6	1	1	        0.35	1	        4.1	    0.928571429
    virtual void Test_TCFbETableEx_PartialNormalize() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TCFbECustomTableEx* Table = this->DataSet->GetPredictionTable();

        //  Max of Column	1	900	0.35	3800	4.1	0.8
        TEST_ASSERT_EQUALS_DOUBLE(1.0,  Table->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900,  Table->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800, Table->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,  Table->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8,  Table->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0	250	0	3200	2.5	0.1
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  Table->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  Table->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1,  Table->GetMinOfColumn(5), 1E-6);

        //  Average of Column	0.4	625	0.216666667	3416.666667	3.516666667	0.491666667
        TEST_ASSERT_EQUALS_DOUBLE(0.4,          Table->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625,          Table->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.216666667,  Table->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3416.666667,  Table->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.516666667,  Table->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.491666667,  Table->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0	650	0.225	3350	3.75	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650,  Table->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.225,Table->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3350, Table->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.75, Table->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5,  Table->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	0.489897949	211.6404183	0.11055416	233.9278141	0.592780641	0.24902588
        TEST_ASSERT_EQUALS_DOUBLE(0.489897949,  Table->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(211.6404183,  Table->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.11055416,   Table->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(233.9278141,  Table->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.592780641,  Table->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.24902588,   Table->GetStdevOfColumn(5), 1E-6);

        //  Inversed Distance		2.032258065	2.333333333	1.472256815	1.779948447	3.643263757
        TEST_ASSERT_EQUALS_DOUBLE(2.032258065, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.333333333, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.472256815, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.779948447, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.643263757, Table->GetInversedDistanceOfColumn(0, 5), 1E-6);

        //  Max of Row  3600    3200    3200    3500    3200    3800
        TEST_ASSERT_EQUALS_DOUBLE(3600, Table->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500, Table->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800, Table->GetMaxOfRow(5), 1E-6);

        //  Min of Row  0.3 0   0   0.25    0   0.35
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  Table->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetMinOfRow(5), 1E-6);

        //  Average of Row	880.98	575.6833333	617.2166667	701.0083333	633.8	784.3666667
        TEST_ASSERT_EQUALS_DOUBLE(880.98, Table->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(575.6833333, Table->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(617.2166667, Table->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(701.0083333, Table->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(633.8, Table->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(784.3666667, Table->GetAverageOfRow(5), 1E-6);

        //  Median of Row	4	1.95	1.65	2.5	1.35	2.55
        TEST_ASSERT_EQUALS_DOUBLE(4, Table->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.95, Table->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, Table->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.35, Table->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.55, Table->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1394.230085	1177.146596	1169.349578	1277.467651	1168.317284	1387.962061
        TEST_ASSERT_EQUALS_DOUBLE(1394.230085, Table->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1177.146596, Table->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1169.349578, Table->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1277.467651, Table->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1168.317284, Table->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1387.962061, Table->GetStdevOfRow(5), 1E-6);

        //  Averaged Multiplier		1.693571429	1.514583333	1.024285714	2.311666667	0.893801985
        TEST_ASSERT_EQUALS_DOUBLE(1.693571429, Table->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.514583333, Table->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.024285714, Table->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.311666667, Table->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.893801985, Table->GetAveragedMultiplierOfRow(0, 5), 1E-6);

        //  Median of Multiplier		1.5	1.466666667	1.028571429	1.5	0.888888889
        TEST_ASSERT_EQUALS_DOUBLE(1.5, Table->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.466666667, Table->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.028571429, Table->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5, Table->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.888888889, Table->GetMedianOfMultiplierOfRow(0, 5), 1E-6);

        //  Weighted Multiplier		1.701317322	1.631736028	0.990075339	2.892575405	0.87490582
        TEST_ASSERT_EQUALS_DOUBLE(1.701317322, Table->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.631736028, Table->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.990075339, Table->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.892575405, Table->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.87490582, Table->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);

        Table->PartialNormalize(1);
        Table->PartialNormalize(3);
        Table->PartialNormalize(5);

        TEST_ASSERT_EQUALS((int)false, (int)Table->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(0.846153846,  Table->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,          Table->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  Table->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,            Table->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714,  Table->GetValueByIndex(0, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,          Table->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,          Table->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.428571429,  Table->GetValueByIndex(1, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.384615385,  Table->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,            Table->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.285714286,  Table->GetValueByIndex(2, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,    Table->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.692307692, Table->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5,  Table->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    Table->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    Table->GetValueByIndex(3, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.538461538, Table->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  Table->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(4, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,         Table->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,          Table->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.928571429,  Table->GetValueByIndex(5, 5), 1E-6);

        //  Max of Column	1	1	0.35	1	4.1	1
        TEST_ASSERT_EQUALS_DOUBLE(1, Table->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, Table->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, Table->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1, Table->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, Table->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0	0	0	0	2.5	0
        TEST_ASSERT_EQUALS_DOUBLE(0, Table->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, Table->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, Table->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, Table->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, Table->GetMinOfColumn(5), 1E-6);

        //  Average of Column	0.4	0.576923077	0.216666667	0.361111111	3.516666667	0.55952381
        TEST_ASSERT_EQUALS_DOUBLE(0.4, Table->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.576923077, Table->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.216666667, Table->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.361111111, Table->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.516666667, Table->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.55952381, Table->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0.0	0.615384615	0.225	0.25	3.75	0.571428571
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.615384615, Table->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.225, Table->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.75, Table->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, Table->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	0.489897949	0.325600644	0.11055416	0.38987969	0.592780641	0.355751257
        TEST_ASSERT_EQUALS_DOUBLE(0.489897949, Table->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.325600644, Table->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.11055416, Table->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.38987969, Table->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.592780641, Table->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.355751257, Table->GetStdevOfColumn(5), 1E-6);

        //  Inversed Distance		2.659090909	2.333333333	5.333333333	1.779948447	4.902356902
        TEST_ASSERT_EQUALS_DOUBLE(2.659090909, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.333333333, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.333333333, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.779948447, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.902356902, Table->GetInversedDistanceOfColumn(0, 5), 1E-6);

        //  Max of Row	4.0	3.5	3.0	4.0	2.5	4.1
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, Table->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1, Table->GetMaxOfRow(5), 1E-6);

        //  Min of Row	0.3	0.0	0.0	0.25	0.0	0.35
        TEST_ASSERT_EQUALS_DOUBLE(0.3, Table->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetMinOfRow(5), 1E-6);

        //  Average of Row	1.305421245	0.688095238	0.611721612	1.240384615	0.53974359	1.396428571
        TEST_ASSERT_EQUALS_DOUBLE(1.305421245, Table->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.688095238, Table->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.611721612, Table->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.240384615, Table->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.53974359, Table->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.396428571, Table->GetAverageOfRow(5), 1E-6);

        //  Median of Row	0.714285714	0.1	0.142857143	0.846153846	0.1	1.0
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714, Table->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1, Table->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.142857143, Table->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.846153846, Table->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1, Table->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1.359411764	1.267071632	1.078914707	1.262303845	0.897403846	1.231169388
        TEST_ASSERT_EQUALS_DOUBLE(1.359411764, Table->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.267071632, Table->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.078914707, Table->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.262303845, Table->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.897403846, Table->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.231169388, Table->GetStdevOfRow(5), 1E-6);

        //  Averaged Multiplier		1.436507937	2.011111111	1.093968254	1.557142857	0.822960779
        TEST_ASSERT_EQUALS_DOUBLE(1.436507937, Table->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.011111111, Table->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.093968254, Table->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.557142857, Table->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.822960779, Table->GetAveragedMultiplierOfRow(0, 5), 1E-6);

        //  Median of Multiplier		1.5	2.2	1.2	1.571428571	0.846153846
        TEST_ASSERT_EQUALS_DOUBLE(1.5, Table->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.2, Table->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2, Table->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.571428571, Table->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.846153846, Table->GetMedianOfMultiplierOfRow(0, 5), 1E-6);

        //  Weighted Multiplier		1.520116557	2.192301481	1.084352941	1.554328066	0.7827543
        TEST_ASSERT_EQUALS_DOUBLE(1.520116557, Table->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.192301481, Table->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.084352941, Table->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.554328066, Table->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7827543, Table->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
    }

    //  PartialStandardize	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
    //  module_1		0.826874193	0.3	0.78371755	4	0.435028413
    //  module_2	0	-1.77187327	0.2	-0.92621165	3.5	-0.368100965
    //  module_3	0	-0.590624423	0	-0.92621165	3	-0.769665654
    //  module_4	1	0.354374654	0.25	0.35623525	4	1.238157791
    //  module_5	0	-0.118124885	0.2	-0.92621165	2.5	-1.572795031
    //  module_6	1	1.299373731	0.35	1.63868215	4.1	1.037375446
    virtual void Test_TCFbETableEx_PartialStandardize() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TCFbECustomTableEx* Table = this->DataSet->GetPredictionTable();
        
        Table->PartialStandardize(1);
        Table->PartialStandardize(3);
        Table->PartialStandardize(5);

        TEST_ASSERT_EQUALS((int)false, (int)Table->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(0.826874193,  Table->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,          Table->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.78371755,   Table->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,            Table->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.435028413,  Table->GetValueByIndex(0, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.77187327,  Table->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,          Table->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.92621165,  Table->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,          Table->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.368100965, Table->GetValueByIndex(1, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.590624423, Table->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.92621165,  Table->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,            Table->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.769665654, Table->GetValueByIndex(2, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.354374654,  Table->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,         Table->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35623525,   Table->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,            Table->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.238157791,  Table->GetValueByIndex(3, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.118124885, Table->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,          Table->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.92621165,  Table->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,          Table->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.572795031, Table->GetValueByIndex(4, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.299373731,  Table->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,         Table->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.63868215,   Table->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,          Table->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.037375446,  Table->GetValueByIndex(5, 5), 1E-6);
    }

    //  PartialOrdering	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
    //  module_1		0.8	0.3	0.8	4	0.6
    //  module_2	0	0	0.2	0.2	3.5	0.4
    //  module_3	0	0.2	0	0.2	3	0.2
    //  module_4	1	0.6	0.25	0.6	4	1
    //  module_5	0	0.4	0.2	0.2	2.5	0
    //  module_6	1	1	0.35	1	4.1	0.8
    virtual void Test_TCFbETableEx_PartialOrdering() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TCFbECustomTableEx* Table = this->DataSet->GetPredictionTable();

        Table->PartialOrdering(1);
        Table->PartialOrdering(3);
        Table->PartialOrdering(5);

        TEST_ASSERT_EQUALS((int)false, (int)Table->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(0.8,  Table->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  Table->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8,  Table->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    Table->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,  Table->GetValueByIndex(0, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,  Table->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4,  Table->GetValueByIndex(1, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,    Table->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(2, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,    Table->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,  Table->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,  Table->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    Table->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    Table->GetValueByIndex(3, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4,  Table->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  Table->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(4, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,    Table->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    Table->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    Table->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,  Table->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8,  Table->GetValueByIndex(5, 5), 1E-6);
    }
    
    //  PartialRowNormalize	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
    //  module_1		800	0.3	3600	4	0.6
    //  module_2	0	0.078125	0.0000625	1	0.00109375	0.000125
    //  module_3	0	500	0	3200	3	0.3
    //  module_4	0.000214301	0.199942853	0	1	0.001071505	0.000157154
    //  module_5	0	600	0.2	3200	2.5	0.1
    //  module_6	0.000171068	0.236771808	0	1	0.000986933	0.000105273
    virtual void Test_TCFbETableEx_PartialRowNormalize() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TCFbECustomTableEx* Table = this->DataSet->GetPredictionTable();

        Table->PartialRowNormalize(1);
        Table->PartialRowNormalize(3);
        Table->PartialRowNormalize(5);

        TEST_ASSERT_EQUALS((int)false, (int)Table->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(800,  Table->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  Table->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600, Table->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    Table->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,  Table->GetValueByIndex(0, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.078125,     Table->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000625,    Table->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.00109375,   Table->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000125,     Table->GetValueByIndex(1, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  Table->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,    Table->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  Table->GetValueByIndex(2, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.000214301,  Table->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.199942853,  Table->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.001071505,  Table->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000157154,  Table->GetValueByIndex(3, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  Table->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  Table->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1,  Table->GetValueByIndex(4, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.000171068,  Table->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.236771808,  Table->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000986933,  Table->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000105273,  Table->GetValueByIndex(5, 5), 1E-6);
    }

    //  PartialRowNormalizeOnColumn	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
    //  module_1		0.222157402	0.3	1	4	8.33403E-05
    //  module_2	0	0.078125	0.2	1	3.5	0.000125
    //  module_3	0	0.15625	0	1	3	0.00009375
    //  module_4	0.000214301	0.199942853	0	1	0.001071505	0.000157154
    //  module_5	0	0.1875	0.2	1	2.5	0.00003125
    //  module_6	1	0.236771808	0.35	1	4.1	0.000105273
    virtual void Test_TCFbETableEx_PartialRowNormalizeOnColumn() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TCFbECustomTableEx* Table = this->DataSet->GetPredictionTable();

        //  Max of Column	1	900	0.35	3800	4.1	0.8
        TEST_ASSERT_EQUALS_DOUBLE(1.0,  Table->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900,  Table->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800, Table->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,  Table->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8,  Table->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0	250	0	3200	2.5	0.1
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  Table->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  Table->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1,  Table->GetMinOfColumn(5), 1E-6);

        //  Average of Column	0.4	625	0.216666667	3416.666667	3.516666667	0.491666667
        TEST_ASSERT_EQUALS_DOUBLE(0.4,          Table->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625,          Table->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.216666667,  Table->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3416.666667,  Table->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.516666667,  Table->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.491666667,  Table->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0	650	0.225	3350	3.75	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650,  Table->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.225,Table->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3350, Table->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.75, Table->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5,  Table->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	0.489897949	211.6404183	0.11055416	233.9278141	0.592780641	0.24902588
        TEST_ASSERT_EQUALS_DOUBLE(0.489897949,  Table->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(211.6404183,  Table->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.11055416,   Table->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(233.9278141,  Table->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.592780641,  Table->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.24902588,   Table->GetStdevOfColumn(5), 1E-6);

        //  Inversed Distance		2.032258065	2.333333333	1.472256815	1.779948447	3.643263757
        TEST_ASSERT_EQUALS_DOUBLE(2.032258065, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.333333333, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.472256815, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.779948447, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.643263757, Table->GetInversedDistanceOfColumn(0, 5), 1E-6);

        //  Max of Row  3600    3200    3200    3500    3200    3800
        TEST_ASSERT_EQUALS_DOUBLE(3600, Table->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500, Table->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800, Table->GetMaxOfRow(5), 1E-6);

        //  Min of Row  0.3 0   0   0.25    0   0.35
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  Table->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetMinOfRow(5), 1E-6);

        //  Average of Row	880.98	575.6833333	617.2166667	701.0083333	633.8	784.3666667
        TEST_ASSERT_EQUALS_DOUBLE(880.98, Table->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(575.6833333, Table->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(617.2166667, Table->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(701.0083333, Table->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(633.8, Table->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(784.3666667, Table->GetAverageOfRow(5), 1E-6);

        //  Median of Row	4	1.95	1.65	2.5	1.35	2.55
        TEST_ASSERT_EQUALS_DOUBLE(4, Table->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.95, Table->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, Table->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.35, Table->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.55, Table->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1394.230085	1177.146596	1169.349578	1277.467651	1168.317284	1387.962061
        TEST_ASSERT_EQUALS_DOUBLE(1394.230085, Table->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1177.146596, Table->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1169.349578, Table->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1277.467651, Table->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1168.317284, Table->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1387.962061, Table->GetStdevOfRow(5), 1E-6);

        //  Averaged Multiplier		1.693571429	1.514583333	1.024285714	2.311666667	0.893801985
        TEST_ASSERT_EQUALS_DOUBLE(1.693571429, Table->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.514583333, Table->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.024285714, Table->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.311666667, Table->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.893801985, Table->GetAveragedMultiplierOfRow(0, 5), 1E-6);

        //  Median of Multiplier		1.5	1.466666667	1.028571429	1.5	0.888888889
        TEST_ASSERT_EQUALS_DOUBLE(1.5, Table->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.466666667, Table->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.028571429, Table->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5, Table->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.888888889, Table->GetMedianOfMultiplierOfRow(0, 5), 1E-6);

        //  Weighted Multiplier		1.701317322	1.631736028	0.990075339	2.892575405	0.87490582
        TEST_ASSERT_EQUALS_DOUBLE(1.701317322, Table->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.631736028, Table->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.990075339, Table->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.892575405, Table->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.87490582, Table->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
/*
        Table->PartialRowNormalize(3, true);
        Table->PartialRowNormalizeOnColumn(1, false);
        Table->PartialRowNormalizeOnColumn(3, false);
        Table->PartialRowNormalizeOnColumn(5, true);

        TEST_ASSERT_EQUALS((int)false, (int)Table->GetValueByIndex(0, 0)->GetEnabled());
        TEST_ASSERT_EQUALS_DOUBLE(0.222157402,  Table->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,          Table->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,            Table->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8.33403E-05,  Table->GetValueByIndex(0, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,        Table->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.078125, Table->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,      Table->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,        Table->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,      Table->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000125, Table->GetValueByIndex(1, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.15625,      Table->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,            Table->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.00009375,   Table->GetValueByIndex(2, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.000214301,  Table->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.199942853,  Table->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.001071505,  Table->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000157154,  Table->GetValueByIndex(3, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,            Table->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1875,       Table->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,          Table->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,          Table->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.00003125,   Table->GetValueByIndex(4, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.236771808,  Table->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,         Table->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            Table->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,          Table->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000105273,  Table->GetValueByIndex(5, 5), 1E-6);

        //  Max of Column	1.0	0.236771808	0.35	1.0	4.1	0.000157154
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.236771808, Table->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35, Table->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1, Table->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000157154, Table->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0.0	0.078125	0.0	1.0	0.001071505	0.00003125
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.078125, Table->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.001071505, Table->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.00003125, Table->GetMinOfColumn(5), 1E-6);

        //  Average of Column	0.20004286	0.18012451	0.175	1.0	2.850178584	9.92945E-05
        TEST_ASSERT_EQUALS_DOUBLE(0.20004286, Table->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.18012451, Table->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.175, Table->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.850178584, Table->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.92945E-05, Table->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0.0	0.193721427	0.2	1.0	3.25	9.95114E-05
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.193721427, Table->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2, Table->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.25, Table->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.95114E-05, Table->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	0.399978579	0.05227609	0.13462912	0.0	1.388578012	3.86428E-05
        TEST_ASSERT_EQUALS_DOUBLE(0.399978579, Table->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.05227609, Table->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.13462912, Table->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.388578012, Table->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.86428E-05, Table->GetStdevOfColumn(5), 1E-6);

        //  Inversed Distance		0.001713104	3.499343826	0.001712207	0.000865657	0.001712651
        TEST_ASSERT_EQUALS_DOUBLE(0.001713104, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.499343826, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.001712207, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000865657, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.001712651, Table->GetInversedDistanceOfColumn(0, 5), 1E-6);

        //  Max of Row	4.0	3.5	3.0	1.0	2.5	4.1
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, Table->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1, Table->GetMaxOfRow(5), 1E-6);

        //  Min of Row	8.33403E-05	0.0	0.0	0.0	0.0	0.000105273
        TEST_ASSERT_EQUALS_DOUBLE(8.33403E-05, Table->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000105273, Table->GetMinOfRow(5), 1E-6);

        //  Average of Row	1.104448148	0.796375	0.692723958	0.200230969	0.647921875	1.114479513
        TEST_ASSERT_EQUALS_DOUBLE(1.104448148, Table->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.796375, Table->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.692723958, Table->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.200230969, Table->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.647921875, Table->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.114479513, Table->GetAverageOfRow(5), 1E-6);

        //  Median of Row	0.3	0.1390625	0.078171875	0.000642903	0.19375	0.675
        TEST_ASSERT_EQUALS_DOUBLE(0.3, Table->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1390625, Table->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.078171875, Table->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.000642903, Table->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.19375, Table->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.675, Table->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1.485955945	1.257697943	1.091269534	0.36501683	0.895017664	1.386612983
        TEST_ASSERT_EQUALS_DOUBLE(1.485955945, Table->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.257697943, Table->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.091269534, Table->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.36501683, Table->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.895017664, Table->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.386612983, Table->GetStdevOfRow(5), 1E-6);

        //  Averaged Multiplier		1.430638823	1.161025919	933.9270201	1.590345677	0.912537749
        TEST_ASSERT_EQUALS_DOUBLE(1.430638823, Table->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.161025919, Table->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(933.9270201, Table->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.590345677, Table->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.912537749, Table->GetAveragedMultiplierOfRow(0, 5), 1E-6);

        //  Median of Multiplier		1.142857143	1.166666667	1.055552246	1.5	0.93827641
        TEST_ASSERT_EQUALS_DOUBLE(1.142857143, Table->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.166666667, Table->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.055552246, Table->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5, Table->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.93827641, Table->GetMedianOfMultiplierOfRow(0, 5), 1E-6);

        //  Weighted Multiplier		1.49991709	1.136748306	539.0214607	1.500196566	0.857249549
        TEST_ASSERT_EQUALS_DOUBLE(1.49991709, Table->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.136748306, Table->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(539.0214607, Table->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.500196566, Table->GetWeightedMultiplierOfRow(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857249549, Table->GetWeightedMultiplierOfRow(0, 5, 0), 1E-6);
*/    }

    //  PartialRowStandardize	BUG	LOC	N_COMM	HALVOL	SCPMN	N_VEXUSE
    //  module_1		800	0.3	3600	4	0.6
    //  module_2	-0.489049822	-0.276671856	-0.48887992	2.229388146	-0.486076531	-0.488710017
    //  module_3	0	500	0	3200	3	0.3
    //  module_4	-0.547965604	-0.000789322	-0.548552703	2.191047001	-0.545617208	-0.548122164
    //  module_5	0	600	0.2	3200	2.5	0.1
    //  module_6	-0.564400634	0.083311595	-0.564868946	2.172705882	-0.562167143	-0.564580754
    virtual void Test_TCFbETableEx_PartialRowStandardize() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0);
        TCFbECustomTableEx* Table = this->DataSet->GetPredictionTable();

        Table->PartialRowStandardize(1);
        Table->PartialRowStandardize(3);
        Table->PartialRowStandardize(5);

        TEST_ASSERT_EQUALS((int)false, (int)Table->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS_DOUBLE(800,  Table->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  Table->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600, Table->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    Table->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,  Table->GetValueByIndex(0, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.489049822, Table->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.276671856, Table->GetValueByIndex(1, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.48887992,  Table->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.229388146,  Table->GetValueByIndex(1, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.486076531, Table->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.488710017, Table->GetValueByIndex(1, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  Table->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3,    Table->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  Table->GetValueByIndex(2, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.547965604, Table->GetValueByIndex(3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.000789322, Table->GetValueByIndex(3, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.548552703, Table->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.191047001,  Table->GetValueByIndex(3, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.545617208, Table->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.548122164, Table->GetValueByIndex(3, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    Table->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  Table->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  Table->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, Table->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  Table->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1,  Table->GetValueByIndex(4, 5), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.564400634, Table->GetValueByIndex(5, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.083311595,  Table->GetValueByIndex(5, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.564868946, Table->GetValueByIndex(5, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.172705882,  Table->GetValueByIndex(5, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.562167143, Table->GetValueByIndex(5, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.564580754, Table->GetValueByIndex(5, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // ȉCASỸeXg
    //---------------------------------------------------------------------------
    // Value-based & Row-based
    //---------------------------------------------------------------------------
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0);

        this->DataSet->GetSimilarity("module_2", "module_1");
        this->DataSet->GetSimilarity("module_2", "module_3");
        this->DataSet->GetSimilarity("module_2", "module_4");
        this->DataSet->GetSimilarity("module_2", "module_5");
        this->DataSet->GetSimilarity("module_2", "module_6");

        TEST_ASSERT_EQUALS_DOUBLE(0.9901177602,    this->DataSet->GetSimilarity("module_1", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9979735938,    this->DataSet->GetSimilarity("module_1", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997737277,    this->DataSet->GetSimilarity("module_1", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994448484,    this->DataSet->GetSimilarity("module_1", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999035624,    this->DataSet->GetSimilarity("module_1", "module_6"), 1E-6);
    }

    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);

        this->DataSet->GetSimilarity("module_2", "module_1");
        this->DataSet->GetSimilarity("module_2", "module_3");
        this->DataSet->GetSimilarity("module_2", "module_4");
        this->DataSet->GetSimilarity("module_2", "module_5");
        this->DataSet->GetSimilarity("module_2", "module_6");

        TEST_ASSERT_EQUALS_DOUBLE(-0.9597356759,    this->DataSet->GetSimilarity("module_1", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9716063011,    this->DataSet->GetSimilarity("module_1", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9995642829,    this->DataSet->GetSimilarity("module_1", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7977311881,    this->DataSet->GetSimilarity("module_1", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9902375944,    this->DataSet->GetSimilarity("module_1", "module_6"), 1E-6);
    }

    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0);

        this->DataSet->GetSimilarity("module_2", "module_1");
        this->DataSet->GetSimilarity("module_2", "module_3");
        this->DataSet->GetSimilarity("module_2", "module_4");
        this->DataSet->GetSimilarity("module_2", "module_5");
        this->DataSet->GetSimilarity("module_2", "module_6");

        TEST_ASSERT_EQUALS_DOUBLE(-0.7439788535,    this->DataSet->GetSimilarity("module_1", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9052136803,    this->DataSet->GetSimilarity("module_1", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7691866503,    this->DataSet->GetSimilarity("module_1", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7658445423,    this->DataSet->GetSimilarity("module_1", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9750753757,    this->DataSet->GetSimilarity("module_1", "module_6"), 1E-6);
    }

    virtual void Test_TCFbEWeightedSum_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.4655868433,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.4193644129,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.4441809806,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.3807384633,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.6282966972,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.3321317612,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.6910731085,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0);
        this->DataSet->GetPredictedValue("module_2", "BUG");
        TEST_ASSERT_EQUALS_DOUBLE(0.6735751295,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    virtual void Test_TCFbEOutputCash_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=0"
            , "-t=BUG"
            , "-l=test\\module0_1_learn.csv"
            , "-e=test\\module0_1_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(8, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 5));

        Cash->GetNeighbor(0, 0);
        Cash->GetNeighbor(0, 1);
        Cash->GetNeighbor(0, 2);
        Cash->GetNeighbor(0, 3);
        Cash->GetNeighbor(0, 4);

        Cash->GetDistribution(0, 0);
        Cash->GetDistribution(0, 1);
        Cash->GetDistribution(0, 2);
        Cash->GetDistribution(0, 3);
        Cash->GetDistribution(0, 4);
        Cash->GetDistribution(0, 5);
        Cash->GetDistribution(0, 6);
        Cash->GetDistribution(0, 7);
        Cash->GetDistribution(0, 8);
        Cash->GetDistribution(0, 9);
        Cash->GetDistribution(0, 10);
        Cash->GetDistribution(0, 11);
        Cash->GetDistribution(0, 12);
        Cash->GetDistribution(0, 13);
        Cash->GetDistribution(0, 14);
        Cash->GetDistribution(0, 15);
        Cash->GetDistribution(0, 16);
        Cash->GetDistribution(0, 17);
        Cash->GetDistribution(0, 18);
        Cash->GetDistribution(0, 19);

        Cash->GetResultValue(0, 0);

        
        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(1, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(1, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(1, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(1, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(1, 4));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(1, 5));

        TEST_ASSERT_EQUALS("module_6",    Cash->GetNeighbor(1, 0)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_4",    Cash->GetNeighbor(1, 1)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_5",    Cash->GetNeighbor(1, 2)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_2",    Cash->GetNeighbor(1, 3)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_3",    Cash->GetNeighbor(1, 4)->GetLabel().c_str());

        TEST_ASSERT_EQUALS_DOUBLE(0.952721939,  Cash->GetNeighbor(1, 0)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.868253765,  Cash->GetNeighbor(1, 1)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.821182611, Cash->GetNeighbor(1, 2)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.838714428, Cash->GetNeighbor(1, 3)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.921658759, Cash->GetNeighbor(1, 4)->GetSimilarity(), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Cash->GetNeighbor(1, 0)->GetSourceValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Cash->GetNeighbor(1, 1)->GetSourceValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(1, 2)->GetSourceValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(1, 3)->GetSourceValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(1, 4)->GetSourceValue(), 1E-6);

        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(1, 0));
        TEST_ASSERT_EQUALS(2,    Cash->GetDistribution(1, 1));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 2));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 3));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 4));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 5));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 6));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 7));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 8));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 9));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 10));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 11));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 12));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 13));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 14));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 15));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 16));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(1, 17));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(1, 18));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(1, 19));

        TEST_ASSERT_EQUALS_DOUBLE(0.420284215,    Cash->GetResultValue(1, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

protected:
    TCFbEDataSetEx* DataSet;
};

//---------------------------------------------------------------------------
#endif

